/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class CheckmarkRequirement
extends Requirement {
    private String description;

    public CheckmarkRequirement(String id, String description) {
        super("checkmark");
        this.setId(id);
        this.description = description;
    }

    public String getRequirementId() {
        return this.getId();
    }

    public void setRequirementId(String id) {
        this.setId(id);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean completed = this.isMet(progress, questId);
        return (completed ? "\u2611" : "\u2610") + " " + this.description;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("description", this.description);
        return json;
    }

    public static CheckmarkRequirement fromJson(JsonObject json) {
        String id = json.get("id").getAsString();
        String description = json.has("description") ? json.get("description").getAsString() : "Manual Completion";
        return new CheckmarkRequirement(id, description);
    }
}

