/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class CustomRequirement
extends Requirement {
    private String taskId;
    private String description;
    private long maxProgress;

    public CustomRequirement(String taskId, String description, long maxProgress) {
        super("custom");
        this.taskId = taskId;
        this.description = description;
        this.maxProgress = maxProgress;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public long getMaxProgress() {
        return this.maxProgress;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMaxProgress(long maxProgress) {
        this.maxProgress = maxProgress;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return (long)progress.getRequirementProgress(questId, this) >= this.maxProgress;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        long current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.maxProgress + " " + (this.description != null ? this.description : this.taskId);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("task_id", this.taskId);
        json.addProperty("description", this.description);
        json.addProperty("max_progress", (Number)this.maxProgress);
        return json;
    }

    public static CustomRequirement fromJson(JsonObject json) {
        String taskId = json.get("task_id").getAsString();
        String description = json.has("description") ? json.get("description").getAsString() : null;
        long maxProgress = json.has("max_progress") ? json.get("max_progress").getAsLong() : 1L;
        return new CustomRequirement(taskId, description, maxProgress);
    }
}

