/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class DimensionRequirement
extends Requirement {
    private String dimensionId;

    public DimensionRequirement(String dimensionId) {
        super("dimension");
        this.dimensionId = dimensionId;
    }

    public String getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(String dimensionId) {
        this.dimensionId = dimensionId;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean visited = progress.getRequirementProgress(questId, this) > 0;
        return (visited ? "\u2713" : "\u2717") + " Visit dimension: " + this.dimensionId;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("dimension", this.dimensionId);
        return json;
    }

    public static DimensionRequirement fromJson(JsonObject json) {
        String dimensionId = json.get("dimension").getAsString();
        return new DimensionRequirement(dimensionId);
    }
}

