/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class EntityKillRequirement
extends Requirement {
    private String entity;
    private int count;

    public EntityKillRequirement(String entity, int count) {
        super("entity_kill");
        this.entity = entity;
        this.count = count;
    }

    public String getEntity() {
        return this.entity;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.count;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        return "Kill " + current + "/" + this.count + " " + this.entity;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("entity", this.entity);
        json.addProperty("count", (Number)this.count);
        return json;
    }

    public static EntityKillRequirement fromJson(JsonObject json) {
        String entity = json.get("entity").getAsString();
        int count = json.get("count").getAsInt();
        return new EntityKillRequirement(entity, count);
    }
}

