/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class TimeRequirement
extends Requirement {
    private long start;
    private long end;

    public TimeRequirement(long start, long end) {
        super("time");
        this.start = (start % 24000L + 24000L) % 24000L;
        this.end = (end % 24000L + 24000L) % 24000L;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean ok = progress.getRequirementProgress(questId, this) > 0;
        return (ok ? "\u2713" : "\u2717") + " Time between " + this.start + " and " + this.end;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("start", (Number)this.start);
        json.addProperty("end", (Number)this.end);
        return json;
    }

    public static TimeRequirement fromJson(JsonObject json) {
        long start = json.has("start") ? json.get("start").getAsLong() : 0L;
        long end = json.has("end") ? json.get("end").getAsLong() : 12000L;
        return new TimeRequirement(start, end);
    }
}

