/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.shape;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.shape.ShapeDef;

public class ShapeRegistry {
    private static final Map<String, ShapeDef> SHAPES = new HashMap<String, ShapeDef>();
    private static boolean initialized = false;

    public static synchronized void initIfNeeded() {
        if (initialized) {
            return;
        }
        ShapeRegistry.registerBuiltins();
        ShapeRegistry.loadCustoms();
        initialized = true;
    }

    public static synchronized void reload() {
        SHAPES.clear();
        ShapeRegistry.registerBuiltins();
        ShapeRegistry.loadCustoms();
    }

    public static synchronized ShapeDef get(String id) {
        ShapeRegistry.initIfNeeded();
        if (id == null) {
            return null;
        }
        ShapeDef d = SHAPES.get(id);
        if (d == null && id.startsWith("custom:")) {
            d = SHAPES.get(id.substring("custom:".length()));
        }
        return d;
    }

    public static synchronized Collection<ShapeDef> all() {
        ShapeRegistry.initIfNeeded();
        return Collections.unmodifiableCollection(SHAPES.values());
    }

    public static synchronized void save(ShapeDef def) throws Exception {
        if (def == null || def.id == null || def.id.isBlank()) {
            throw new IllegalArgumentException("Shape id required");
        }
        File dir = ShapeRegistry.getConfigDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File out = new File(dir, def.id + ".qshape.json");
        try (BufferedWriter bw = Files.newBufferedWriter(out.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            bw.write(ShapeDef.GSON.toJson((Object)def));
        }
        SHAPES.put(def.id, def);
    }

    private static void registerBuiltins() {
        SHAPES.put("square", ShapeRegistry.builtin("square", "Square"));
        SHAPES.put("circle", ShapeRegistry.builtin("circle", "Circle"));
        SHAPES.put("rsquare", ShapeRegistry.builtin("rsquare", "Rounded Square"));
        SHAPES.put("diamond", ShapeRegistry.builtin("diamond", "Diamond"));
        SHAPES.put("triangle", ShapeRegistry.builtin("triangle", "Triangle"));
        SHAPES.put("pentagon", ShapeRegistry.builtin("pentagon", "Pentagon"));
        SHAPES.put("hexagon", ShapeRegistry.builtin("hexagon", "Hexagon"));
        SHAPES.put("octagon", ShapeRegistry.builtin("octagon", "Octagon"));
        SHAPES.put("oval", ShapeRegistry.builtin("oval", "Oval"));
        SHAPES.put("star", ShapeRegistry.builtin("star", "Star"));
        SHAPES.put("heart", ShapeRegistry.builtin("heart", "Heart"));
        SHAPES.put("gear", ShapeRegistry.builtin("gear", "Gear"));
        SHAPES.put("cross", ShapeRegistry.builtin("cross", "Cross"));
        SHAPES.put("shield", ShapeRegistry.builtin("shield", "Shield"));
        SHAPES.put("arrow", ShapeRegistry.builtin("arrow", "Arrow"));
    }

    private static ShapeDef builtin(String id, String name) {
        ShapeDef d = new ShapeDef();
        d.id = id;
        d.displayName = name;
        d.viewBox = new double[]{0.0, 0.0, 1.0, 1.0};
        d.hitTest = "auto";
        return d;
    }

    private static void loadCustoms() {
        File dir = ShapeRegistry.getConfigDir();
        File[] files = dir.listFiles((f, n) -> n.endsWith(".qshape.json"));
        if (files == null) {
            return;
        }
        for (File f2 : files) {
            try (BufferedReader br = Files.newBufferedReader(f2.toPath(), StandardCharsets.UTF_8);){
                JsonElement el = JsonParser.parseReader((Reader)br);
                ShapeDef d = (ShapeDef)ShapeDef.GSON.fromJson(el, ShapeDef.class);
                if (d == null || d.id == null || d.id.isBlank()) continue;
                SHAPES.put(d.id, d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static File getConfigDir() {
        Path cfg = Questory.getConfigPath();
        File configDir = cfg != null ? cfg.toFile() : new File(new File(".", "config").getPath());
        return new File(new File(configDir, "questory"), "shapes");
    }
}

