/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.backend.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;

public class JsonPlayerProgressBackend
implements IPlayerProgressBackend {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path progressPath;
    private boolean connected = false;

    public JsonPlayerProgressBackend(Path dataPath) {
        this.progressPath = dataPath.resolve("questory_progress");
    }

    @Override
    public boolean connect() {
        try {
            Files.createDirectories(this.progressPath, new FileAttribute[0]);
            this.connected = true;
            System.out.println("[Questory] JSON storage backend connected: " + String.valueOf(this.progressPath));
            return true;
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to create progress directory: " + e.getMessage());
            this.connected = false;
            return false;
        }
    }

    @Override
    public void disconnect() {
        this.connected = false;
        System.out.println("[Questory] JSON storage backend disconnected");
    }

    @Override
    public boolean isConnected() {
        return this.connected && Files.exists(this.progressPath, new LinkOption[0]);
    }

    @Override
    public boolean healthCheck() {
        return this.isConnected() && Files.isWritable(this.progressPath);
    }

    @Override
    public String getBackendType() {
        return "JSON";
    }

    @Override
    public QuestProgress loadProgress(UUID playerId) {
        Path progressFile = this.getProgressFile(playerId);
        if (!Files.exists(progressFile, new LinkOption[0])) {
            return null;
        }
        try {
            String content = Files.readString(progressFile);
            JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
            return QuestProgress.fromJson(json);
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to load progress for player " + String.valueOf(playerId) + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean saveProgress(QuestProgress progress) {
        try {
            Path progressFile = this.getProgressFile(progress.getPlayerId());
            Files.createDirectories(progressFile.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((JsonElement)progress.toJson());
            Files.writeString(progressFile, (CharSequence)json, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to save progress for player " + String.valueOf(progress.getPlayerId()) + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean deleteProgress(UUID playerId) {
        Path progressFile = this.getProgressFile(playerId);
        try {
            return Files.deleteIfExists(progressFile);
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to delete progress for player " + String.valueOf(playerId) + ": " + e.getMessage());
            return false;
        }
    }

    @Override
    public List<UUID> getAllPlayerIds() {
        ArrayList<UUID> playerIds = new ArrayList<UUID>();
        try {
            if (!Files.exists(this.progressPath, new LinkOption[0])) {
                return playerIds;
            }
            try (Stream<Path> paths = Files.list(this.progressPath);){
                paths.filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                    try {
                        String fileName = path.getFileName().toString();
                        String uuidString = fileName.replace("player_", "").replace(".json", "");
                        UUID playerId = UUID.fromString(uuidString);
                        playerIds.add(playerId);
                    }
                    catch (Exception e) {
                        System.err.println("[Questory] Failed to parse player ID from file: " + String.valueOf(path));
                    }
                });
            }
        }
        catch (IOException e) {
            System.err.println("[Questory] Error listing player progress files: " + e.getMessage());
        }
        return playerIds;
    }

    private Path getProgressFile(UUID playerId) {
        return this.progressPath.resolve("player_" + playerId.toString() + ".json");
    }
}

