/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.SelectorProperties;
import org.texboobcat.questory.theme.panel.PanelTemplateLoader;
import org.texboobcat.questory.theme.selector.AllSelector;
import org.texboobcat.questory.theme.selector.AndSelector;
import org.texboobcat.questory.theme.selector.ChapterSelector;
import org.texboobcat.questory.theme.selector.GroupSelector;
import org.texboobcat.questory.theme.selector.IDSelector;
import org.texboobcat.questory.theme.selector.NotSelector;
import org.texboobcat.questory.theme.selector.TagSelector;
import org.texboobcat.questory.theme.selector.ThemeSelector;
import org.texboobcat.questory.theme.selector.TypeSelector;

public class ThemeLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> loadThemeLinesFromFTBQuests(Path ftbQuestsPath) {
        Path[] possiblePaths;
        for (Path path : possiblePaths = new Path[]{ftbQuestsPath.resolve("ftb_quests_theme.txt"), ftbQuestsPath.resolve("theme.txt"), ftbQuestsPath.getParent() != null ? ftbQuestsPath.getParent().resolve("config/ftbquests/theme.txt") : null, ftbQuestsPath.getParent() != null && ftbQuestsPath.getParent().getParent() != null ? ftbQuestsPath.getParent().getParent().resolve("config/ftbquests/theme.txt") : null}) {
            if (path == null || !Files.exists(path, new LinkOption[0])) continue;
            try {
                return Files.readAllLines(path);
            }
            catch (IOException e) {
                System.err.println("Failed to read theme file: " + String.valueOf(path) + ": " + e.getMessage());
            }
        }
        try (InputStream in = ThemeLoader.class.getClassLoader().getResourceAsStream("assets/ftbquests/ftb_quests_theme.txt");){
            if (in == null) return null;
            List<String> list = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            System.err.println("Failed to load theme from classpath: " + e.getMessage());
        }
        return null;
    }

    public static QuestTheme loadTheme(Path themePath) {
        if (!Files.exists(themePath, new LinkOption[0])) {
            System.err.println("Theme file not found: " + String.valueOf(themePath));
            return ThemeLoader.createDefaultTheme();
        }
        try {
            List<String> lines = Files.readAllLines(themePath);
            return ThemeLoader.parseTheme(lines);
        }
        catch (IOException e) {
            System.err.println("Failed to load theme file: " + e.getMessage());
            return ThemeLoader.createDefaultTheme();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QuestTheme loadFromFTBQuests(Path ftbQuestsPath) {
        Path[] possiblePaths = new Path[]{ftbQuestsPath.resolve("ftb_quests_theme.txt"), ftbQuestsPath.resolve("theme.txt"), ftbQuestsPath.getParent() != null ? ftbQuestsPath.getParent().resolve("config/ftbquests/theme.txt") : null, ftbQuestsPath.getParent() != null && ftbQuestsPath.getParent().getParent() != null ? ftbQuestsPath.getParent().getParent().resolve("config/ftbquests/theme.txt") : null};
        System.out.println("Attempting to load FTB Quests theme. Search roots:");
        for (Path p : possiblePaths) {
            System.out.println("  - " + String.valueOf(p));
        }
        for (Path path : possiblePaths) {
            if (path == null || !Files.exists(path, new LinkOption[0])) continue;
            System.out.println("Loading theme from: " + String.valueOf(path));
            return ThemeLoader.loadTheme(path);
        }
        try (InputStream in = ThemeLoader.class.getClassLoader().getResourceAsStream("assets/ftbquests/ftb_quests_theme.txt");){
            if (in != null) {
                System.out.println("Loading theme from classpath: assets/ftbquests/ftb_quests_theme.txt");
                List<String> lines = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                QuestTheme questTheme = ThemeLoader.parseTheme(lines);
                return questTheme;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load theme from classpath: " + e.getMessage());
        }
        System.out.println("No theme file found, using default theme");
        return ThemeLoader.createDefaultTheme();
    }

    public static QuestTheme parseTheme(List<String> lines) {
        HashMap<ThemeSelector, SelectorProperties> selectorPropertyMap = new HashMap<ThemeSelector, SelectorProperties>();
        ThemeLoader.parse(selectorPropertyMap, lines, null, null);
        QuestTheme theme = new QuestTheme();
        theme.defaults = (SelectorProperties)selectorPropertyMap.remove(AllSelector.INSTANCE);
        if (theme.defaults == null) {
            theme.defaults = new SelectorProperties(AllSelector.INSTANCE);
        }
        theme.selectors.addAll(selectorPropertyMap.values());
        theme.selectors.sort(null);
        System.out.println("Theme loaded with " + theme.selectors.size() + " selectors");
        System.out.println("Default properties: " + theme.defaults.properties.size());
        theme.setPanels(PanelTemplateLoader.loadPanels("default"));
        QuestTheme.instance = theme;
        QuestTheme.instance.clearCache();
        return theme;
    }

    public static QuestTheme parseTheme(List<String> lines, Map<String, String> idMap, Set<String> chapterIds) {
        HashMap<ThemeSelector, SelectorProperties> selectorPropertyMap = new HashMap<ThemeSelector, SelectorProperties>();
        ThemeLoader.parse(selectorPropertyMap, lines, idMap, chapterIds);
        QuestTheme theme = new QuestTheme();
        theme.defaults = (SelectorProperties)selectorPropertyMap.remove(AllSelector.INSTANCE);
        if (theme.defaults == null) {
            theme.defaults = new SelectorProperties(AllSelector.INSTANCE);
        }
        theme.selectors.addAll(selectorPropertyMap.values());
        theme.selectors.sort(null);
        System.out.println("Theme (with ID remap + chapter IDs) loaded with " + theme.selectors.size() + " selectors");
        System.out.println("Default properties: " + theme.defaults.properties.size());
        theme.setPanels(PanelTemplateLoader.loadPanels("default"));
        QuestTheme.instance = theme;
        QuestTheme.instance.clearCache();
        return theme;
    }

    public static QuestTheme parseTheme(List<String> lines, Map<String, String> idMap) {
        HashMap<ThemeSelector, SelectorProperties> selectorPropertyMap = new HashMap<ThemeSelector, SelectorProperties>();
        ThemeLoader.parse(selectorPropertyMap, lines, idMap, null);
        QuestTheme theme = new QuestTheme();
        theme.defaults = (SelectorProperties)selectorPropertyMap.remove(AllSelector.INSTANCE);
        if (theme.defaults == null) {
            theme.defaults = new SelectorProperties(AllSelector.INSTANCE);
        }
        theme.selectors.addAll(selectorPropertyMap.values());
        theme.selectors.sort(null);
        System.out.println("Theme (with ID remap) loaded with " + theme.selectors.size() + " selectors");
        System.out.println("Default properties: " + theme.defaults.properties.size());
        theme.setPanels(PanelTemplateLoader.loadPanels("default"));
        QuestTheme.instance = theme;
        QuestTheme.instance.clearCache();
        return theme;
    }

    private static void parse(Map<ThemeSelector, SelectorProperties> selectorPropertyMap, List<String> lines, Map<String, String> idMap, Set<String> chapterIds) {
        ArrayList<SelectorProperties> current = new ArrayList<SelectorProperties>();
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("//") || line.startsWith("#")) continue;
            int si = line.indexOf(91);
            int ei = line.indexOf(93);
            if (si >= 0 && ei > si) {
                current.clear();
                String selectorText = line.substring(si + 1, ei);
                for (String sel : selectorText.split("\\|")) {
                    AndSelector andSelector = new AndSelector();
                    for (String sel1 : sel.trim().split("&")) {
                        ThemeSelector themeSelector = ThemeLoader.parseSelector(Pattern.compile("\\s").matcher(sel1).replaceAll(""), idMap, chapterIds);
                        if (themeSelector == null) continue;
                        andSelector.selectors.add(themeSelector);
                    }
                    if (andSelector.selectors.isEmpty()) continue;
                    AndSelector selector = andSelector.selectors.size() == 1 ? andSelector.selectors.get(0) : andSelector;
                    current.add(selectorPropertyMap.computeIfAbsent(selector, SelectorProperties::new));
                }
                continue;
            }
            String[] parts = line.split(":", 2);
            if (parts.length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            int c1 = value.indexOf("//");
            if (c1 >= 0) {
                value = value.substring(0, c1).trim();
            }
            if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            if (key.isEmpty() || value.isEmpty()) continue;
            if (current.isEmpty()) {
                SelectorProperties defaults = selectorPropertyMap.computeIfAbsent(AllSelector.INSTANCE, SelectorProperties::new);
                defaults.properties.put(key, value);
                continue;
            }
            for (SelectorProperties selectorProperties : current) {
                selectorProperties.properties.put(key, value);
            }
        }
    }

    private static ThemeSelector parseSelector(String sel, Map<String, String> idMap, Set<String> chapterIds) {
        String mapped;
        if (sel == null || sel.isEmpty()) {
            return null;
        }
        if (sel.equals("*")) {
            return AllSelector.INSTANCE;
        }
        if (sel.startsWith("!")) {
            ThemeSelector s = ThemeLoader.parseSelector(sel.substring(1), idMap, chapterIds);
            return s == null ? null : new NotSelector(s);
        }
        if (sel.startsWith("#")) {
            String tag = sel.substring(1);
            return tag.isEmpty() ? null : new TagSelector(tag);
        }
        if (sel.startsWith("group:")) {
            String group = sel.substring(6);
            return group.isEmpty() ? null : new GroupSelector(group);
        }
        if (sel.startsWith("chapter:")) {
            String chapter = sel.substring(8);
            return chapter.isEmpty() ? null : new ChapterSelector(chapter);
        }
        if (sel.startsWith("type:")) {
            String type = sel.substring(5);
            return type.isEmpty() ? null : new TypeSelector(type);
        }
        if (sel.startsWith("parent:")) {
            String pid = sel.substring(7);
            return pid.isEmpty() ? null : new ChapterSelector(pid);
        }
        if (sel.startsWith("ancestor:")) {
            String aid = sel.substring(9);
            return aid.isEmpty() ? null : new ChapterSelector(aid);
        }
        if (chapterIds != null) {
            if (chapterIds.contains(sel)) {
                return new ChapterSelector(sel);
            }
            if (sel.endsWith("L") && chapterIds.contains(sel.substring(0, sel.length() - 1))) {
                return new ChapterSelector(sel.substring(0, sel.length() - 1));
            }
        }
        if (idMap != null && (mapped = idMap.get(sel)) != null && !mapped.isEmpty()) {
            return new IDSelector(mapped);
        }
        return new IDSelector(sel);
    }

    public static QuestTheme createDefaultTheme() {
        QuestTheme theme = new QuestTheme();
        theme.defaults = new SelectorProperties(AllSelector.INSTANCE);
        Map<String, String> props = theme.defaults.properties;
        props.put("text_color", "#FFFFFF");
        props.put("hover_text_color", "#FFFFA0");
        props.put("disabled_text_color", "#999999");
        props.put("widget_border", "#1B1D1E");
        props.put("widget_background", "#44000000");
        props.put("quest_completed_color", "#C856FF56");
        props.put("quest_started_color", "#C800FFFF");
        props.put("quest_not_started_color", "#96FFFFFF");
        props.put("quest_locked_color", "#FF999999");
        props.put("dependency_line_completed_color", "#64DC64");
        props.put("dependency_line_uncompleted_color", "#B4CCA3A3");
        props.put("dependency_line_thickness", "0.17");
        props.put("quest_spacing", "1.0");
        props.put("quest_shade_mode", "linear");
        props.put("quest_shade_direction", "down_right");
        props.put("quest_shade_strength", "0.0");
        props.put("quest_shade_color", "#FF000000");
        System.out.println("Created default theme");
        return theme;
    }
}

