/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.texboobcat.questory.theme.panel.PanelNode;

public class ListNode
extends PanelNode {
    private String items;
    private PanelNode itemTemplate;

    @Override
    public String getType() {
        return "list";
    }

    @Override
    protected void parseSpecificProperties(JsonObject json) {
        if (json.has("items")) {
            this.items = json.get("items").getAsString();
        }
        if (json.has("item")) {
            JsonObject itemJson = json.getAsJsonObject("item");
            this.itemTemplate = PanelNode.fromJson(itemJson);
        }
    }

    public void setItems(String items) {
        this.items = items;
    }

    public void setItemTemplate(PanelNode itemTemplate) {
        this.itemTemplate = itemTemplate;
    }

    @Override
    protected void addSpecificProperties(JsonObject json) {
        if (this.items != null) {
            json.addProperty("items", this.items);
        }
        if (this.itemTemplate != null) {
            json.add("item", (JsonElement)this.itemTemplate.toJson());
        }
    }

    @Override
    public PanelNode deepCopy() {
        ListNode copy = new ListNode();
        this.copyCommonProperties(copy);
        copy.items = this.items;
        if (this.itemTemplate != null) {
            copy.itemTemplate = this.itemTemplate.deepCopy();
        }
        return copy;
    }

    public String getItems() {
        return this.items;
    }

    public PanelNode getItemTemplate() {
        return this.itemTemplate;
    }
}

