/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.questory.theme.panel.PanelNode;

public class StackNode
extends PanelNode {
    private List<PanelNode> children = new ArrayList<PanelNode>();

    @Override
    public String getType() {
        return "stack";
    }

    @Override
    protected void parseSpecificProperties(JsonObject json) {
        if (json.has("children")) {
            JsonArray childrenArray = json.getAsJsonArray("children");
            for (JsonElement element : childrenArray) {
                PanelNode child;
                if (!element.isJsonObject() || (child = PanelNode.fromJson(element.getAsJsonObject())) == null) continue;
                this.children.add(child);
            }
        }
    }

    public void setChildren(List<PanelNode> children) {
        this.children = children;
    }

    @Override
    protected void addSpecificProperties(JsonObject json) {
        if (!this.children.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (PanelNode child : this.children) {
                arr.add((JsonElement)child.toJson());
            }
            json.add("children", (JsonElement)arr);
        }
    }

    @Override
    public PanelNode deepCopy() {
        StackNode copy = new StackNode();
        this.copyCommonProperties(copy);
        for (PanelNode child : this.children) {
            copy.children.add(child.deepCopy());
        }
        return copy;
    }

    public List<PanelNode> getChildren() {
        return this.children;
    }
}

