/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.property;

import org.texboobcat.questory.theme.property.ThemeProperty;

public class ColorProperty
extends ThemeProperty<Integer> {
    public ColorProperty(String name) {
        super(name, -1);
    }

    public ColorProperty(String name, int defaultValue) {
        super(name, defaultValue);
    }

    @Override
    public Integer parse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if ((string = string.trim()).startsWith("#")) {
            string = string.substring(1);
        }
        try {
            if (string.length() == 6) {
                return (int)(0xFF000000L | Long.parseLong(string, 16));
            }
            if (string.length() == 8) {
                return (int)Long.parseLong(string, 16);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse color: " + string);
        }
        return null;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int fromARGB(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

