/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;

public enum QuestShape {
    SQUARE("square", "default"),
    CIRCLE("circle", new String[0]),
    RSQUARE("rsquare", "rounded_square"),
    DIAMOND("diamond", new String[0]),
    HEXAGON("hexagon", new String[0]),
    OCTAGON("octagon", new String[0]),
    HEART("heart", new String[0]),
    GEAR("gear", new String[0]);

    private final String id;
    private final String[] aliases;
    private static final Map<String, QuestShape> EXTRA_ALIAS_REGISTRY;

    private QuestShape(String id, String ... aliases) {
        this.id = id;
        this.aliases = aliases;
    }

    public String getId() {
        return this.id;
    }

    public static QuestShape get(String shapeId) {
        if (shapeId == null || shapeId.isEmpty() || "default".equals(shapeId)) {
            return SQUARE;
        }
        QuestShape mapped = EXTRA_ALIAS_REGISTRY.get(shapeId.toLowerCase(Locale.ROOT));
        if (mapped != null) {
            return mapped;
        }
        for (QuestShape shape : QuestShape.values()) {
            if (!shape.id.equalsIgnoreCase(shapeId)) continue;
            return shape;
        }
        for (QuestShape shape : QuestShape.values()) {
            for (String alias : shape.aliases) {
                if (!alias.equalsIgnoreCase(shapeId)) continue;
                return shape;
            }
        }
        return SQUARE;
    }

    public static void registerExtraAliases(String csv) {
        String[] parts;
        if (csv == null || csv.isEmpty()) {
            return;
        }
        for (String p : parts = csv.split(",")) {
            String name = p.trim().toLowerCase(Locale.ROOT);
            if (name.isEmpty()) continue;
            EXTRA_ALIAS_REGISTRY.put(name, switch (name) {
                case "square", "rsquare", "rounded_square" -> RSQUARE;
                case "circle" -> CIRCLE;
                case "diamond" -> DIAMOND;
                case "hexagon" -> HEXAGON;
                case "octagon" -> OCTAGON;
                case "heart" -> HEART;
                case "gear" -> GEAR;
                case "pentagon" -> HEXAGON;
                default -> DIAMOND;
            });
        }
    }

    public void drawBackground(GuiGraphics graphics, int x, int y, int size, int color) {
        switch (this.ordinal()) {
            case 1: {
                this.drawCircle(graphics, x, y, size, color);
                break;
            }
            case 3: {
                this.drawDiamond(graphics, x, y, size, color);
                break;
            }
            case 4: {
                this.drawHexagon(graphics, x, y, size, color);
                break;
            }
            case 5: {
                this.drawOctagon(graphics, x, y, size, color);
                break;
            }
            case 2: {
                this.drawRoundedSquare(graphics, x, y, size, color);
                break;
            }
            case 6: {
                this.drawHeart(graphics, x, y, size, color);
                break;
            }
            case 7: {
                this.drawGear(graphics, x, y, size, color);
                break;
            }
            default: {
                graphics.m_280509_(x, y, x + size, y + size, color);
            }
        }
    }

    public void drawOutline(GuiGraphics graphics, int x, int y, int size, int color, int thickness) {
        this.drawBackground(graphics, x - thickness, y - thickness, size + thickness * 2, color);
    }

    public boolean contains(int shapeX, int shapeY, int shapeSize, int pointX, int pointY) {
        int centerX = shapeX + shapeSize / 2;
        int centerY = shapeY + shapeSize / 2;
        int dx = pointX - centerX;
        int dy = pointY - centerY;
        return switch (this.ordinal()) {
            case 1 -> {
                if (dx * dx + dy * dy <= shapeSize / 2 * (shapeSize / 2)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (Math.abs(dx) + Math.abs(dy) <= shapeSize / 2) {
                    yield true;
                }
                yield false;
            }
            case 4, 5, 6, 7 -> this.containsComplex(dx, dy, shapeSize);
            default -> pointX >= shapeX && pointX < shapeX + shapeSize && pointY >= shapeY && pointY < shapeY + shapeSize;
        };
    }

    private void drawCircle(GuiGraphics graphics, int x, int y, int size, int color) {
        int centerX = x + size / 2;
        int centerY = y + size / 2;
        int radius = size / 2;
        for (int py = 0; py < size; ++py) {
            for (int px = 0; px < size; ++px) {
                int dx = px - radius;
                int dy = py - radius;
                if (dx * dx + dy * dy > radius * radius) continue;
                graphics.m_280509_(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private void drawDiamond(GuiGraphics graphics, int x, int y, int size, int color) {
        int centerX = x + size / 2;
        int centerY = y + size / 2;
        int halfSize = size / 2;
        for (int py = 0; py < size; ++py) {
            for (int px = 0; px < size; ++px) {
                int dy;
                int dx = Math.abs(px - halfSize);
                if (dx + (dy = Math.abs(py - halfSize)) > halfSize) continue;
                graphics.m_280509_(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private void drawRoundedSquare(GuiGraphics graphics, int x, int y, int size, int color) {
        int cornerRadius = size / 5;
        graphics.m_280509_(x + cornerRadius, y, x + size - cornerRadius, y + size, color);
        graphics.m_280509_(x, y + cornerRadius, x + cornerRadius, y + size - cornerRadius, color);
        graphics.m_280509_(x + size - cornerRadius, y + cornerRadius, x + size, y + size - cornerRadius, color);
        this.drawCornerCircle(graphics, x + cornerRadius, y + cornerRadius, cornerRadius, color);
        this.drawCornerCircle(graphics, x + size - cornerRadius, y + cornerRadius, cornerRadius, color);
        this.drawCornerCircle(graphics, x + cornerRadius, y + size - cornerRadius, cornerRadius, color);
        this.drawCornerCircle(graphics, x + size - cornerRadius, y + size - cornerRadius, cornerRadius, color);
    }

    private void drawCornerCircle(GuiGraphics graphics, int centerX, int centerY, int radius, int color) {
        for (int py = -radius; py <= radius; ++py) {
            for (int px = -radius; px <= radius; ++px) {
                if (px * px + py * py > radius * radius) continue;
                graphics.m_280509_(centerX + px, centerY + py, centerX + px + 1, centerY + py + 1, color);
            }
        }
    }

    private void drawHexagon(GuiGraphics graphics, int x, int y, int size, int color) {
        int centerX = x + size / 2;
        int centerY = y + size / 2;
        int radius = size / 2;
        for (int py = 0; py < size; ++py) {
            for (int px = 0; px < size; ++px) {
                if (!this.isInsideHexagon(px - radius, py - radius, radius)) continue;
                graphics.m_280509_(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean isInsideHexagon(int dx, int dy, int radius) {
        double distance = (double)Math.abs(dx) + (double)Math.abs(dy) / 1.732;
        return distance <= (double)radius;
    }

    private void drawOctagon(GuiGraphics graphics, int x, int y, int size, int color) {
        int cutoff = size / 4;
        for (int py = 0; py < size; ++py) {
            for (int px = 0; px < size; ++px) {
                int dy;
                int dx = Math.abs(px - size / 2);
                if (dx + (dy = Math.abs(py - size / 2)) > size * 3 / 4) continue;
                graphics.m_280509_(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private void drawHeart(GuiGraphics graphics, int x, int y, int size, int color) {
        int centerX = size / 2;
        int centerY = size / 2;
        for (int py = 0; py < size; ++py) {
            for (int px = 0; px < size; ++px) {
                if (!this.isInsideHeart(px - centerX, py - centerY, size / 2)) continue;
                graphics.m_280509_(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean isInsideHeart(int dx, int dy, int size) {
        double x = (double)dx / (double)size;
        double y = (double)(-dy) / (double)size + 0.3;
        return (x * x + y * y - 1.0) * (x * x + y * y - 1.0) * (x * x + y * y - 1.0) - x * x * y * y * y <= 0.0;
    }

    private void drawGear(GuiGraphics graphics, int x, int y, int size, int color) {
        int centerX = x + size / 2;
        int centerY = y + size / 2;
        int outerRadius = size / 2;
        int innerRadius = (int)((double)(size / 2) * 0.7);
        for (int py = 0; py < size; ++py) {
            for (int px = 0; px < size; ++px) {
                int radius;
                int dy = py - size / 2;
                int dx = px - size / 2;
                double angle = Math.atan2(dy, dx);
                int teeth = (int)((angle + Math.PI) / 0.7853981633974483) % 2;
                int n = radius = teeth == 0 ? outerRadius : innerRadius;
                if (dx * dx + dy * dy > radius * radius) continue;
                graphics.m_280509_(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
    }

    private boolean containsComplex(int dx, int dy, int size) {
        return Math.abs(dx) <= size / 2 && Math.abs(dy) <= size / 2;
    }

    static {
        EXTRA_ALIAS_REGISTRY = new HashMap<String, QuestShape>();
    }
}

