/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.texboobcat.questory.client.rendering.AnimationHelper;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeLoader;

public class ThemeEditorScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemeEditorScreen.class);
    private static final int PANEL_WIDTH = 300;
    private static final int PREVIEW_WIDTH = 400;
    private static final int SPACING = 10;
    private final Screen parent;
    private QuestTheme currentTheme;
    private String themeName = "custom_theme";
    private EditBox themeNameBox;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private final Map<String, PropertyEditor> propertyEditors = new HashMap<String, PropertyEditor>();
    private final List<String> propertyCategories = new ArrayList<String>();
    private boolean previewDirty = true;
    private long lastPreviewUpdate = 0L;

    public ThemeEditorScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Theme Editor"));
        this.parent = parent;
        this.currentTheme = new QuestTheme();
        this.initializePropertyCategories();
    }

    public ThemeEditorScreen(Screen parent, QuestTheme theme, String name) {
        this(parent);
        this.currentTheme = theme;
        this.themeName = name;
    }

    private void initializePropertyCategories() {
        this.propertyCategories.add("Quest Appearance");
        this.propertyCategories.add("Colors");
        this.propertyCategories.add("Dependency Lines");
        this.propertyCategories.add("Background");
        this.propertyCategories.add("Icons");
        this.propertyCategories.add("Animation");
    }

    protected void m_7856_() {
        super.m_7856_();
        this.themeNameBox = new EditBox(this.f_96547_, this.f_96543_ - 300 + 10, 30, 280, 20, (Component)Component.m_237113_((String)"Theme Name"));
        this.themeNameBox.m_94144_(this.themeName);
        this.themeNameBox.m_94199_(50);
        this.m_142416_((GuiEventListener)this.themeNameBox);
        int categoryY = 60;
        for (String category : this.propertyCategories) {
            Button categoryButton = Button.m_253074_((Component)Component.m_237113_((String)category), b -> this.selectCategory(category)).m_252987_(this.f_96543_ - 300 + 10, categoryY, 280, 20).m_253136_();
            this.m_142416_((GuiEventListener)categoryButton);
            categoryY += 25;
        }
        int bottomY = this.f_96544_ - 30;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save Theme"), b -> this.saveTheme()).m_252987_(this.f_96543_ - 300 + 10, bottomY, 90, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Load"), b -> this.loadTheme()).m_252987_(this.f_96543_ - 300 + 100, bottomY, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset"), b -> this.resetTheme()).m_252987_(this.f_96543_ - 300 + 170, bottomY, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(this.f_96543_ - 300 + 240, bottomY, 50, 20).m_253136_());
        this.initializePropertyEditors();
    }

    private void initializePropertyEditors() {
        this.propertyEditors.put("Quest Size", new SliderEditor("size", 0.5f, 3.0f, 1.0f));
        this.propertyEditors.put("Quest Spacing", new SliderEditor("spacing", 0.0f, 8.0f, 2.0f));
        this.propertyEditors.put("Icon Scale", new SliderEditor("icon_scale", 0.5f, 2.0f, 1.0f));
        this.propertyEditors.put("Shape", new TextEditor("shape", "circle"));
        this.propertyEditors.put("Completed Color", new ColorEditor("completed_color", -16711936));
        this.propertyEditors.put("Started Color", new ColorEditor("started_color", -256));
        this.propertyEditors.put("Locked Color", new ColorEditor("locked_color", -8355712));
        this.propertyEditors.put("Not Started Color", new ColorEditor("not_started_color", -1));
        this.propertyEditors.put("Line Thickness", new SliderEditor("line_thickness", 1.0f, 5.0f, 2.0f));
        this.propertyEditors.put("Line Animation Speed", new SliderEditor("line_speed", 0.0f, 10.0f, 1.0f));
        this.propertyEditors.put("Line Color", new ColorEditor("line_color", -1));
        this.propertyEditors.put("Background Path", new TextEditor("background_path", "minecraft:textures/block/stone.png"));
        this.propertyEditors.put("Background Tile Size", new SliderEditor("background_tile", 0.0f, 64.0f, 16.0f));
        this.propertyEditors.put("Background Tint", new ColorEditor("background_tint", 0));
        this.propertyEditors.put("Enable Animations", new BooleanEditor("animations", true));
        this.propertyEditors.put("Pulse Speed", new SliderEditor("pulse_speed", 0.0f, 10.0f, 3.0f));
    }

    private void selectCategory(String category) {
        this.scrollOffset = 0;
        this.previewDirty = true;
    }

    private void saveTheme() {
        block14: {
            String name = this.themeNameBox.m_94155_();
            if (name.isEmpty()) {
                name = "custom_theme";
            }
            try {
                Path configDir = Paths.get("config", "questory", "themes");
                Files.createDirectories(configDir, new FileAttribute[0]);
                Path themePath = configDir.resolve(name + ".txt");
                try (BufferedWriter writer = Files.newBufferedWriter(themePath, new OpenOption[0]);){
                    writer.write("// Questory Theme: " + name);
                    writer.newLine();
                    writer.write("// Generated by Theme Editor");
                    writer.newLine();
                    writer.newLine();
                    writer.write("[*]");
                    writer.newLine();
                    for (Map.Entry<String, PropertyEditor> entry : this.propertyEditors.entrySet()) {
                        String display = entry.getKey();
                        Object value = entry.getValue().getValue();
                        if (value == null) continue;
                        if ("Line Animation Speed".equals(display)) {
                            String v = this.formatPropertyValue(value);
                            writer.write("dependency_line_selected_speed: " + v);
                            writer.newLine();
                            writer.write("dependency_line_unselected_speed: " + v);
                            writer.newLine();
                            continue;
                        }
                        String key = this.mapDisplayToThemeKey(display);
                        if (key == null || key.isEmpty()) continue;
                        String valueStr = this.formatPropertyValue(value);
                        writer.write(key + ": " + valueStr);
                        writer.newLine();
                    }
                    String bg = this.buildBackgroundIconString((String)this.getEditorValue("Background Path"), (Number)this.getEditorValue("Background Tile Size"), (Integer)this.getEditorValue("Background Tint"));
                    if (bg != null) {
                        writer.write("background: " + bg);
                        writer.newLine();
                    }
                }
                LOGGER.info("Saved theme to: {}", (Object)themePath);
                QuestTheme.instance = this.currentTheme = ThemeLoader.loadTheme(themePath);
                QuestTheme.instance.clearCache();
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Theme saved: " + String.valueOf(themePath.getFileName()))));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to save theme", (Throwable)e);
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block14;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to save theme: " + e.getMessage())));
            }
        }
    }

    private String mapDisplayToThemeKey(String displayName) {
        switch (displayName) {
            case "Quest Spacing": {
                return "quest_spacing";
            }
            case "Completed Color": {
                return "quest_completed_color";
            }
            case "Started Color": {
                return "quest_started_color";
            }
            case "Locked Color": {
                return "quest_locked_color";
            }
            case "Not Started Color": {
                return "quest_not_started_color";
            }
            case "Line Thickness": {
                return "dependency_line_thickness";
            }
            case "Line Color": {
                return "dependency_line_uncompleted_color";
            }
        }
        return null;
    }

    private Object getEditorValue(String displayName) {
        PropertyEditor ed = this.propertyEditors.get(displayName);
        return ed == null ? null : ed.getValue();
    }

    private String buildBackgroundIconString(String path, Number tileSizeValue, Integer tint) {
        int a;
        int tile;
        if (path == null || path.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(path.trim());
        if (tileSizeValue != null && (tile = Math.max(0, (int)Math.round(tileSizeValue.doubleValue()))) > 0) {
            sb.append("; tile_size=").append(tile);
        }
        if (tint != null && (a = tint >> 24 & 0xFF) != 0) {
            sb.append("; color=").append(String.format("#%08X", tint));
        }
        return sb.toString();
    }

    private String formatPropertyValue(Object value) {
        if (value instanceof Integer) {
            int color = (Integer)value;
            return String.format("#%08X", color);
        }
        if (value instanceof Float) {
            return String.format("%.2f", (Float)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        return value.toString();
    }

    private void loadTheme() {
        block7: {
            try {
                Path themesDir = Paths.get("config", "questory", "themes");
                if (!Files.exists(themesDir, new LinkOption[0])) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"No themes directory found"));
                    }
                    return;
                }
                ArrayList themes = new ArrayList();
                Files.list(themesDir).filter(p -> p.toString().endsWith(".txt")).forEach(p -> themes.add(p.getFileName().toString().replace(".txt", "")));
                if (themes.isEmpty()) {
                    if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("No themes found in " + String.valueOf(themesDir))));
                    }
                    return;
                }
                String themeName = (String)themes.get(0);
                Path themePath = themesDir.resolve(themeName + ".txt");
                QuestTheme.instance = this.currentTheme = ThemeLoader.loadTheme(themePath);
                QuestTheme.instance.clearCache();
                this.previewDirty = true;
                LOGGER.info("Loaded theme: {}", (Object)themeName);
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Loaded theme: " + themeName + " (" + themes.size() + " available)")));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load theme", (Throwable)e);
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block7;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("Failed to load theme: " + e.getMessage())));
            }
        }
    }

    private void resetTheme() {
        this.currentTheme = new QuestTheme();
        this.previewDirty = true;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.renderEditorPanel(graphics, mouseX, mouseY);
        this.renderPreviewPanel(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, -1);
    }

    private void renderEditorPanel(GuiGraphics graphics, int mouseX, int mouseY) {
        int panelX = this.f_96543_ - 300;
        int panelY = 0;
        int panelHeight = this.f_96544_;
        graphics.m_280509_(panelX, panelY, panelX + 300, panelY + panelHeight, -536870912);
        graphics.m_280509_(panelX, panelY, panelX + 2, panelY + panelHeight, -12566464);
        int propertyY = 200 - this.scrollOffset;
        for (Map.Entry<String, PropertyEditor> entry : this.propertyEditors.entrySet()) {
            if (propertyY > 200 && propertyY < this.f_96544_ - 60) {
                String label = entry.getKey();
                PropertyEditor editor = entry.getValue();
                graphics.m_280488_(this.f_96547_, label, panelX + 10, propertyY, -1);
                editor.render(graphics, panelX + 10, propertyY + 12, 280, 20, mouseX, mouseY);
                propertyY += 40;
                continue;
            }
            propertyY += 40;
        }
        this.maxScroll = Math.max(0, propertyY - (this.f_96544_ - 260));
    }

    private void renderPreviewPanel(GuiGraphics graphics, int mouseX, int mouseY) {
        int previewX = 10;
        int previewY = 40;
        int previewHeight = this.f_96544_ - 80;
        graphics.m_280509_(previewX, previewY, previewX + 400, previewY + previewHeight, -536870912);
        graphics.m_280509_(previewX, previewY, previewX + 400, previewY + 2, -12566464);
        graphics.m_280137_(this.f_96547_, "Preview", previewX + 200, previewY + 10, -256);
        this.renderPreviewQuest(graphics, previewX + 50, previewY + 100, mouseX, mouseY);
        this.renderPreviewDependencyLine(graphics, previewX + 50, previewY + 100, previewX + 200, previewY + 200);
        this.renderPreviewQuest(graphics, previewX + 200, previewY + 200, mouseX, mouseY);
    }

    private void renderPreviewQuest(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        int size = 40;
        int pulseColor = AnimationHelper.getPulsingColor(-1);
        graphics.m_280509_(x - 1, y - 1, x + size + 1, y + size + 1, pulseColor);
        graphics.m_280509_(x, y, x + size, y + size, -12566464);
        graphics.m_280509_(x + 10, y + 10, x + 30, y + 30, -16711681);
        int indicatorSize = 12;
        graphics.m_280509_(x + size - indicatorSize, y, x + size, y + indicatorSize, -16711936);
    }

    private void renderPreviewDependencyLine(GuiGraphics graphics, int x1, int y1, int x2, int y2) {
        float offset = AnimationHelper.DependencyLineAnimation.getLineOffset(true, 0.001);
        int lineColor = AnimationHelper.DependencyLineAnimation.getAnimatedLineColor(-1, false, true);
        graphics.m_280509_(x1, y1, x2, y1 + 2, lineColor);
        graphics.m_280509_(x2 - 2, y1, x2, y2, lineColor);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX > (double)(this.f_96543_ - 300)) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private static class SliderEditor
    extends PropertyEditor {
        private float min;
        private float max;
        private float current;

        public SliderEditor(String name, float min, float max, float defaultValue) {
            super(name);
            this.min = min;
            this.max = max;
            this.current = defaultValue;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y + height / 2 - 2, x + width, y + height / 2 + 2, -12566464);
            int handleX = (int)((float)x + (this.current - this.min) / (this.max - this.min) * (float)width);
            graphics.m_280509_(handleX - 3, y, handleX + 3, y + height, -1);
            String valueStr = String.format("%.2f", Float.valueOf(this.current));
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, valueStr, x + width + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.current);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Number) {
                this.current = ((Number)value).floatValue();
            }
        }
    }

    private static class TextEditor
    extends PropertyEditor {
        private String text;

        public TextEditor(String name, String defaultValue) {
            super(name);
            this.text = defaultValue;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y, x + width, y + height, -14671840);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, this.text, x + 2, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.text;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                this.text = (String)value;
            }
        }
    }

    private static class ColorEditor
    extends PropertyEditor {
        private int color;

        public ColorEditor(String name, int defaultColor) {
            super(name);
            this.color = defaultColor;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y, x + height, y + height, this.color);
            graphics.m_280509_(x, y, x + height, y + 1, -1);
            graphics.m_280509_(x, y, x + 1, y + height, -1);
            graphics.m_280509_(x + height - 1, y, x + height, y + height, -1);
            graphics.m_280509_(x, y + height - 1, x + height, y + height, -1);
            String hexStr = String.format("#%08X", this.color);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, hexStr, x + height + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.color;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Integer) {
                this.color = (Integer)value;
            }
        }
    }

    private static class BooleanEditor
    extends PropertyEditor {
        private boolean value;

        public BooleanEditor(String name, boolean defaultValue) {
            super(name);
            this.value = defaultValue;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
            graphics.m_280509_(x, y, x + height, y + height, this.value ? -16711936 : -12566464);
            graphics.m_280509_(x, y, x + height, y + 1, -1);
            graphics.m_280509_(x, y, x + 1, y + height, -1);
            graphics.m_280509_(x + height - 1, y, x + height, y + height, -1);
            graphics.m_280509_(x, y + height - 1, x + height, y + height, -1);
            String label = this.value ? "Enabled" : "Disabled";
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, label, x + height + 5, y + height / 2 - 4, -1);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Boolean) {
                this.value = (Boolean)value;
            }
        }
    }

    private static abstract class PropertyEditor {
        protected String propertyName;

        public PropertyEditor(String propertyName) {
            this.propertyName = propertyName;
        }

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public abstract Object getValue();

        public abstract void setValue(Object var1);
    }
}

