/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.events;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class QuestEvents {
    public static void onItemObtained(ServerPlayer player, ItemStack stack) {
        if (stack.m_41619_()) {
            System.out.println("[Questory Debug] onItemObtained called with empty stack");
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        System.out.println("[Questory Debug] onItemObtained: Player=" + player.m_7755_().getString() + ", Item=" + String.valueOf(itemId) + ", Count=" + stack.m_41613_());
        QuestManager.getInstance().trackItemProgress(player.m_20148_(), itemId.toString(), stack.m_41613_(), player);
    }

    public static void onItemCrafted(ServerPlayer player, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        QuestManager.getInstance().trackCraftingProgress(player.m_20148_(), itemId.toString(), stack.m_41613_(), player);
        QuestEvents.onItemObtained(player, stack);
    }

    public static void onEntityKilled(ServerPlayer player, LivingEntity entity) {
        ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        QuestManager.getInstance().trackEntityKillProgress(player.m_20148_(), entityId.toString(), 1, player);
    }

    public static void onAdvancementEarned(ServerPlayer player, ResourceLocation advancementId) {
        QuestManager.getInstance().trackAdvancementProgress(player.m_20148_(), advancementId.toString(), player);
    }

    public static void onPlayerDisconnect(ServerPlayer player) {
        QuestManager.getInstance().onPlayerDisconnect(player.m_20148_());
    }

    public static void onPlayerJoin(ServerPlayer player) {
        QuestManager.getInstance().onPlayerJoin(player);
    }

    public static void onInventoryChanged(ServerPlayer player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        boolean changed = false;
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                if (!(req instanceof ItemRequirement)) continue;
                ItemRequirement itemReq = (ItemRequirement)req;
                int invCount = QuestEvents.countItemInInventory(player, itemReq.getItem());
                int cap = Math.min(invCount, itemReq.getCount());
                if (!itemReq.shouldConsume()) {
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    if (before == cap) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                int existing = progress.getRequirementProgress(quest.getId(), req);
                if (cap <= existing) continue;
                progress.setRequirementProgress(quest.getId(), req, cap);
                changed = true;
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static int countItemInInventory(ServerPlayer player, String itemIdString) {
        ResourceLocation itemId = new ResourceLocation(itemIdString);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
        if (item == null) {
            return 0;
        }
        int total = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    public static void onStatisticChanged(ServerPlayer player, String statistic, int value) {
        QuestManager.getInstance().trackStatisticProgress(player.m_20148_(), statistic, value, player);
    }
}

