/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.ChapterImage;

public class ChapterDataSyncPacket {
    private static final Gson GSON = new Gson();
    private final List<ChapterData> chapters;

    public ChapterDataSyncPacket(List<ChapterData> chapters) {
        this.chapters = chapters;
    }

    public static void encode(ChapterDataSyncPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.chapters.size());
        for (ChapterData cd : packet.chapters) {
            JsonObject json = cd.toJson();
            buf.m_130070_(GSON.toJson((JsonElement)json));
        }
    }

    public static ChapterDataSyncPacket decode(FriendlyByteBuf buf) {
        int n = buf.readInt();
        ArrayList<ChapterData> list = new ArrayList<ChapterData>();
        for (int i = 0; i < n; ++i) {
            String s = buf.m_130277_();
            JsonObject json = (JsonObject)GSON.fromJson(s, JsonObject.class);
            list.add(ChapterData.fromJson(json));
        }
        return new ChapterDataSyncPacket(list);
    }

    public void handle() {
        HashMap<String, List<ChapterImage>> map = new HashMap<String, List<ChapterImage>>();
        for (ChapterData cd : this.chapters) {
            String slug;
            map.put(cd.getTitle(), cd.getImages());
            String string = slug = cd.getTitle() == null ? null : cd.getTitle().toLowerCase().replaceAll("[^a-z0-9]+", "_").replaceAll("^_|_$", "");
            if (slug != null && !slug.isBlank()) {
                map.put(slug, cd.getImages());
            }
            if (cd.getId() == null || cd.getId().isBlank()) continue;
            map.put(cd.getId(), cd.getImages());
        }
        ClientQuestManager.getInstance().setChapterImages(map);
    }

    public List<ChapterData> getChapters() {
        return this.chapters;
    }
}

