/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.texboobcat.questory.network.ChapterDataSyncPacket;
import org.texboobcat.questory.network.DailyDataSyncPacket;
import org.texboobcat.questory.network.GroupTreeSyncPacket;
import org.texboobcat.questory.network.OpenGuiPacket;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.network.QuestCompleteRequestPacket;
import org.texboobcat.questory.network.QuestPositionUpdatePacket;
import org.texboobcat.questory.network.QuestSyncPacket;

public class NetworkManager {
    public static final ResourceLocation QUEST_SYNC_PACKET = new ResourceLocation("questory", "quest_sync");
    public static final ResourceLocation PROGRESS_SYNC_PACKET = new ResourceLocation("questory", "progress_sync");
    public static final ResourceLocation CHAPTER_DATA_SYNC_PACKET = new ResourceLocation("questory", "chapter_data_sync");
    public static final ResourceLocation GROUP_TREE_SYNC_PACKET = new ResourceLocation("questory", "group_tree_sync");
    public static final ResourceLocation DAILY_DATA_SYNC_PACKET = new ResourceLocation("questory", "daily_data_sync");
    public static final ResourceLocation QUEST_COMPLETE_PACKET = new ResourceLocation("questory", "quest_complete");
    public static final ResourceLocation OPEN_GUI_PACKET = new ResourceLocation("questory", "open_gui");
    private static final NetworkChannel CHANNEL = NetworkChannel.create((ResourceLocation)new ResourceLocation("questory", "main"));

    public static void init() {
        CHANNEL.register(QuestSyncPacket.class, QuestSyncPacket::encode, QuestSyncPacket::decode, NetworkManager::handleQuestSync);
        CHANNEL.register(ProgressSyncPacket.class, ProgressSyncPacket::encode, ProgressSyncPacket::decode, NetworkManager::handleProgressSync);
        CHANNEL.register(ChapterDataSyncPacket.class, ChapterDataSyncPacket::encode, ChapterDataSyncPacket::decode, NetworkManager::handleChapterDataSync);
        CHANNEL.register(GroupTreeSyncPacket.class, GroupTreeSyncPacket::encode, GroupTreeSyncPacket::decode, NetworkManager::handleGroupTreeSync);
        CHANNEL.register(DailyDataSyncPacket.class, DailyDataSyncPacket::encode, DailyDataSyncPacket::decode, NetworkManager::handleDailyDataSync);
        CHANNEL.register(OpenGuiPacket.class, OpenGuiPacket::encode, OpenGuiPacket::decode, NetworkManager::handleOpenGui);
        CHANNEL.register(QuestCompleteRequestPacket.class, QuestCompleteRequestPacket::encode, QuestCompleteRequestPacket::decode, NetworkManager::handleQuestCompleteRequest);
        CHANNEL.register(QuestPositionUpdatePacket.class, QuestPositionUpdatePacket::encode, QuestPositionUpdatePacket::decode, NetworkManager::handleQuestPositionUpdate);
        System.out.println("[Questory] Network handlers registered");
    }

    private static void handleGroupTreeSync(GroupTreeSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleChapterDataSync(ChapterDataSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    public static void sendToClient(ServerPlayer player, Object packet) {
        CHANNEL.sendToPlayer(player, packet);
    }

    public static void sendToServer(Object packet) {
        CHANNEL.sendToServer(packet);
    }

    private static void handleQuestSync(QuestSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleProgressSync(ProgressSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleOpenGui(OpenGuiPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleDailyDataSync(DailyDataSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleQuestCompleteRequest(QuestCompleteRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleQuestPositionUpdate(QuestPositionUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }
}

