/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.quest.Quest;

public class QuestSyncPacket {
    private static final Gson GSON = new Gson();
    private final List<Quest> quests;

    public QuestSyncPacket(List<Quest> quests) {
        this.quests = quests;
    }

    public static void encode(QuestSyncPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.quests.size());
        for (Quest quest : packet.quests) {
            JsonObject json = quest.toJson();
            String jsonString = GSON.toJson((JsonElement)json);
            buf.m_130070_(jsonString);
        }
    }

    public static QuestSyncPacket decode(FriendlyByteBuf buf) {
        int count = buf.readInt();
        ArrayList<Quest> quests = new ArrayList<Quest>();
        for (int i = 0; i < count; ++i) {
            String jsonString = buf.m_130277_();
            JsonObject json = (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
            Quest quest = Quest.fromJson(json);
            quests.add(quest);
        }
        return new QuestSyncPacket(quests);
    }

    public void handle() {
        ClientQuestManager.getInstance().setQuests(this.quests);
    }

    public List<Quest> getQuests() {
        return this.quests;
    }
}

