/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class ChapterImage {
    private int x;
    private int y;
    private double width;
    private double height;
    private double rotation;
    private String imageUrl;
    private String color;
    private int alpha;
    private List<String> hoverText;
    private String clickUrl;
    private boolean editorsOnly;
    private boolean alignToCorner;
    private String dependencyQuestId;
    private int order;

    public ChapterImage(int x, int y, double width, double height, String imageUrl) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.rotation = 0.0;
        this.imageUrl = imageUrl;
        this.color = "#FFFFFF";
        this.alpha = 255;
        this.hoverText = new ArrayList<String>();
        this.clickUrl = "";
        this.editorsOnly = false;
        this.alignToCorner = false;
        this.dependencyQuestId = null;
        this.order = 0;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getRotation() {
        return this.rotation;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getColor() {
        return this.color;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public List<String> getHoverText() {
        return this.hoverText;
    }

    public String getClickUrl() {
        return this.clickUrl;
    }

    public boolean isEditorsOnly() {
        return this.editorsOnly;
    }

    public boolean isAlignToCorner() {
        return this.alignToCorner;
    }

    public String getDependencyQuestId() {
        return this.dependencyQuestId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public void setEditorsOnly(boolean editorsOnly) {
        this.editorsOnly = editorsOnly;
    }

    public void setAlignToCorner(boolean alignToCorner) {
        this.alignToCorner = alignToCorner;
    }

    public void setDependencyQuestId(String dependencyQuestId) {
        this.dependencyQuestId = dependencyQuestId;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void addHoverText(String text) {
        this.hoverText.add(text);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        json.addProperty("width", (Number)this.width);
        json.addProperty("height", (Number)this.height);
        json.addProperty("rotation", (Number)this.rotation);
        json.addProperty("image", this.imageUrl);
        json.addProperty("color", this.color);
        json.addProperty("alpha", (Number)this.alpha);
        json.addProperty("order", (Number)this.order);
        if (!this.hoverText.isEmpty()) {
            JsonArray hoverArray = new JsonArray();
            this.hoverText.forEach(arg_0 -> ((JsonArray)hoverArray).add(arg_0));
            json.add("hover", (JsonElement)hoverArray);
        }
        if (!this.clickUrl.isEmpty()) {
            json.addProperty("click", this.clickUrl);
        }
        if (this.editorsOnly) {
            json.addProperty("editors_only", Boolean.valueOf(true));
        }
        if (this.alignToCorner) {
            json.addProperty("align_to_corner", Boolean.valueOf(true));
        }
        if (this.dependencyQuestId != null) {
            json.addProperty("dependency", this.dependencyQuestId);
        }
        return json;
    }

    public static ChapterImage fromJson(JsonObject json) {
        int x = json.get("x").getAsInt();
        int y = json.get("y").getAsInt();
        double width = json.get("width").getAsDouble();
        double height = json.get("height").getAsDouble();
        String imageUrl = json.get("image").getAsString();
        ChapterImage image = new ChapterImage(x, y, width, height, imageUrl);
        if (json.has("rotation")) {
            image.setRotation(json.get("rotation").getAsDouble());
        }
        if (json.has("color")) {
            image.setColor(json.get("color").getAsString());
        }
        if (json.has("alpha")) {
            image.setAlpha(json.get("alpha").getAsInt());
        }
        if (json.has("order")) {
            image.setOrder(json.get("order").getAsInt());
        }
        if (json.has("hover")) {
            JsonArray hoverArray = json.getAsJsonArray("hover");
            hoverArray.forEach(elem -> image.addHoverText(elem.getAsString()));
        }
        if (json.has("click")) {
            image.setClickUrl(json.get("click").getAsString());
        }
        if (json.has("editors_only")) {
            image.setEditorsOnly(json.get("editors_only").getAsBoolean());
        }
        if (json.has("align_to_corner")) {
            image.setAlignToCorner(json.get("align_to_corner").getAsBoolean());
        }
        if (json.has("dependency")) {
            image.setDependencyQuestId(json.get("dependency").getAsString());
        }
        return image;
    }
}

