/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class CommandRequirement
extends Requirement {
    private String id;
    private String description;

    public CommandRequirement(String id, String description) {
        super("command");
        this.id = id;
        this.description = description;
    }

    public String getRequirementId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean completed = this.isMet(progress, questId);
        return (completed ? "\u2713" : "\u2717") + " " + this.description;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("id", this.id);
        json.addProperty("description", this.description);
        return json;
    }

    public static CommandRequirement fromJson(JsonObject json) {
        String id = json.get("id").getAsString();
        String description = json.get("description").getAsString();
        return new CommandRequirement(id, description);
    }
}

