/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.texboobcat.questory.quest.Reward;

public class ItemReward
extends Reward {
    private String item;
    private int count;
    private CompoundTag nbt;

    public ItemReward(String item, int count) {
        super("item");
        this.item = item;
        this.count = count;
        this.nbt = null;
    }

    public String getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
    }

    @Override
    public void grant(ServerPlayer player) {
        Item itemType = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(this.item));
        if (itemType != null) {
            ItemStack stack = new ItemStack((ItemLike)itemType, this.count);
            if (this.nbt != null) {
                stack.m_41751_(this.nbt.m_6426_());
            }
            if (!player.m_150109_().m_36054_(stack)) {
                player.m_36176_(stack, false);
            }
        }
    }

    @Override
    public String getDisplayString() {
        return this.count + "x " + this.item;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("item", this.item);
        json.addProperty("count", (Number)this.count);
        if (this.nbt != null) {
            json.addProperty("nbt", this.nbt.toString());
        }
        return json;
    }

    public static ItemReward fromJson(JsonObject json) {
        String item = json.get("item").getAsString();
        int count = json.get("count").getAsInt();
        ItemReward reward = new ItemReward(item, count);
        if (json.has("nbt")) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)json.get("nbt").getAsString());
                reward.setNbt(nbt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reward;
    }
}

