/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.gui.QuestHudOverlay;

public class QuestHudConfigScreen
extends class_437 {
    private final class_437 parent;
    private String position;
    private float scale;
    private int opacity;
    private boolean compactMode;
    private boolean showIcons;
    private boolean showProgressBars;
    private int offsetX;
    private int offsetY;
    private class_4185 positionButton;
    private class_4185 scaleDownButton;
    private class_4185 scaleUpButton;
    private class_4185 opacityDownButton;
    private class_4185 opacityUpButton;
    private class_4185 compactToggleButton;
    private class_4185 iconsToggleButton;
    private class_4185 progressBarsToggleButton;
    private class_4185 resetButton;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private boolean draggingHud = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int originalOffsetX = 0;
    private int originalOffsetY = 0;

    public QuestHudConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"HUD Configuration"));
        this.parent = parent;
        this.position = ClientConfig.getHudPosition();
        this.scale = ClientConfig.getHudScale();
        this.opacity = ClientConfig.getHudOpacity();
        this.compactMode = ClientConfig.isHudCompactMode();
        this.showIcons = ClientConfig.isHudShowIcons();
        this.showProgressBars = ClientConfig.isHudShowProgressBars();
        this.offsetX = ClientConfig.getHudOffsetX();
        this.offsetY = ClientConfig.getHudOffsetY();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int spacing = 25;
        this.positionButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Position: " + this.position)), b -> {
            this.position = switch (this.position) {
                case "TOP_LEFT" -> "TOP_RIGHT";
                case "TOP_RIGHT" -> "BOTTOM_RIGHT";
                case "BOTTOM_RIGHT" -> "BOTTOM_LEFT";
                default -> "TOP_LEFT";
            };
            b.method_25355((class_2561)class_2561.method_43470((String)("Position: " + this.position)));
        }).method_46434(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).method_46431());
        int scaleY = startY + spacing;
        this.scaleDownButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
            this.scale = Math.max(0.5f, this.scale - 0.1f);
            this.updateScaleLabel();
        }).method_46434(centerX - 60, scaleY, 20, buttonHeight).method_46431());
        this.scaleUpButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
            this.scale = Math.min(2.0f, this.scale + 0.1f);
            this.updateScaleLabel();
        }).method_46434(centerX + 40, scaleY, 20, buttonHeight).method_46431());
        int opacityY = startY + spacing * 2;
        this.opacityDownButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
            this.opacity = Math.max(0, this.opacity - 10);
            this.updateOpacityLabel();
        }).method_46434(centerX - 60, opacityY, 20, buttonHeight).method_46431());
        this.opacityUpButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
            this.opacity = Math.min(100, this.opacity + 10);
            this.updateOpacityLabel();
        }).method_46434(centerX + 40, opacityY, 20, buttonHeight).method_46431());
        int compactY = startY + spacing * 3;
        this.compactToggleButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Compact: " + (this.compactMode ? "ON" : "OFF"))), b -> {
            this.compactMode = !this.compactMode;
            b.method_25355((class_2561)class_2561.method_43470((String)("Compact: " + (this.compactMode ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, compactY, buttonWidth, buttonHeight).method_46431());
        int iconsY = startY + spacing * 4;
        this.iconsToggleButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Icons: " + (this.showIcons ? "ON" : "OFF"))), b -> {
            this.showIcons = !this.showIcons;
            b.method_25355((class_2561)class_2561.method_43470((String)("Icons: " + (this.showIcons ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, iconsY, buttonWidth, buttonHeight).method_46431());
        int barsY = startY + spacing * 5;
        this.progressBarsToggleButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Progress Bars: " + (this.showProgressBars ? "ON" : "OFF"))), b -> {
            this.showProgressBars = !this.showProgressBars;
            b.method_25355((class_2561)class_2561.method_43470((String)("Progress Bars: " + (this.showProgressBars ? "ON" : "OFF"))));
        }).method_46434(centerX - buttonWidth / 2, barsY, buttonWidth, buttonHeight).method_46431());
        int bottomY = this.field_22790 - 30;
        int bottomButtonWidth = 70;
        this.resetButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> this.resetToDefaults()).method_46434(centerX - bottomButtonWidth * 2 - 10, bottomY, bottomButtonWidth, buttonHeight).method_46431());
        this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            this.saveConfig();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX - bottomButtonWidth / 2, bottomY, bottomButtonWidth, buttonHeight).method_46431());
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX + bottomButtonWidth + 10, bottomY, bottomButtonWidth, buttonHeight).method_46431());
    }

    private void updateScaleLabel() {
    }

    private void updateOpacityLabel() {
    }

    private void resetToDefaults() {
        this.position = "TOP_LEFT";
        this.scale = 1.0f;
        this.opacity = 80;
        this.compactMode = false;
        this.showIcons = true;
        this.showProgressBars = true;
        this.offsetX = 10;
        this.offsetY = 10;
        this.positionButton.method_25355((class_2561)class_2561.method_43470((String)("Position: " + this.position)));
        this.compactToggleButton.method_25355((class_2561)class_2561.method_43470((String)"Compact: OFF"));
        this.iconsToggleButton.method_25355((class_2561)class_2561.method_43470((String)"Icons: ON"));
        this.progressBarsToggleButton.method_25355((class_2561)class_2561.method_43470((String)"Progress Bars: ON"));
    }

    private void saveConfig() {
        ClientConfig.setHudPosition(this.position);
        ClientConfig.setHudScale(this.scale);
        ClientConfig.setHudOpacity(this.opacity);
        ClientConfig.setHudCompactMode(this.compactMode);
        ClientConfig.setHudShowIcons(this.showIcons);
        ClientConfig.setHudShowProgressBars(this.showProgressBars);
        ClientConfig.setHudOffsetX(this.offsetX);
        ClientConfig.setHudOffsetY(this.offsetY);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -1072689136);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        String instruction = "Click and drag the HUD preview to reposition it";
        graphics.method_25300(this.field_22793, instruction, this.field_22789 / 2, this.field_22790 - 50, 0xAAAAFF);
        int centerX = this.field_22789 / 2;
        String scaleText = String.format("Scale: %.1fx", Float.valueOf(this.scale));
        graphics.method_25300(this.field_22793, scaleText, centerX, 78, 0xFFFFFF);
        String opacityText = String.format("Opacity: %d%%", this.opacity);
        graphics.method_25300(this.field_22793, opacityText, centerX, 103, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.renderLivePreview(graphics, partialTick);
    }

    private void renderLivePreview(class_332 graphics, float partialTick) {
        String oldPos = ClientConfig.getHudPosition();
        float oldScale = ClientConfig.getHudScale();
        int oldOpacity = ClientConfig.getHudOpacity();
        boolean oldCompact = ClientConfig.isHudCompactMode();
        boolean oldIcons = ClientConfig.isHudShowIcons();
        boolean oldBars = ClientConfig.isHudShowProgressBars();
        int oldOffsetX = ClientConfig.getHudOffsetX();
        int oldOffsetY = ClientConfig.getHudOffsetY();
        ClientConfig.setHudPosition(this.position);
        ClientConfig.setHudScale(this.scale);
        ClientConfig.setHudOpacity(this.opacity);
        ClientConfig.setHudCompactMode(this.compactMode);
        ClientConfig.setHudShowIcons(this.showIcons);
        ClientConfig.setHudShowProgressBars(this.showProgressBars);
        ClientConfig.setHudOffsetX(this.offsetX);
        ClientConfig.setHudOffsetY(this.offsetY);
        QuestHudOverlay.render(graphics, partialTick);
        ClientConfig.setHudPosition(oldPos);
        ClientConfig.setHudScale(oldScale);
        ClientConfig.setHudOpacity(oldOpacity);
        ClientConfig.setHudCompactMode(oldCompact);
        ClientConfig.setHudShowIcons(oldIcons);
        ClientConfig.setHudShowProgressBars(oldBars);
        ClientConfig.setHudOffsetX(oldOffsetX);
        ClientConfig.setHudOffsetY(oldOffsetY);
        this.drawDragIndicator(graphics);
    }

    private void drawDragIndicator(class_332 graphics) {
        int hudX;
        int panelWidth = this.compactMode ? 200 : 240;
        int panelHeight = 100;
        int hudY = switch (this.position) {
            case "TOP_RIGHT" -> {
                hudX = this.field_22789 - panelWidth - this.offsetX;
                yield this.offsetY;
            }
            case "BOTTOM_LEFT" -> {
                hudX = this.offsetX;
                yield this.field_22790 - panelHeight - this.offsetY;
            }
            case "BOTTOM_RIGHT" -> {
                hudX = this.field_22789 - panelWidth - this.offsetX;
                yield this.field_22790 - panelHeight - this.offsetY;
            }
            default -> {
                hudX = this.offsetX;
                yield this.offsetY;
            }
        };
        if (this.draggingHud) {
            graphics.method_25294(hudX - 2, hudY - 2, hudX + panelWidth + 2, hudY, -2013200640);
            graphics.method_25294(hudX - 2, hudY + panelHeight, hudX + panelWidth + 2, hudY + panelHeight + 2, -2013200640);
            graphics.method_25294(hudX - 2, hudY, hudX, hudY + panelHeight, -2013200640);
            graphics.method_25294(hudX + panelWidth, hudY, hudX + panelWidth + 2, hudY + panelHeight, -2013200640);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int hudX;
            int panelWidth = this.compactMode ? 200 : 240;
            int panelHeight = 100;
            int hudY = switch (this.position) {
                case "TOP_RIGHT" -> {
                    hudX = this.field_22789 - panelWidth - this.offsetX;
                    yield this.offsetY;
                }
                case "BOTTOM_LEFT" -> {
                    hudX = this.offsetX;
                    yield this.field_22790 - panelHeight - this.offsetY;
                }
                case "BOTTOM_RIGHT" -> {
                    hudX = this.field_22789 - panelWidth - this.offsetX;
                    yield this.field_22790 - panelHeight - this.offsetY;
                }
                default -> {
                    hudX = this.offsetX;
                    yield this.offsetY;
                }
            };
            if (mouseX >= (double)hudX && mouseX <= (double)(hudX + panelWidth) && mouseY >= (double)hudY && mouseY <= (double)(hudY + panelHeight)) {
                this.draggingHud = true;
                this.dragStartX = (int)mouseX;
                this.dragStartY = (int)mouseY;
                this.originalOffsetX = this.offsetX;
                this.originalOffsetY = this.offsetY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingHud) {
            this.draggingHud = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingHud) {
            int deltaX = (int)(mouseX - (double)this.dragStartX);
            int deltaY = (int)(mouseY - (double)this.dragStartY);
            this.offsetX = this.position.contains("RIGHT") ? Math.max(0, Math.min(this.field_22789 / 2, this.originalOffsetX - deltaX)) : Math.max(0, Math.min(this.field_22789 / 2, this.originalOffsetX + deltaX));
            this.offsetY = this.position.contains("BOTTOM") ? Math.max(0, Math.min(this.field_22790 / 2, this.originalOffsetY - deltaY)) : Math.max(0, Math.min(this.field_22790 / 2, this.originalOffsetY + deltaY));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

