/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.QuestoryKeybindings;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestUpdateRequestPacket;
import org.texboobcat.questory.quest.Quest;

public class QuestPositionPickerScreen
extends class_437 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_437 parent;
    private final Quest questBeingPositioned;
    private final BiConsumer<Integer, Integer> onPositionSelected;
    private int questX;
    private int questY;
    private boolean altMode = false;
    private final Map<String, int[]> modifiedPositions = new HashMap<String, int[]>();
    private Quest currentlyDraggingQuest = null;
    private boolean altLock = false;
    private boolean altHeld = false;
    private long lastAltPressMs = 0L;
    private static final long ALT_DOUBLE_TAP_MS = 300L;
    private double zoom = 1.0;
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private boolean draggingQuest = false;
    private boolean panning = false;
    private int prevMouseX = 0;
    private int prevMouseY = 0;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private static final int QUEST_SIZE = 32;
    private static final int GRID_SIZE = 100;

    public QuestPositionPickerScreen(class_437 parent, Quest quest, BiConsumer<Integer, Integer> onPositionSelected) {
        super((class_2561)class_2561.method_43470((String)("Position Quest: " + quest.getTitle())));
        this.parent = parent;
        this.questBeingPositioned = quest;
        this.questX = quest.getX();
        this.questY = quest.getY();
        this.onPositionSelected = onPositionSelected;
    }

    protected void method_25426() {
        super.method_25426();
        int btnY = this.field_22790 - 30;
        int btnX = this.field_22789 / 2 - 110;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply"), b -> {
            this.onPositionSelected.accept(this.questX, this.questY);
            int savedCount = 0;
            int errorCount = 0;
            for (Map.Entry<String, int[]> entry : this.modifiedPositions.entrySet()) {
                String questId = entry.getKey();
                int[] pos = entry.getValue();
                Quest q = ClientQuestManager.getInstance().getAllQuests().stream().filter(quest -> quest.getId().equals(questId)).findFirst().orElse(null);
                if (q == null) continue;
                try {
                    q.setX(pos[0]);
                    q.setY(pos[1]);
                    JsonObject json = q.toJson();
                    String payload = GSON.toJson((JsonElement)json);
                    NetworkManager.sendToServer(new QuestUpdateRequestPacket(questId, payload));
                    ++savedCount;
                }
                catch (Exception e) {
                    System.err.println("[QuestPositionPicker] Failed to save quest " + questId + ": " + e.getMessage());
                    ++errorCount;
                }
            }
            if (savedCount > 0) {
                System.out.println("[QuestPositionPicker] Saved " + savedCount + " repositioned quest(s) to server");
            }
            if (errorCount > 0) {
                System.err.println("[QuestPositionPicker] Failed to save " + errorCount + " quest(s)");
            }
            this.field_22787.method_1507(this.parent);
        }).method_46434(btnX, btnY, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> {
            this.questX = this.questBeingPositioned.getX();
            this.questY = this.questBeingPositioned.getY();
            this.modifiedPositions.clear();
        }).method_46434(btnX + 65, btnY, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(btnX + 130, btnY, 60, 20).method_46431());
        this.centerOnQuest();
    }

    private void centerOnQuest() {
        this.scrollX = (double)this.questX * this.zoom - (double)this.field_22789 / 2.0;
        this.scrollY = (double)this.questY * this.zoom - (double)this.field_22790 / 2.0;
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        this.altMode = this.isAltActive();
        this.renderGrid(g);
        List<Quest> allQuests = this.getQuestsInSameChapter();
        for (Quest q : allQuests) {
            if (q.getId().equals(this.questBeingPositioned.getId())) continue;
            int[] pos = this.getQuestPosition(q);
            boolean modified = this.modifiedPositions.containsKey(q.getId());
            this.renderQuestNode(g, q, pos[0], pos[1], modified && this.altMode);
        }
        this.renderDependencyLines(g);
        this.renderQuestNode(g, this.questBeingPositioned, this.questX, this.questY, true);
        super.method_25394(g, mouseX, mouseY, partialTick);
        String modeTip = this.altMode ? (this.altLock ? "\u00a7eALT LOCK: Drag ANY quest to reposition (press Alt to unlock)" : "\u00a7eALT MODE: Drag ANY quest to reposition") : "Hold ALT to reposition other quests (double-tap to lock)";
        g.method_25303(this.field_22793, "Drag the highlighted quest to position it", 10, 10, -1);
        g.method_25303(this.field_22793, modeTip, 10, 22, this.altMode ? -256 : -5592406);
        g.method_25303(this.field_22793, "Pan (" + QuestoryKeybindings.getPanViewDisplayName() + ") to move view, scroll to zoom", 10, 34, -5592406);
        g.method_25303(this.field_22793, String.format("Position: X=%d, Y=%d | Modified: %d", this.questX, this.questY, this.modifiedPositions.size()), 10, 46, -256);
    }

    private List<Quest> getQuestsInSameChapter() {
        List<Quest> byGroup;
        String group;
        ClientQuestManager manager = ClientQuestManager.getInstance();
        String chapterId = this.questBeingPositioned.getChapterId();
        if (chapterId != null && !chapterId.isBlank()) {
            ArrayList<Quest> result = new ArrayList<Quest>();
            for (Quest quest : manager.getAllQuests()) {
                if (!chapterId.equals(quest.getChapterId())) continue;
                result.add(quest);
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        if ((group = this.questBeingPositioned.getGroup()) != null && !group.isBlank() && (byGroup = manager.getQuestsByGroup(group)) != null && !byGroup.isEmpty()) {
            return new ArrayList<Quest>(byGroup);
        }
        return new ArrayList<Quest>(manager.getAllQuests());
    }

    private int[] getQuestPosition(Quest quest) {
        if (this.modifiedPositions.containsKey(quest.getId())) {
            return this.modifiedPositions.get(quest.getId());
        }
        return new int[]{quest.getX(), quest.getY()};
    }

    private boolean isAltActive() {
        return this.altLock || QuestPositionPickerScreen.method_25443();
    }

    private void renderGrid(class_332 g) {
        int gridSpacing = (int)(100.0 * this.zoom);
        if (gridSpacing < 10) {
            return;
        }
        int startX = (int)(-this.scrollX % (double)gridSpacing);
        int startY = (int)(-this.scrollY % (double)gridSpacing);
        for (int x = startX; x < this.field_22789; x += gridSpacing) {
            g.method_25294(x, 0, x + 1, this.field_22790 - 40, 0x20FFFFFF);
        }
        for (int y = startY; y < this.field_22790 - 40; y += gridSpacing) {
            g.method_25294(0, y, this.field_22789, y + 1, 0x20FFFFFF);
        }
    }

    private void renderQuestNode(class_332 g, Quest quest, int qx, int qy, boolean highlighted) {
        int screenX = (int)((double)qx * this.zoom - this.scrollX);
        int screenY = (int)((double)qy * this.zoom - this.scrollY);
        int size = (int)(32.0 * this.zoom);
        if (screenX + size < 0 || screenX > this.field_22789 || screenY + size < 0 || screenY > this.field_22790 - 40) {
            return;
        }
        boolean completed = ClientQuestManager.getInstance().isQuestCompleted(quest.getId());
        int color = highlighted ? -256 : (completed ? -16711936 : -7829368);
        int alpha = highlighted ? 255 : 128;
        g.method_25294(screenX, screenY, screenX + size, screenY + size, alpha << 24 | color & 0xFFFFFF);
        int borderColor = highlighted ? -1 : -12303292;
        g.method_25294(screenX, screenY, screenX + size, screenY + 1, borderColor);
        g.method_25294(screenX, screenY + size - 1, screenX + size, screenY + size, borderColor);
        g.method_25294(screenX, screenY, screenX + 1, screenY + size, borderColor);
        g.method_25294(screenX + size - 1, screenY, screenX + size, screenY + size, borderColor);
        if (this.zoom > 0.5) {
            Object title = quest.getTitle();
            if (this.field_22793.method_1727((String)title) > size) {
                title = this.field_22793.method_27523((String)title, size - 4) + "...";
            }
            g.method_25303(this.field_22793, (String)title, screenX + 2, screenY + size + 2, highlighted ? -1 : -5592406);
        }
    }

    private void renderDependencyLines(class_332 g) {
        List<Quest> allQuests = this.getQuestsInSameChapter();
        if (this.altMode) {
            for (Quest quest : allQuests) {
                int[] nArray;
                if (quest.getId().equals(this.questBeingPositioned.getId())) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = this.questX;
                    nArray = nArray2;
                    nArray2[1] = this.questY;
                } else {
                    nArray = this.getQuestPosition(quest);
                }
                int[] qPos = nArray;
                for (String depId : quest.getDependencies()) {
                    int[] nArray3;
                    Quest dep = allQuests.stream().filter(q -> q.getId().equals(depId)).findFirst().orElse(null);
                    if (dep == null) continue;
                    if (dep.getId().equals(this.questBeingPositioned.getId())) {
                        int[] nArray4 = new int[2];
                        nArray4[0] = this.questX;
                        nArray3 = nArray4;
                        nArray4[1] = this.questY;
                    } else {
                        nArray3 = this.getQuestPosition(dep);
                    }
                    int[] depPos = nArray3;
                    this.renderLine(g, depPos[0], depPos[1], qPos[0], qPos[1], -2147418113, "\u2192");
                }
            }
        } else {
            for (String depId : this.questBeingPositioned.getDependencies()) {
                Quest dep = allQuests.stream().filter(q -> q.getId().equals(depId)).findFirst().orElse(null);
                if (dep == null) continue;
                int[] depPos = this.getQuestPosition(dep);
                this.renderLine(g, depPos[0], depPos[1], this.questX, this.questY, -16711681, "\u2192");
            }
            for (Quest q2 : allQuests) {
                if (!q2.getDependencies().contains(this.questBeingPositioned.getId())) continue;
                int[] qPos = this.getQuestPosition(q2);
                this.renderLine(g, this.questX, this.questY, qPos[0], qPos[1], -22016, "\u2192");
            }
        }
    }

    private void renderLine(class_332 g, int x1, int y1, int x2, int y2, int color, String arrow) {
        int screenX1 = (int)((double)x1 * this.zoom - this.scrollX) + 16;
        int screenY1 = (int)((double)y1 * this.zoom - this.scrollY) + 16;
        int screenX2 = (int)((double)x2 * this.zoom - this.scrollX) + 16;
        int screenY2 = (int)((double)y2 * this.zoom - this.scrollY) + 16;
        this.drawLine(g, screenX1, screenY1, screenX2, screenY2, color);
    }

    private void drawLine(class_332 g, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            g.method_25294(x1, y1, x1 + 2, y1 + 2, color);
            if (x1 == x2 && y1 == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            int size = (int)(32.0 * this.zoom);
            int screenX = (int)((double)this.questX * this.zoom - this.scrollX);
            int screenY = (int)((double)this.questY * this.zoom - this.scrollY);
            if (mouseX >= (double)screenX && mouseX <= (double)(screenX + size) && mouseY >= (double)screenY && mouseY <= (double)(screenY + size)) {
                this.draggingQuest = true;
                this.currentlyDraggingQuest = this.questBeingPositioned;
                int questScreenCenterX = screenX + size / 2;
                int questScreenCenterY = screenY + size / 2;
                this.dragOffsetX = (int)(((double)questScreenCenterX - mouseX) / this.zoom);
                this.dragOffsetY = (int)(((double)questScreenCenterY - mouseY) / this.zoom);
                return true;
            }
            if (this.isAltActive()) {
                List<Quest> allQuests = this.getQuestsInSameChapter();
                for (Quest q : allQuests) {
                    if (q.getId().equals(this.questBeingPositioned.getId())) continue;
                    int[] pos = this.getQuestPosition(q);
                    int qScreenX = (int)((double)pos[0] * this.zoom - this.scrollX);
                    int qScreenY = (int)((double)pos[1] * this.zoom - this.scrollY);
                    if (!(mouseX >= (double)qScreenX) || !(mouseX <= (double)(qScreenX + size)) || !(mouseY >= (double)qScreenY) || !(mouseY <= (double)(qScreenY + size))) continue;
                    this.draggingQuest = true;
                    this.currentlyDraggingQuest = q;
                    int questScreenCenterX = qScreenX + size / 2;
                    int questScreenCenterY = qScreenY + size / 2;
                    this.dragOffsetX = (int)(((double)questScreenCenterX - mouseX) / this.zoom);
                    this.dragOffsetY = (int)(((double)questScreenCenterY - mouseY) / this.zoom);
                    return true;
                }
            }
        } else if (QuestoryKeybindings.isPanButton(button)) {
            this.panning = true;
            this.prevMouseX = (int)mouseX;
            this.prevMouseY = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 342 || keyCode == 346) {
            if (!this.altHeld) {
                long now = System.currentTimeMillis();
                if (this.altLock) {
                    this.altLock = false;
                    this.lastAltPressMs = 0L;
                } else if (now - this.lastAltPressMs <= 300L) {
                    this.altLock = true;
                    this.lastAltPressMs = 0L;
                } else {
                    this.lastAltPressMs = now;
                }
                this.altHeld = true;
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 342 || keyCode == 346) {
            this.altHeld = false;
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingQuest && this.currentlyDraggingQuest != null) {
            int worldMouseX = (int)((mouseX + this.scrollX) / this.zoom);
            int worldMouseY = (int)((mouseY + this.scrollY) / this.zoom);
            int newX = worldMouseX + this.dragOffsetX;
            int newY = worldMouseY + this.dragOffsetY;
            newX = Math.round((float)newX / 10.0f) * 10;
            newY = Math.round((float)newY / 10.0f) * 10;
            if (this.currentlyDraggingQuest.getId().equals(this.questBeingPositioned.getId())) {
                this.questX = newX;
                this.questY = newY;
            } else {
                this.modifiedPositions.put(this.currentlyDraggingQuest.getId(), new int[]{newX, newY});
            }
            return true;
        }
        if (this.panning) {
            this.scrollX -= mouseX - (double)this.prevMouseX;
            this.scrollY -= mouseY - (double)this.prevMouseY;
            this.prevMouseX = (int)mouseX;
            this.prevMouseY = (int)mouseY;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingQuest = false;
        this.currentlyDraggingQuest = null;
        this.panning = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        double oldZoom = this.zoom;
        this.zoom *= 1.0 + delta * 0.1;
        this.zoom = Math.max(0.1, Math.min(3.0, this.zoom));
        double zoomChange = this.zoom / oldZoom;
        this.scrollX = mouseX + (this.scrollX - mouseX) * zoomChange;
        this.scrollY = mouseY + (this.scrollY - mouseY) * zoomChange;
        return true;
    }

    public boolean method_25421() {
        return false;
    }
}

