/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.rendering.CustomShapeRenderer;
import org.texboobcat.questory.shape.ShapeDef;
import org.texboobcat.questory.shape.ShapeRegistry;

public class ShapeDesignerScreen
extends class_437 {
    private final class_437 parent;
    private final Consumer<String> onApplyShapeId;
    private class_342 idBox;
    private class_342 nameBox;
    private class_342 pointsBox;
    private class_342 circleCx;
    private class_342 circleCy;
    private class_342 circleR;
    private class_342 gearTeeth;
    private class_342 gearInnerR;
    private class_342 gearOuterR;
    private class_342 gearHoleR;
    private class_4185 addPolygonBtn;
    private class_4185 addCircleBtn;
    private class_4185 addGearBtn;
    private class_4185 saveBtn;
    private class_4185 applyBtn;
    private class_4185 cancelBtn;
    private class_4185 templateCircleBtn;
    private class_4185 templateHexBtn;
    private class_4185 templateStarBtn;
    private class_4185 templateGearBtn;
    private class_4185 clearBtn;
    private class_4185 gridToggleBtn;
    private class_4185 brushBtn;
    private class_4185 eraserBtn;
    private class_4185 sizeMinusBtn;
    private class_4185 sizePlusBtn;
    private class_4185 clearIconBtn;
    private class_4185 exportIconBtn;
    private class_4185 useAsIconBtn;
    private class_4185 undoBtn;
    private class_4185 redoBtn;
    private class_4185 eyedropperBtn;
    private class_342 colorHexBox;
    private int brushSize = 4;
    private int brushColor = -1;
    private boolean erasing = false;
    private boolean drawing = false;
    private boolean eyedropper = false;
    private boolean strokeSnapshotTaken = false;
    private int lastDrawX = -1;
    private int lastDrawY = -1;
    private int[] previewRect = null;
    private static final int ICON_W = 128;
    private static final int ICON_H = 128;
    private static final long UPLOAD_INTERVAL_NS_DRAW = 150000000L;
    private int[] iconPixels = new int[16384];
    private boolean showGrid = true;
    private boolean livePreview = true;
    private boolean[] shapeMask128;
    private boolean[] shapeMaskLow;
    private class_1043 canvasTexture;
    private class_1011 canvasImage;
    private class_2960 canvasRL;
    private boolean canvasDirty = false;
    private long lastUploadNs = 0L;
    private boolean needCanvasSync = false;
    private static final int LIVE_W = 64;
    private static final int LIVE_H = 64;
    private class_1011 liveImage;
    private class_1043 liveTexture;
    private class_2960 liveRL;
    private boolean liveDirty = false;
    private long lastLiveUploadNs = 0L;
    private boolean hasLiveStroke = false;
    private static final long LIVE_UPLOAD_INTERVAL_NS = 16000000L;
    private static final Map<Integer, short[]> BRUSH_MASKS = new HashMap<Integer, short[]>();
    private final Deque<int[]> undoStack = new ArrayDeque<int[]>();
    private final Deque<int[]> redoStack = new ArrayDeque<int[]>();
    private final ShapeDef working = new ShapeDef();

    public ShapeDesignerScreen(class_437 parent, String initialId, Consumer<String> onApplyShapeId) {
        super((class_2561)class_2561.method_43470((String)"Shape Designer"));
        this.parent = parent;
        this.onApplyShapeId = onApplyShapeId;
        this.working.displayName = this.working.id = initialId == null || initialId.isBlank() ? "my_shape" : ShapeDesignerScreen.sanitize(initialId);
        this.working.viewBox = new double[]{0.0, 0.0, 1.0, 1.0};
        this.working.hitTest = "auto";
    }

    protected void method_25426() {
        int ix;
        int iy;
        int panelW = 520;
        int x = Math.max(12, this.field_22789 / 2 - panelW / 2);
        int y = Math.max(20, this.field_22790 / 2 - 110);
        int pvSize = Math.min(240, this.field_22790 - 120);
        int pvX = x;
        int pvY = y;
        this.previewRect = new int[]{pvX, pvY, pvSize, pvSize};
        this.rebuildMask128();
        if (this.canvasImage == null) {
            this.canvasImage = new class_1011(128, 128, true);
            for (iy = 0; iy < 128; ++iy) {
                for (ix = 0; ix < 128; ++ix) {
                    int argb = this.iconPixels[iy * 128 + ix];
                    int a = argb >>> 24 & 0xFF;
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b2 = argb & 0xFF;
                    int rgba = r << 24 | g << 16 | b2 << 8 | a;
                    this.canvasImage.method_4305(ix, iy, rgba);
                }
            }
            this.canvasTexture = new class_1043(this.canvasImage);
            this.canvasRL = new class_2960("questory", "textures/gui/custom_icons/_designer/" + String.valueOf(UUID.randomUUID()));
            class_310.method_1551().method_1531().method_4616(this.canvasRL, (class_1044)this.canvasTexture);
            this.canvasDirty = true;
        }
        if (this.liveImage == null) {
            this.liveImage = new class_1011(64, 64, true);
            for (iy = 0; iy < 64; ++iy) {
                for (ix = 0; ix < 64; ++ix) {
                    this.liveImage.method_4305(ix, iy, 0);
                }
            }
            this.liveTexture = new class_1043(this.liveImage);
            this.liveRL = new class_2960("questory", "textures/gui/custom_icons/_designer_live/" + String.valueOf(UUID.randomUUID()));
            class_310.method_1551().method_1531().method_4616(this.liveRL, (class_1044)this.liveTexture);
            this.liveDirty = true;
        }
        int controlsX = pvX + pvSize + 16;
        this.idBox = new class_342(this.field_22793, controlsX, y, 220, 18, (class_2561)class_2561.method_43470((String)"id"));
        this.idBox.method_1852(this.working.id);
        this.method_37063((class_364)this.idBox);
        this.nameBox = new class_342(this.field_22793, controlsX, y += 20, 260, 18, (class_2561)class_2561.method_43470((String)"display name"));
        this.nameBox.method_1852(this.working.displayName == null ? this.working.id : this.working.displayName);
        this.method_37063((class_364)this.nameBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Polygon"), b -> {}).method_46434(controlsX, y += 24, 80, 18).method_46431());
        this.pointsBox = new class_342(this.field_22793, controlsX + 84, y, 256, 18, (class_2561)class_2561.method_43470((String)"x1,y1 x2,y2 ... (0..1)"));
        this.pointsBox.method_1852("0.2,0.2 0.8,0.2 0.5,0.8");
        this.method_37063((class_364)this.pointsBox);
        this.addPolygonBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), b -> this.addPolygon()).method_46434(controlsX + 344, y, 40, 18).method_46431();
        this.method_37063((class_364)this.addPolygonBtn);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Circle"), b -> {}).method_46434(controlsX, y += 22, 80, 18).method_46431());
        this.circleCx = new class_342(this.field_22793, controlsX + 84, y, 60, 18, (class_2561)class_2561.method_43470((String)"cx"));
        this.circleCx.method_1852("0.5");
        this.method_37063((class_364)this.circleCx);
        this.circleCy = new class_342(this.field_22793, controlsX + 148, y, 60, 18, (class_2561)class_2561.method_43470((String)"cy"));
        this.circleCy.method_1852("0.5");
        this.method_37063((class_364)this.circleCy);
        this.circleR = new class_342(this.field_22793, controlsX + 212, y, 60, 18, (class_2561)class_2561.method_43470((String)"r"));
        this.circleR.method_1852("0.45");
        this.method_37063((class_364)this.circleR);
        this.addCircleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), b -> this.addCircle()).method_46434(controlsX + 276, y, 40, 18).method_46431();
        this.method_37063((class_364)this.addCircleBtn);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Gear"), b -> {}).method_46434(controlsX, y += 22, 80, 18).method_46431());
        this.gearTeeth = new class_342(this.field_22793, controlsX + 84, y, 40, 18, (class_2561)class_2561.method_43470((String)"teeth"));
        this.gearTeeth.method_1852("8");
        this.method_37063((class_364)this.gearTeeth);
        this.gearInnerR = new class_342(this.field_22793, controlsX + 128, y, 50, 18, (class_2561)class_2561.method_43470((String)"innerR"));
        this.gearInnerR.method_1852("0.28");
        this.method_37063((class_364)this.gearInnerR);
        this.gearOuterR = new class_342(this.field_22793, controlsX + 182, y, 50, 18, (class_2561)class_2561.method_43470((String)"outerR"));
        this.gearOuterR.method_1852("0.48");
        this.method_37063((class_364)this.gearOuterR);
        this.gearHoleR = new class_342(this.field_22793, controlsX + 236, y, 50, 18, (class_2561)class_2561.method_43470((String)"holeR"));
        this.gearHoleR.method_1852("0.10");
        this.method_37063((class_364)this.gearHoleR);
        this.addGearBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), b -> this.addGear()).method_46434(controlsX + 290, y, 40, 18).method_46431();
        this.method_37063((class_364)this.addGearBtn);
        this.saveBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.doSave()).method_46434(controlsX, y += 28, 80, 20).method_46431();
        this.method_37063((class_364)this.saveBtn);
        this.applyBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Apply to Quest"), b -> this.doApply()).method_46434(controlsX + 86, y, 120, 20).method_46431();
        this.method_37063((class_364)this.applyBtn);
        this.cancelBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(controlsX + 210, y, 80, 20).method_46431();
        this.method_37063((class_364)this.cancelBtn);
        this.templateCircleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Template: Circle"), b -> this.applyTemplateCircle()).method_46434(controlsX, y += 24, 120, 18).method_46431();
        this.method_37063((class_364)this.templateCircleBtn);
        this.templateHexBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hexagon"), b -> this.applyTemplateHex()).method_46434(controlsX + 124, y, 80, 18).method_46431();
        this.method_37063((class_364)this.templateHexBtn);
        this.templateStarBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Star"), b -> this.applyTemplateStar()).method_46434(controlsX + 208, y, 60, 18).method_46431();
        this.method_37063((class_364)this.templateStarBtn);
        this.templateGearBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Gear"), b -> this.applyTemplateGear()).method_46434(controlsX + 272, y, 60, 18).method_46431();
        this.method_37063((class_364)this.templateGearBtn);
        this.clearBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear"), b -> {
            this.working.paths.clear();
            this.rebuildMask128();
        }).method_46434(controlsX + 336, y, 60, 18).method_46431();
        this.method_37063((class_364)this.clearBtn);
        this.gridToggleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Grid: On"), b -> {
            this.showGrid = !this.showGrid;
            this.gridToggleBtn.method_25355((class_2561)class_2561.method_43470((String)(this.showGrid ? "Grid: On" : "Grid: Off")));
        }).method_46434(controlsX, y += 20, 80, 18).method_46431();
        this.method_37063((class_364)this.gridToggleBtn);
        class_4185 livePreviewBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Live: On"), b -> {
            this.livePreview = !this.livePreview;
            b.method_25355((class_2561)class_2561.method_43470((String)(this.livePreview ? "Live: On" : "Live: Off")));
        }).method_46434(controlsX + 84, y, 80, 18).method_46431();
        this.method_37063((class_364)livePreviewBtn);
        int toolsY = pvY + pvSize + 10;
        this.brushBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Brush"), b -> {
            this.erasing = false;
        }).method_46434(pvX, toolsY, 50, 18).method_46431();
        this.method_37063((class_364)this.brushBtn);
        this.eraserBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Eraser"), b -> {
            this.erasing = true;
        }).method_46434(pvX + 54, toolsY, 60, 18).method_46431();
        this.method_37063((class_364)this.eraserBtn);
        this.sizeMinusBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
            this.brushSize = Math.max(1, this.brushSize - 1);
        }).method_46434(pvX + 118, toolsY, 18, 18).method_46431();
        this.method_37063((class_364)this.sizeMinusBtn);
        this.sizePlusBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
            this.brushSize = Math.min(32, this.brushSize + 1);
        }).method_46434(pvX + 138, toolsY, 18, 18).method_46431();
        this.method_37063((class_364)this.sizePlusBtn);
        this.colorHexBox = new class_342(this.field_22793, pvX + 160, toolsY, 70, 18, (class_2561)class_2561.method_43470((String)"#ARGB"));
        this.colorHexBox.method_1852("FFFFFFFF");
        this.method_37063((class_364)this.colorHexBox);
        this.clearIconBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear Icon"), b -> this.clearIcon()).method_46434(pvX + 234, toolsY, 80, 18).method_46431();
        this.method_37063((class_364)this.clearIconBtn);
        this.exportIconBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Export PNG"), b -> this.exportIcon()).method_46434(pvX + 320, toolsY, 90, 18).method_46431();
        this.method_37063((class_364)this.exportIconBtn);
        this.useAsIconBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Use as Icon"), b -> this.useAsQuestIcon()).method_46434(pvX + 416, toolsY, 100, 18).method_46431();
        this.method_37063((class_364)this.useAsIconBtn);
        int toolsY2 = toolsY + 22;
        this.eyedropperBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Eyedropper"), b -> {
            this.eyedropper = true;
            this.erasing = false;
        }).method_46434(pvX, toolsY2, 76, 18).method_46431();
        this.method_37063((class_364)this.eyedropperBtn);
        this.undoBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Undo"), b -> this.undo()).method_46434(pvX + 82, toolsY2, 50, 18).method_46431();
        this.method_37063((class_364)this.undoBtn);
        this.redoBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Redo"), b -> this.redo()).method_46434(pvX + 136, toolsY2, 50, 18).method_46431();
        this.method_37063((class_364)this.redoBtn);
    }

    private void addPolygon() {
        try {
            String txt = this.pointsBox.method_1882();
            String[] tokens = txt.split("\\s+");
            ArrayList<Double> pts = new ArrayList<Double>();
            for (String t : tokens) {
                String[] xy = t.split(",");
                if (xy.length != 2) continue;
                pts.add(Double.parseDouble(xy[0]));
                pts.add(Double.parseDouble(xy[1]));
            }
            if (pts.size() >= 6) {
                ShapeDef.Path p = new ShapeDef.Path();
                p.type = "polygon";
                p.points.addAll(pts);
                p.fill = true;
                this.working.paths.add(p);
                this.rebuildMask128();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCircle() {
        try {
            double cx = Double.parseDouble(this.circleCx.method_1882());
            double cy = Double.parseDouble(this.circleCy.method_1882());
            double r = Double.parseDouble(this.circleR.method_1882());
            ShapeDef.Path p = new ShapeDef.Path();
            p.type = "circle";
            p.num.put("cx", cx);
            p.num.put("cy", cy);
            p.num.put("r", r);
            p.fill = true;
            this.working.paths.add(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addGear() {
        try {
            int teeth = (int)Double.parseDouble(this.gearTeeth.method_1882());
            double innerR = Double.parseDouble(this.gearInnerR.method_1882());
            double outerR = Double.parseDouble(this.gearOuterR.method_1882());
            double holeR = Double.parseDouble(this.gearHoleR.method_1882());
            ShapeDef.Path p = new ShapeDef.Path();
            p.type = "gear";
            p.num.put("teeth", Double.valueOf(teeth));
            p.num.put("innerR", innerR);
            p.num.put("outerR", outerR);
            p.num.put("holeR", holeR);
            p.fill = true;
            this.working.paths.add(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doSave() {
        this.working.id = ShapeDesignerScreen.sanitize(this.idBox.method_1882());
        this.working.displayName = this.nameBox.method_1882().isBlank() ? this.working.id : this.nameBox.method_1882();
        try {
            ShapeRegistry.save(this.working);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doApply() {
        this.doSave();
        if (this.onApplyShapeId != null) {
            this.onApplyShapeId.accept(this.working.id);
        }
    }

    private static String sanitize(String s) {
        String out = s == null ? "" : s.trim().toLowerCase(Locale.ROOT);
        out = out.replaceAll("[^a-z0-9_]+", "_");
        if ((out = out.replaceAll("_+", "_")).isEmpty()) {
            out = "my_shape";
        }
        return out;
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        long now;
        this.method_25420(g);
        int panelW = 520;
        int x = Math.max(12, this.field_22789 / 2 - panelW / 2);
        int y = Math.max(20, this.field_22790 / 2 - 110);
        int pvSize = Math.min(240, this.field_22790 - 120);
        int pvX = x;
        int pvY = y;
        g.method_25303(this.field_22793, "Shape Designer (MVP)", x, y - 12, -1);
        g.method_25303(this.field_22793, "ID:", x + pvSize + 16 - 40, y + 4, -5592406);
        g.method_25303(this.field_22793, "Name:", x + pvSize + 16 - 40, y + 24, -5592406);
        super.method_25394(g, mouseX, mouseY, partialTick);
        g.method_25294(pvX - 6, pvY - 6, pvX + pvSize + 6, pvY + pvSize + 6, -2013265920);
        g.method_25294(pvX - 4, pvY - 4, pvX + pvSize + 4, pvY + pvSize + 4, -14803426);
        if (this.showGrid && !this.drawing) {
            int step = Math.max(8, pvSize / 10);
            int gridColorMajor = 0x22444444;
            int gridColorMinor = 0x11222222;
            for (int i = 0; i <= pvSize; i += step) {
                int c = i == pvSize / 2 ? gridColorMajor : gridColorMinor;
                g.method_25294(pvX + i, pvY, pvX + i + 1, pvY + pvSize, c);
                g.method_25294(pvX, pvY + i, pvX + pvSize, pvY + i + 1, c);
            }
        }
        if (!this.drawing) {
            CustomShapeRenderer.draw(this.working, g, pvX, pvY, pvSize, -14013910);
            CustomShapeRenderer.drawShadeOverlay(this.working, g, pvX, pvY, pvSize, "linear", "down_right", 0.6, -16777216);
            CustomShapeRenderer.drawOutline(this.working, g, pvX, pvY, pvSize, -1, Math.max(1, pvSize / 24));
        } else {
            g.method_25294(pvX, pvY, pvX + pvSize, pvY + pvSize, -14671840);
        }
        if (this.canvasDirty && this.canvasTexture != null) {
            long interval;
            long now2 = System.nanoTime();
            long l = interval = this.drawing ? 150000000L : 16000000L;
            if (now2 - this.lastUploadNs > interval) {
                if (this.needCanvasSync && this.canvasImage != null) {
                    for (int iy = 0; iy < 128; ++iy) {
                        for (int ix = 0; ix < 128; ++ix) {
                            int argb = this.iconPixels[iy * 128 + ix];
                            int a = argb >>> 24 & 0xFF;
                            int r = argb >>> 16 & 0xFF;
                            int gch = argb >>> 8 & 0xFF;
                            int b = argb & 0xFF;
                            int rgba = r << 24 | gch << 16 | b << 8 | a;
                            this.canvasImage.method_4305(ix, iy, rgba);
                        }
                    }
                    this.needCanvasSync = false;
                }
                this.canvasTexture.method_4524();
                this.canvasDirty = false;
                this.lastUploadNs = now2;
            }
        }
        if (this.liveDirty && this.liveTexture != null && (now = System.nanoTime()) - this.lastLiveUploadNs > 16000000L) {
            this.liveTexture.method_4524();
            this.liveDirty = false;
            this.lastLiveUploadNs = now;
        }
        if (this.canvasRL != null) {
            g.method_25293(this.canvasRL, pvX, pvY, pvSize, pvSize, 0.0f, 0.0f, 128, 128, 128, 128);
        }
        if (this.liveRL != null && (this.drawing || this.hasLiveStroke)) {
            g.method_25293(this.liveRL, pvX, pvY, pvSize, pvSize, 0.0f, 0.0f, 64, 64, 64, 64);
        }
        g.method_25303(this.field_22793, "Preview", pvX, pvY + pvSize + 6, -3355444);
    }

    private void applyTemplateCircle() {
        this.working.paths.clear();
        ShapeDef.Path p = new ShapeDef.Path();
        p.type = "circle";
        p.num.put("cx", 0.5);
        p.num.put("cy", 0.5);
        p.num.put("r", 0.48);
        p.fill = true;
        this.working.paths.add(p);
        this.rebuildMask128();
        this.rebuildMask128();
    }

    private void applyTemplateHex() {
        this.working.paths.clear();
        double cx = 0.5;
        double cy = 0.5;
        double r = 0.48;
        double[][] pts = new double[6][2];
        for (int i = 0; i < 6; ++i) {
            double a = Math.toRadians(60 * i - 30);
            pts[i][0] = cx + r * Math.cos(a);
            pts[i][1] = cy + r * Math.sin(a);
        }
        ShapeDef.Path p = new ShapeDef.Path();
        p.type = "polygon";
        for (int i = 0; i < 6; ++i) {
            p.points.add(pts[i][0]);
            p.points.add(pts[i][1]);
        }
        p.fill = true;
        this.working.paths.add(p);
        this.rebuildMask128();
    }

    private void applyTemplateStar() {
        this.working.paths.clear();
        ShapeDef.Path p = new ShapeDef.Path();
        p.type = "star";
        p.num.put("cx", 0.5);
        p.num.put("cy", 0.5);
        p.num.put("points", 5.0);
        p.num.put("innerR", 0.22);
        p.num.put("outerR", 0.48);
        p.num.put("rotation", -90.0);
        p.fill = true;
        this.working.paths.add(p);
        this.rebuildMask128();
    }

    private void applyTemplateGear() {
        this.working.paths.clear();
        ShapeDef.Path p = new ShapeDef.Path();
        p.type = "gear";
        p.num.put("cx", 0.5);
        p.num.put("cy", 0.5);
        p.num.put("teeth", 10.0);
        p.num.put("innerR", 0.3);
        p.num.put("outerR", 0.48);
        p.fill = true;
        this.working.paths.add(p);
        ShapeDef.Path inner = new ShapeDef.Path();
        inner.type = "circle";
        inner.num.put("cx", 0.5);
        inner.num.put("cy", 0.5);
        inner.num.put("r", 0.12);
        inner.fill = false;
        this.working.paths.add(inner);
        this.rebuildMask128();
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }

    private void clearIcon() {
        Arrays.fill(this.iconPixels, 0);
        if (this.canvasImage != null) {
            for (int iy = 0; iy < 128; ++iy) {
                for (int ix = 0; ix < 128; ++ix) {
                    this.canvasImage.method_4305(ix, iy, 0);
                }
            }
            this.canvasDirty = true;
        }
        this.clearLiveCanvas();
    }

    private void clearLiveCanvas() {
        if (this.liveImage == null) {
            return;
        }
        for (int iy = 0; iy < 64; ++iy) {
            for (int ix = 0; ix < 64; ++ix) {
                this.liveImage.method_4305(ix, iy, 0);
            }
        }
        this.liveDirty = true;
        this.hasLiveStroke = false;
    }

    private void exportIcon() {
        try {
            String id = ShapeDesignerScreen.sanitize(this.idBox.method_1882());
            File dir = new File(class_310.method_1551().field_1697, "config/questory/shapes/icons");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File out = new File(dir, id + ".png");
            BufferedImage img = new BufferedImage(128, 128, 2);
            img.setRGB(0, 0, 128, 128, this.iconPixels, 0, 128);
            ImageIO.write((RenderedImage)img, "PNG", out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int parseColorBox() {
        try {
            String s = this.colorHexBox.method_1882().trim();
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (s.length() == 8) {
                return (int)Long.parseLong(s, 16);
            }
            if (s.length() == 6) {
                int rgb = Integer.parseInt(s, 16);
                return 0xFF000000 | rgb;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private void drawAtScreen(int mouseX, int mouseY) {
        if (this.previewRect == null) {
            return;
        }
        int px = this.previewRect[0];
        int py = this.previewRect[1];
        int ps = this.previewRect[2];
        if (mouseX < px || mouseX >= px + ps || mouseY < py || mouseY >= py + ps) {
            return;
        }
        if (this.eyedropper) {
            int sx = (int)Math.round((double)(mouseX - px) * (128.0 / (double)ps));
            int sy = (int)Math.round((double)(mouseY - py) * (128.0 / (double)ps));
            sx = Math.max(0, Math.min(127, sx));
            sy = Math.max(0, Math.min(127, sy));
            int argb = this.iconPixels[sy * 128 + sx];
            this.colorHexBox.method_1852(String.format(Locale.ROOT, "%08X", argb));
            this.eyedropper = false;
            return;
        }
        this.brushColor = this.parseColorBox();
        int cx = (int)Math.round((double)(mouseX - px) * (128.0 / (double)ps));
        int cy = (int)Math.round((double)(mouseY - py) * (128.0 / (double)ps));
        cx = Math.max(0, Math.min(127, cx));
        cy = Math.max(0, Math.min(127, cy));
        int liveX = (int)Math.round((double)(mouseX - px) * (64.0 / (double)ps));
        int liveY = (int)Math.round((double)(mouseY - py) * (64.0 / (double)ps));
        liveX = Math.max(0, Math.min(63, liveX));
        liveY = Math.max(0, Math.min(63, liveY));
        if (!this.strokeSnapshotTaken) {
            this.pushUndoSnapshot();
            this.strokeSnapshotTaken = true;
        }
        this.paintCircleLive(liveX, liveY, this.brushSize, this.erasing ? 0 : this.brushColor);
        this.hasLiveStroke = true;
    }

    private int toRgba(int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        return r << 24 | g << 16 | b << 8 | a;
    }

    private int liveRadiusFor(int baseRadius) {
        double scaled = (double)baseRadius * 0.5;
        return Math.max(1, (int)Math.round(scaled));
    }

    private void paintCircleLive(int cx, int cy, int baseRadius, int color) {
        if (this.liveImage == null) {
            return;
        }
        int rLive = this.liveRadiusFor(baseRadius);
        short[] mask = BRUSH_MASKS.computeIfAbsent(rLive, this::buildBrushMask);
        int rgba = this.toRgba(color);
        boolean changed = false;
        for (int i = 0; i < mask.length; i += 2) {
            short dx = mask[i];
            short dy = mask[i + 1];
            int x = cx + dx;
            int y = cy + dy;
            if (x < 0 || x >= 64 || y < 0 || y >= 64) continue;
            this.liveImage.method_4305(x, y, rgba);
            changed = true;
        }
        if (changed) {
            this.liveDirty = true;
            this.hasLiveStroke = true;
        }
    }

    private short[] buildBrushMask(int r) {
        ArrayList<Short> list = new ArrayList<Short>();
        int r2 = r * r;
        for (int dy = -r; dy <= r; ++dy) {
            for (int dx = -r; dx <= r; ++dx) {
                if (dx * dx + dy * dy > r2) continue;
                list.add((short)dx);
                list.add((short)dy);
            }
        }
        short[] arr = new short[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (Short)list.get(i);
        }
        return arr;
    }

    private void rebuildMask128() {
        this.shapeMask128 = new boolean[16384];
        boolean any = false;
        for (int py = 0; py < 128; ++py) {
            for (int px = 0; px < 128; ++px) {
                boolean inside;
                this.shapeMask128[py * 128 + px] = inside = CustomShapeRenderer.contains(this.working, 0, 0, 128, px, py);
                if (!inside) continue;
                any = true;
            }
        }
        this.shapeMaskLow = new boolean[4096];
        boolean anyLow = false;
        for (int py = 0; py < 64; ++py) {
            for (int px = 0; px < 64; ++px) {
                boolean inside;
                this.shapeMaskLow[py * 64 + px] = inside = CustomShapeRenderer.contains(this.working, 0, 0, 64, px, py);
                if (!inside) continue;
                anyLow = true;
            }
        }
        if (!any) {
            this.shapeMask128 = null;
        }
        if (!anyLow) {
            this.shapeMaskLow = null;
        }
    }

    private void commitLiveToHiRes() {
        if (this.liveImage == null || !this.hasLiveStroke) {
            return;
        }
        for (int y = 0; y < 128; ++y) {
            int sy = (int)Math.floor((double)y * 0.5);
            if (sy < 0) {
                sy = 0;
            }
            if (sy >= 64) {
                sy = 63;
            }
            for (int x = 0; x < 128; ++x) {
                int argb;
                int sx = (int)Math.floor((double)x * 0.5);
                if (sx < 0) {
                    sx = 0;
                }
                if (sx >= 64) {
                    sx = 63;
                }
                int rgba = this.liveImage.method_4315(sx, sy);
                int a = rgba >>> 24 & 0xFF;
                int r = rgba >>> 16 & 0xFF;
                int g = rgba >>> 8 & 0xFF;
                int b = rgba & 0xFF;
                if (a == 0) continue;
                this.iconPixels[y * 128 + x] = argb = a << 24 | r << 16 | g << 8 | b;
            }
        }
        for (int iy = 0; iy < 64; ++iy) {
            for (int ix = 0; ix < 64; ++ix) {
                this.liveImage.method_4305(ix, iy, 0);
            }
        }
        this.liveDirty = true;
        this.canvasDirty = true;
        this.needCanvasSync = true;
        this.hasLiveStroke = false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.drawing = true;
            this.drawAtScreen((int)mouseX, (int)mouseY);
            if (this.previewRect != null) {
                int px = this.previewRect[0];
                int py = this.previewRect[1];
                int ps = this.previewRect[2];
                this.lastDrawX = (int)Math.round((mouseX - (double)px) * (64.0 / (double)ps));
                this.lastDrawY = (int)Math.round((mouseY - (double)py) * (64.0 / (double)ps));
                this.lastDrawX = Math.max(0, Math.min(63, this.lastDrawX));
                this.lastDrawY = Math.max(0, Math.min(63, this.lastDrawY));
                this.canvasDirty = true;
                this.lastUploadNs = 0L;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.commitLiveToHiRes();
            this.drawing = false;
            this.strokeSnapshotTaken = false;
            this.lastDrawY = -1;
            this.lastDrawX = -1;
            this.canvasDirty = true;
            this.lastUploadNs = 0L;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.drawing && button == 0 && this.previewRect != null) {
            int px = this.previewRect[0];
            int py = this.previewRect[1];
            int ps = this.previewRect[2];
            int cx = (int)Math.round((mouseX - (double)px) * (64.0 / (double)ps));
            int cy = (int)Math.round((mouseY - (double)py) * (64.0 / (double)ps));
            cx = Math.max(0, Math.min(63, cx));
            cy = Math.max(0, Math.min(63, cy));
            this.brushColor = this.parseColorBox();
            if (this.lastDrawX >= 0) {
                int dx = cx - this.lastDrawX;
                int dy = cy - this.lastDrawY;
                int maxDelta = Math.max(Math.abs(dx), Math.abs(dy));
                int stepPx = Math.max(1, this.liveRadiusFor(this.brushSize));
                int steps = Math.max(1, maxDelta / stepPx);
                for (int i = 1; i <= steps; ++i) {
                    int ix = this.lastDrawX + dx * i / steps;
                    int iy = this.lastDrawY + dy * i / steps;
                    this.paintCircleLive(ix, iy, this.brushSize, this.erasing ? 0 : this.brushColor);
                }
            } else {
                this.paintCircleLive(cx, cy, this.brushSize, this.erasing ? 0 : this.brushColor);
            }
            this.lastDrawX = cx;
            this.lastDrawY = cy;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    private void pushUndoSnapshot() {
        int[] snap = Arrays.copyOf(this.iconPixels, this.iconPixels.length);
        this.undoStack.push(snap);
        this.redoStack.clear();
    }

    private void applySnapshot(int[] snap) {
        System.arraycopy(snap, 0, this.iconPixels, 0, this.iconPixels.length);
        if (this.canvasImage != null) {
            for (int iy = 0; iy < 128; ++iy) {
                for (int ix = 0; ix < 128; ++ix) {
                    int argb = this.iconPixels[iy * 128 + ix];
                    int a = argb >>> 24 & 0xFF;
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int rgba = r << 24 | g << 16 | b << 8 | a;
                    this.canvasImage.method_4305(ix, iy, rgba);
                }
            }
            this.canvasDirty = true;
        }
    }

    private void undo() {
        if (!this.undoStack.isEmpty()) {
            int[] current = Arrays.copyOf(this.iconPixels, this.iconPixels.length);
            int[] snap = this.undoStack.pop();
            this.redoStack.push(current);
            this.applySnapshot(snap);
        }
    }

    private void redo() {
        if (!this.redoStack.isEmpty()) {
            int[] current = Arrays.copyOf(this.iconPixels, this.iconPixels.length);
            int[] snap = this.redoStack.pop();
            this.undoStack.push(current);
            this.applySnapshot(snap);
        }
    }

    private void useAsQuestIcon() {
        try {
            class_1011 img = new class_1011(128, 128, true);
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    int argb = this.iconPixels[y * 128 + x];
                    int a = argb >>> 24 & 0xFF;
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int rgba = r << 24 | g << 16 | b << 8 | a;
                    img.method_4305(x, y, rgba);
                }
            }
            String sid = ShapeDesignerScreen.sanitize(this.idBox.method_1882());
            class_2960 rl = new class_2960("questory", "textures/gui/custom_icons/" + sid + ".png");
            class_1043 dyn = new class_1043(img);
            class_310.method_1551().method_1531().method_4616(rl, (class_1044)dyn);
            class_437 r = this.parent;
            if (r instanceof QuestEditorScreen) {
                QuestEditorScreen editor = (QuestEditorScreen)r;
                String iconSpec = "texture:questory:gui/custom_icons/" + sid;
                editor.getWorkingQuest().setIcon(iconSpec);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

