/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.texboobcat.questory.team.ITeamProvider;

public class FTBTeamsProvider
implements ITeamProvider {
    @Override
    public UUID getTeamId(UUID playerId) {
        try {
            FTBTeamsAPI.API api = FTBTeamsAPI.api();
            if (api == null || !api.isManagerLoaded()) {
                return null;
            }
            return api.getManager().getTeamForPlayerID(playerId).map(team -> team.isPartyTeam() ? team.getTeamId() : null).orElse(null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public Set<UUID> getTeamMembers(UUID teamId) {
        try {
            FTBTeamsAPI.API api = FTBTeamsAPI.api();
            if (api == null || !api.isManagerLoaded()) {
                return Collections.emptySet();
            }
            return api.getManager().getTeamByID(teamId).map(team -> team.isPartyTeam() ? team.getMembers() : Collections.emptySet()).orElse(Collections.emptySet());
        }
        catch (Throwable t) {
            return Collections.emptySet();
        }
    }

    @Override
    public String getTeamName(UUID teamId) {
        try {
            FTBTeamsAPI.API api = FTBTeamsAPI.api();
            if (api == null || !api.isManagerLoaded()) {
                return null;
            }
            return api.getManager().getTeamByID(teamId).map(team -> {
                try {
                    return (String)team.getProperty((TeamProperty)TeamProperties.DISPLAY_NAME);
                }
                catch (Throwable ignored) {
                    return team.getName().getString();
                }
            }).orElse(null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public boolean isTeamOwner(UUID playerId, UUID teamId) {
        try {
            FTBTeamsAPI.API api = FTBTeamsAPI.api();
            if (api == null || !api.isManagerLoaded()) {
                return false;
            }
            return api.getManager().getTeamByID(teamId).map(team -> team.getOwner().equals(playerId)).orElse(false);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public String getProviderId() {
        return "ftbteams";
    }

    @Override
    public boolean isAvailable() {
        try {
            Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

