/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class CommandRequirement
extends Requirement {
    private String description;

    public CommandRequirement(String id, String description) {
        super("command");
        this.setId(id);
        this.description = description;
    }

    public String getRequirementId() {
        return this.getId();
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean completed = this.isMet(progress, questId);
        return (completed ? "\u2713" : "\u2717") + " " + this.description;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("description", this.description);
        return json;
    }

    public static CommandRequirement fromJson(JsonObject json) {
        String id = json.get("id").getAsString();
        String description = json.get("description").getAsString();
        return new CommandRequirement(id, description);
    }
}

