/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class EntityKillRequirement
extends Requirement {
    private String entity;
    private int count;
    private String customName;

    public EntityKillRequirement(String entity, int count) {
        super("entity_kill");
        this.entity = entity;
        this.count = count;
        this.customName = null;
    }

    public String getEntity() {
        return this.entity;
    }

    public int getCount() {
        return this.count;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean isEntityTag() {
        return this.entity != null && this.entity.startsWith("#");
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.count;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        Object entityDisplay = this.entity;
        if (this.customName != null && !this.customName.isEmpty()) {
            entityDisplay = this.entity + " named \"" + this.customName + "\"";
        }
        return "Kill " + current + "/" + this.count + " " + (String)entityDisplay;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("entity", this.entity);
        json.addProperty("count", (Number)this.count);
        if (this.customName != null && !this.customName.isEmpty()) {
            json.addProperty("customName", this.customName);
        }
        return json;
    }

    public static EntityKillRequirement fromJson(JsonObject json) {
        String entity = json.get("entity").getAsString();
        int count = json.get("count").getAsInt();
        EntityKillRequirement req = new EntityKillRequirement(entity, count);
        if (json.has("customName")) {
            req.setCustomName(json.get("customName").getAsString());
        }
        return req;
    }
}

