/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class ItemRequirement
extends Requirement {
    private String item;
    private int count;
    private class_2487 nbt;
    private boolean consume;
    private boolean onlyFromCrafting = false;
    private boolean taskScreenOnly = false;
    private String matchComponents = "none";

    public ItemRequirement(String item, int count) {
        super("item_obtain");
        this.item = item;
        this.count = count;
        this.nbt = null;
        this.consume = false;
    }

    public String getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    public boolean shouldConsume() {
        return this.consume;
    }

    public void setNbt(class_2487 nbt) {
        this.nbt = nbt;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    public boolean isOnlyFromCrafting() {
        return this.onlyFromCrafting;
    }

    public void setOnlyFromCrafting(boolean onlyFromCrafting) {
        this.onlyFromCrafting = onlyFromCrafting;
    }

    public boolean isTaskScreenOnly() {
        return this.taskScreenOnly;
    }

    public void setTaskScreenOnly(boolean taskScreenOnly) {
        this.taskScreenOnly = taskScreenOnly;
    }

    public String getMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(String matchComponents) {
        this.matchComponents = matchComponents;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.count;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.count + " " + this.item;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("item", this.item);
        json.addProperty("count", (Number)this.count);
        json.addProperty("consume", Boolean.valueOf(this.consume));
        if (this.nbt != null) {
            json.addProperty("nbt", this.nbt.toString());
        }
        if (this.onlyFromCrafting) {
            json.addProperty("only_from_crafting", Boolean.valueOf(true));
        }
        if (this.taskScreenOnly) {
            json.addProperty("task_screen_only", Boolean.valueOf(true));
        }
        if (!"none".equals(this.matchComponents)) {
            json.addProperty("match_components", this.matchComponents);
        }
        return json;
    }

    public static ItemRequirement fromJson(JsonObject json) {
        String item = json.get("item").getAsString();
        int count = json.get("count").getAsInt();
        ItemRequirement req = new ItemRequirement(item, count);
        if (json.has("consume")) {
            req.setConsume(json.get("consume").getAsBoolean());
        }
        if (json.has("nbt")) {
            try {
                class_2487 nbt = class_2522.method_10718((String)json.get("nbt").getAsString());
                req.setNbt(nbt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (json.has("only_from_crafting")) {
            req.setOnlyFromCrafting(json.get("only_from_crafting").getAsBoolean());
        }
        if (json.has("task_screen_only")) {
            req.setTaskScreenOnly(json.get("task_screen_only").getAsBoolean());
        }
        if (json.has("match_components")) {
            req.setMatchComponents(json.get("match_components").getAsString());
        }
        return req;
    }

    public boolean matches(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_2960 stackId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (!stackId.toString().equals(this.item)) {
            return false;
        }
        if (this.nbt != null) {
            class_2487 stackNbt = stack.method_7969();
            if (stackNbt == null) {
                return false;
            }
            return this.nbtMatches(stackNbt, this.nbt);
        }
        return true;
    }

    private boolean nbtMatches(class_2487 stackNbt, class_2487 requiredNbt) {
        for (String key : requiredNbt.method_10541()) {
            if (!stackNbt.method_10545(key)) {
                return false;
            }
            if (stackNbt.method_10580(key).equals((Object)requiredNbt.method_10580(key))) continue;
            return false;
        }
        return true;
    }
}

