/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.team.TeamQuestSettings;

public class Quest {
    private String id;
    private String title;
    private String description;
    private String icon;
    private List<String> dependencies;
    private List<Requirement> requirements;
    private List<Reward> rewards;
    private boolean hidden;
    private long deletedTimestamp = 0L;
    private String group;
    private String chapterId;
    private int x;
    private int y;
    private boolean hideDependencyLines;
    private boolean hideDependentLines;
    private double iconScale;
    private String lineStyle;
    private List<String> tags;
    private String shape = "";
    private double size = 1.0;
    private boolean optional = false;
    private int minWidth = 0;
    private String canRepeat = "default";
    private String dependencyRequirement = "all_completed";
    private int minRequiredDependencies = 0;
    private int maxCompletableDeps = 0;
    private String progressionMode = "default";
    private String requireSequentialTasks = "default";
    private boolean invisibleUntilCompleted = false;
    private int invisibleUntilTasks = 0;
    private String hideTextUntilComplete = "default";
    private String hideDetailsUntilStartable = "default";
    private String hideUntilDepsVisible = "default";
    private String hideUntilDepsComplete = "default";
    private String disableJEI = "default";
    private boolean hideLockIcon = false;
    private String guidePage = "";
    private boolean ignoreRewardBlocking = false;
    private boolean disableToast = false;
    private String subtitle = "";
    private TeamQuestSettings teamSettings;

    public Quest(String id, String title, String description) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.icon = "minecraft:writable_book";
        this.dependencies = new ArrayList<String>();
        this.requirements = new ArrayList<Requirement>();
        this.rewards = new ArrayList<Reward>();
        this.hidden = false;
        this.group = "default";
        this.chapterId = null;
        this.x = 0;
        this.y = 0;
        this.hideDependencyLines = false;
        this.hideDependentLines = false;
        this.iconScale = 1.0;
        this.lineStyle = "solid";
        this.tags = new ArrayList<String>();
        this.teamSettings = new TeamQuestSettings();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public long getDeletedTimestamp() {
        return this.deletedTimestamp;
    }

    public String getGroup() {
        return this.group;
    }

    public String getChapterId() {
        return this.chapterId;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isHideDependencyLines() {
        return this.hideDependencyLines;
    }

    public boolean isHideDependentLines() {
        return this.hideDependentLines;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getShape() {
        return this.shape;
    }

    public double getSize() {
        return this.size;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public String getCanRepeat() {
        return this.canRepeat;
    }

    public String getDependencyRequirement() {
        return this.dependencyRequirement;
    }

    public int getMinRequiredDependencies() {
        return this.minRequiredDependencies;
    }

    public int getMaxCompletableDeps() {
        return this.maxCompletableDeps;
    }

    public String getProgressionMode() {
        return this.progressionMode;
    }

    public String getRequireSequentialTasks() {
        return this.requireSequentialTasks;
    }

    public boolean isInvisibleUntilCompleted() {
        return this.invisibleUntilCompleted;
    }

    public int getInvisibleUntilTasks() {
        return this.invisibleUntilTasks;
    }

    public String getHideTextUntilComplete() {
        return this.hideTextUntilComplete;
    }

    public String getHideDetailsUntilStartable() {
        return this.hideDetailsUntilStartable;
    }

    public String getHideUntilDepsVisible() {
        return this.hideUntilDepsVisible;
    }

    public String getHideUntilDepsComplete() {
        return this.hideUntilDepsComplete;
    }

    public String getDisableJEI() {
        return this.disableJEI;
    }

    public boolean isHideLockIcon() {
        return this.hideLockIcon;
    }

    public String getGuidePage() {
        return this.guidePage;
    }

    public boolean isIgnoreRewardBlocking() {
        return this.ignoreRewardBlocking;
    }

    public TeamQuestSettings getTeamSettings() {
        return this.teamSettings;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setDeletedTimestamp(long deletedTimestamp) {
        this.deletedTimestamp = deletedTimestamp;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setChapterId(String v) {
        this.chapterId = v;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setHideDependencyLines(boolean v) {
        this.hideDependencyLines = v;
    }

    public void setHideDependentLines(boolean v) {
        this.hideDependentLines = v;
    }

    public void setIconScale(double v) {
        this.iconScale = v;
    }

    public void setLineStyle(String v) {
        this.lineStyle = v;
    }

    public void setShape(String v) {
        this.shape = v;
    }

    public void setSize(double v) {
        this.size = v;
    }

    public void setOptional(boolean v) {
        this.optional = v;
    }

    public void setMinWidth(int v) {
        this.minWidth = v;
    }

    public void setCanRepeat(String v) {
        this.canRepeat = v;
    }

    public void setDependencyRequirement(String v) {
        this.dependencyRequirement = v;
    }

    public void setMinRequiredDependencies(int v) {
        this.minRequiredDependencies = v;
    }

    public void setMaxCompletableDeps(int v) {
        this.maxCompletableDeps = v;
    }

    public void setProgressionMode(String v) {
        this.progressionMode = v;
    }

    public void setRequireSequentialTasks(String v) {
        this.requireSequentialTasks = v;
    }

    public void setInvisibleUntilCompleted(boolean v) {
        this.invisibleUntilCompleted = v;
    }

    public void setInvisibleUntilTasks(int v) {
        this.invisibleUntilTasks = v;
    }

    public void setHideTextUntilComplete(String v) {
        this.hideTextUntilComplete = v;
    }

    public void setHideDetailsUntilStartable(String v) {
        this.hideDetailsUntilStartable = v;
    }

    public void setHideUntilDepsVisible(String v) {
        this.hideUntilDepsVisible = v;
    }

    public void setHideUntilDepsComplete(String v) {
        this.hideUntilDepsComplete = v;
    }

    public void setDisableJEI(String v) {
        this.disableJEI = v;
    }

    public void setHideLockIcon(boolean v) {
        this.hideLockIcon = v;
    }

    public void setGuidePage(String v) {
        this.guidePage = v;
    }

    public void setIgnoreRewardBlocking(boolean v) {
        this.ignoreRewardBlocking = v;
    }

    public boolean isDisableToast() {
        return this.disableToast;
    }

    public void setDisableToast(boolean v) {
        this.disableToast = v;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String v) {
        this.subtitle = v != null ? v : "";
    }

    public void setTeamSettings(TeamQuestSettings settings) {
        this.teamSettings = settings;
    }

    public void addDependency(String questId) {
        if (!this.dependencies.contains(questId)) {
            this.dependencies.add(questId);
        }
    }

    public void removeDependency(String questId) {
        this.dependencies.remove(questId);
    }

    public void addRequirement(Requirement requirement) {
        this.requirements.add(requirement);
    }

    public void removeRequirement(Requirement requirement) {
        this.requirements.remove(requirement);
    }

    public void addReward(Reward reward) {
        this.rewards.add(reward);
    }

    public void removeReward(Reward reward) {
        this.rewards.remove(reward);
    }

    public void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public boolean areDependenciesMet(QuestProgress progress) {
        if (this.dependencies.isEmpty()) {
            return true;
        }
        int completedCount = 0;
        int startedCount = 0;
        for (String depId : this.dependencies) {
            if (progress.isQuestCompleted(depId)) {
                ++completedCount;
                ++startedCount;
                continue;
            }
            if (!this.hasQuestStarted(progress, depId)) continue;
            ++startedCount;
        }
        if (this.minRequiredDependencies > 0 && completedCount < this.minRequiredDependencies) {
            return false;
        }
        if (this.maxCompletableDeps > 0 && completedCount > this.maxCompletableDeps) {
            return false;
        }
        return switch (this.dependencyRequirement.toLowerCase()) {
            case "one_completed" -> {
                if (completedCount >= 1) {
                    yield true;
                }
                yield false;
            }
            case "all_started" -> {
                if (startedCount == this.dependencies.size()) {
                    yield true;
                }
                yield false;
            }
            case "one_started" -> {
                if (startedCount >= 1) {
                    yield true;
                }
                yield false;
            }
            default -> completedCount == this.dependencies.size();
        };
    }

    private boolean hasQuestStarted(QuestProgress progress, String questId) {
        if (progress.isQuestCompleted(questId)) {
            return true;
        }
        return progress.getCompletionTime(questId) > 0L;
    }

    public boolean areRequirementsMet(QuestProgress progress) {
        if (this.requirements.isEmpty()) {
            return true;
        }
        boolean sequential = "true".equals(this.requireSequentialTasks);
        if (sequential) {
            for (int i = 0; i < this.requirements.size(); ++i) {
                Requirement req = this.requirements.get(i);
                if (req.isMet(progress, this.id)) continue;
                if (i > 0) {
                    for (int j = 0; j < i; ++j) {
                        if (this.requirements.get(j).isMet(progress, this.id)) continue;
                        return false;
                    }
                }
                return false;
            }
            return true;
        }
        for (Requirement req : this.requirements) {
            if (req.isMet(progress, this.id)) continue;
            return false;
        }
        return true;
    }

    public boolean canComplete(QuestProgress progress) {
        return this.areDependenciesMet(progress) && this.areRequirementsMet(progress);
    }

    public boolean isVisible(QuestProgress progress) {
        if (this.hidden) {
            return false;
        }
        if (this.invisibleUntilCompleted && !progress.isQuestCompleted(this.id)) {
            return false;
        }
        if (this.invisibleUntilTasks > 0) {
            int completedTasks = 0;
            for (Requirement req : this.requirements) {
                if (!req.isMet(progress, this.id)) continue;
                ++completedTasks;
            }
            if (completedTasks < this.invisibleUntilTasks) {
                return false;
            }
        }
        if ("true".equals(this.hideUntilDepsVisible)) {
            for (String depId : this.dependencies) {
                if (progress.isQuestCompleted(depId)) continue;
                return false;
            }
        }
        return !"true".equals(this.hideUntilDepsComplete) || this.areDependenciesMet(progress);
    }

    public boolean canRepeat() {
        return "true".equals(this.canRepeat);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("title", this.title);
        json.addProperty("description", this.description);
        json.addProperty("icon", this.icon);
        json.addProperty("hidden", Boolean.valueOf(this.hidden));
        if (this.deletedTimestamp > 0L) {
            json.addProperty("deletedTimestamp", (Number)this.deletedTimestamp);
        }
        json.addProperty("group", this.group);
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        if (this.hideDependencyLines) {
            json.addProperty("hide_dependency_lines", Boolean.valueOf(true));
        }
        if (this.hideDependentLines) {
            json.addProperty("hide_dependent_lines", Boolean.valueOf(true));
        }
        if (this.iconScale != 1.0) {
            json.addProperty("icon_scale", (Number)this.iconScale);
        }
        if (!"solid".equals(this.lineStyle)) {
            json.addProperty("line_style", this.lineStyle);
        }
        if (!this.shape.isEmpty()) {
            json.addProperty("shape", this.shape);
        }
        if (this.size != 1.0) {
            json.addProperty("size", (Number)this.size);
        }
        if (this.optional) {
            json.addProperty("optional", Boolean.valueOf(true));
        }
        if (this.minWidth > 0) {
            json.addProperty("min_width", (Number)this.minWidth);
        }
        if (!"default".equals(this.canRepeat)) {
            json.addProperty("can_repeat", this.canRepeat);
        }
        if (!"all_completed".equals(this.dependencyRequirement)) {
            json.addProperty("dependency_requirement", this.dependencyRequirement);
        }
        if (this.minRequiredDependencies > 0) {
            json.addProperty("min_required_dependencies", (Number)this.minRequiredDependencies);
        }
        if (this.maxCompletableDeps > 0) {
            json.addProperty("max_completable_deps", (Number)this.maxCompletableDeps);
        }
        if (!"default".equals(this.progressionMode)) {
            json.addProperty("progression_mode", this.progressionMode);
        }
        if (!"default".equals(this.requireSequentialTasks)) {
            json.addProperty("require_sequential_tasks", this.requireSequentialTasks);
        }
        if (this.invisibleUntilCompleted) {
            json.addProperty("invisible_until_completed", Boolean.valueOf(true));
        }
        if (this.invisibleUntilTasks > 0) {
            json.addProperty("invisible_until_tasks", (Number)this.invisibleUntilTasks);
        }
        if (!"default".equals(this.hideTextUntilComplete)) {
            json.addProperty("hide_text_until_complete", this.hideTextUntilComplete);
        }
        if (!"default".equals(this.hideDetailsUntilStartable)) {
            json.addProperty("hide_details_until_startable", this.hideDetailsUntilStartable);
        }
        if (!"default".equals(this.hideUntilDepsVisible)) {
            json.addProperty("hide_until_deps_visible", this.hideUntilDepsVisible);
        }
        if (!"default".equals(this.hideUntilDepsComplete)) {
            json.addProperty("hide_until_deps_complete", this.hideUntilDepsComplete);
        }
        if (!"default".equals(this.disableJEI)) {
            json.addProperty("disable_jei", this.disableJEI);
        }
        if (this.hideLockIcon) {
            json.addProperty("hide_lock_icon", Boolean.valueOf(true));
        }
        if (!this.guidePage.isEmpty()) {
            json.addProperty("guide_page", this.guidePage);
        }
        if (this.ignoreRewardBlocking) {
            json.addProperty("ignore_reward_blocking", Boolean.valueOf(true));
        }
        if (this.disableToast) {
            json.addProperty("disable_toast", Boolean.valueOf(true));
        }
        if (!this.subtitle.isEmpty()) {
            json.addProperty("subtitle", this.subtitle);
        }
        if (this.teamSettings != null && this.teamSettings.isTeamEnabled()) {
            json.add("teamSettings", (JsonElement)this.teamSettings.toJson());
        }
        if (!this.tags.isEmpty()) {
            JsonArray tagsArray = new JsonArray();
            for (String tag : this.tags) {
                tagsArray.add(tag);
            }
            json.add("tags", (JsonElement)tagsArray);
        }
        JsonArray depsArray = new JsonArray();
        for (String dep : this.dependencies) {
            depsArray.add(dep);
        }
        json.add("dependencies", (JsonElement)depsArray);
        JsonArray reqsArray = new JsonArray();
        for (int i = 0; i < this.requirements.size(); ++i) {
            Requirement req = this.requirements.get(i);
            JsonObject reqJson = req.toJson();
            if (req.getId() == null || req.getId().isEmpty() || req.getId().contains("randomUUID")) {
                String stableId = this.id + "_req_" + i;
                req.setId(stableId);
                Questory.LOGGER.warn("[Questory] Requirement missing stable ID during save, assigned: {} for quest {}", (Object)stableId, (Object)this.id);
            }
            reqsArray.add((JsonElement)reqJson);
        }
        json.add("requirements", (JsonElement)reqsArray);
        JsonArray rewardsArray = new JsonArray();
        for (Reward reward : this.rewards) {
            rewardsArray.add((JsonElement)reward.toJson());
        }
        json.add("rewards", (JsonElement)rewardsArray);
        return json;
    }

    public static Quest fromJson(JsonObject json) {
        String id = json.get("id").getAsString();
        String title = json.get("title").getAsString();
        String description = json.get("description").getAsString();
        Quest quest = new Quest(id, title, description);
        if (json.has("icon")) {
            quest.setIcon(json.get("icon").getAsString());
        }
        if (json.has("hidden")) {
            quest.setHidden(json.get("hidden").getAsBoolean());
        }
        if (json.has("deletedTimestamp")) {
            quest.setDeletedTimestamp(json.get("deletedTimestamp").getAsLong());
        }
        if (json.has("group")) {
            quest.setGroup(json.get("group").getAsString());
        }
        if (json.has("x")) {
            quest.setX(json.get("x").getAsInt());
        }
        if (json.has("y")) {
            quest.setY(json.get("y").getAsInt());
        }
        if (json.has("hide_dependency_lines")) {
            quest.setHideDependencyLines(json.get("hide_dependency_lines").getAsBoolean());
        }
        if (json.has("hide_dependent_lines")) {
            quest.setHideDependentLines(json.get("hide_dependent_lines").getAsBoolean());
        }
        if (json.has("icon_scale")) {
            try {
                quest.setIconScale(json.get("icon_scale").getAsDouble());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (json.has("line_style")) {
            quest.setLineStyle(json.get("line_style").getAsString());
        }
        if (json.has("shape")) {
            quest.setShape(json.get("shape").getAsString());
        }
        if (json.has("size")) {
            quest.setSize(json.get("size").getAsDouble());
        }
        if (json.has("optional")) {
            quest.setOptional(json.get("optional").getAsBoolean());
        }
        if (json.has("min_width")) {
            quest.setMinWidth(json.get("min_width").getAsInt());
        }
        if (json.has("can_repeat")) {
            quest.setCanRepeat(json.get("can_repeat").getAsString());
        }
        if (json.has("dependency_requirement")) {
            quest.setDependencyRequirement(json.get("dependency_requirement").getAsString());
        }
        if (json.has("min_required_dependencies")) {
            quest.setMinRequiredDependencies(json.get("min_required_dependencies").getAsInt());
        }
        if (json.has("max_completable_deps")) {
            quest.setMaxCompletableDeps(json.get("max_completable_deps").getAsInt());
        }
        if (json.has("progression_mode")) {
            quest.setProgressionMode(json.get("progression_mode").getAsString());
        }
        if (json.has("require_sequential_tasks")) {
            quest.setRequireSequentialTasks(json.get("require_sequential_tasks").getAsString());
        }
        if (json.has("invisible_until_completed")) {
            quest.setInvisibleUntilCompleted(json.get("invisible_until_completed").getAsBoolean());
        }
        if (json.has("invisible_until_tasks")) {
            quest.setInvisibleUntilTasks(json.get("invisible_until_tasks").getAsInt());
        }
        if (json.has("hide_text_until_complete")) {
            quest.setHideTextUntilComplete(json.get("hide_text_until_complete").getAsString());
        }
        if (json.has("hide_details_until_startable")) {
            quest.setHideDetailsUntilStartable(json.get("hide_details_until_startable").getAsString());
        }
        if (json.has("hide_until_deps_visible")) {
            quest.setHideUntilDepsVisible(json.get("hide_until_deps_visible").getAsString());
        }
        if (json.has("hide_until_deps_complete")) {
            quest.setHideUntilDepsComplete(json.get("hide_until_deps_complete").getAsString());
        }
        if (json.has("disable_jei")) {
            quest.setDisableJEI(json.get("disable_jei").getAsString());
        }
        if (json.has("hide_lock_icon")) {
            quest.setHideLockIcon(json.get("hide_lock_icon").getAsBoolean());
        }
        if (json.has("guide_page")) {
            quest.setGuidePage(json.get("guide_page").getAsString());
        }
        if (json.has("ignore_reward_blocking")) {
            quest.setIgnoreRewardBlocking(json.get("ignore_reward_blocking").getAsBoolean());
        }
        if (json.has("disable_toast")) {
            quest.setDisableToast(json.get("disable_toast").getAsBoolean());
        }
        if (json.has("subtitle")) {
            quest.setSubtitle(json.get("subtitle").getAsString());
        }
        if (json.has("teamSettings")) {
            quest.setTeamSettings(TeamQuestSettings.fromJson(json.getAsJsonObject("teamSettings")));
        }
        if (json.has("tags")) {
            JsonArray tagsArray = json.getAsJsonArray("tags");
            for (JsonElement element : tagsArray) {
                quest.addTag(element.getAsString());
            }
        }
        if (json.has("dependencies")) {
            JsonArray depsArray = json.getAsJsonArray("dependencies");
            for (JsonElement element : depsArray) {
                quest.addDependency(element.getAsString());
            }
        }
        if (json.has("requirements")) {
            JsonArray reqsArray = json.getAsJsonArray("requirements");
            for (int i = 0; i < reqsArray.size(); ++i) {
                try {
                    JsonObject reqJson = reqsArray.get(i).getAsJsonObject();
                    Requirement req = Requirement.fromJson(reqJson);
                    String expectedStableId = id + "_req_" + i;
                    if (!reqJson.has("id")) {
                        req.setId(expectedStableId);
                        if (QuestoryConfig.getInstance().debugMode) {
                            Questory.LOGGER.debug("[Questory Debug] Assigned stable ID to requirement: {} (type: {})", (Object)expectedStableId, (Object)req.getType());
                        }
                    } else {
                        String loadedId = req.getId();
                        if (loadedId != null && !loadedId.equals(expectedStableId)) {
                            Questory.LOGGER.warn("[Questory] Requirement ID mismatch for quest {}: loaded={}, expected={}. Using expected ID.", (Object)id, (Object)loadedId, (Object)expectedStableId);
                            req.setId(expectedStableId);
                        }
                    }
                    quest.addRequirement(req);
                    continue;
                }
                catch (Exception e) {
                    Questory.LOGGER.error("Failed to load requirement for quest {}: {}", (Object)id, (Object)e.getMessage());
                }
            }
        }
        if (json.has("rewards")) {
            JsonArray rewardsArray = json.getAsJsonArray("rewards");
            for (int i = 0; i < rewardsArray.size(); ++i) {
                try {
                    JsonObject rewardJson = rewardsArray.get(i).getAsJsonObject();
                    Reward reward = Reward.fromJson(rewardJson);
                    if (!rewardJson.has("id")) {
                        String stableId = id + "_reward_" + i;
                        reward.setId(stableId);
                        if (QuestoryConfig.getInstance().debugMode) {
                            Questory.LOGGER.debug("[Questory Debug] Assigned stable ID to reward: {} (type: {})", (Object)stableId, (Object)reward.getType());
                        }
                    }
                    quest.addReward(reward);
                    continue;
                }
                catch (Exception e) {
                    Questory.LOGGER.error("Failed to load reward for quest {}: {}", (Object)id, (Object)e.getMessage());
                }
            }
        }
        return quest;
    }
}

