/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.integration.OPACPlaceholders;
import org.texboobcat.questory.quest.Reward;

public class ScriptReward
extends Reward {
    private String script;
    private String displayName;

    public ScriptReward(String script, String displayName) {
        super("script");
        this.script = script != null ? script : "";
        this.displayName = displayName;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script != null ? script : "";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void grant(class_3222 player) {
        if (this.script == null || this.script.trim().isEmpty()) {
            return;
        }
        String processedScript = this.script.replace("{player}", player.method_7334().getName()).replace("{uuid}", player.method_5845()).replace("{x}", String.valueOf((int)player.method_23317())).replace("{y}", String.valueOf((int)player.method_23318())).replace("{z}", String.valueOf((int)player.method_23321()));
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (cfg.opacIntegrationEnabled && cfg.opacEnablePlaceholders) {
                processedScript = OPACPlaceholders.process(processedScript, player);
            }
        }
        catch (Throwable cfg) {
            // empty catch block
        }
        try {
            class_2168 source = new class_2168((class_2165)player, player.method_19538(), player.method_5802(), player.method_51469(), 4, player.method_5477().getString(), player.method_5476(), player.field_13995, (class_1297)player);
            String kubeCommand = "kubejs run_server " + this.escapeForCommand(processedScript);
            try {
                player.field_13995.method_3734().method_44252(source, kubeCommand);
            }
            catch (Exception e) {
                String[] lines;
                for (String line : lines = processedScript.split("\n")) {
                    String trimmed = line.trim();
                    if (trimmed.isEmpty() || trimmed.startsWith("//")) continue;
                    try {
                        player.field_13995.method_3734().method_44252(source, trimmed);
                    }
                    catch (Exception ex) {
                        System.err.println("[Questory] Failed to execute script line: " + trimmed);
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to execute script reward");
            e.printStackTrace();
        }
    }

    private String escapeForCommand(String script) {
        return script.replace("\"", "\\\"").replace("'", "\\'");
    }

    @Override
    public String getDisplayString() {
        if (this.displayName != null && !this.displayName.trim().isEmpty()) {
            return this.displayName;
        }
        return "Execute KubeJS Script";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("script", this.script);
        if (this.displayName != null && !this.displayName.trim().isEmpty()) {
            json.addProperty("displayName", this.displayName);
        }
        return json;
    }

    public static ScriptReward fromJson(JsonObject json) {
        String script = json.has("script") ? json.get("script").getAsString() : "";
        String displayName = json.has("displayName") ? json.get("displayName").getAsString() : null;
        return new ScriptReward(script, displayName);
    }
}

