/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class WeatherRequirement
extends Requirement {
    private Mode mode;

    public WeatherRequirement(Mode mode) {
        super("weather");
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) > 0;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        boolean ok = progress.getRequirementProgress(questId, this) > 0;
        return (ok ? "\u2713" : "\u2717") + " Weather: " + this.mode.name().toLowerCase();
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("mode", this.mode.name().toLowerCase());
        return json;
    }

    public static WeatherRequirement fromJson(JsonObject json) {
        Mode mode;
        String m = json.has("mode") ? json.get("mode").getAsString().toUpperCase() : "CLEAR";
        try {
            mode = Mode.valueOf(m);
        }
        catch (Exception e) {
            mode = Mode.CLEAR;
        }
        return new WeatherRequirement(mode);
    }

    public static enum Mode {
        CLEAR,
        RAIN,
        THUNDER;

    }
}

