/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;

public class PlayerProgressStorage {
    private final IPlayerProgressBackend backend;
    private final Map<UUID, QuestProgress> progressCache;

    public PlayerProgressStorage(IPlayerProgressBackend backend) {
        this.backend = backend;
        this.progressCache = new HashMap<UUID, QuestProgress>();
    }

    public QuestProgress getProgress(UUID playerId) {
        if (this.progressCache.containsKey(playerId)) {
            return this.progressCache.get(playerId);
        }
        QuestProgress progress = this.backend.loadProgress(playerId);
        if (progress == null) {
            progress = new QuestProgress(playerId);
        }
        this.progressCache.put(playerId, progress);
        return progress;
    }

    public boolean saveProgress(UUID playerId) {
        QuestProgress progress = this.progressCache.get(playerId);
        if (progress == null) {
            return false;
        }
        return this.backend.saveProgress(progress);
    }

    public boolean saveProgress(QuestProgress progress) {
        return this.backend.saveProgress(progress);
    }

    public void saveAll() {
        for (QuestProgress progress : this.progressCache.values()) {
            this.backend.saveProgress(progress);
        }
    }

    public void unloadPlayer(UUID playerId) {
        QuestProgress progress = this.progressCache.remove(playerId);
        if (progress != null) {
            this.backend.saveProgress(progress);
        }
    }

    public void loadAll() {
        try {
            List<UUID> playerIds = this.backend.getAllPlayerIds();
            for (UUID playerId : playerIds) {
                QuestProgress progress = this.backend.loadProgress(playerId);
                if (progress == null) continue;
                this.progressCache.put(playerId, progress);
            }
            System.out.println("[Questory] Loaded progress for " + this.progressCache.size() + " players from " + this.backend.getBackendType());
        }
        catch (Exception e) {
            System.err.println("[Questory] Error loading player progress: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void clearCache() {
        this.saveAll();
        this.progressCache.clear();
    }

    public String getBackendType() {
        return this.backend.getBackendType();
    }

    public boolean healthCheck() {
        return this.backend.healthCheck();
    }

    public void disconnect() {
        this.saveAll();
        this.backend.disconnect();
    }
}

