/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.storage.migration;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BackupManager {
    private final Path backupDir;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    public BackupManager(Path dataPath) {
        this.backupDir = dataPath.resolve("questory_backups");
    }

    public Path createBackup(String storageName) {
        try {
            Files.createDirectories(this.backupDir, new FileAttribute[0]);
            String timestamp = DATE_FORMAT.format(new Date());
            String backupName = String.format("questory_%s_backup_%s.zip", storageName, timestamp);
            Path backupFile = this.backupDir.resolve(backupName);
            System.out.println("[Questory] Creating backup: " + backupName);
            Path dataPath = this.backupDir.getParent();
            try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(backupFile, new OpenOption[0]));){
                Path sqliteShm;
                Path sqliteWal;
                Path sqliteDb;
                Path teamsPath;
                Path progressPath = dataPath.resolve("questory_progress");
                if (Files.exists(progressPath, new LinkOption[0])) {
                    this.backupDirectory(progressPath, "questory_progress", zos);
                }
                if (Files.exists(teamsPath = dataPath.resolve("teams"), new LinkOption[0])) {
                    this.backupDirectory(teamsPath, "teams", zos);
                }
                if (Files.exists(sqliteDb = dataPath.resolve("questory.db"), new LinkOption[0])) {
                    this.addFileToZip(sqliteDb, "questory.db", zos);
                }
                if (Files.exists(sqliteWal = dataPath.resolve("questory.db-wal"), new LinkOption[0])) {
                    this.addFileToZip(sqliteWal, "questory.db-wal", zos);
                }
                if (Files.exists(sqliteShm = dataPath.resolve("questory.db-shm"), new LinkOption[0])) {
                    this.addFileToZip(sqliteShm, "questory.db-shm", zos);
                }
            }
            System.out.println("[Questory] Backup created successfully: " + String.valueOf(backupFile));
            return backupFile;
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to create backup: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void backupDirectory(Path directory, String baseName, ZipOutputStream zos) throws IOException {
        Files.walk(directory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
            try {
                String relativePath = directory.getParent().relativize((Path)file).toString();
                this.addFileToZip((Path)file, relativePath, zos);
            }
            catch (IOException e) {
                System.err.println("[Questory] Failed to backup file " + String.valueOf(file) + ": " + e.getMessage());
            }
        });
    }

    private void addFileToZip(Path file, String entryName, ZipOutputStream zos) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName.replace("\\", "/"));
        zos.putNextEntry(zipEntry);
        Files.copy(file, zos);
        zos.closeEntry();
    }

    public void cleanupOldBackups(int keepCount) {
        try {
            if (!Files.exists(this.backupDir, new LinkOption[0])) {
                return;
            }
            Files.list(this.backupDir).filter(path -> path.toString().endsWith(".zip")).sorted((a, b) -> {
                try {
                    return Files.getLastModifiedTime(b, new LinkOption[0]).compareTo(Files.getLastModifiedTime(a, new LinkOption[0]));
                }
                catch (IOException e) {
                    return 0;
                }
            }).skip(keepCount).forEach(path -> {
                try {
                    Files.delete(path);
                    System.out.println("[Questory] Deleted old backup: " + String.valueOf(path.getFileName()));
                }
                catch (IOException e) {
                    System.err.println("[Questory] Failed to delete old backup: " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to cleanup old backups: " + e.getMessage());
        }
    }

    public Path getBackupDirectory() {
        return this.backupDir;
    }
}

