/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.team;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.texboobcat.questory.team.ITeamProvider;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamManager;

public class BuiltInTeamProvider
implements ITeamProvider {
    private final TeamManager teamManager;

    public BuiltInTeamProvider(TeamManager teamManager) {
        this.teamManager = teamManager;
    }

    @Override
    public UUID getTeamId(UUID playerId) {
        QuestTeam team = this.teamManager.getPlayerTeam(playerId);
        return team != null ? team.getTeamId() : null;
    }

    @Override
    public Set<UUID> getTeamMembers(UUID teamId) {
        QuestTeam team = this.teamManager.getTeam(teamId);
        return team != null ? team.getMembers() : Collections.emptySet();
    }

    @Override
    public String getTeamName(UUID teamId) {
        QuestTeam team = this.teamManager.getTeam(teamId);
        return team != null ? team.getTeamName() : null;
    }

    @Override
    public boolean isTeamOwner(UUID playerId, UUID teamId) {
        QuestTeam team = this.teamManager.getTeam(teamId);
        return team != null && team.isOwner(playerId);
    }

    @Override
    public int getPriority() {
        return -1000;
    }

    @Override
    public String getProviderId() {
        return "questory:builtin";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

