/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.telemetry;

import java.util.HashMap;
import java.util.Map;

public class HeatmapData {
    private final Map<String, QuestHeatData> questData = new HashMap<String, QuestHeatData>();
    private long fetchedAt = System.currentTimeMillis();

    public void addQuestData(String questId, int completionCount, int uniquePlayers, double avgCompletionTime) {
        this.questData.put(questId, new QuestHeatData(completionCount, uniquePlayers, avgCompletionTime));
    }

    public QuestHeatData getQuestData(String questId) {
        return this.questData.get(questId);
    }

    public boolean hasQuestData(String questId) {
        return this.questData.containsKey(questId);
    }

    public int getQuestCount() {
        return this.questData.size();
    }

    public long getFetchedAt() {
        return this.fetchedAt;
    }

    public boolean isStale(int ttlSeconds) {
        long ageSeconds = (System.currentTimeMillis() - this.fetchedAt) / 1000L;
        return ageSeconds > (long)ttlSeconds;
    }

    public double getIntensity(String questId) {
        QuestHeatData data = this.questData.get(questId);
        return data != null ? data.getHeatIntensity() : 0.0;
    }

    public int getCompletionCount(String questId) {
        QuestHeatData data = this.questData.get(questId);
        return data != null ? data.getCompletionCount() : 0;
    }

    public int getUniquePlayers(String questId) {
        QuestHeatData data = this.questData.get(questId);
        return data != null ? data.getUniquePlayers() : 0;
    }

    public double getAvgCompletionTime(String questId) {
        QuestHeatData data = this.questData.get(questId);
        return data != null ? data.getAvgCompletionTime() : 0.0;
    }

    public static class QuestHeatData {
        private final int completionCount;
        private final int uniquePlayers;
        private final double avgCompletionTime;

        public QuestHeatData(int completionCount, int uniquePlayers, double avgCompletionTime) {
            this.completionCount = completionCount;
            this.uniquePlayers = uniquePlayers;
            this.avgCompletionTime = avgCompletionTime;
        }

        public int getCompletionCount() {
            return this.completionCount;
        }

        public int getUniquePlayers() {
            return this.uniquePlayers;
        }

        public double getAvgCompletionTime() {
            return this.avgCompletionTime;
        }

        public double getHeatIntensity() {
            if (this.completionCount <= 1) {
                return 0.0;
            }
            if (this.completionCount >= 1000) {
                return 1.0;
            }
            double logValue = Math.log10(this.completionCount);
            return Math.min(1.0, logValue / 3.0);
        }
    }
}

