/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.questory.theme.panel.PanelNode;

public class GridNode
extends PanelNode {
    private Integer columns = 2;
    private Integer rows;
    private Integer gap = 4;
    private List<PanelNode> children = new ArrayList<PanelNode>();

    @Override
    public String getType() {
        return "grid";
    }

    @Override
    protected void parseSpecificProperties(JsonObject json) {
        if (json.has("columns")) {
            this.columns = json.get("columns").getAsInt();
        }
        if (json.has("rows")) {
            this.rows = json.get("rows").getAsInt();
        }
        if (json.has("gap")) {
            this.gap = json.get("gap").getAsInt();
        }
        if (json.has("children")) {
            JsonArray childrenArray = json.getAsJsonArray("children");
            for (JsonElement element : childrenArray) {
                PanelNode child;
                if (!element.isJsonObject() || (child = PanelNode.fromJson(element.getAsJsonObject())) == null) continue;
                this.children.add(child);
            }
        }
    }

    @Override
    protected void addSpecificProperties(JsonObject json) {
        if (this.columns != null) {
            json.addProperty("columns", (Number)this.columns);
        }
        if (this.rows != null) {
            json.addProperty("rows", (Number)this.rows);
        }
        if (this.gap != null) {
            json.addProperty("gap", (Number)this.gap);
        }
        if (!this.children.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (PanelNode child : this.children) {
                arr.add((JsonElement)child.toJson());
            }
            json.add("children", (JsonElement)arr);
        }
    }

    @Override
    public PanelNode deepCopy() {
        GridNode copy = new GridNode();
        this.copyCommonProperties(copy);
        copy.columns = this.columns;
        copy.rows = this.rows;
        copy.gap = this.gap;
        for (PanelNode child : this.children) {
            copy.children.add(child.deepCopy());
        }
        return copy;
    }

    public Integer getColumns() {
        return this.columns;
    }

    public void setColumns(Integer columns) {
        this.columns = columns;
    }

    public Integer getRows() {
        return this.rows;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public Integer getGap() {
        return this.gap;
    }

    public void setGap(Integer gap) {
        this.gap = gap;
    }

    public List<PanelNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<PanelNode> children) {
        this.children = children;
    }
}

