/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.selector;

import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.theme.selector.AllSelector;
import org.texboobcat.questory.theme.selector.ChapterSelector;
import org.texboobcat.questory.theme.selector.GroupSelector;
import org.texboobcat.questory.theme.selector.IDSelector;
import org.texboobcat.questory.theme.selector.ThemeSelector;
import org.texboobcat.questory.theme.selector.TypeSelector;

public class DirectParentSelector
implements ThemeSelector {
    private final ThemeSelector parent;
    private final ThemeSelector child;

    public DirectParentSelector(ThemeSelector parent, ThemeSelector child) {
        this.parent = parent;
        this.child = child;
    }

    @Override
    public boolean matches(Quest quest) {
        if (quest == null || !this.child.matches(quest)) {
            return false;
        }
        String chapterId = quest.getChapterId();
        if (chapterId == null || chapterId.isEmpty()) {
            return false;
        }
        ThemeSelector themeSelector = this.parent;
        if (themeSelector instanceof ChapterSelector) {
            ChapterSelector cs = (ChapterSelector)themeSelector;
            return cs.matchesChapterId(chapterId);
        }
        themeSelector = this.parent;
        if (themeSelector instanceof IDSelector) {
            IDSelector ids = (IDSelector)themeSelector;
            return ids.matchesId(chapterId);
        }
        if (this.parent instanceof AllSelector) {
            return true;
        }
        themeSelector = this.parent;
        if (themeSelector instanceof TypeSelector) {
            TypeSelector ts = (TypeSelector)themeSelector;
            return true;
        }
        themeSelector = this.parent;
        if (themeSelector instanceof GroupSelector) {
            GroupSelector gs = (GroupSelector)themeSelector;
            return gs.matchesGroup(quest.getGroup());
        }
        return false;
    }

    @Override
    public int getPriority() {
        return Math.max(this.parent.getPriority(), this.child.getPriority()) + 20;
    }

    public String toString() {
        return String.valueOf(this.parent) + ">" + String.valueOf(this.child);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectParentSelector) {
            DirectParentSelector other = (DirectParentSelector)obj;
            return this.parent.equals(other.parent) && this.child.equals(other.child);
        }
        return false;
    }

    public int hashCode() {
        return this.parent.hashCode() * 31 + this.child.hashCode();
    }
}

