/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.selector;

import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.theme.selector.ThemeSelector;

public class TypeSelector
implements ThemeSelector {
    private final Kind kind;
    private final String rawType;

    public TypeSelector(String type) {
        this.rawType = type;
        this.kind = TypeSelector.parse(type);
    }

    private static Kind parse(String type) {
        String t;
        return switch (t = type == null ? "" : type.trim().toLowerCase()) {
            case "chapter", "chapters" -> Kind.CHAPTER;
            case "task", "tasks" -> Kind.TASK;
            case "reward", "rewards" -> Kind.REWARD;
            case "file" -> Kind.FILE;
            case "chapter_group" -> Kind.CHAPTER_GROUP;
            case "reward_table" -> Kind.REWARD_TABLE;
            case "loot_crate" -> Kind.LOOT_CRATE;
            default -> Kind.QUEST;
        };
    }

    @Override
    public boolean matches(Quest quest) {
        if (quest == null) {
            return false;
        }
        return switch (this.kind.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> true;
            case 1 -> {
                if (quest.getChapterId() != null && !quest.getChapterId().isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (!quest.getRequirements().isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (!quest.getRewards().isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 4, 5 -> true;
            case 6 -> {
                if (!quest.getRewards().isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 7 -> quest.getRewards().stream().anyMatch(r -> "loot".equals(r.getType()) || "random".equals(r.getType()));
        };
    }

    @Override
    public int getPriority() {
        return 50;
    }

    public String toString() {
        return "type:" + this.kind.name().toLowerCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TypeSelector)) return false;
        TypeSelector other = (TypeSelector)obj;
        if (other.kind != this.kind) return false;
        return true;
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public static enum Kind {
        QUEST,
        CHAPTER,
        TASK,
        REWARD,
        FILE,
        CHAPTER_GROUP,
        REWARD_TABLE,
        LOOT_CRATE;

    }
}

