/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import org.hjson.JsonValue;

public class ClientConfig {
    private static final Gson GSON = new Gson();
    private static final String FILE_NAME = "questory_client.hjson";
    private static Set<String> pinnedGroups = new HashSet<String>();
    private static Set<String> trackedQuests = new HashSet<String>();
    private static boolean chapterPanelPinned = false;
    private static Set<String> collapsedSections = new HashSet<String>();
    private static boolean loaded = false;
    private static boolean clientEnableAdvancedEditor = true;
    private static boolean suppressUiScaleEditorWarning = false;
    private static int miniMapX = -1;
    private static int miniMapY = -1;
    private static int miniMapW = 0;
    private static int miniMapH = 0;
    private static int miniMapOpacityPct = 75;
    private static int heatX = -1;
    private static int heatY = -1;
    private static int heatW = 180;
    private static int heatH = 74;
    private static int heatOpacityPct = 90;
    private static int heatmapCacheTtl = 300;
    private static boolean mapIntegrationEnabled = true;
    private static boolean journeyMapEnabled = true;
    private static String hudPosition = "TOP_LEFT";
    private static float hudScale = 1.0f;
    private static int hudOpacity = 80;
    private static boolean hudCompactMode = false;
    private static boolean hudShowIcons = true;
    private static boolean hudShowProgressBars = true;
    private static int hudOffsetX = 10;
    private static int hudOffsetY = 10;
    private static boolean telemetryEnabled = false;
    private static String telemetryPlayerUuid = null;
    private static boolean telemetryConsentShown = false;
    private static String modpackIdOverride = null;
    private static String modpackVersionOverride = null;
    private static String supabaseUrl = "";
    private static String supabaseAnonKey = "";

    private static File getConfigFile() {
        File dir = new File(Minecraft.m_91087_().f_91069_, "config");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, FILE_NAME);
    }

    public static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            File configFile;
            File hjsonFile = ClientConfig.getConfigFile();
            File jsonFile = new File(hjsonFile.getParentFile(), "questory_client.json");
            File file = hjsonFile.exists() ? hjsonFile : (configFile = jsonFile.exists() ? jsonFile : hjsonFile);
            if (!configFile.exists()) {
                return;
            }
            String s = Files.readString(configFile.toPath());
            String jsonString = JsonValue.readHjson(s).toString();
            JsonObject o = (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
            pinnedGroups.clear();
            if (o.has("pinnedGroups") && o.get("pinnedGroups").isJsonArray()) {
                o.getAsJsonArray("pinnedGroups").forEach(e -> pinnedGroups.add(e.getAsString()));
            }
            if (o.has("chapterPanelPinned")) {
                chapterPanelPinned = o.get("chapterPanelPinned").getAsBoolean();
            }
            if (o.has("collapsedSections") && o.get("collapsedSections").isJsonArray()) {
                o.getAsJsonArray("collapsedSections").forEach(e -> collapsedSections.add(e.getAsString()));
            }
            if (o.has("trackedQuests") && o.get("trackedQuests").isJsonArray()) {
                o.getAsJsonArray("trackedQuests").forEach(e -> trackedQuests.add(e.getAsString()));
            }
            if (o.has("miniMapX")) {
                miniMapX = o.get("miniMapX").getAsInt();
            }
            if (o.has("miniMapY")) {
                miniMapY = o.get("miniMapY").getAsInt();
            }
            if (o.has("miniMapW")) {
                miniMapW = o.get("miniMapW").getAsInt();
            }
            if (o.has("miniMapH")) {
                miniMapH = o.get("miniMapH").getAsInt();
            }
            if (o.has("miniMapOpacityPct")) {
                miniMapOpacityPct = o.get("miniMapOpacityPct").getAsInt();
            }
            if (o.has("heatX")) {
                heatX = o.get("heatX").getAsInt();
            }
            if (o.has("heatY")) {
                heatY = o.get("heatY").getAsInt();
            }
            if (o.has("heatW")) {
                heatW = o.get("heatW").getAsInt();
            }
            if (o.has("heatH")) {
                heatH = o.get("heatH").getAsInt();
            }
            if (o.has("heatOpacityPct")) {
                heatOpacityPct = o.get("heatOpacityPct").getAsInt();
            }
            if (o.has("mapIntegrationEnabled")) {
                mapIntegrationEnabled = o.get("mapIntegrationEnabled").getAsBoolean();
            }
            if (o.has("journeyMapEnabled")) {
                journeyMapEnabled = o.get("journeyMapEnabled").getAsBoolean();
            }
            if (o.has("clientEnableAdvancedEditor")) {
                clientEnableAdvancedEditor = o.get("clientEnableAdvancedEditor").getAsBoolean();
            }
            if (o.has("hudPosition")) {
                hudPosition = o.get("hudPosition").getAsString();
            }
            if (o.has("hudScale")) {
                hudScale = o.get("hudScale").getAsFloat();
            }
            if (o.has("hudOpacity")) {
                hudOpacity = o.get("hudOpacity").getAsInt();
            }
            if (o.has("hudCompactMode")) {
                hudCompactMode = o.get("hudCompactMode").getAsBoolean();
            }
            if (o.has("hudShowIcons")) {
                hudShowIcons = o.get("hudShowIcons").getAsBoolean();
            }
            if (o.has("hudShowProgressBars")) {
                hudShowProgressBars = o.get("hudShowProgressBars").getAsBoolean();
            }
            if (o.has("hudOffsetX")) {
                hudOffsetX = o.get("hudOffsetX").getAsInt();
            }
            if (o.has("hudOffsetY")) {
                hudOffsetY = o.get("hudOffsetY").getAsInt();
            }
            if (o.has("suppressUiScaleEditorWarning")) {
                suppressUiScaleEditorWarning = o.get("suppressUiScaleEditorWarning").getAsBoolean();
            }
            if (o.has("telemetryEnabled")) {
                telemetryEnabled = o.get("telemetryEnabled").getAsBoolean();
            }
            if (o.has("telemetryPlayerUuid")) {
                telemetryPlayerUuid = o.get("telemetryPlayerUuid").getAsString();
            }
            if (o.has("telemetryConsentShown")) {
                telemetryConsentShown = o.get("telemetryConsentShown").getAsBoolean();
            }
            if (o.has("modpackIdOverride")) {
                modpackIdOverride = o.get("modpackIdOverride").getAsString();
            }
            if (o.has("modpackVersionOverride")) {
                modpackVersionOverride = o.get("modpackVersionOverride").getAsString();
            }
            if (o.has("supabaseUrl")) {
                supabaseUrl = o.get("supabaseUrl").getAsString();
            }
            if (o.has("supabaseAnonKey")) {
                supabaseAnonKey = o.get("supabaseAnonKey").getAsString();
            }
            if (o.has("heatmapCacheTtl")) {
                heatmapCacheTtl = o.get("heatmapCacheTtl").getAsInt();
            }
            if (configFile.equals(jsonFile)) {
                System.out.println("[Questory] Migrating client config from JSON to HJSON format");
                ClientConfig.save();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void save() {
        try {
            JsonObject json = new JsonObject();
            JsonArray pinnedArr = new JsonArray();
            for (String string : pinnedGroups) {
                pinnedArr.add(string);
            }
            json.add("pinnedGroups", (JsonElement)pinnedArr);
            json.addProperty("chapterPanelPinned", Boolean.valueOf(chapterPanelPinned));
            JsonArray collapsedArr = new JsonArray();
            for (String string : collapsedSections) {
                collapsedArr.add(string);
            }
            json.add("collapsedSections", (JsonElement)collapsedArr);
            JsonArray jsonArray = new JsonArray();
            for (String q : trackedQuests) {
                jsonArray.add(q);
            }
            json.add("trackedQuests", (JsonElement)jsonArray);
            json.addProperty("clientEnableAdvancedEditor", Boolean.valueOf(clientEnableAdvancedEditor));
            json.addProperty("suppressUiScaleEditorWarning", Boolean.valueOf(suppressUiScaleEditorWarning));
            json.addProperty("miniMapX", (Number)miniMapX);
            json.addProperty("miniMapY", (Number)miniMapY);
            json.addProperty("miniMapW", (Number)miniMapW);
            json.addProperty("miniMapH", (Number)miniMapH);
            json.addProperty("miniMapOpacityPct", (Number)miniMapOpacityPct);
            json.addProperty("heatX", (Number)heatX);
            json.addProperty("heatY", (Number)heatY);
            json.addProperty("heatW", (Number)heatW);
            json.addProperty("heatH", (Number)heatH);
            json.addProperty("heatOpacityPct", (Number)heatOpacityPct);
            json.addProperty("heatmapCacheTtl", (Number)heatmapCacheTtl);
            json.addProperty("mapIntegrationEnabled", Boolean.valueOf(mapIntegrationEnabled));
            json.addProperty("journeyMapEnabled", Boolean.valueOf(journeyMapEnabled));
            json.addProperty("hudPosition", hudPosition);
            json.addProperty("hudScale", (Number)Float.valueOf(hudScale));
            json.addProperty("hudOpacity", (Number)hudOpacity);
            json.addProperty("hudCompactMode", Boolean.valueOf(hudCompactMode));
            json.addProperty("hudShowIcons", Boolean.valueOf(hudShowIcons));
            json.addProperty("hudShowProgressBars", Boolean.valueOf(hudShowProgressBars));
            json.addProperty("hudOffsetX", (Number)hudOffsetX);
            json.addProperty("hudOffsetY", (Number)hudOffsetY);
            json.addProperty("telemetryEnabled", Boolean.valueOf(telemetryEnabled));
            if (telemetryPlayerUuid != null) {
                json.addProperty("telemetryPlayerUuid", telemetryPlayerUuid);
            }
            json.addProperty("telemetryConsentShown", Boolean.valueOf(telemetryConsentShown));
            if (modpackIdOverride != null) {
                json.addProperty("modpackIdOverride", modpackIdOverride);
            }
            if (modpackVersionOverride != null) {
                json.addProperty("modpackVersionOverride", modpackVersionOverride);
            }
            if (supabaseUrl != null && !supabaseUrl.isEmpty()) {
                json.addProperty("supabaseUrl", supabaseUrl);
            }
            if (supabaseAnonKey != null && !supabaseAnonKey.isEmpty()) {
                json.addProperty("supabaseAnonKey", supabaseAnonKey);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("//\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            stringBuilder.append("// Questory Client Configuration\n");
            stringBuilder.append("//\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n");
            stringBuilder.append("// Client-specific settings for UI, HUD, and telemetry\n");
            stringBuilder.append("// This file is automatically managed - edit with care\n");
            stringBuilder.append("//\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\n\n");
            stringBuilder.append("{\n");
            stringBuilder.append("  // \u2550\u2550\u2550\u2550\u2550\u2550 UI STATE \u2550\u2550\u2550\u2550\u2550\u2550\n");
            ClientConfig.appendClientField(stringBuilder, json, "pinnedGroups", "Pinned quest groups");
            ClientConfig.appendClientField(stringBuilder, json, "collapsedSections", "Collapsed UI sections");
            ClientConfig.appendClientField(stringBuilder, json, "trackedQuests", "Tracked quests in HUD");
            ClientConfig.appendClientField(stringBuilder, json, "chapterPanelPinned", "Chapter panel pinned open");
            stringBuilder.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550 EDITOR \u2550\u2550\u2550\u2550\u2550\u2550\n");
            ClientConfig.appendClientField(stringBuilder, json, "clientEnableAdvancedEditor", "Enable advanced editor (client-side)");
            ClientConfig.appendClientField(stringBuilder, json, "suppressUiScaleEditorWarning", "Suppress UI scale warning");
            stringBuilder.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550 MINI-MAP \u2550\u2550\u2550\u2550\u2550\u2550\n");
            ClientConfig.appendClientField(stringBuilder, json, "miniMapX", "X position (-1 = default)");
            ClientConfig.appendClientField(stringBuilder, json, "miniMapY", "Y position");
            ClientConfig.appendClientField(stringBuilder, json, "miniMapW", "Width");
            ClientConfig.appendClientField(stringBuilder, json, "miniMapH", "Height");
            ClientConfig.appendClientField(stringBuilder, json, "miniMapOpacityPct", "Opacity % (0-100)");
            stringBuilder.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550 HEATMAP \u2550\u2550\u2550\u2550\u2550\u2550\n");
            ClientConfig.appendClientField(stringBuilder, json, "heatX", "Legend X position");
            ClientConfig.appendClientField(stringBuilder, json, "heatY", "Legend Y position");
            ClientConfig.appendClientField(stringBuilder, json, "heatW", "Legend width");
            ClientConfig.appendClientField(stringBuilder, json, "heatH", "Legend height");
            ClientConfig.appendClientField(stringBuilder, json, "heatOpacityPct", "Opacity % (0-100)");
            ClientConfig.appendClientField(stringBuilder, json, "heatmapCacheTtl", "Cache TTL in seconds");
            stringBuilder.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550 MAP INTEGRATION \u2550\u2550\u2550\u2550\u2550\u2550\n");
            ClientConfig.appendClientField(stringBuilder, json, "mapIntegrationEnabled", "Enable map mod integration");
            ClientConfig.appendClientField(stringBuilder, json, "journeyMapEnabled", "Enable JourneyMap integration");
            stringBuilder.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550 HUD CUSTOMIZATION \u2550\u2550\u2550\u2550\u2550\u2550\n");
            ClientConfig.appendClientField(stringBuilder, json, "hudPosition", "Position (TOP_LEFT|TOP_RIGHT|BOTTOM_LEFT|BOTTOM_RIGHT)");
            ClientConfig.appendClientField(stringBuilder, json, "hudScale", "Scale (0.5 - 2.0)");
            ClientConfig.appendClientField(stringBuilder, json, "hudOpacity", "Opacity % (0-100)");
            ClientConfig.appendClientField(stringBuilder, json, "hudCompactMode", "Compact mode");
            ClientConfig.appendClientField(stringBuilder, json, "hudShowIcons", "Show quest icons");
            ClientConfig.appendClientField(stringBuilder, json, "hudShowProgressBars", "Show progress bars");
            ClientConfig.appendClientField(stringBuilder, json, "hudOffsetX", "X offset from edge (pixels)");
            ClientConfig.appendClientField(stringBuilder, json, "hudOffsetY", "Y offset from edge (pixels)");
            stringBuilder.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550 TELEMETRY \u2550\u2550\u2550\u2550\u2550\u2550\n");
            stringBuilder.append("  // Anonymous usage data to help improve quests\n");
            ClientConfig.appendClientField(stringBuilder, json, "telemetryEnabled", "Enable telemetry");
            ClientConfig.appendClientField(stringBuilder, json, "telemetryConsentShown", "Consent dialog shown");
            if (json.has("telemetryPlayerUuid")) {
                ClientConfig.appendClientField(stringBuilder, json, "telemetryPlayerUuid", "Anonymous player ID");
            }
            if (json.has("modpackIdOverride")) {
                ClientConfig.appendClientField(stringBuilder, json, "modpackIdOverride", "Modpack ID override");
            }
            if (json.has("modpackVersionOverride")) {
                ClientConfig.appendClientField(stringBuilder, json, "modpackVersionOverride", "Modpack version override");
            }
            if (json.has("supabaseUrl") || json.has("supabaseAnonKey")) {
                stringBuilder.append("\n  // \u2550\u2550\u2550\u2550\u2550\u2550 ADVANCED \u2550\u2550\u2550\u2550\u2550\u2550\n");
                if (json.has("supabaseUrl")) {
                    ClientConfig.appendClientField(stringBuilder, json, "supabaseUrl", "Supabase backend URL");
                }
                if (json.has("supabaseAnonKey")) {
                    ClientConfig.appendClientFieldLast(stringBuilder, json, "supabaseAnonKey", "Supabase anon key");
                }
            } else {
                int lastComma = stringBuilder.lastIndexOf(",");
                if (lastComma > 0) {
                    stringBuilder.deleteCharAt(lastComma);
                }
            }
            stringBuilder.append("\n}\n");
            Files.writeString(ClientConfig.getConfigFile().toPath(), (CharSequence)stringBuilder.toString(), new OpenOption[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void appendClientField(StringBuilder sb, JsonObject json, String key, String desc) {
        if (json.has(key)) {
            sb.append("  \"").append(key).append("\": ");
            sb.append(json.get(key).toString());
            sb.append(",  // ").append(desc).append("\n");
        }
    }

    private static void appendClientFieldLast(StringBuilder sb, JsonObject json, String key, String desc) {
        if (json.has(key)) {
            sb.append("  \"").append(key).append("\": ");
            sb.append(json.get(key).toString());
            sb.append("  // ").append(desc).append("\n");
        }
    }

    public static Set<String> getPinnedGroups() {
        ClientConfig.load();
        return new HashSet<String>(pinnedGroups);
    }

    public static void togglePinned(String group) {
        ClientConfig.load();
        if (pinnedGroups.contains(group)) {
            pinnedGroups.remove(group);
        } else {
            pinnedGroups.add(group);
        }
        ClientConfig.save();
    }

    public static boolean isChapterPanelPinned() {
        ClientConfig.load();
        return chapterPanelPinned;
    }

    public static void toggleChapterPanelPinned() {
        ClientConfig.load();
        chapterPanelPinned = !chapterPanelPinned;
        ClientConfig.save();
    }

    public static Set<String> getCollapsedSections() {
        ClientConfig.load();
        return new HashSet<String>(collapsedSections);
    }

    public static void toggleSectionCollapsed(String sectionId) {
        ClientConfig.load();
        if (collapsedSections.contains(sectionId)) {
            collapsedSections.remove(sectionId);
        } else {
            collapsedSections.add(sectionId);
        }
        ClientConfig.save();
    }

    public static int getMiniMapX() {
        ClientConfig.load();
        return miniMapX;
    }

    public static int getMiniMapY() {
        ClientConfig.load();
        return miniMapY;
    }

    public static int getMiniMapW() {
        ClientConfig.load();
        return miniMapW;
    }

    public static int getMiniMapH() {
        ClientConfig.load();
        return miniMapH;
    }

    public static void setMiniMapRect(int x, int y, int w, int h) {
        ClientConfig.load();
        miniMapX = x;
        miniMapY = y;
        miniMapW = w;
        miniMapH = h;
        ClientConfig.save();
    }

    public static int getMiniMapOpacityPct() {
        ClientConfig.load();
        return miniMapOpacityPct;
    }

    public static void setMiniMapOpacityPct(int pct) {
        ClientConfig.load();
        miniMapOpacityPct = Math.max(0, Math.min(100, pct));
        ClientConfig.save();
    }

    public static int getHeatX() {
        ClientConfig.load();
        return heatX;
    }

    public static int getHeatY() {
        ClientConfig.load();
        return heatY;
    }

    public static int getHeatW() {
        ClientConfig.load();
        return heatW;
    }

    public static int getHeatH() {
        ClientConfig.load();
        return heatH;
    }

    public static void setHeatRect(int x, int y, int w, int h) {
        ClientConfig.load();
        heatX = x;
        heatY = y;
        heatW = w;
        heatH = h;
        ClientConfig.save();
    }

    public static int getHeatOpacityPct() {
        ClientConfig.load();
        return heatOpacityPct;
    }

    public static void setHeatOpacityPct(int pct) {
        ClientConfig.load();
        heatOpacityPct = Math.max(0, Math.min(100, pct));
        ClientConfig.save();
    }

    public static boolean isMapIntegrationEnabled() {
        ClientConfig.load();
        return mapIntegrationEnabled;
    }

    public static void setMapIntegrationEnabled(boolean enabled) {
        ClientConfig.load();
        mapIntegrationEnabled = enabled;
        ClientConfig.save();
    }

    public static boolean isJourneyMapEnabled() {
        ClientConfig.load();
        return journeyMapEnabled;
    }

    public static void setJourneyMapEnabled(boolean enabled) {
        ClientConfig.load();
        journeyMapEnabled = enabled;
        ClientConfig.save();
    }

    public static boolean isClientEnableAdvancedEditor() {
        ClientConfig.load();
        return clientEnableAdvancedEditor;
    }

    public static void setClientEnableAdvancedEditor(boolean enabled) {
        ClientConfig.load();
        clientEnableAdvancedEditor = enabled;
        ClientConfig.save();
    }

    public static Set<String> getTrackedQuests() {
        ClientConfig.load();
        return new HashSet<String>(trackedQuests);
    }

    public static boolean isQuestTracked(String questId) {
        ClientConfig.load();
        return trackedQuests.contains(questId);
    }

    public static void setQuestTracked(String questId, boolean tracked) {
        ClientConfig.load();
        if (tracked) {
            trackedQuests.add(questId);
        } else {
            trackedQuests.remove(questId);
        }
        ClientConfig.save();
    }

    public static String getHudPosition() {
        ClientConfig.load();
        return hudPosition;
    }

    public static void setHudPosition(String pos) {
        ClientConfig.load();
        hudPosition = pos;
        ClientConfig.save();
    }

    public static float getHudScale() {
        ClientConfig.load();
        return hudScale;
    }

    public static void setHudScale(float scale) {
        ClientConfig.load();
        hudScale = Math.max(0.5f, Math.min(2.0f, scale));
        ClientConfig.save();
    }

    public static int getHudOpacity() {
        ClientConfig.load();
        return hudOpacity;
    }

    public static void setHudOpacity(int opacity) {
        ClientConfig.load();
        hudOpacity = Math.max(0, Math.min(100, opacity));
        ClientConfig.save();
    }

    public static boolean isHudCompactMode() {
        ClientConfig.load();
        return hudCompactMode;
    }

    public static void setHudCompactMode(boolean compact) {
        ClientConfig.load();
        hudCompactMode = compact;
        ClientConfig.save();
    }

    public static boolean isHudShowIcons() {
        ClientConfig.load();
        return hudShowIcons;
    }

    public static void setHudShowIcons(boolean show) {
        ClientConfig.load();
        hudShowIcons = show;
        ClientConfig.save();
    }

    public static boolean isHudShowProgressBars() {
        ClientConfig.load();
        return hudShowProgressBars;
    }

    public static void setHudShowProgressBars(boolean show) {
        ClientConfig.load();
        hudShowProgressBars = show;
        ClientConfig.save();
    }

    public static int getHudOffsetX() {
        ClientConfig.load();
        return hudOffsetX;
    }

    public static void setHudOffsetX(int offset) {
        ClientConfig.load();
        hudOffsetX = offset;
        ClientConfig.save();
    }

    public static int getHudOffsetY() {
        ClientConfig.load();
        return hudOffsetY;
    }

    public static void setHudOffsetY(int offset) {
        ClientConfig.load();
        hudOffsetY = offset;
        ClientConfig.save();
    }

    public static boolean isSuppressUiScaleEditorWarning() {
        ClientConfig.load();
        return suppressUiScaleEditorWarning;
    }

    public static void setSuppressUiScaleEditorWarning(boolean suppress) {
        ClientConfig.load();
        suppressUiScaleEditorWarning = suppress;
        ClientConfig.save();
    }

    public static boolean isTelemetryEnabled() {
        ClientConfig.load();
        return telemetryEnabled;
    }

    public static void setTelemetryEnabled(boolean enabled) {
        ClientConfig.load();
        telemetryEnabled = enabled;
        ClientConfig.save();
    }

    public static String getTelemetryPlayerUuid() {
        ClientConfig.load();
        return telemetryPlayerUuid;
    }

    public static void setTelemetryPlayerUuid(String uuid) {
        ClientConfig.load();
        telemetryPlayerUuid = uuid;
        ClientConfig.save();
    }

    public static boolean isTelemetryConsentShown() {
        ClientConfig.load();
        return telemetryConsentShown;
    }

    public static void setTelemetryConsentShown(boolean shown) {
        ClientConfig.load();
        telemetryConsentShown = shown;
        ClientConfig.save();
    }

    public static String getModpackIdOverride() {
        ClientConfig.load();
        return modpackIdOverride;
    }

    public static void setModpackIdOverride(String id) {
        ClientConfig.load();
        modpackIdOverride = id;
        ClientConfig.save();
    }

    public static String getModpackVersionOverride() {
        ClientConfig.load();
        return modpackVersionOverride;
    }

    public static void setModpackVersionOverride(String version) {
        ClientConfig.load();
        modpackVersionOverride = version;
        ClientConfig.save();
    }

    public static String getSupabaseUrl() {
        ClientConfig.load();
        return supabaseUrl;
    }

    public static void setSupabaseUrl(String url) {
        ClientConfig.load();
        supabaseUrl = url;
        ClientConfig.save();
    }

    public static String getSupabaseAnonKey() {
        ClientConfig.load();
        return supabaseAnonKey;
    }

    public static void setSupabaseAnonKey(String key) {
        ClientConfig.load();
        supabaseAnonKey = key;
        ClientConfig.save();
    }

    public static int getHeatmapCacheTtl() {
        ClientConfig.load();
        return heatmapCacheTtl;
    }

    public static void setHeatmapCacheTtl(int ttl) {
        ClientConfig.load();
        heatmapCacheTtl = Math.max(60, ttl);
        ClientConfig.save();
    }
}

