/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.ClientRuntimeConfig;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.client.QuestoryKeybindings;
import org.texboobcat.questory.client.compat.map.MapCompatManager;
import org.texboobcat.questory.client.gui.AdvancedEditorMenuScreen;
import org.texboobcat.questory.client.gui.ConsentLoadingScreen;
import org.texboobcat.questory.client.gui.ConsentScreen;
import org.texboobcat.questory.client.gui.FormattedTextWithImages;
import org.texboobcat.questory.client.gui.ImageRenderer;
import org.texboobcat.questory.client.gui.QuestHudOverlay;
import org.texboobcat.questory.client.gui.QuestIconRenderer;
import org.texboobcat.questory.client.gui.QuestScreen;
import org.texboobcat.questory.client.gui.QuestShape;
import org.texboobcat.questory.client.gui.QuestoryConfigScreen;
import org.texboobcat.questory.client.gui.SidebarPanel;
import org.texboobcat.questory.client.gui.TeamCreationScreen;
import org.texboobcat.questory.client.gui.TeamManagementScreen;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.client.gui.ThemeEditorScreen;
import org.texboobcat.questory.client.rendering.AnimationHelper;
import org.texboobcat.questory.client.rendering.BackgroundRenderer;
import org.texboobcat.questory.client.rendering.CustomShapeRenderer;
import org.texboobcat.questory.client.rendering.ThemeIconRenderer;
import org.texboobcat.questory.client.rendering.heatmap.HeatmapRenderer;
import org.texboobcat.questory.modpack.ModpackDetector;
import org.texboobcat.questory.modpack.ModpackInfo;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestCompleteRequestPacket;
import org.texboobcat.questory.network.RequirementCompletePacket;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.ChapterImage;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.GroupNode;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.quest.TagAutoDetector;
import org.texboobcat.questory.shape.ShapeDef;
import org.texboobcat.questory.shape.ShapeRegistry;
import org.texboobcat.questory.team.TeamQuestSettings;
import org.texboobcat.questory.telemetry.HeatmapData;
import org.texboobcat.questory.telemetry.HeatmapDataCache;
import org.texboobcat.questory.telemetry.SupabaseClient;
import org.texboobcat.questory.telemetry.TelemetryManager;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class QuestGraphScreen
extends Screen {
    private static final int MAX_DETAILS_WIDTH = 260;
    private String selectedGroup = "all";
    private List<Quest> visibleQuests = new ArrayList<Quest>();
    private SidebarPanel sidebar;
    private static final int MAX_QUESTS_PER_VIEW = 500;
    private static final int MAX_SEGMENTS_PER_PASS = 1000;
    private Quest selectedQuest = null;
    private Button completeActionButton;
    private Button closeButton;
    private Button centerButton;
    private Button fitButton;
    private Button themeButton;
    private Button animToggleButton;
    private Button miniMapButton;
    private Button heatmapButton;
    private Button advancedButton;
    private Button hudConfigButton;
    private Button teamButton;
    private int zoom = 16;
    private static final int MIN_ZOOM = 1;
    private static final int MAX_ZOOM = 60;
    private double scrollX = 0.0;
    private double scrollY = 0.0;
    private double scrollWidth = 0.0;
    private double scrollHeight = 0.0;
    private boolean dragging = false;
    private int prevMouseX = 0;
    private int prevMouseY = 0;
    private double questMinX = 0.0;
    private double questMinY = 0.0;
    private double questMaxX = 0.0;
    private double questMaxY = 0.0;
    private Map<String, QuestRenderCache> renderCache = new HashMap<String, QuestRenderCache>();
    private int cachedVisibleLeft;
    private int cachedVisibleTop;
    private int cachedVisibleRight;
    private int cachedVisibleBottom;
    private boolean viewportBoundsCacheValid = false;
    private int detailsPanelScroll = 0;
    private int detailsPanelContentHeight = 0;
    private int[] lastDetailsTrackRect = null;
    private int[] lastDetailsHudPinRect = null;
    private int[] lastDetailsCloseButtonRect = null;
    private List<int[]> checkmarkButtonRects = new ArrayList<int[]>();
    private FormattedTextWithImages formattedDescriptionWithImages = null;
    private int descriptionStartY = 0;
    private int descriptionPanelX = 0;
    private BackgroundRenderer backgroundRenderer = BackgroundRenderer.darkGradient();
    private Integer backgroundTintColor;
    private boolean enableAnimations = true;
    private boolean showMiniMap = false;
    private String heatmapMode = "off";
    private HeatmapData currentHeatmapData = null;
    private int[] lastMiniMapRect = null;
    private boolean miniMapDragging = false;
    private boolean miniMapMoving = false;
    private boolean miniMapResizing = false;
    private int[] lastMiniMapHeaderRect = null;
    private int[] lastMiniMapResizeRect = null;
    private int miniMapMoveOffsetX = 0;
    private int miniMapMoveOffsetY = 0;
    private int[] lastMiniMapGearRect = null;
    private boolean miniMapSettingsOpen = false;
    private int[][] miniMapSizeOptionRects = null;
    private int[][] miniMapOpacityOptionRects = null;
    private long lastHeaderClickMs = 0L;
    private int[] lastHeatRect = null;
    private int[] lastHeatHeaderRect = null;
    private int[] lastHeatResizeRect = null;
    private boolean heatMoving = false;
    private boolean heatResizing = false;
    private int heatMoveOffsetX = 0;
    private int heatMoveOffsetY = 0;
    private static final Set<String> loggedImageGroups = new HashSet<String>();

    private int getDetailsPanelWidth() {
        return Math.min(260, Math.max(150, this.f_96543_ - 40));
    }

    public QuestGraphScreen() {
        super((Component)Component.m_237113_((String)"Quests"));
    }

    public void toggleTrackSelected() {
        if (this.selectedQuest == null) {
            return;
        }
        boolean isPinned = ClientConfig.isQuestTracked(this.selectedQuest.getId());
        if (isPinned) {
            QuestHudOverlay.untrackQuest(this.selectedQuest.getId());
        } else {
            QuestHudOverlay.trackQuest(this.selectedQuest.getId());
        }
        try {
            MapCompatManager.onClientDataChanged();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void doFitToScreen() {
        this.fitToScreen();
    }

    public void doCenterView() {
        this.resetScroll();
    }

    public void doZoomIn() {
        this.addZoom(5.0, (double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0);
    }

    public void doZoomOut() {
        this.addZoom(-5.0, (double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0);
    }

    private void layoutBottomButtons() {
        ArrayList<Button> buttons = new ArrayList<Button>();
        ArrayList<Integer> desired = new ArrayList<Integer>();
        ArrayList<Integer> minimum = new ArrayList<Integer>();
        this.addButtonForLayout(this.teamButton, buttons, desired, minimum, 55, 50);
        this.addButtonForLayout(this.miniMapButton, buttons, desired, minimum, 80, 60);
        this.addButtonForLayout(this.heatmapButton, buttons, desired, minimum, 90, 60);
        this.addButtonForLayout(this.advancedButton, buttons, desired, minimum, 90, 70);
        if (this.completeActionButton != null) {
            int desiredWidth = Math.max(90, this.f_96547_.m_92895_(this.completeActionButton.m_6035_().getString()) + 24);
            this.addButtonForLayout(this.completeActionButton, buttons, desired, minimum, desiredWidth, 70);
        }
        this.addButtonForLayout(this.closeButton, buttons, desired, minimum, 70, 60);
        int count = buttons.size();
        if (count == 0) {
            return;
        }
        int spacing = 6;
        int available = this.f_96543_ - 20;
        int totalWidth = spacing * (count - 1);
        int[] widths = new int[count];
        for (int i = 0; i < count; ++i) {
            widths[i] = (Integer)desired.get(i);
            totalWidth += widths[i];
        }
        if (totalWidth > available) {
            int minSpacingTotal;
            int totalSpacing;
            int spacingReducible;
            boolean reduced;
            int deficit = totalWidth - available;
            do {
                reduced = false;
                for (int i = 0; i < count && deficit > 0; ++i) {
                    int reducible = widths[i] - (Integer)minimum.get(i);
                    if (reducible <= 0) continue;
                    int amount = Math.min(reducible, Math.max(1, deficit / (count - i)));
                    int n = i;
                    widths[n] = widths[n] - amount;
                    deficit -= amount;
                    reduced = true;
                }
            } while (deficit > 0 && reduced);
            if (deficit > 0 && count > 1 && (spacingReducible = (totalSpacing = spacing * (count - 1)) - (minSpacingTotal = 2 * (count - 1))) > 0) {
                int spacingReduction = Math.min(deficit, spacingReducible);
                deficit -= spacingReduction;
                spacing = count > 1 ? Math.max(2, (totalSpacing -= spacingReduction) / (count - 1)) : 0;
            }
            totalWidth = spacing * (count - 1);
            for (int w : widths) {
                totalWidth += w;
            }
        }
        int startX = Math.max(10, (this.f_96543_ - totalWidth) / 2);
        int y = this.f_96544_ - 30;
        int x = startX;
        for (int i = 0; i < count; ++i) {
            Button btn = (Button)buttons.get(i);
            if (btn == null) continue;
            btn.m_93674_(widths[i]);
            btn.m_252865_(x);
            btn.m_253211_(y);
            x += widths[i] + spacing;
        }
    }

    private void addButtonForLayout(Button btn, List<Button> buttons, List<Integer> desired, List<Integer> minimum, int desiredWidth, int minWidth) {
        if (btn == null) {
            return;
        }
        int msgWidth = this.f_96547_.m_92895_(btn.m_6035_().getString()) + 20;
        desired.add(Math.max(desiredWidth, msgWidth));
        minimum.add(Math.max(40, minWidth));
        buttons.add(btn);
    }

    private void buildSidebarEntries() {
        if (this.sidebar == null) {
            return;
        }
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        GroupNode tree = cqm.getGroupTree();
        if (tree != null && !tree.getChildren().isEmpty()) {
            this.sidebar.setCountProvider(cqm::getQuestCountForGroup);
            this.sidebar.setGroupLabelProvider(key -> {
                Object pretty;
                try {
                    ChapterData cd = cqm.getChapterByTitle((String)key);
                    if (cd != null && cd.getTitle() != null && !cd.getTitle().isBlank()) {
                        String t = cd.getTitle();
                        String conv = TextFormatter.convertMinecraftCodesToTags(t);
                        String plain = TextFormatter.stripTags(conv);
                        return Component.m_237113_((String)plain);
                    }
                    List<ChapterData> all = cqm.getAllChapters();
                    for (ChapterData ch : all) {
                        String conv2;
                        String plain2;
                        String t;
                        if (key.equalsIgnoreCase(ch.getId()) && (t = ch.getTitle()) != null && !t.isBlank()) {
                            String conv = TextFormatter.convertMinecraftCodesToTags(t);
                            String plain = TextFormatter.stripTags(conv);
                            return Component.m_237113_((String)plain);
                        }
                        String t2 = ch.getTitle();
                        if (t2 == null || t2.isBlank() || !(plain2 = TextFormatter.stripTags(conv2 = TextFormatter.convertMinecraftCodesToTags(t2))).equalsIgnoreCase((String)key)) continue;
                        return Component.m_237113_((String)plain2);
                    }
                }
                catch (Throwable cd) {
                    // empty catch block
                }
                Object object = pretty = key == null ? "" : key.replace('_', ' ');
                if (!((String)pretty).isEmpty()) {
                    pretty = Character.toUpperCase(((String)pretty).charAt(0)) + ((String)pretty).substring(1);
                }
                return Component.m_237113_((String)pretty);
            });
            this.sidebar.setGroupColorProvider(key -> {
                try {
                    QuestProgress progress = cqm.getProgress();
                    if (progress == null) {
                        return null;
                    }
                    List<Quest> qs = cqm.getQuestsByGroup((String)key);
                    if (qs == null || qs.isEmpty()) {
                        return null;
                    }
                    boolean allCompleted = true;
                    boolean anyStarted = false;
                    for (Quest q : qs) {
                        if (!progress.isQuestCompleted(q.getId())) {
                            allCompleted = false;
                            for (Requirement req : q.getRequirements()) {
                                if (progress.getRequirementProgress(q.getId(), req) <= 0) continue;
                                anyStarted = true;
                                break;
                            }
                        }
                        if (allCompleted || !anyStarted) continue;
                        break;
                    }
                    if (allCompleted) {
                        return (Integer)ThemeProperties.QUEST_COMPLETED_COLOR.get();
                    }
                    if (anyStarted) {
                        return (Integer)ThemeProperties.QUEST_STARTED_COLOR.get();
                    }
                    return (Integer)ThemeProperties.QUEST_NOT_STARTED_COLOR.get();
                }
                catch (Throwable throwable) {
                    return null;
                }
            });
            this.sidebar.setRightBadgeProvider(key -> {
                try {
                    QuestProgress progress = cqm.getProgress();
                    if (progress == null) {
                        return 0;
                    }
                    List<Quest> qs = cqm.getQuestsByGroup((String)key);
                    if (qs == null || qs.isEmpty()) {
                        return 2;
                    }
                    boolean anyVisible = false;
                    boolean hasUnclaimed = false;
                    for (Quest q : qs) {
                        if (q == null) continue;
                        if (q.isVisible(progress)) {
                            anyVisible = true;
                        }
                        if (progress.isQuestCompleted(q.getId())) {
                            boolean allClaimed = true;
                            for (Reward r : q.getRewards()) {
                                if (progress.isRewardClaimed(q.getId(), r.getId())) continue;
                                allClaimed = false;
                                break;
                            }
                            if (!allClaimed) {
                                hasUnclaimed = true;
                            }
                        }
                        if (!hasUnclaimed || !anyVisible) continue;
                        break;
                    }
                    if (!anyVisible) {
                        return 2;
                    }
                    return hasUnclaimed ? 1 : 0;
                }
                catch (Throwable throwable) {
                    return 0;
                }
            });
            this.sidebar.setGroupIconProvider(key -> {
                try {
                    String icon;
                    ChapterData cd = cqm.getChapterByTitle((String)key);
                    if (cd == null) {
                        for (ChapterData ch : cqm.getAllChapters()) {
                            if (!key.equalsIgnoreCase(ch.getId())) continue;
                            cd = ch;
                            break;
                        }
                    }
                    if (cd != null && cd.getIcon() != null && !cd.getIcon().isBlank()) {
                        return cd.getIcon();
                    }
                    List<Quest> qs = cqm.getQuestsByGroup((String)key);
                    if (qs != null && !qs.isEmpty() && (icon = qs.get(0).getIcon()) != null && !icon.isBlank()) {
                        return icon;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            });
            this.sidebar.setShowCounts(false);
            this.sidebar.setGroupTree(tree);
            this.sidebar.setSelectedGroup(this.selectedGroup);
            return;
        }
        ArrayList<SidebarPanel.Entry> entries = new ArrayList<SidebarPanel.Entry>();
        int total = cqm.getVisibleQuests().size();
        this.sidebar.setShowCounts(false);
        if (total <= 500) {
            entries.add(new SidebarPanel.Entry("all", (Component)Component.m_237113_((String)"All"), total, false, 0, null, null));
        }
        QuestProgress progress = cqm.getProgress();
        for (String g : cqm.getQuestGroups()) {
            int count = cqm.getQuestsByGroup(g).size();
            MutableComponent label = Component.m_237113_((String)g);
            try {
                ChapterData cd = cqm.getChapterByTitle(g);
                if (cd == null) {
                    for (ChapterData throwable : cqm.getAllChapters()) {
                        if (!g.equalsIgnoreCase(throwable.getId())) continue;
                        cd = throwable;
                        break;
                    }
                }
                if (cd != null && cd.getTitle() != null && !cd.getTitle().isBlank()) {
                    label = Component.m_237113_((String)cd.getTitle());
                } else {
                    Object pretty = g.replace('_', ' ');
                    if (!((String)pretty).isEmpty()) {
                        pretty = Character.toUpperCase(((String)pretty).charAt(0)) + ((String)pretty).substring(1);
                    }
                    label = Component.m_237113_((String)pretty);
                }
            }
            catch (Throwable cd) {
                // empty catch block
            }
            String icon = null;
            try {
                List<Quest> list;
                ChapterData cd = cqm.getChapterByTitle(g);
                if (cd == null) {
                    for (ChapterData ch2 : cqm.getAllChapters()) {
                        if (!g.equalsIgnoreCase(ch2.getId())) continue;
                        cd = ch2;
                        break;
                    }
                }
                if (cd != null && cd.getIcon() != null && !cd.getIcon().isBlank()) {
                    icon = cd.getIcon();
                }
                if (icon == null && !(list = cqm.getQuestsByGroup(g)).isEmpty() && list.get(0).getIcon() != null && !list.get(0).getIcon().isBlank()) {
                    icon = list.get(0).getIcon();
                }
            }
            catch (Throwable cd) {
                // empty catch block
            }
            Integer color = null;
            try {
                if (progress != null) {
                    List<Quest> list = cqm.getQuestsByGroup(g);
                    boolean allCompleted = !list.isEmpty();
                    boolean anyStarted = false;
                    for (Quest q : list) {
                        if (!progress.isQuestCompleted(q.getId())) {
                            allCompleted = false;
                            for (Requirement req : q.getRequirements()) {
                                if (progress.getRequirementProgress(q.getId(), req) <= 0) continue;
                                anyStarted = true;
                                break;
                            }
                        }
                        if (allCompleted || !anyStarted) continue;
                        break;
                    }
                    color = allCompleted ? (Integer)ThemeProperties.QUEST_COMPLETED_COLOR.get() : (anyStarted ? (Integer)ThemeProperties.QUEST_STARTED_COLOR.get() : (Integer)ThemeProperties.QUEST_NOT_STARTED_COLOR.get());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            entries.add(new SidebarPanel.Entry(g, (Component)label, count, false, 0, color, icon));
        }
        this.sidebar.setEntries(entries);
        this.sidebar.setSelectedGroup(this.selectedGroup);
    }

    private void renderChapterImages(GuiGraphics g, int graphLeft, int graphTop, int graphW, int graphH) {
        if (this.selectedGroup == null || this.selectedGroup.isEmpty()) {
            return;
        }
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        List<ChapterImage> images = cqm.getChapterImages(this.selectedGroup);
        if (images.isEmpty()) {
            return;
        }
        if (!loggedImageGroups.contains(this.selectedGroup)) {
            System.out.println("[Questory Client] Rendering chapter images for '" + this.selectedGroup + "': " + images.size());
            if (!images.isEmpty()) {
                System.out.println("  First image url= " + images.get(0).getImageUrl());
            }
            loggedImageGroups.add(this.selectedGroup);
        }
        double bs = this.getQuestButtonSize();
        double bp = this.getQuestButtonSpacing();
        images.sort(Comparator.comparingInt(ChapterImage::getOrder));
        for (ChapterImage img : images) {
            int y;
            int x;
            int iw;
            int ih;
            boolean isBackgroundImage;
            if (img.getDependencyQuestId() != null && !img.getDependencyQuestId().isBlank() && !cqm.isQuestCompleted(img.getDependencyQuestId())) continue;
            double gridX = (double)img.getX() / 45.0;
            double gridY = (double)img.getY() / 45.0;
            double gridW = img.getWidth();
            double gridH = img.getHeight();
            boolean bl = isBackgroundImage = gridW >= 8.0 && gridH >= 4.0;
            if (isBackgroundImage) {
                double imgAspect = gridW / gridH;
                double viewAspect = (double)graphW / (double)graphH;
                if (imgAspect > viewAspect) {
                    ih = graphH;
                    iw = (int)Math.round((double)ih * imgAspect);
                } else {
                    iw = graphW;
                    ih = (int)Math.round((double)iw / imgAspect);
                }
                x = graphLeft + (graphW - iw) / 2;
                y = graphTop + (graphH - ih) / 2;
            } else {
                double screenX = (gridX - this.questMinX - gridW / 2.0) * (bs + bp) + bp / 2.0 - this.scrollX + (double)graphLeft;
                double screenY = (gridY - this.questMinY - gridH / 2.0) * (bs + bp) + bp / 2.0 - this.scrollY + (double)graphTop;
                iw = (int)Math.round(bs * gridW);
                ih = (int)Math.round(bs * gridH);
                x = img.isAlignToCorner() ? (int)Math.round(screenX) : (int)Math.round(screenX + (bs * gridW - (double)iw) / 2.0);
                int n = y = img.isAlignToCorner() ? (int)Math.round(screenY) : (int)Math.round(screenY + (bs * gridH - (double)ih) / 2.0);
            }
            if (img == images.get(0)) {
                System.out.println("  Image placement: x=" + x + ", y=" + y + ", w=" + iw + ", h=" + ih + " (bg=" + isBackgroundImage + ")");
            }
            if (x + iw < graphLeft || x > graphLeft + graphW || y + ih < graphTop || y > graphTop + graphH) continue;
            int argb = -1;
            try {
                if (img.getColor() != null && img.getColor().startsWith("#")) {
                    int rgb = Integer.parseInt(img.getColor().substring(1), 16) & 0xFFFFFF;
                    argb = (img.getAlpha() & 0xFF) << 24 | rgb;
                }
            }
            catch (Exception rgb) {
                // empty catch block
            }
            ResourceLocation rl = null;
            String url = img.getImageUrl();
            if (url != null) {
                String namespace = "minecraft";
                Object path = url;
                if (url.contains(":")) {
                    String[] parts = url.split(":", 2);
                    namespace = parts[0];
                    path = parts[1];
                }
                if (!((String)path).startsWith("textures/")) {
                    path = "textures/" + (String)path;
                }
                if (!((String)path).endsWith(".png")) {
                    path = (String)path + ".png";
                }
                try {
                    rl = new ResourceLocation(namespace, (String)path);
                }
                catch (Exception parts) {
                    // empty catch block
                }
            }
            boolean resourceOk = false;
            if (rl != null) {
                try {
                    ResourceManager rm = Minecraft.m_91087_().m_91098_();
                    Optional res = rm.m_213713_(rl);
                    resourceOk = res.isPresent();
                    if (!resourceOk && img == images.get(0)) {
                        System.out.println("  Missing texture: " + String.valueOf(rl) + " (from: " + img.getImageUrl() + ")");
                    }
                }
                catch (Throwable t) {
                    resourceOk = false;
                }
            }
            if (rl != null && resourceOk) {
                PoseStack pose = g.m_280168_();
                pose.m_85836_();
                pose.m_85837_((double)x + (double)iw / 2.0, (double)y + (double)ih / 2.0, 0.0);
                if (img.getRotation() != 0.0) {
                    pose.m_252781_(Axis.f_252403_.m_252977_((float)img.getRotation()));
                }
                pose.m_85837_((double)(-iw) / 2.0, (double)(-ih) / 2.0, 0.0);
                float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
                float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
                float gch = (float)(argb >>> 8 & 0xFF) / 255.0f;
                float b = (float)(argb & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)gch, (float)b, (float)a);
                g.m_280163_(rl, 0, 0, 0.0f, 0.0f, iw, ih, iw, ih);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                pose.m_85849_();
                continue;
            }
            g.m_280509_(x, y, x + iw, y + ih, argb);
        }
    }

    protected void m_7856_() {
        TelemetryManager tm = TelemetryManager.getInstance();
        SupabaseClient.ConsentStatus status = tm.getConsentStatus();
        if (status == null) {
            Minecraft.m_91087_().m_91152_((Screen)new ConsentLoadingScreen(null, this));
            return;
        }
        if (tm.shouldShowConsentScreen()) {
            Minecraft.m_91087_().m_91152_((Screen)new ConsentScreen(this, null));
            return;
        }
        super.m_7856_();
        this.reloadVisibleQuests();
        this.rebuildBackgroundFromTheme();
        if (this.sidebar == null) {
            this.sidebar = new SidebarPanel(0, 30, 180, this.f_96544_ - 70);
            this.sidebar.setOnSelect(this::filterByGroup);
        } else {
            this.sidebar.setBounds(0, 30, 180, this.f_96544_ - 70);
        }
        this.buildSidebarEntries();
        try {
            this.sidebar.setPinned(ClientConfig.getPinnedGroups());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.sidebar.setPanelPinned(ClientConfig.isChapterPanelPinned());
            this.sidebar.setCollapsedSections(ClientConfig.getCollapsedSections());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String extraShapes = (String)ThemeProperties.EXTRA_QUEST_SHAPES.get();
        if (extraShapes != null && !extraShapes.isEmpty()) {
            QuestShape.registerExtraAliases(extraShapes);
        }
        if (this.selectedGroup == null || this.selectedGroup.isEmpty() || "all".equals(this.selectedGroup)) {
            ClientQuestManager cqm = ClientQuestManager.getInstance();
            String candidate = null;
            GroupNode tree = cqm.getGroupTree();
            if (tree != null && !tree.getChildren().isEmpty()) {
                block6: for (GroupNode sec : tree.getChildren()) {
                    for (String g : sec.getGroups()) {
                        if (cqm.getQuestCountForGroup(g) <= 0) continue;
                        candidate = g;
                        break block6;
                    }
                }
            }
            if (candidate == null) {
                for (String g : cqm.getQuestGroups()) {
                    if (cqm.getQuestsByGroup(g).size() <= 0) continue;
                    candidate = g;
                    break;
                }
            }
            if (candidate != null) {
                this.selectedGroup = candidate;
                if (this.sidebar != null) {
                    this.sidebar.setSelectedGroup(candidate);
                }
                this.reloadVisibleQuests();
            }
        }
        if (!this.visibleQuests.isEmpty()) {
            this.fitToScreen();
        } else {
            this.alignQuestPositions();
            this.resetScroll();
        }
        this.closeButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(0, this.f_96544_ - 30, 70, 20).m_253136_());
        this.completeActionButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Complete All"), b -> {
            if (this.selectedQuest != null && ClientQuestManager.getInstance().canCompleteQuest(this.selectedQuest.getId())) {
                this.completeSelectedQuest();
            } else {
                this.completeAllCompletableQuests();
            }
        }).m_252987_(0, this.f_96544_ - 30, 90, 20).m_253136_());
        this.miniMapButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"MiniMap"), b -> {
            this.showMiniMap = !this.showMiniMap;
        }).m_252987_(0, this.f_96544_ - 30, 80, 20).m_253136_());
        this.heatmapButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Heat: Off"), b -> {
            this.heatmapMode = switch (this.heatmapMode) {
                case "off" -> {
                    b.m_93666_((Component)Component.m_237113_((String)"Heat: Diff"));
                    yield "difficulty";
                }
                case "difficulty" -> {
                    b.m_93666_((Component)Component.m_237113_((String)"Heat: Prog"));
                    yield "progress";
                }
                case "progress" -> {
                    b.m_93666_((Component)Component.m_237113_((String)"Heat: Tags"));
                    yield "tags";
                }
                case "tags" -> {
                    b.m_93666_((Component)Component.m_237113_((String)"Heat: Analytics"));
                    this.fetchAnalyticsHeatmapData();
                    yield "analytics";
                }
                default -> {
                    b.m_93666_((Component)Component.m_237113_((String)"Heat: Off"));
                    yield "off";
                }
            };
        }).m_252987_(0, this.f_96544_ - 30, 90, 20).m_253136_());
        try {
            this.advancedButton = ClientRuntimeConfig.shouldShowAdvancedEditor() ? (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Advanced"), b -> {
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_((Screen)new AdvancedEditorMenuScreen(this));
                }
            }).m_252987_(0, this.f_96544_ - 30, 90, 20).m_253136_()) : null;
        }
        catch (Throwable ignored) {
            this.advancedButton = null;
        }
        this.hudConfigButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2699"), b -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new QuestoryConfigScreen(this));
            }
        }).m_252987_(this.f_96543_ - 30, 5, 25, 20).m_253136_());
        this.teamButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Team"), b -> {
            if (this.f_96541_ != null) {
                ClientTeamManager clientTeamMgr = ClientTeamManager.getInstance();
                if (clientTeamMgr.isInTeam()) {
                    this.f_96541_.m_91152_((Screen)new TeamManagementScreen(this));
                } else {
                    this.f_96541_.m_91152_((Screen)new TeamCreationScreen(this));
                }
            }
        }).m_252987_(0, this.f_96544_ - 30, 50, 20).m_253136_());
        this.layoutBottomButtons();
    }

    private void fetchAnalyticsHeatmapData() {
        try {
            ModpackInfo modpackInfo = ModpackDetector.detect();
            String modpackId = modpackInfo.getId();
            String modpackVersion = modpackInfo.getVersion();
            if (modpackId == null || modpackId.isBlank()) {
                Questory.LOGGER.warn("Cannot fetch heatmap data: modpack ID not set");
                this.currentHeatmapData = new HeatmapData();
                return;
            }
            CompletableFuture.runAsync(() -> {
                try {
                    this.currentHeatmapData = HeatmapDataCache.getInstance().getHeatmapData(modpackId, modpackVersion);
                    Questory.LOGGER.info("Loaded heatmap data for {} quests", (Object)this.currentHeatmapData.getQuestCount());
                }
                catch (Exception e) {
                    Questory.LOGGER.error("Failed to fetch analytics heatmap data", (Throwable)e);
                    this.currentHeatmapData = new HeatmapData();
                }
            });
        }
        catch (Exception e) {
            Questory.LOGGER.error("Failed to initialize analytics heatmap data fetch", (Throwable)e);
            this.currentHeatmapData = new HeatmapData();
        }
    }

    private void reloadVisibleQuests() {
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        this.visibleQuests.clear();
        if ("all".equals(this.selectedGroup)) {
            ArrayList<String> groups;
            List<Quest> allQuests = cqm.getVisibleQuests();
            if (allQuests.size() > 500 && !(groups = new ArrayList<String>(cqm.getQuestGroups())).isEmpty()) {
                this.selectedGroup = (String)groups.get(0);
                this.reloadVisibleQuests();
                return;
            }
            this.visibleQuests.addAll(allQuests);
        } else {
            QuestProgress progress = cqm.getProgress();
            for (Quest q : cqm.getQuestsByGroup(this.selectedGroup)) {
                if (!q.isVisible(progress)) continue;
                this.visibleQuests.add(q);
            }
        }
    }

    private double getQuestButtonSize() {
        return (double)this.zoom * 3.0 / 2.0;
    }

    private double getQuestButtonSpacing() {
        double s = (Double)ThemeProperties.QUEST_SPACING.get();
        return (double)this.zoom * s / 4.0;
    }

    private void updateMinMax() {
        this.questMinX = Double.POSITIVE_INFINITY;
        this.questMinY = Double.POSITIVE_INFINITY;
        this.questMaxX = Double.NEGATIVE_INFINITY;
        this.questMaxY = Double.NEGATIVE_INFINITY;
        for (Quest q : this.visibleQuests) {
            double qx = q.getX();
            double qy = q.getY();
            this.questMinX = Math.min(this.questMinX, qx);
            this.questMinY = Math.min(this.questMinY, qy);
            this.questMaxX = Math.max(this.questMaxX, qx);
            this.questMaxY = Math.max(this.questMaxY, qy);
        }
        if (this.questMinX == Double.POSITIVE_INFINITY) {
            this.questMaxY = 0.0;
            this.questMaxX = 0.0;
            this.questMinY = 0.0;
            this.questMinX = 0.0;
        }
        this.questMinX -= 40.0;
        this.questMinY -= 30.0;
        this.questMaxX += 40.0;
        this.questMaxY += 30.0;
    }

    private void alignQuestPositions() {
        this.updateMinMax();
        double bs = this.getQuestButtonSize();
        double bp = this.getQuestButtonSpacing();
        double maxQuestSize = bs;
        for (Quest q : this.visibleQuests) {
            int size = this.computeQuestIconSize(q, (int)Math.round(bs));
            maxQuestSize = Math.max(maxQuestSize, (double)size);
        }
        this.scrollWidth = (this.questMaxX - this.questMinX) * (bs + bp) + bp + maxQuestSize;
        this.scrollHeight = (this.questMaxY - this.questMinY) * (bs + bp) + bp + maxQuestSize;
    }

    private void resetScroll() {
        this.alignQuestPositions();
        int graphWidth = this.selectedQuest == null ? this.f_96543_ - 16 : this.f_96543_ - this.getDetailsPanelWidth() - 16;
        int graphHeight = this.f_96544_ - 70;
        this.scrollX = this.scrollWidth > (double)graphWidth ? (this.scrollWidth - (double)graphWidth) / 2.0 : 0.0;
        this.scrollY = this.scrollHeight > (double)graphHeight ? (this.scrollHeight - (double)graphHeight) / 2.0 : 0.0;
        System.out.println("[QuestUI] Centered view: zoom=" + this.zoom + ", scrollX=" + this.scrollX + ", scrollY=" + this.scrollY + ", visible=" + this.visibleQuests.size());
        System.out.println("[QuestUI] Bounds: minX=" + this.questMinX + ", maxX=" + this.questMaxX + ", minY=" + this.questMinY + ", maxY=" + this.questMaxY);
        System.out.println("[QuestUI] Scroll size: width=" + this.scrollWidth + ", height=" + this.scrollHeight);
    }

    private void addZoom(double delta, double mouseX, double mouseY) {
        int oldZoom = this.zoom;
        this.zoom = (int)Mth.m_14008_((double)((double)this.zoom + delta * 4.0), (double)1.0, (double)60.0);
        if (this.zoom != oldZoom) {
            int graphLeft = 8;
            int graphTop = 30;
            int graphWidth = this.selectedQuest == null ? this.f_96543_ - 16 : this.f_96543_ - this.getDetailsPanelWidth() - 16;
            int graphHeight = this.f_96544_ - 70;
            double oldBs = (double)oldZoom * 3.0 / 2.0;
            double oldBp = (double)oldZoom * (Double)ThemeProperties.QUEST_SPACING.get() / 4.0;
            double oldScrollWidth = (this.questMaxX - this.questMinX) * (oldBs + oldBp);
            double oldScrollHeight = (this.questMaxY - this.questMinY) * (oldBs + oldBp);
            double relMouseX = mouseX - (double)graphLeft + this.scrollX;
            double relMouseY = mouseY - (double)graphTop + this.scrollY;
            double questPosX = relMouseX / oldScrollWidth * (this.questMaxX - this.questMinX) + this.questMinX;
            double questPosY = relMouseY / oldScrollHeight * (this.questMaxY - this.questMinY) + this.questMinY;
            this.alignQuestPositions();
            double newRelMouseX = (questPosX - this.questMinX) / (this.questMaxX - this.questMinX) * this.scrollWidth;
            double newRelMouseY = (questPosY - this.questMinY) / (this.questMaxY - this.questMinY) * this.scrollHeight;
            this.scrollX = newRelMouseX - (mouseX - (double)graphLeft);
            this.scrollY = newRelMouseY - (mouseY - (double)graphTop);
            this.scrollX = Math.max(0.0, Math.min(this.scrollWidth - (double)graphWidth, this.scrollX));
            this.scrollY = Math.max(0.0, Math.min(this.scrollHeight - (double)graphHeight, this.scrollY));
        }
    }

    private void fitToScreen() {
        if (this.visibleQuests.isEmpty()) {
            return;
        }
        this.alignQuestPositions();
        int graphWidth = this.selectedQuest == null ? this.f_96543_ - 16 : this.f_96543_ - this.getDetailsPanelWidth() - 16;
        int graphHeight = this.f_96544_ - 70;
        double gridWidth = this.questMaxX - this.questMinX;
        double gridHeight = this.questMaxY - this.questMinY;
        if (gridWidth <= 0.0 || gridHeight <= 0.0) {
            this.zoom = 16;
            this.resetScroll();
            return;
        }
        double zoomForWidth = (double)graphWidth / (gridWidth * 1.5);
        double zoomForHeight = (double)graphHeight / (gridHeight * 1.5);
        int optimalZoom = (int)Math.min(zoomForWidth, zoomForHeight);
        this.zoom = (int)Mth.m_14008_((double)((double)optimalZoom * 0.9), (double)1.0, (double)60.0);
        System.out.println("[QuestUI] Fit to screen: gridW=" + gridWidth + ", gridH=" + gridHeight + ", optimalZoom=" + this.zoom);
        this.alignQuestPositions();
        this.resetScroll();
    }

    private int[] gridToScreen(int gridX, int gridY, int viewportLeft, int viewportTop) {
        double bs = this.getQuestButtonSize();
        double bp = this.getQuestButtonSpacing();
        double screenX = ((double)gridX - this.questMinX) * (bs + bp) + bp / 2.0 - this.scrollX + (double)viewportLeft;
        double screenY = ((double)gridY - this.questMinY) * (bs + bp) + bp / 2.0 - this.scrollY + (double)viewportTop;
        return new int[]{(int)Math.round(screenX), (int)Math.round(screenY)};
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        String tooltip;
        int[] depPos;
        Quest dep;
        int[] qPos;
        this.backgroundRenderer.render(graphics, 0, 0, this.f_96543_, this.f_96544_);
        int graphLeft = 8 + (this.sidebar != null ? this.sidebar.getReservedWidth() : 0);
        int graphTop = 30;
        int graphRight = this.selectedQuest == null ? this.f_96543_ - 16 : this.f_96543_ - this.getDetailsPanelWidth() - 16;
        int graphBottom = this.f_96544_ - 40;
        this.renderChapterImages(graphics, graphLeft, graphTop, graphRight - graphLeft, graphBottom - graphTop);
        if (this.sidebar != null) {
            this.sidebar.render(graphics, this.f_96547_, this.f_96544_, mouseX, mouseY);
        }
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        double bs = this.getQuestButtonSize();
        int margin = (int)(bs * 4.0);
        int visibleLeft = graphLeft - margin;
        int visibleTop = graphTop - margin;
        int visibleRight = graphRight + margin;
        int visibleBottom = graphBottom + margin;
        this.cachedVisibleLeft = visibleLeft;
        this.cachedVisibleTop = visibleTop;
        this.cachedVisibleRight = visibleRight;
        this.cachedVisibleBottom = visibleBottom;
        this.viewportBoundsCacheValid = true;
        Quest hoveredQuest = this.getHoveredQuest(mouseX, mouseY, graphLeft, graphTop);
        ResourceLocation lineTexture = ThemeProperties.DEPENDENCY_LINE_TEXTURE.getResourceLocation();
        if (lineTexture != null) {
            RenderSystem.setShader(GameRenderer::m_172814_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)lineTexture);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        int segCount = 0;
        for (Quest q : this.visibleQuests) {
            if (q.isHideDependencyLines()) continue;
            qPos = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            for (String depId : q.getDependencies()) {
                boolean touchesFocus;
                dep = cqm.getQuest(depId);
                if (dep == null || !this.visibleQuests.contains(dep) || dep.isHideDependentLines()) continue;
                boolean bl = touchesFocus = this.selectedQuest != null && (q.equals(this.selectedQuest) || dep.equals(this.selectedQuest)) || hoveredQuest != null && (q.equals(hoveredQuest) || dep.equals(hoveredQuest));
                if (touchesFocus) continue;
                depPos = this.gridToScreen(dep.getX(), dep.getY(), graphLeft, graphTop);
                if (qPos[0] < visibleLeft && depPos[0] < visibleLeft || qPos[0] > visibleRight && depPos[0] > visibleRight || qPos[1] < visibleTop && depPos[1] < visibleTop || qPos[1] > visibleBottom && depPos[1] > visibleBottom) continue;
                boolean depCompleted = cqm.isQuestCompleted(dep.getId());
                boolean qCompleted = cqm.isQuestCompleted(q.getId());
                int baseColor = qCompleted && depCompleted ? (Integer)ThemeProperties.DEPENDENCY_LINE_COMPLETED_COLOR.get(q) : (!qCompleted && depCompleted ? ((Integer)ThemeProperties.DEPENDENCY_LINE_UNCOMPLETED_COLOR.get(q)).intValue() : ((Integer)ThemeProperties.DEPENDENCY_LINE_UNAVAILABLE_COLOR.get(q)).intValue());
                double thickness = (Double)ThemeProperties.DEPENDENCY_LINE_THICKNESS.get(q);
                if (thickness <= 0.0) {
                    thickness = 0.17;
                }
                float thicknessPx = (float)(thickness * this.getQuestButtonSize());
                double unselSpeed = (Double)ThemeProperties.DEPENDENCY_LINE_UNSELECTED_SPEED.get(q);
                float offset = this.enableAnimations ? AnimationHelper.DependencyLineAnimation.getLineOffset(false, unselSpeed) : 0.0f;
                int color = QuestGraphScreen.adjustAlpha(baseColor, 90);
                boolean dashed = "dashed".equalsIgnoreCase(q.getLineStyle()) || "dashed".equalsIgnoreCase(dep.getLineStyle());
                this.drawLine(graphics, qPos[0], qPos[1], depPos[0], depPos[1], color, dashed, thicknessPx, offset, lineTexture);
                if (++segCount < 1000) continue;
                break;
            }
            if (segCount < 1000) continue;
            break;
        }
        if (lineTexture != null) {
            RenderSystem.setShader(GameRenderer::m_172814_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)lineTexture);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
        segCount = 0;
        for (Quest q : this.visibleQuests) {
            if (q.isHideDependencyLines()) continue;
            qPos = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            for (String depId : q.getDependencies()) {
                boolean highlight;
                dep = cqm.getQuest(depId);
                if (dep == null || !this.visibleQuests.contains(dep) || dep.isHideDependentLines()) continue;
                boolean bl = highlight = this.selectedQuest != null && (q.equals(this.selectedQuest) || dep.equals(this.selectedQuest)) || hoveredQuest != null && (q.equals(hoveredQuest) || dep.equals(hoveredQuest));
                if (!highlight) continue;
                depPos = this.gridToScreen(dep.getX(), dep.getY(), graphLeft, graphTop);
                int colorProp = q.equals(dep) ? (Integer)ThemeProperties.DEPENDENCY_LINE_UNCOMPLETED_COLOR.get(q) : (q.equals(this.selectedQuest) || q.equals(hoveredQuest) ? (Integer)ThemeProperties.DEPENDENCY_LINE_REQUIRES_COLOR.get(q) : (Integer)ThemeProperties.DEPENDENCY_LINE_REQUIRED_FOR_COLOR.get(q));
                double thickness = (Double)ThemeProperties.DEPENDENCY_LINE_THICKNESS.get(q);
                if (thickness <= 0.0) {
                    thickness = 0.17;
                }
                float thicknessPx = (float)(thickness * this.getQuestButtonSize());
                double selSpeed = (Double)ThemeProperties.DEPENDENCY_LINE_SELECTED_SPEED.get(q);
                float offset = this.enableAnimations ? AnimationHelper.DependencyLineAnimation.getLineOffset(true, selSpeed) : 0.0f;
                int color = QuestGraphScreen.adjustAlpha(colorProp, 200);
                boolean dashed = "dashed".equalsIgnoreCase(q.getLineStyle()) || "dashed".equalsIgnoreCase(dep.getLineStyle());
                this.drawLine(graphics, qPos[0], qPos[1], depPos[0], depPos[1], color, dashed, thicknessPx, offset, lineTexture);
                if (++segCount < 1000) continue;
                break;
            }
            if (segCount < 1000) continue;
            break;
        }
        double bs_d = bs;
        double bp = this.getQuestButtonSpacing();
        double gridUnitsPerScreenPixel = 1.0 / (bs_d + bp);
        double gridMarginX = (double)margin * gridUnitsPerScreenPixel + 2.0;
        double gridMarginY = (double)margin * gridUnitsPerScreenPixel + 2.0;
        double gridVisibleLeft = this.questMinX + this.scrollX * gridUnitsPerScreenPixel - gridMarginX;
        double gridVisibleRight = this.questMinX + (this.scrollX + (double)(graphRight - graphLeft)) * gridUnitsPerScreenPixel + gridMarginX;
        double gridVisibleTop = this.questMinY + this.scrollY * gridUnitsPerScreenPixel - gridMarginY;
        double gridVisibleBottom = this.questMinY + (this.scrollY + (double)(graphBottom - graphTop)) * gridUnitsPerScreenPixel + gridMarginY;
        int questsRendered = 0;
        int questsCulled = 0;
        for (Quest q : this.visibleQuests) {
            int qx = q.getX();
            int qy = q.getY();
            if ((double)qx < gridVisibleLeft - 5.0 || (double)qx > gridVisibleRight + 5.0 || (double)qy < gridVisibleTop - 5.0 || (double)qy > gridVisibleBottom + 5.0) {
                ++questsCulled;
                continue;
            }
            int[] pos = this.gridToScreen(qx, qy, graphLeft, graphTop);
            if (pos[0] < visibleLeft || pos[0] > visibleRight || pos[1] < visibleTop || pos[1] > visibleBottom) {
                ++questsCulled;
                continue;
            }
            this.drawNode(graphics, q, pos, (int)bs, mouseX, mouseY);
            ++questsRendered;
        }
        if (questsCulled > 0) {
            System.out.println("[Performance] Rendered: " + questsRendered + ", Culled: " + questsCulled + " (" + questsCulled * 100 / (questsRendered + questsCulled) + "% saved)");
        }
        if (this.completeActionButton != null) {
            ClientQuestManager cqmBtn = ClientQuestManager.getInstance();
            if (this.selectedQuest != null) {
                boolean isCompleted = cqmBtn.isQuestCompleted(this.selectedQuest.getId());
                boolean canComplete = cqmBtn.canCompleteQuest(this.selectedQuest.getId());
                if (isCompleted) {
                    this.completeActionButton.m_93666_((Component)Component.m_237113_((String)"Completed"));
                    this.completeActionButton.f_93623_ = false;
                } else if (canComplete) {
                    this.completeActionButton.m_93666_((Component)Component.m_237113_((String)"Complete Quest"));
                    this.completeActionButton.f_93623_ = true;
                } else {
                    this.completeActionButton.m_93666_((Component)Component.m_237113_((String)"Complete Quest"));
                    this.completeActionButton.f_93623_ = false;
                }
            } else {
                this.completeActionButton.m_93666_((Component)Component.m_237113_((String)"Complete All"));
                this.completeActionButton.f_93623_ = !cqmBtn.getCompletableQuests().isEmpty();
            }
        }
        this.layoutBottomButtons();
        if (this.selectedQuest != null) {
            this.renderDetailsPanel(graphics);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.drawShadowedStringCentered(graphics, this.f_96539_.getString(), this.f_96543_ / 2, 10, 0xFFFFFF);
        if ("analytics".equals(this.heatmapMode) && hoveredQuest != null && this.currentHeatmapData != null && (tooltip = HeatmapRenderer.formatTooltip(hoveredQuest.getId(), this.currentHeatmapData)) != null && !tooltip.isEmpty()) {
            ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
            for (String line : tooltip.split("\n")) {
                tooltipLines.add(Component.m_237113_((String)line));
            }
            graphics.m_280677_(this.f_96547_, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
        String zoomInfo = "Zoom: " + this.zoom + "/60 (Scroll/+/-, F=Fit)";
        this.drawShadowedString(graphics, zoomInfo, 10, this.f_96544_ - 15, 0xAAAAAA);
        String questInfo = this.visibleQuests.size() + " quests";
        this.drawShadowedString(graphics, questInfo, 10, this.f_96544_ - 25, 0xAAAAAA);
        try {
            ClientQuestManager cqmDaily = ClientQuestManager.getInstance();
            String did = cqmDaily.getDailyId();
            if (did != null && !did.isBlank()) {
                String title = cqmDaily.getDailyTitle();
                String label = "Daily: " + (String)(title == null || title.isBlank() ? did : title + " (" + did + ")");
                QuestProgress prog = cqmDaily.getProgress();
                boolean completedToday = prog != null && did.equals(prog.getLastCompletedDailyId());
                int color = completedToday ? 0x55FF55 : 16767334;
                this.drawShadowedString(graphics, label, 10, this.f_96544_ - 45, color);
            }
        }
        catch (Exception cqmDaily) {
            // empty catch block
        }
        if (this.showMiniMap) {
            int mmW = ClientConfig.getMiniMapW();
            int mmH = ClientConfig.getMiniMapH();
            if (mmW <= 0) {
                mmW = 180;
            }
            if (mmH <= 0) {
                mmH = 120;
            }
            int mmX = ClientConfig.getMiniMapX();
            int mmY = ClientConfig.getMiniMapY();
            if (mmX < 0 || mmY < 0) {
                mmX = Math.max(8, this.f_96543_ - mmW - 8);
                mmY = 8;
                ClientConfig.setMiniMapRect(mmX, mmY, mmW, mmH);
            }
            this.lastMiniMapRect = new int[]{mmX, mmY, mmW, mmH};
            this.lastMiniMapHeaderRect = new int[]{mmX, mmY, mmW, 14};
            this.lastMiniMapResizeRect = new int[]{mmX + mmW - 12, mmY + mmH - 12, 12, 12};
            this.renderMiniMap(graphics, mmX, mmY, mmW, mmH, graphLeft, graphTop, graphRight, graphBottom);
        } else {
            this.lastMiniMapRect = null;
            this.lastMiniMapHeaderRect = null;
            this.lastMiniMapResizeRect = null;
        }
        if (!"off".equals(this.heatmapMode)) {
            int hx = ClientConfig.getHeatX();
            int hy = ClientConfig.getHeatY();
            int hw = Math.max(140, ClientConfig.getHeatW());
            int hh = Math.max(50, ClientConfig.getHeatH());
            if (hx < 0 || hy < 0) {
                hx = this.f_96543_ - hw - 8;
                hy = this.f_96544_ - hh - 8;
                ClientConfig.setHeatRect(hx, hy, hw, hh);
            }
            this.lastHeatRect = new int[]{hx, hy, hw, hh};
            this.lastHeatHeaderRect = new int[]{hx, hy, hw, 14};
            this.lastHeatResizeRect = new int[]{hx + hw - 12, hy + hh - 12, 12, 12};
            this.renderHeatmapLegend(graphics, hx, hy, hw, hh);
        } else {
            this.lastHeatRect = null;
            this.lastHeatHeaderRect = null;
            this.lastHeatResizeRect = null;
        }
        if (this.visibleQuests.isEmpty()) {
            this.drawShadowedStringCentered(graphics, "No quests in this chapter", this.f_96543_ / 2, this.f_96544_ / 2 - 20, 0xFFFFFF);
            this.drawShadowedStringCentered(graphics, "Select a different chapter above", this.f_96543_ / 2, this.f_96544_ / 2, 0xAAAAAA);
        }
    }

    private Quest getHoveredQuest(int mouseX, int mouseY, int graphLeft, int graphTop) {
        double bs = this.getQuestButtonSize();
        for (Quest q : this.visibleQuests) {
            QuestShape shape;
            boolean isCustom;
            int[] p = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            int size = this.computeQuestIconSize(q, (int)Math.round(bs));
            int x = p[0] - size / 2;
            int y = p[1] - size / 2;
            String shapeId = q.getShape();
            ShapeDef def = ShapeRegistry.get(shapeId);
            boolean bl = isCustom = def != null && !QuestShape.get(shapeId).getId().equalsIgnoreCase(shapeId);
            if (!(isCustom ? CustomShapeRenderer.contains(def, x, y, size, mouseX, mouseY) : (shape = QuestShape.get(shapeId)).contains(x, y, size, mouseX, mouseY))) continue;
            return q;
        }
        return null;
    }

    private static int adjustAlpha(int argb, int newAlpha) {
        if (newAlpha < 0) {
            newAlpha = 0;
        }
        if (newAlpha > 255) {
            newAlpha = 255;
        }
        return newAlpha << 24 | argb & 0xFFFFFF;
    }

    private int computeDifficultyHeatColor(Quest q) {
        Set<String> tags = TagAutoDetector.suggestTags(q);
        if (tags.contains("hard")) {
            return -3390396;
        }
        if (tags.contains("medium")) {
            return -1660613;
        }
        if (tags.contains("easy")) {
            return -10040218;
        }
        if (tags.contains("tutorial")) {
            return -10050612;
        }
        return -8355712;
    }

    private int computeProgressHeatColor(Quest q) {
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        if (progress == null) {
            return -8355712;
        }
        if (progress.isQuestCompleted(q.getId())) {
            return -13382605;
        }
        List<Requirement> reqs = q.getRequirements();
        if (reqs == null || reqs.isEmpty()) {
            return -8355712;
        }
        int total = reqs.size();
        int met = 0;
        for (Requirement req : reqs) {
            if (!req.isMet(progress, q.getId())) continue;
            ++met;
        }
        double frac = Math.max(0.0, Math.min(1.0, total == 0 ? 0.0 : (double)met / (double)total));
        return this.colorFromFraction(frac);
    }

    private int computeTagHeatColor(Quest q) {
        HashSet<String> tags = new HashSet<String>(q.getTags());
        tags.addAll(TagAutoDetector.suggestTags(q));
        if (tags.contains("combat")) {
            return -3390396;
        }
        if (tags.contains("exploration")) {
            return -10050612;
        }
        if (tags.contains("crafting")) {
            return -1660613;
        }
        if (tags.contains("mining")) {
            return -6390961;
        }
        if (tags.contains("building")) {
            return -4473925;
        }
        if (tags.contains("trading")) {
            return -11751600;
        }
        if (tags.contains("magic")) {
            return -6543440;
        }
        if (tags.contains("technology")) {
            return -16728876;
        }
        return -8355712;
    }

    private int colorFromFraction(double f) {
        int g;
        int r;
        if (f < 0.5) {
            t = f / 0.5;
            r = 204;
            g = (int)Math.round(68.0 + t * 162.0);
        } else {
            t = (f - 0.5) / 0.5;
            r = (int)Math.round(204.0 - t * 153.0);
            g = 230;
        }
        int b = 51;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private int blendARGB(int dst, int src) {
        int aS = src >>> 24 & 0xFF;
        if (aS <= 0) {
            return dst;
        }
        int rS = src >>> 16 & 0xFF;
        int gS = src >>> 8 & 0xFF;
        int bS = src & 0xFF;
        int aD = dst >>> 24 & 0xFF;
        int rD = dst >>> 16 & 0xFF;
        int gD = dst >>> 8 & 0xFF;
        int bD = dst & 0xFF;
        int aO = aS + aD * (255 - aS) / 255;
        int rO = (rS * aS + rD * (255 - aS)) / 255;
        int gO = (gS * aS + gD * (255 - aS)) / 255;
        int bO = (bS * aS + bD * (255 - aS)) / 255;
        return aO << 24 | rO << 16 | gO << 8 | bO;
    }

    private void renderMiniMap(GuiGraphics g, int x, int y, int w, int h, int graphLeft, int graphTop, int graphRight, int graphBottom) {
        int pct = ClientConfig.getMiniMapOpacityPct();
        int baseA = (int)Math.round(192.0 * ((double)pct / 100.0));
        int panel = (baseA & 0xFF) << 24 | 0x101010;
        g.m_280509_(x, y, x + w, y + h, panel);
        g.m_280509_(x, y, x + w, y + 1, -12566464);
        g.m_280509_(x, y + h - 1, x + w, y + h, -12566464);
        g.m_280509_(x, y, x + 1, y + h, -12566464);
        g.m_280509_(x + w - 1, y, x + w, y + h, -12566464);
        double gw = Math.max(1.0, this.questMaxX - this.questMinX);
        double gh = Math.max(1.0, this.questMaxY - this.questMinY);
        int headerH = 14;
        g.m_280509_(x, y, x + w, y + headerH, -2145904616);
        g.m_280488_(this.f_96547_, "Mini-map", x + 4, y + 3, 0xFFFFFF);
        this.lastMiniMapGearRect = new int[]{x + w - 26, y + 2, 24, 10};
        g.m_280509_(this.lastMiniMapGearRect[0], this.lastMiniMapGearRect[1], this.lastMiniMapGearRect[0] + this.lastMiniMapGearRect[2], this.lastMiniMapGearRect[1] + this.lastMiniMapGearRect[3], -2144128205);
        g.m_280488_(this.f_96547_, "\u2699", this.lastMiniMapGearRect[0] + 7, this.lastMiniMapGearRect[1] + 1, 0xFFFFFF);
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        ResourceLocation lineTex = null;
        for (Quest q : this.visibleQuests) {
            if (q.isHideDependencyLines()) continue;
            double nx1 = ((double)q.getX() - this.questMinX) / gw;
            double ny1 = ((double)q.getY() - this.questMinY) / gh;
            int px1 = x + 4 + (int)Math.round(nx1 * (double)(w - 8));
            int py1 = y + headerH + 4 + (int)Math.round(ny1 * (double)(h - headerH - 8));
            for (String depId : q.getDependencies()) {
                Quest dep = cqm.getQuest(depId);
                if (dep == null || !this.visibleQuests.contains(dep) || dep.isHideDependentLines()) continue;
                double nx2 = ((double)dep.getX() - this.questMinX) / gw;
                double ny2 = ((double)dep.getY() - this.questMinY) / gh;
                int px2 = x + 4 + (int)Math.round(nx2 * (double)(w - 8));
                int py2 = y + headerH + 4 + (int)Math.round(ny2 * (double)(h - headerH - 8));
                boolean depCompleted = cqm.isQuestCompleted(dep.getId());
                boolean qCompleted = cqm.isQuestCompleted(q.getId());
                int baseColor = qCompleted && depCompleted ? (Integer)ThemeProperties.DEPENDENCY_LINE_COMPLETED_COLOR.get(q) : (!qCompleted && depCompleted ? ((Integer)ThemeProperties.DEPENDENCY_LINE_UNCOMPLETED_COLOR.get(q)).intValue() : ((Integer)ThemeProperties.DEPENDENCY_LINE_UNAVAILABLE_COLOR.get(q)).intValue());
                int color = QuestGraphScreen.adjustAlpha(baseColor, 150);
                boolean dashed = "dashed".equalsIgnoreCase(q.getLineStyle()) || "dashed".equalsIgnoreCase(dep.getLineStyle());
                this.drawLine(g, px1, py1, px2, py2, color, dashed, 1.25f, 0.0f, lineTex);
            }
        }
        for (Quest q : this.visibleQuests) {
            double nx = ((double)q.getX() - this.questMinX) / gw;
            double ny = ((double)q.getY() - this.questMinY) / gh;
            int px = x + 4 + (int)Math.round(nx * (double)(w - 8));
            int py = y + headerH + 4 + (int)Math.round(ny * (double)(h - headerH - 8));
            int col = -5592406;
            if (ClientQuestManager.getInstance().isQuestCompleted(q.getId())) {
                col = -10040218;
            }
            g.m_280509_(px - 1, py - 1, px + 1, py + 1, col);
        }
        double bs = this.getQuestButtonSize();
        double bp = this.getQuestButtonSpacing();
        double vw = graphRight - graphLeft;
        double vh = graphBottom - graphTop;
        double vx0 = this.scrollX;
        double vy0 = this.scrollY;
        double totalW = Math.max(1.0, (this.questMaxX - this.questMinX) * (bs + bp));
        double totalH = Math.max(1.0, (this.questMaxY - this.questMinY) * (bs + bp));
        int innerX = x + 4;
        int innerY = y + headerH + 4;
        int innerW = Math.max(1, w - 8);
        int innerH = Math.max(1, h - headerH - 8);
        int rx0 = innerX + (int)Math.round(vx0 / totalW * (double)innerW);
        int ry0 = innerY + (int)Math.round(vy0 / totalH * (double)innerH);
        int rpw = (int)Math.round(Math.min(1.0, vw / totalW) * (double)innerW);
        int rph = (int)Math.round(Math.min(1.0, vh / totalH) * (double)innerH);
        rpw = Math.max(4, Math.min(innerW, rpw));
        rph = Math.max(4, Math.min(innerH, rph));
        int rx1 = rx0 + rpw;
        int ry1 = ry0 + rph;
        if (rx0 < innerX) {
            rx0 = innerX;
            rx1 = innerX + rpw;
        }
        if (ry0 < innerY) {
            ry0 = innerY;
            ry1 = innerY + rph;
        }
        if (rx1 > innerX + innerW) {
            rx1 = innerX + innerW;
            rx0 = rx1 - rpw;
        }
        if (ry1 > innerY + innerH) {
            ry1 = innerY + innerH;
            ry0 = ry1 - rph;
        }
        int rc = -2130706433;
        g.m_280509_(rx0, ry0, rx1, ry0 + 1, rc);
        g.m_280509_(rx0, ry1, rx1, ry1 + 1, rc);
        g.m_280509_(rx0, ry0, rx0 + 1, ry1, rc);
        g.m_280509_(rx1, ry0, rx1 + 1, ry1, rc);
        this.miniMapSizeOptionRects = null;
        this.miniMapOpacityOptionRects = null;
        if (this.miniMapSettingsOpen) {
            int menuW = 160;
            int menuH = 74;
            int mx = x + w - menuW - 4;
            int my = y + headerH + 4;
            g.m_280509_(mx, my, mx + menuW, my + menuH, -535555052);
            g.m_280509_(mx, my, mx + menuW, my + 1, -12566464);
            g.m_280509_(mx, my + menuH - 1, mx + menuW, my + menuH, -12566464);
            g.m_280509_(mx, my, mx + 1, my + menuH, -12566464);
            g.m_280509_(mx + menuW - 1, my, mx + menuW, my + menuH, -12566464);
            g.m_280488_(this.f_96547_, "Size", mx + 6, my + 4, 0xFFFFFF);
            int y1 = my + 18;
            this.miniMapSizeOptionRects = new int[][]{{mx + 6, y1, 46, 12}, {mx + 58, y1, 60, 12}, {mx + 124, y1, 30, 12}};
            this.drawMenuButton(g, this.miniMapSizeOptionRects[0], "Small");
            this.drawMenuButton(g, this.miniMapSizeOptionRects[1], "Medium");
            this.drawMenuButton(g, this.miniMapSizeOptionRects[2], "Large");
            g.m_280488_(this.f_96547_, "Opacity", mx + 6, my + 36, 0xFFFFFF);
            int y2 = my + 50;
            this.miniMapOpacityOptionRects = new int[][]{{mx + 6, y2, 26, 12}, {mx + 38, y2, 26, 12}, {mx + 70, y2, 26, 12}, {mx + 102, y2, 26, 12}};
            this.drawMenuButton(g, this.miniMapOpacityOptionRects[0], "0%");
            this.drawMenuButton(g, this.miniMapOpacityOptionRects[1], "25%");
            this.drawMenuButton(g, this.miniMapOpacityOptionRects[2], "50%");
            this.drawMenuButton(g, this.miniMapOpacityOptionRects[3], "75%");
        }
    }

    private void drawMenuButton(GuiGraphics g, int[] r, String label) {
        g.m_280509_(r[0], r[1], r[0] + r[2], r[1] + r[3], -2144128205);
        int tx = r[0] + Math.max(2, (r[2] - this.f_96547_.m_92895_(label)) / 2);
        int ty = r[1] + 2;
        g.m_280488_(this.f_96547_, label, tx, ty, 0xFFFFFF);
    }

    private void renderHeatmapLegend(GuiGraphics g, int x, int y, int w, int h) {
        int pct = ClientConfig.getHeatOpacityPct();
        int baseA = (int)Math.round(192.0 * ((double)pct / 100.0));
        int panel = (baseA & 0xFF) << 24 | 0x121212;
        g.m_280509_(x, y, x + w, y + h, panel);
        g.m_280509_(x, y, x + w, y + 1, -12566464);
        g.m_280509_(x, y + h - 1, x + w, y + h, -12566464);
        g.m_280509_(x, y, x + 1, y + h, -12566464);
        g.m_280509_(x + w - 1, y, x + w, y + h, -12566464);
        g.m_280509_(x, y, x + w, y + 14, -2145378272);
        g.m_280488_(this.f_96547_, "Heatmap: " + this.heatmapMode, x + 6, y + 3, 0xFFFFFF);
        int cy = y + 18;
        if ("difficulty".equals(this.heatmapMode)) {
            int cols = w >= 260 ? 2 : 1;
            int colGap = 16;
            int colW = Math.max(60, (w - 12 - (cols - 1) * colGap) / cols);
            String[] labels = new String[]{"Hard", "Medium", "Easy", "Tutorial"};
            int[] colors = new int[]{-3390396, -1660613, -10040218, -10050612};
            int itemsPerCol = (int)Math.ceil((double)labels.length / (double)cols);
            for (int i = 0; i < labels.length; ++i) {
                int col = i / itemsPerCol;
                int row = i % itemsPerCol;
                int lx = x + 6 + col * (colW + colGap);
                int ly = cy + row * 14;
                this.drawLegendRow(g, lx, ly, colors[i], labels[i]);
            }
        } else if ("progress".equals(this.heatmapMode)) {
            int bx = x + 6;
            int by = cy + 8;
            int bw = Math.max(20, w - 12);
            int bh = 8;
            for (int i = 0; i < bw; ++i) {
                double f = (double)i / (double)(bw - 1);
                g.m_280509_(bx + i, by, bx + i + 1, by + bh, this.colorFromFraction(f));
            }
            g.m_280488_(this.f_96547_, "0%", bx, cy, 0xFFFFFF);
            g.m_280488_(this.f_96547_, "100%", Math.max(bx, x + w - 6 - this.f_96547_.m_92895_("100%")), cy, 0xFFFFFF);
        } else if ("tags".equals(this.heatmapMode)) {
            String[] labels = new String[]{"Combat", "Exploration", "Crafting", "Mining", "Magic"};
            int[] colors = new int[]{-3390396, -10050612, -1660613, -6390961, -6543440};
            int cols = w >= 300 ? 2 : 1;
            int colGap = 16;
            int colW = Math.max(80, (w - 12 - (cols - 1) * colGap) / cols);
            int itemsPerCol = (int)Math.ceil((double)labels.length / (double)cols);
            for (int i = 0; i < labels.length; ++i) {
                int col = i / itemsPerCol;
                int row = i % itemsPerCol;
                int lx = x + 6 + col * (colW + colGap);
                int ly = cy + row * 14;
                this.drawLegendRow(g, lx, ly, colors[i], labels[i]);
            }
        } else if ("analytics".equals(this.heatmapMode)) {
            int bx = x + 6;
            int by = cy + 8;
            int bw = Math.max(20, w - 12);
            int bh = 8;
            for (int i = 0; i < bw; ++i) {
                double intensity = (double)i / (double)(bw - 1);
                int color = HeatmapRenderer.getColorFromIntensity(intensity);
                g.m_280509_(bx + i, by, bx + i + 1, by + bh, color);
            }
            g.m_280488_(this.f_96547_, "Cold", bx, cy, 0xFFFFFF);
            g.m_280488_(this.f_96547_, "Hot", Math.max(bx, x + w - 6 - this.f_96547_.m_92895_("Hot")), cy, 0xFFFFFF);
            String status = this.currentHeatmapData != null && this.currentHeatmapData.getQuestCount() > 0 ? this.currentHeatmapData.getQuestCount() + " quests tracked" : "Loading analytics...";
            g.m_280488_(this.f_96547_, status, x + 6, cy + 24, 0xAAAAAA);
        }
        g.m_280509_(x + w - 12, y + h - 12, x + w, y + h, 0x60FFFFFF);
    }

    private void drawLegendRow(GuiGraphics g, int x, int y, int color, String label) {
        g.m_280509_(x, y, x + 10, y + 10, color);
        g.m_280488_(this.f_96547_, label, x + 14, y + 1, 0xFFFFFF);
    }

    private void drawShadowedString(GuiGraphics g, String text, int x, int y, int color) {
        g.m_280488_(this.f_96547_, text, x + 1, y + 1, -1442840576);
        g.m_280488_(this.f_96547_, text, x, y, color);
    }

    private void drawShadowedStringCentered(GuiGraphics g, String text, int cx, int y, int color) {
        int w = this.f_96547_.m_92895_(text);
        this.drawShadowedString(g, text, cx - w / 2, y, color);
    }

    private int computeQuestIconSize(Quest q, int buttonSize) {
        double base = (double)buttonSize * q.getSize() * q.getIconScale();
        double minSize = 20.0 + Math.sqrt(Math.max(1.0, (double)this.zoom)) * 4.0;
        double maxSize = 96.0 + Math.sqrt(Math.max(1.0, (double)this.zoom)) * 8.0;
        return (int)Math.round(Mth.m_14008_((double)base, (double)minSize, (double)maxSize));
    }

    private void drawNode(GuiGraphics g, Quest q, int[] screenPos, int buttonSize, int mouseX, int mouseY) {
        int iy;
        int size = this.computeQuestIconSize(q, buttonSize);
        int padding = Math.max(2, size / 6);
        int x = screenPos[0] - size / 2;
        int y = screenPos[1] - size / 2;
        ClientQuestManager cqm = ClientQuestManager.getInstance();
        boolean completed = cqm.isQuestCompleted(q.getId());
        boolean canComplete = cqm.canCompleteQuest(q.getId());
        boolean selected = q.equals(this.selectedQuest);
        String shapeId = q.getShape();
        ShapeDef customDef = ShapeRegistry.get(shapeId);
        boolean isCustomShape = customDef != null && !QuestShape.get(shapeId).getId().equalsIgnoreCase(shapeId);
        QuestShape shape = QuestShape.get(shapeId);
        boolean hovered = isCustomShape ? CustomShapeRenderer.contains(customDef, x, y, size, mouseX, mouseY) : shape.contains(x, y, size, mouseX, mouseY);
        int bgColor = -15066598;
        int outlineColor = selected ? (this.enableAnimations ? AnimationHelper.QuestButtonAnimation.getOutlineColor(true, hovered) : (Integer)ThemeProperties.QUEST_SELECTED_COLOR.get(q)) : (completed ? (Integer)ThemeProperties.QUEST_COMPLETED_COLOR.get(q) : (canComplete ? ((Integer)ThemeProperties.QUEST_STARTED_COLOR.get(q)).intValue() : ((Integer)ThemeProperties.QUEST_LOCKED_COLOR.get(q)).intValue()));
        int baseBg = -14013910;
        if (!"off".equals(this.heatmapMode)) {
            int heat = switch (this.heatmapMode) {
                case "progress" -> this.computeProgressHeatColor(q);
                case "tags" -> this.computeTagHeatColor(q);
                case "analytics" -> HeatmapRenderer.getColorForQuest(q.getId(), this.currentHeatmapData);
                default -> this.computeDifficultyHeatColor(q);
            };
            if ((heat & 0xFF000000) != 0 && heat != -8355712) {
                int glowColor = heat & 0xFFFFFF | 0x66000000;
                int glowSize = size + 12;
                int glowX = x - 6;
                int glowY = y - 6;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                if (isCustomShape) {
                    CustomShapeRenderer.draw(customDef, g, glowX, glowY, glowSize, glowColor);
                } else {
                    shape.drawBackground(g, glowX, glowY, glowSize, glowColor);
                }
            }
            baseBg = this.blendARGB(baseBg, heat & 0xFFFFFF | 0x99000000);
        }
        if (isCustomShape) {
            CustomShapeRenderer.draw(customDef, g, x, y, size, baseBg);
            try {
                shadeMode = (String)ThemeProperties.QUEST_SHADE_MODE.get();
                shadeDir = (String)ThemeProperties.QUEST_SHADE_DIRECTION.get();
                double shadeStrength = (Double)ThemeProperties.QUEST_SHADE_STRENGTH.get();
                shadeTint = (Integer)ThemeProperties.QUEST_SHADE_COLOR.get();
                if (shadeStrength > 0.0 && shadeMode != null && !"none".equalsIgnoreCase(shadeMode)) {
                    CustomShapeRenderer.drawShadeOverlay(customDef, g, x, y, size, shadeMode, shadeDir, shadeStrength, shadeTint);
                }
            }
            catch (Throwable shadeMode) {}
        } else {
            shape.drawBackground(g, x, y, size, baseBg);
            try {
                shadeMode = (String)ThemeProperties.QUEST_SHADE_MODE.get();
                shadeDir = (String)ThemeProperties.QUEST_SHADE_DIRECTION.get();
                double shadeStrength = (Double)ThemeProperties.QUEST_SHADE_STRENGTH.get();
                shadeTint = (Integer)ThemeProperties.QUEST_SHADE_COLOR.get();
                if (shadeStrength > 0.0 && shadeMode != null && !"none".equalsIgnoreCase(shadeMode)) {
                    shape.drawShadeOverlay(g, x, y, size, shadeMode, shadeDir, shadeStrength, shadeTint);
                }
            }
            catch (Throwable shadeMode) {
                // empty catch block
            }
        }
        if (hovered) {
            int hoverAlpha;
            int n = hoverAlpha = this.enableAnimations ? AnimationHelper.getPulsingAlpha(40, 100, 0.005) : 64;
            if (isCustomShape) {
                CustomShapeRenderer.draw(customDef, g, x, y, size, hoverAlpha << 24 | 0xFFFFFF);
            } else {
                shape.drawBackground(g, x, y, size, hoverAlpha << 24 | 0xFFFFFF);
            }
        }
        int outlineThickness = Math.max(1, size / 20);
        if (isCustomShape) {
            CustomShapeRenderer.drawOutline(customDef, g, x, y, size, outlineColor, outlineThickness);
        } else {
            shape.drawOutline(g, x, y, size, outlineColor, outlineThickness);
        }
        if (!q.getIcon().isEmpty()) {
            int iconSize = (int)((double)size * 0.65);
            int iconX = x + (size - iconSize) / 2;
            int iconY = y + (size - iconSize) / 2;
            QuestIconRenderer.render(g, q.getIcon(), iconX, iconY, iconSize, hovered, selected);
            if (isCustomShape) {
                CustomShapeRenderer.drawOutsideMask(customDef, g, x, y, size, iconX, iconY, iconSize, iconSize, baseBg);
            }
        }
        if (completed) {
            int indicatorSize = Math.max(10, size / 4);
            int ix = x + size - indicatorSize - 2;
            iy = y + 2;
            ThemeIconRenderer.draw(g, ThemeProperties.CHECK_ICON, ix, iy, indicatorSize, indicatorSize);
        }
        if (!canComplete) {
            int s = Math.max(10, size / 4);
            int ix = x + size - s - 2;
            iy = y + size - s - 2;
            ThemeIconRenderer.draw(g, ThemeProperties.LOCK_ICON, ix, iy, s, s);
        }
        if (q.isHidden()) {
            int s = Math.max(10, size / 4);
            ThemeIconRenderer.draw(g, ThemeProperties.HIDDEN_ICON, x + 2, y + 2, s, s);
        }
        if ((Integer)ThemeProperties.SHOW_QUEST_TITLES.get() == 1) {
            String title = q.getTitle();
            int maxTitleWidth = Math.max(size + 40, 100);
            Component formattedTitle = TextFormatter.parse(title);
            List titleLines = this.f_96547_.m_92923_((FormattedText)formattedTitle, maxTitleWidth);
            int titleColor = hovered ? (Integer)ThemeProperties.HOVER_TEXT_COLOR.get(q) : (Integer)ThemeProperties.TEXT_COLOR.get(q);
            int lineY = y + size + 2;
            int lineHeight = 10;
            for (FormattedCharSequence line : titleLines) {
                int lineWidth = this.f_96547_.m_92724_(line);
                int titleX = x + (size - lineWidth) / 2;
                g.m_280648_(this.f_96547_, line, titleX, lineY, titleColor);
                lineY += lineHeight;
            }
        }
    }

    private void renderDetailsPanel(GuiGraphics g) {
        int cy;
        int detailsW = this.getDetailsPanelWidth();
        int x = this.f_96543_ - detailsW - 8;
        int y = 30;
        int w = detailsW;
        int h = this.f_96544_ - 70;
        int borderCol = (Integer)ThemeProperties.WIDGET_BORDER.get();
        IconProperty qvbg = ThemeProperties.QUEST_VIEW_BACKGROUND;
        if (qvbg.getResourceLocation() != null || qvbg.getColorModifier() != null || "builtin".equals(qvbg.getTexturePath())) {
            ThemeIconRenderer.draw(g, qvbg, x, y, w, h);
        } else {
            int bgCol = (Integer)ThemeProperties.WIDGET_BACKGROUND.get();
            g.m_280509_(x, y, x + w, y + h, bgCol);
        }
        g.m_280509_(x - 1, y - 1, x + w + 1, y, borderCol);
        g.m_280509_(x - 1, y + h, x + w + 1, y + h + 1, borderCol);
        g.m_280509_(x - 1, y, x, y + h, borderCol);
        g.m_280509_(x + w, y, x + w + 1, y + h, borderCol);
        int closeButtonSize = 16;
        int closeButtonX = x + w - closeButtonSize - 4;
        int closeButtonY = y + 4;
        g.m_280509_(closeButtonX, closeButtonY, closeButtonX + closeButtonSize, closeButtonY + closeButtonSize, -2130771968);
        g.m_280488_(this.f_96547_, "\u00d7", closeButtonX + 4, closeButtonY + 4, -1);
        this.lastDetailsCloseButtonRect = new int[]{closeButtonX, closeButtonY, closeButtonSize, closeButtonSize};
        g.m_280588_(x, y, x + w, y + h);
        int contentStartY = cy = y + 6 - this.detailsPanelScroll;
        Component formattedTitle = TextFormatter.parse(this.selectedQuest.getTitle());
        g.m_280430_(this.f_96547_, formattedTitle, x + 6, cy, 0xFFFFFF);
        QuestIconRenderer.render(g, this.selectedQuest.getIcon(), x + 6, cy += 14, 24);
        boolean isPinned = ClientConfig.isQuestTracked(this.selectedQuest.getId());
        String pinLabel = isPinned ? "Pinned to HUD" : "Pin to HUD";
        int pbx = x + 36;
        int pby = cy + 6;
        int pbw = Math.max(80, this.f_96547_.m_92895_(pinLabel) + 12);
        int pbh = 14;
        int pinBg = isPinned ? -2130716928 : -2141891243;
        g.m_280509_(pbx, pby, pbx + pbw, pby + pbh, pinBg);
        g.m_280488_(this.f_96547_, pinLabel, pbx + 6, pby + 3, 0xFFFFFF);
        this.lastDetailsHudPinRect = new int[]{pbx, pby, pbw, pbh};
        this.lastDetailsTrackRect = null;
        cy += 28;
        TeamQuestSettings teamSettings = this.selectedQuest.getTeamSettings();
        if (teamSettings != null && teamSettings.isTeamEnabled()) {
            String teamIcon = "\ud83d\udc65";
            String progressMode = teamSettings.getProgressMode().name();
            String rewardMode = teamSettings.getRewardMode().name();
            g.m_280488_(this.f_96547_, teamIcon + " \u00a76Team Quest", x + 6, cy, 0xFFAA00);
            g.m_280488_(this.f_96547_, "  \u00a77Progress: \u00a7e" + progressMode, x + 6, cy += 12, 0xFFFFFF);
            g.m_280488_(this.f_96547_, "  \u00a77Rewards: \u00a7e" + (String)rewardMode, x + 6, cy += 10, 0xFFFFFF);
            cy += 10;
            if (teamSettings.getMinTeamSize() > 1 || teamSettings.getMaxTeamSize() < 10) {
                String sizeInfo = "  \u00a77Team Size: \u00a7f" + teamSettings.getMinTeamSize() + "-" + teamSettings.getMaxTeamSize();
                g.m_280488_(this.f_96547_, sizeInfo, x + 6, cy, 0xFFFFFF);
                cy += 10;
            }
            cy += 6;
        }
        String desc = this.selectedQuest.getDescription();
        this.formattedDescriptionWithImages = TextFormatter.parseWithImages(desc);
        this.descriptionStartY = cy;
        this.descriptionPanelX = x;
        int textStartY = cy;
        for (FormattedCharSequence line : this.f_96547_.m_92923_((FormattedText)this.formattedDescriptionWithImages.getTextComponent(), w - 20)) {
            g.m_280648_(this.f_96547_, line, x + 6, cy, 0xFFFFFF);
            cy += 10;
        }
        if (this.formattedDescriptionWithImages.hasImages()) {
            int imageHeight = ImageRenderer.renderAllImages(g, this.formattedDescriptionWithImages, x + 6, textStartY, w - 20, 10);
            cy += imageHeight;
        }
        int tasksColor = (Integer)ThemeProperties.TASKS_TEXT_COLOR.get();
        g.m_280488_(this.f_96547_, "Requirements:", x + 6, cy += 6, tasksColor);
        cy += 12;
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        this.checkmarkButtonRects.clear();
        int reqIndex = 0;
        for (Requirement requirement : this.selectedQuest.getRequirements()) {
            IconProperty iconProp;
            String txt = requirement.getProgressDisplay(progress, this.selectedQuest.getId());
            boolean met = requirement.isMet(progress, this.selectedQuest.getId());
            int iconSize = 10;
            int ix = x + 6;
            int iy = cy + 1;
            IconProperty iconProperty = iconProp = met ? ThemeProperties.CHECKMARK_TASK_ACTIVE : ThemeProperties.CHECKMARK_TASK_INACTIVE;
            if (requirement instanceof CheckmarkRequirement && !met) {
                this.checkmarkButtonRects.add(new int[]{ix, iy, iconSize, iconSize, reqIndex});
            }
            if (iconProp.getResourceLocation() != null || iconProp.getColorModifier() != null || "builtin".equals(iconProp.getTexturePath())) {
                ThemeIconRenderer.draw(g, iconProp, ix, iy, iconSize, iconSize);
                g.m_280488_(this.f_96547_, "  " + txt, ix + iconSize + 2, cy, ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
            } else {
                g.m_280488_(this.f_96547_, (met ? "\u2713 " : "  \u2022 ") + txt, ix, cy, ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
            }
            cy += 10;
            ++reqIndex;
        }
        cy += 4;
        if (!this.selectedQuest.getRewards().isEmpty()) {
            int rewardsColor = (Integer)ThemeProperties.REWARDS_TEXT_COLOR.get();
            g.m_280488_(this.f_96547_, "Rewards:", x + 6, cy, rewardsColor);
            cy += 12;
            for (Reward reward : this.selectedQuest.getRewards()) {
                g.m_280488_(this.f_96547_, "  \u2022 " + reward.getDisplayString(), x + 6, cy, ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
                cy += 10;
            }
        }
        this.detailsPanelContentHeight = cy - contentStartY + 10;
        g.m_280618_();
        if (this.detailsPanelContentHeight > h) {
            int scrollbarX = x + w - 6;
            int n = Math.max(20, h * h / this.detailsPanelContentHeight);
            int maxScroll = this.detailsPanelContentHeight - h;
            int scrollbarY = y + (int)((double)this.detailsPanelScroll / (double)maxScroll * (double)(h - n));
            IconProperty trackIcon = ThemeProperties.SCROLL_BAR_BACKGROUND;
            if (trackIcon.getResourceLocation() != null) {
                ThemeIconRenderer.draw(g, trackIcon, scrollbarX, y, 4, h);
            } else {
                g.m_280509_(scrollbarX, y, scrollbarX + 4, y + h, Integer.MIN_VALUE);
            }
            IconProperty thumbIcon = ThemeProperties.SCROLL_BAR;
            if (thumbIcon.getResourceLocation() != null) {
                ThemeIconRenderer.draw(g, thumbIcon, scrollbarX, scrollbarY, 4, n);
            } else {
                g.m_280509_(scrollbarX, scrollbarY, scrollbarX + 4, scrollbarY + n, -5592406);
            }
        }
    }

    private Style getStyleAtLinePosition(Component component, int x, int lineIndex) {
        if (component == null || this.f_96547_ == null) {
            return null;
        }
        List lines = this.f_96547_.m_92923_((FormattedText)component, this.getDetailsPanelWidth() - 20);
        if (lineIndex < 0 || lineIndex >= lines.size()) {
            System.out.println("[Link Debug] Line index " + lineIndex + " out of bounds (0-" + (lines.size() - 1) + ")");
            return null;
        }
        FormattedCharSequence line = (FormattedCharSequence)lines.get(lineIndex);
        Style[] foundStyle = new Style[]{null};
        int[] currentX = new int[]{0};
        line.m_13731_((charIndex, style, codePoint) -> {
            int charWidth = this.f_96547_.m_92895_(String.valueOf((char)codePoint));
            if (x >= currentX[0] && x < currentX[0] + charWidth) {
                foundStyle[0] = style;
                return false;
            }
            currentX[0] = currentX[0] + charWidth;
            return true;
        });
        System.out.println("[Link Debug] Found style at x=" + x + ": " + (foundStyle[0] != null ? "yes" : "no"));
        return foundStyle[0];
    }

    private List<String> splitText(String text, int maxWidth) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        text = text.replaceAll("&[0-9a-fk-or]", "");
        for (String paragraph : paragraphs = text.split("\\n")) {
            if (paragraph.trim().isEmpty()) {
                lines.add("");
                continue;
            }
            String[] words = paragraph.split(" ");
            StringBuilder current = new StringBuilder();
            for (String w : words) {
                String test;
                String string = test = current.length() == 0 ? w : String.valueOf(current) + " " + w;
                if (this.f_96547_.m_92895_(test) <= maxWidth) {
                    if (current.length() > 0) {
                        current.append(" ");
                    }
                    current.append(w);
                    continue;
                }
                if (current.length() > 0) {
                    lines.add(current.toString());
                }
                current = new StringBuilder(w);
            }
            if (current.length() <= 0) continue;
            lines.add(current.toString());
        }
        return lines;
    }

    private void drawLine(GuiGraphics g, int x1, int y1, int x2, int y2, int argb, boolean dashed, float thickness, float offset, ResourceLocation texture) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        float len = (float)Math.hypot(dx, dy);
        if (len <= 0.5f) {
            g.m_280509_(x1, y1, x1 + 1, y1 + 1, argb);
            return;
        }
        if (dashed) {
            float dash;
            float gap = dash = Math.max(6.0f, thickness * 3.0f);
            for (float dist = 0.0f; dist < len; dist += dash + gap) {
                float seg = Math.min(dash, len - dist);
                float t1 = dist / len;
                float t2 = (dist + seg) / len;
                int sx = Math.round((float)x1 + (float)dx * t1);
                int sy = Math.round((float)y1 + (float)dy * t1);
                int ex = Math.round((float)x1 + (float)dx * t2);
                int ey = Math.round((float)y1 + (float)dy * t2);
                this.drawLine(g, sx, sy, ex, ey, argb, false, thickness, offset, texture);
            }
            return;
        }
        float half = Math.max(1.0f, thickness / 2.0f);
        if (texture != null) {
            RenderSystem.setShader(GameRenderer::m_172814_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
            float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
            float gch = (float)(argb >>> 8 & 0xFF) / 255.0f;
            float b = (float)(argb & 0xFF) / 255.0f;
            float mu = (offset % 1.0f + 1.0f) % 1.0f;
            PoseStack pose = g.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)x1, (float)y1, 0.0f);
            pose.m_252781_(Axis.f_252403_.m_252961_((float)Math.atan2(dy, dx)));
            Matrix4f m = pose.m_85850_().m_252922_();
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buf = tess.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            int ai = Math.round(a * 255.0f);
            int ri = Math.round(r * 255.0f);
            int gi = Math.round(gch * 255.0f);
            int bi = Math.round(b * 255.0f);
            int ri2 = ri * 3 / 4;
            int gi2 = gi * 3 / 4;
            int bi2 = bi * 3 / 4;
            buf.m_252986_(m, 0.0f, -half, 0.0f).m_6122_(ri, gi, bi, ai).m_7421_(len / half / 2.0f + mu, 0.0f).m_5752_();
            buf.m_252986_(m, 0.0f, half, 0.0f).m_6122_(ri, gi, bi, ai).m_7421_(len / half / 2.0f + mu, 1.0f).m_5752_();
            buf.m_252986_(m, len, half, 0.0f).m_6122_(ri2, gi2, bi2, ai).m_7421_(mu, 1.0f).m_5752_();
            buf.m_252986_(m, len, -half, 0.0f).m_6122_(ri2, gi2, bi2, ai).m_7421_(mu, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
            pose.m_85849_();
        } else {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
            float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
            float gch = (float)(argb >>> 8 & 0xFF) / 255.0f;
            float b = (float)(argb & 0xFF) / 255.0f;
            PoseStack pose = g.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)x1, (float)y1, 0.0f);
            pose.m_252781_(Axis.f_252403_.m_252961_((float)Math.atan2(dy, dx)));
            Matrix4f m = pose.m_85850_().m_252922_();
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buf = tess.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            int ai = Math.round(a * 255.0f);
            int ri = Math.round(r * 255.0f);
            int gi = Math.round(gch * 255.0f);
            int bi = Math.round(b * 255.0f);
            buf.m_252986_(m, 0.0f, -half, 0.0f).m_6122_(ri, gi, bi, ai).m_5752_();
            buf.m_252986_(m, 0.0f, half, 0.0f).m_6122_(ri, gi, bi, ai).m_5752_();
            buf.m_252986_(m, len, half, 0.0f).m_6122_(ri, gi, bi, ai).m_5752_();
            buf.m_252986_(m, len, -half, 0.0f).m_6122_(ri, gi, bi, ai).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
            pose.m_85849_();
        }
    }

    private void rebuildBackgroundFromTheme() {
        IconProperty bg = ThemeProperties.BACKGROUND;
        ResourceLocation loc = bg.getResourceLocation();
        Integer tile = bg.getTileSize();
        this.backgroundTintColor = bg.getColorModifier();
        this.backgroundRenderer = loc == null ? BackgroundRenderer.darkGradient() : (tile != null && tile > 0 ? new BackgroundRenderer().withTiledTexture(loc, tile) : new BackgroundRenderer().withTexture(loc));
        if (this.backgroundTintColor != null) {
            this.backgroundRenderer.withTint(this.backgroundTintColor);
        }
    }

    private void completeSelectedQuest() {
        if (this.selectedQuest != null && ClientQuestManager.getInstance().canCompleteQuest(this.selectedQuest.getId())) {
            NetworkManager.sendToServer(new QuestCompleteRequestPacket(this.selectedQuest.getId()));
        }
    }

    private void completeAllCompletableQuests() {
        List<Quest> list = ClientQuestManager.getInstance().getCompletableQuests();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Quest q : list) {
            NetworkManager.sendToServer(new QuestCompleteRequestPacket(q.getId()));
        }
    }

    private void openThemeEditor() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new ThemeEditorScreen(this));
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.backgroundRenderer != null) {
            this.backgroundRenderer.tick();
        }
    }

    private void filterByGroup(String group) {
        if (this.selectedGroup.equals(group)) {
            return;
        }
        this.selectedGroup = group;
        if (this.sidebar != null) {
            this.sidebar.setSelectedGroup(group);
        }
        this.reloadVisibleQuests();
        if (!this.visibleQuests.isEmpty()) {
            this.fitToScreen();
        } else {
            this.alignQuestPositions();
            this.resetScroll();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int hy;
        int hx;
        int panelH;
        int panelW;
        int panelY;
        int panelX;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.sidebar != null && this.sidebar.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.selectedQuest != null && button == 0 && this.lastDetailsCloseButtonRect != null) {
            int cbx = this.lastDetailsCloseButtonRect[0];
            int cby = this.lastDetailsCloseButtonRect[1];
            int cbw = this.lastDetailsCloseButtonRect[2];
            int cbh = this.lastDetailsCloseButtonRect[3];
            if (mouseX >= (double)cbx && mouseX <= (double)(cbx + cbw) && mouseY >= (double)cby && mouseY <= (double)(cby + cbh)) {
                this.selectedQuest = null;
                this.detailsPanelScroll = 0;
                return true;
            }
        }
        if (this.selectedQuest != null && button == 0 && this.formattedDescriptionWithImages != null) {
            panelX = this.f_96543_ - this.getDetailsPanelWidth() - 8;
            panelY = 30;
            panelW = this.getDetailsPanelWidth();
            panelH = this.f_96544_ - 70;
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
                int relativeX = (int)mouseX - this.descriptionPanelX - 6;
                int relativeY = (int)mouseY - panelY + this.detailsPanelScroll;
                int lineClicked = (relativeY - (this.descriptionStartY - panelY)) / 10;
                System.out.println("[Link Debug] Click at screen (" + mouseX + "," + mouseY + ") relative (" + relativeX + "," + relativeY + ") line: " + lineClicked);
                Style style = this.getStyleAtLinePosition(this.formattedDescriptionWithImages.getTextComponent(), relativeX, lineClicked);
                if (style != null) {
                    System.out.println("[Link Debug] Found style, clickEvent: " + (style.m_131182_() != null));
                    if (style.m_131182_() != null) {
                        System.out.println("[Link Debug] Click event action: " + String.valueOf(style.m_131182_().m_130622_()) + ", value: " + style.m_131182_().m_130623_());
                        if (this.m_5561_(style)) {
                            System.out.println("[Link Debug] Successfully handled click!");
                            return true;
                        }
                    }
                }
            }
        }
        if (this.selectedQuest != null && button == 0 && !this.checkmarkButtonRects.isEmpty()) {
            panelX = this.f_96543_ - this.getDetailsPanelWidth() - 8;
            panelY = 30;
            panelW = this.getDetailsPanelWidth();
            panelH = this.f_96544_ - 70;
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
                for (int[] btnRect : this.checkmarkButtonRects) {
                    int bx = btnRect[0];
                    int by = btnRect[1];
                    int bw = btnRect[2];
                    int bh = btnRect[3];
                    int requirementIndex = btnRect[4];
                    System.out.println("[Checkmark Debug] Click at (" + mouseX + "," + mouseY + "), Button at (" + bx + "," + by + "," + (bx + bw) + "," + (by + bh) + ")");
                    if (!(mouseX >= (double)bx) || !(mouseX <= (double)(bx + bw)) || !(mouseY >= (double)by) || !(mouseY <= (double)(by + bh))) continue;
                    System.out.println("[Checkmark] Button clicked! Sending completion for req index: " + requirementIndex);
                    NetworkManager.sendToServer(new RequirementCompletePacket(this.selectedQuest.getId(), requirementIndex));
                    return true;
                }
            }
        }
        if (this.showMiniMap && this.lastMiniMapRect != null && button == 0) {
            int x = this.lastMiniMapRect[0];
            int y = this.lastMiniMapRect[1];
            int w = this.lastMiniMapRect[2];
            int h = this.lastMiniMapRect[3];
            boolean insideMenu = false;
            if (this.miniMapSettingsOpen && (this.miniMapSizeOptionRects != null || this.miniMapOpacityOptionRects != null)) {
                if (this.miniMapSizeOptionRects != null) {
                    for (int[] r : this.miniMapSizeOptionRects) {
                        if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)(r[0] + r[2])) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)(r[1] + r[3]))) continue;
                        insideMenu = true;
                    }
                }
                if (this.miniMapOpacityOptionRects != null) {
                    for (int[] r : this.miniMapOpacityOptionRects) {
                        if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)(r[0] + r[2])) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)(r[1] + r[3]))) continue;
                        insideMenu = true;
                    }
                }
            }
            if (this.miniMapSettingsOpen && this.lastMiniMapGearRect != null && mouseX >= (double)this.lastMiniMapGearRect[0] && mouseX <= (double)(this.lastMiniMapGearRect[0] + this.lastMiniMapGearRect[2]) && mouseY >= (double)this.lastMiniMapGearRect[1] && mouseY <= (double)(this.lastMiniMapGearRect[1] + this.lastMiniMapGearRect[3])) {
                insideMenu = true;
            }
            if (this.miniMapSettingsOpen && !insideMenu) {
                this.miniMapSettingsOpen = false;
            }
            if (this.lastMiniMapGearRect != null && mouseX >= (double)this.lastMiniMapGearRect[0] && mouseX <= (double)(this.lastMiniMapGearRect[0] + this.lastMiniMapGearRect[2]) && mouseY >= (double)this.lastMiniMapGearRect[1] && mouseY <= (double)(this.lastMiniMapGearRect[1] + this.lastMiniMapGearRect[3])) {
                this.miniMapSettingsOpen = !this.miniMapSettingsOpen;
                return true;
            }
            if (this.miniMapSettingsOpen) {
                int i;
                if (this.miniMapSizeOptionRects != null) {
                    for (i = 0; i < this.miniMapSizeOptionRects.length; ++i) {
                        int nw;
                        int[] r = this.miniMapSizeOptionRects[i];
                        if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)(r[0] + r[2])) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)(r[1] + r[3]))) continue;
                        int n = i == 0 ? 140 : (nw = i == 1 ? 180 : 240);
                        int nh = i == 0 ? 90 : (i == 1 ? 120 : 160);
                        int nx = Math.max(0, Math.min(this.f_96543_ - nw - 8, x));
                        int ny = Math.max(0, Math.min(this.f_96544_ - nh - 8, y));
                        ClientConfig.setMiniMapRect(nx, ny, nw, nh);
                        this.miniMapSettingsOpen = false;
                        return true;
                    }
                }
                if (this.miniMapOpacityOptionRects != null) {
                    for (i = 0; i < this.miniMapOpacityOptionRects.length; ++i) {
                        int[] r = this.miniMapOpacityOptionRects[i];
                        if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)(r[0] + r[2])) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)(r[1] + r[3]))) continue;
                        int pct = switch (i) {
                            case 0 -> 0;
                            case 1 -> 25;
                            case 2 -> 50;
                            default -> 75;
                        };
                        ClientConfig.setMiniMapOpacityPct(pct);
                        this.miniMapSettingsOpen = false;
                        return true;
                    }
                }
            }
            if (this.lastMiniMapHeaderRect != null && mouseX >= (double)this.lastMiniMapHeaderRect[0] && mouseX <= (double)(this.lastMiniMapHeaderRect[0] + this.lastMiniMapHeaderRect[2]) && mouseY >= (double)this.lastMiniMapHeaderRect[1] && mouseY <= (double)(this.lastMiniMapHeaderRect[1] + this.lastMiniMapHeaderRect[3])) {
                long now = System.currentTimeMillis();
                if (now - this.lastHeaderClickMs < 300L) {
                    int nw = w;
                    int nh = h;
                    int[][] corners = new int[][]{{8, 8}, {this.f_96543_ - nw - 8, 8}, {8, this.f_96544_ - nh - 48}, {this.f_96543_ - nw - 8, this.f_96544_ - nh - 48}};
                    int bx = (int)mouseX;
                    int by = (int)mouseY;
                    double best = Double.MAX_VALUE;
                    int sel = 0;
                    for (int i = 0; i < corners.length; ++i) {
                        double dx = bx - corners[i][0];
                        double dy = by - corners[i][1];
                        double d = dx * dx + dy * dy;
                        if (!(d < best)) continue;
                        best = d;
                        sel = i;
                    }
                    int nx = Math.max(0, Math.min(this.f_96543_ - nw - 8, corners[sel][0]));
                    int ny = Math.max(0, Math.min(this.f_96544_ - nh - 8, corners[sel][1]));
                    ClientConfig.setMiniMapRect(nx, ny, nw, nh);
                    this.lastHeaderClickMs = 0L;
                    return true;
                }
                this.lastHeaderClickMs = now;
                this.miniMapMoving = true;
                this.miniMapMoveOffsetX = (int)mouseX - x;
                this.miniMapMoveOffsetY = (int)mouseY - y;
                return true;
            }
            if (this.lastMiniMapResizeRect != null && mouseX >= (double)this.lastMiniMapResizeRect[0] && mouseX <= (double)(this.lastMiniMapResizeRect[0] + this.lastMiniMapResizeRect[2]) && mouseY >= (double)this.lastMiniMapResizeRect[1] && mouseY <= (double)(this.lastMiniMapResizeRect[1] + this.lastMiniMapResizeRect[3])) {
                this.miniMapResizing = true;
                return true;
            }
            if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
                double nx = (mouseX - (double)x - 4.0) / Math.max(1.0, (double)(w - 8));
                double ny = (mouseY - (double)y - 4.0) / Math.max(1.0, (double)(h - 8));
                nx = Math.max(0.0, Math.min(1.0, nx));
                ny = Math.max(0.0, Math.min(1.0, ny));
                double bs = this.getQuestButtonSize();
                double bp = this.getQuestButtonSpacing();
                double totalW = Math.max(1.0, (this.questMaxX - this.questMinX) * (bs + bp));
                double totalH = Math.max(1.0, (this.questMaxY - this.questMinY) * (bs + bp));
                int graphLeft = 8 + (this.sidebar != null ? this.sidebar.getOccupiedWidth() : 0);
                int graphTop = 30;
                int graphRight = this.selectedQuest == null ? this.f_96543_ - 16 : this.f_96543_ - this.getDetailsPanelWidth() - 16;
                int graphBottom = this.f_96544_ - 40;
                double vw = graphRight - graphLeft;
                double vh = graphBottom - graphTop;
                double vx0 = nx * totalW - vw / 2.0;
                double vy0 = ny * totalH - vh / 2.0;
                this.scrollX = Math.max(0.0, Math.min(totalW - vw, vx0));
                this.scrollY = Math.max(0.0, Math.min(totalH - vh, vy0));
                this.miniMapDragging = true;
                return true;
            }
        }
        if (!"off".equals(this.heatmapMode) && this.lastHeatRect != null && button == 0) {
            hx = this.lastHeatRect[0];
            hy = this.lastHeatRect[1];
            if (this.lastHeatHeaderRect != null && mouseX >= (double)this.lastHeatHeaderRect[0] && mouseX <= (double)(this.lastHeatHeaderRect[0] + this.lastHeatHeaderRect[2]) && mouseY >= (double)this.lastHeatHeaderRect[1] && mouseY <= (double)(this.lastHeatHeaderRect[1] + this.lastHeatHeaderRect[3])) {
                this.heatMoving = true;
                this.heatMoveOffsetX = (int)mouseX - hx;
                this.heatMoveOffsetY = (int)mouseY - hy;
                return true;
            }
            if (this.lastHeatResizeRect != null && mouseX >= (double)this.lastHeatResizeRect[0] && mouseX <= (double)(this.lastHeatResizeRect[0] + this.lastHeatResizeRect[2]) && mouseY >= (double)this.lastHeatResizeRect[1] && mouseY <= (double)(this.lastHeatResizeRect[1] + this.lastHeatResizeRect[3])) {
                this.heatResizing = true;
                return true;
            }
        }
        if (QuestoryKeybindings.isPanButton(button)) {
            this.dragging = true;
            this.prevMouseX = (int)mouseX;
            this.prevMouseY = (int)mouseY;
            return true;
        }
        if (this.selectedQuest != null && button == 0 && this.lastDetailsHudPinRect != null) {
            hx = this.lastDetailsHudPinRect[0];
            hy = this.lastDetailsHudPinRect[1];
            int hw = this.lastDetailsHudPinRect[2];
            int hh = this.lastDetailsHudPinRect[3];
            int panelX2 = this.f_96543_ - this.getDetailsPanelWidth() - 8;
            int panelY2 = 30;
            int panelW2 = this.getDetailsPanelWidth();
            int panelH2 = this.f_96544_ - 70;
            if (mouseX >= (double)panelX2 && mouseX <= (double)(panelX2 + panelW2) && mouseY >= (double)panelY2 && mouseY <= (double)(panelY2 + panelH2) && mouseX >= (double)hx && mouseX <= (double)(hx + hw) && mouseY >= (double)hy && mouseY <= (double)(hy + hh)) {
                boolean isPinned = ClientConfig.isQuestTracked(this.selectedQuest.getId());
                if (isPinned) {
                    QuestHudOverlay.untrackQuest(this.selectedQuest.getId());
                } else {
                    QuestHudOverlay.trackQuest(this.selectedQuest.getId());
                }
                try {
                    MapCompatManager.onClientDataChanged();
                }
                catch (Throwable bs) {
                    // empty catch block
                }
                return true;
            }
        }
        int graphLeft = 8 + (this.sidebar != null ? this.sidebar.getOccupiedWidth() : 0);
        int graphTop = 30;
        double bs = this.getQuestButtonSize();
        boolean clickedQuest = false;
        for (Quest q : this.visibleQuests) {
            int[] p = this.gridToScreen(q.getX(), q.getY(), graphLeft, graphTop);
            int size = this.computeQuestIconSize(q, (int)Math.round(bs));
            int x = p[0] - size / 2;
            int y = p[1] - size / 2;
            QuestShape shape = QuestShape.get(q.getShape());
            if (!shape.contains(x, y, size, (int)mouseX, (int)mouseY)) continue;
            try {
                if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get() == 1 && this.f_96541_ != null) {
                    this.f_96541_.m_91152_((Screen)new QuestScreen(q.getId()));
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.selectedQuest = q;
            this.detailsPanelScroll = 0;
            clickedQuest = true;
            return true;
        }
        if (!clickedQuest && button == 0) {
            if (this.selectedQuest != null) {
                boolean clickInDetailsPanel;
                int panelX3 = this.f_96543_ - this.getDetailsPanelWidth() - 8;
                int panelY3 = 30;
                int panelW3 = this.getDetailsPanelWidth();
                int panelH3 = this.f_96544_ - 70;
                boolean bl = clickInDetailsPanel = mouseX >= (double)panelX3 && mouseX <= (double)(panelX3 + panelW3) && mouseY >= (double)panelY3 && mouseY <= (double)(panelY3 + panelH3);
                if (!clickInDetailsPanel) {
                    this.selectedQuest = null;
                    this.detailsPanelScroll = 0;
                }
            } else {
                this.selectedQuest = null;
                this.detailsPanelScroll = 0;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (QuestoryKeybindings.isPanButton(button) && this.dragging) {
            this.dragging = false;
            return true;
        }
        if (button == 0 && this.miniMapDragging) {
            this.miniMapDragging = false;
            return true;
        }
        if (button == 0 && this.miniMapMoving) {
            this.miniMapMoving = false;
            return true;
        }
        if (button == 0 && this.miniMapResizing) {
            this.miniMapResizing = false;
            return true;
        }
        if (button == 0 && this.heatMoving) {
            this.heatMoving = false;
            return true;
        }
        if (button == 0 && this.heatResizing) {
            this.heatResizing = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.miniMapDragging && button == 0 && this.lastMiniMapRect != null) {
            int x = this.lastMiniMapRect[0];
            int y = this.lastMiniMapRect[1];
            int w = this.lastMiniMapRect[2];
            int h = this.lastMiniMapRect[3];
            double nx = (mouseX - (double)x - 4.0) / Math.max(1.0, (double)(w - 8));
            double ny = (mouseY - (double)y - 4.0) / Math.max(1.0, (double)(h - 8));
            nx = Math.max(0.0, Math.min(1.0, nx));
            ny = Math.max(0.0, Math.min(1.0, ny));
            double bs = this.getQuestButtonSize();
            double bp = this.getQuestButtonSpacing();
            double totalW = Math.max(1.0, (this.questMaxX - this.questMinX) * (bs + bp));
            double totalH = Math.max(1.0, (this.questMaxY - this.questMinY) * (bs + bp));
            int graphLeft = 8 + (this.sidebar != null ? this.sidebar.getOccupiedWidth() : 0);
            int graphTop = 30;
            int graphRight = this.selectedQuest == null ? this.f_96543_ - 16 : this.f_96543_ - this.getDetailsPanelWidth() - 16;
            int graphBottom = this.f_96544_ - 40;
            double vw = graphRight - graphLeft;
            double vh = graphBottom - graphTop;
            double vx0 = nx * totalW - vw / 2.0;
            double vy0 = ny * totalH - vh / 2.0;
            this.scrollX = Math.max(0.0, Math.min(totalW - vw, vx0));
            this.scrollY = Math.max(0.0, Math.min(totalH - vh, vy0));
            return true;
        }
        if (this.miniMapMoving && button == 0 && this.lastMiniMapRect != null) {
            int w = this.lastMiniMapRect[2];
            int h = this.lastMiniMapRect[3];
            int nx = (int)mouseX - this.miniMapMoveOffsetX;
            int ny = (int)mouseY - this.miniMapMoveOffsetY;
            nx = Math.max(0, Math.min(this.f_96543_ - w - 8, nx));
            ny = Math.max(0, Math.min(this.f_96544_ - h - 8, ny));
            ClientConfig.setMiniMapRect(nx, ny, w, h);
            return true;
        }
        if (this.miniMapResizing && button == 0 && this.lastMiniMapRect != null) {
            int x = this.lastMiniMapRect[0];
            int y = this.lastMiniMapRect[1];
            int nw = Math.max(120, (int)mouseX - x);
            int nh = Math.max(80, (int)mouseY - y);
            nw = Math.min(nw, this.f_96543_ - x - 8);
            nh = Math.min(nh, this.f_96544_ - y - 8);
            ClientConfig.setMiniMapRect(x, y, nw, nh);
            return true;
        }
        if (this.heatMoving && button == 0 && this.lastHeatRect != null) {
            int w = this.lastHeatRect[2];
            int h = this.lastHeatRect[3];
            int nx = (int)mouseX - this.heatMoveOffsetX;
            int ny = (int)mouseY - this.heatMoveOffsetY;
            nx = Math.max(0, Math.min(this.f_96543_ - w - 8, nx));
            ny = Math.max(0, Math.min(this.f_96544_ - h - 8, ny));
            ClientConfig.setHeatRect(nx, ny, w, h);
            return true;
        }
        if (this.heatResizing && button == 0 && this.lastHeatRect != null) {
            int x = this.lastHeatRect[0];
            int y = this.lastHeatRect[1];
            int nw = Math.max(140, (int)mouseX - x);
            int nh = Math.max(50, (int)mouseY - y);
            nw = Math.min(nw, this.f_96543_ - x - 8);
            nh = Math.min(nh, this.f_96544_ - y - 8);
            ClientConfig.setHeatRect(x, y, nw, nh);
            return true;
        }
        if (this.dragging && QuestoryKeybindings.isPanButton(button)) {
            int graphWidth = this.selectedQuest == null ? this.f_96543_ - 16 : this.f_96543_ - this.getDetailsPanelWidth() - 16;
            int graphHeight = this.f_96544_ - 70;
            int mx = (int)mouseX;
            int my = (int)mouseY;
            this.scrollX = this.scrollWidth > (double)graphWidth ? Math.max(0.0, Math.min(this.scrollWidth - (double)graphWidth, this.scrollX + (double)(this.prevMouseX - mx))) : (this.scrollWidth - (double)graphWidth) / 2.0;
            this.scrollY = this.scrollHeight > (double)graphHeight ? Math.max(0.0, Math.min(this.scrollHeight - (double)graphHeight, this.scrollY + (double)(this.prevMouseY - my))) : (this.scrollHeight - (double)graphHeight) / 2.0;
            this.prevMouseX = mx;
            this.prevMouseY = my;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 70) {
            this.fitToScreen();
            return true;
        }
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 61 || keyCode == 334) {
            this.addZoom(1.0, (double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0);
            return true;
        }
        if (keyCode == 45 || keyCode == 333) {
            this.addZoom(-1.0, (double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0);
            return true;
        }
        if (keyCode == 67) {
            this.resetScroll();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        if (this.selectedQuest != null && this.formattedDescriptionWithImages != null) {
            int panelX = this.f_96543_ - this.getDetailsPanelWidth() - 8;
            int panelY = 30;
            int panelW = this.getDetailsPanelWidth();
            int panelH = this.f_96544_ - 70;
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
                int relativeX = (int)mouseX - this.descriptionPanelX - 6;
                int relativeY = (int)mouseY - this.descriptionStartY + this.detailsPanelScroll;
                if (relativeY >= 0) {
                    Component hoverText;
                    int lineHovered = (relativeY - (this.descriptionStartY - panelY)) / 10;
                    Style style = this.getStyleAtLinePosition(this.formattedDescriptionWithImages.getTextComponent(), relativeX, lineHovered);
                    if (style != null && style.m_131186_() != null && (hoverText = (Component)style.m_131186_().m_130823_(HoverEvent.Action.f_130831_)) != null) {
                        this.m_257404_(hoverText);
                    }
                }
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.sidebar != null && this.sidebar.mouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.selectedQuest != null) {
            int panelX = this.f_96543_ - this.getDetailsPanelWidth() - 8;
            int panelY = 30;
            int panelW = this.getDetailsPanelWidth();
            int panelH = this.f_96544_ - 70;
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
                int maxScroll = Math.max(0, this.detailsPanelContentHeight - panelH);
                this.detailsPanelScroll = (int)Math.max(0.0, Math.min((double)maxScroll, (double)this.detailsPanelScroll - delta * 15.0));
                return true;
            }
        }
        this.addZoom(delta, mouseX, mouseY);
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private static class QuestRenderCache {
        int[] screenPos;
        int iconSize;
        int lastZoom;
        double lastScrollX;
        double lastScrollY;
        int lastGraphLeft;
        int lastGraphTop;

        private QuestRenderCache() {
        }

        boolean isValid(int currentZoom, double scrollX, double scrollY, int graphLeft, int graphTop) {
            return this.lastZoom == currentZoom && this.lastScrollX == scrollX && this.lastScrollY == scrollY && this.lastGraphLeft == graphLeft && this.lastGraphTop == graphTop;
        }

        void update(int[] pos, int size, int z, double sx, double sy, int gl, int gt) {
            this.screenPos = pos;
            this.iconSize = size;
            this.lastZoom = z;
            this.lastScrollX = sx;
            this.lastScrollY = sy;
            this.lastGraphLeft = gl;
            this.lastGraphTop = gt;
        }
    }
}

