/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.gui.ClientInputHelper;
import org.texboobcat.questory.client.gui.FormattedTextWithImages;
import org.texboobcat.questory.client.gui.ImageRenderer;
import org.texboobcat.questory.client.gui.QuestHudOverlay;
import org.texboobcat.questory.client.gui.QuestIconRenderer;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.client.hooks.ClientHooks;
import org.texboobcat.questory.client.rendering.ThemeIconRenderer;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestCompleteRequestPacket;
import org.texboobcat.questory.network.RequirementCompletePacket;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.panel.BindingContext;
import org.texboobcat.questory.theme.panel.PanelRenderer;
import org.texboobcat.questory.theme.panel.PanelTemplate;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class QuestScreen
extends Screen
implements ClientQuestManager.ProgressUpdateListener {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("questory", "textures/gui/quest_background.png");
    private static final int QUEST_LIST_X = 10;
    private static final int QUEST_LIST_Y = 30;
    private static final int QUEST_LIST_WIDTH = 200;
    private static final int QUEST_ITEM_HEIGHT = 25;
    private List<Quest> visibleQuests;
    private Quest selectedQuest;
    private int scrollOffset = 0;
    private String selectedGroup = "all";
    private final String preselectQuestId;
    private boolean fullScreen = false;
    private List<Button> checkmarkButtons = new ArrayList<Button>();
    private EditBox searchBox;
    private String searchText = "";
    private PanelRenderer panelRenderer;
    private BindingContext panelContext;

    public QuestScreen() {
        this(null);
    }

    public QuestScreen(String preselectQuestId) {
        super((Component)Component.m_237113_((String)"Quests"));
        this.preselectQuestId = preselectQuestId;
    }

    protected void m_7856_() {
        Quest q;
        super.m_7856_();
        this.panelRenderer = new PanelRenderer();
        this.setupPanelEventHandlers();
        this.visibleQuests = new ArrayList<Quest>(ClientQuestManager.getInstance().getVisibleQuests());
        this.visibleQuests.sort((a, b) -> {
            boolean bComplete;
            boolean aComplete = ClientQuestManager.getInstance().isQuestCompleted(a.getId());
            if (aComplete != (bComplete = ClientQuestManager.getInstance().isQuestCompleted(b.getId()))) {
                return aComplete ? 1 : -1;
            }
            return a.getTitle().compareTo(b.getTitle());
        });
        try {
            this.fullScreen = (Integer)ThemeProperties.FULL_SCREEN_QUEST.get() == 1 && this.preselectQuestId != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.preselectQuestId != null && (q = ClientQuestManager.getInstance().getQuest(this.preselectQuestId)) != null) {
            this.selectedQuest = q;
            this.updateCheckmarkButtons();
            this.updateCheckmarkEventHandlers();
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.m_7379_()).m_252987_(this.f_96543_ - 80, this.f_96544_ - 30, 70, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Complete"), button -> this.completeSelectedQuest()).m_252987_(this.f_96543_ - 160, this.f_96544_ - 30, 70, 20).m_253136_());
        try {
            int btnW = 70;
            int btnH = 20;
            int gap = 6;
            int actionRightOf = this.f_96543_ - 160;
            int nextX = actionRightOf - gap;
            for (ClientHooks.ButtonSpec spec : ClientHooks.getActionButtons()) {
                Runnable action = spec.onClick;
                int x = nextX - btnW;
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)spec.title), b -> {
                    if (action != null) {
                        action.run();
                    }
                }).m_252987_(x, this.f_96544_ - 30, btnW, btnH).m_253136_());
                nextX = x - gap;
            }
        }
        catch (Throwable btnW) {
            // empty catch block
        }
        int groupX = 10;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"All"), button -> this.filterByGroup("all")).m_252987_(groupX, 5, 50, 20).m_253136_());
        groupX += 55;
        Iterator<String> iterator = ClientQuestManager.getInstance().getQuestGroups().iterator();
        while (iterator.hasNext()) {
            String group;
            String g = group = iterator.next();
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)group), button -> this.filterByGroup(g)).m_252987_(groupX, 5, 80, 20).m_253136_());
            if ((groupX += 85) <= this.f_96543_ - 220) continue;
            break;
        }
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ - 210, 5, 120, 20, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94151_(text -> {
            this.searchText = text;
            this.scrollOffset = 0;
            this.filterQuests();
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        ClientQuestManager.getInstance().addProgressListener(this);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        if (this.fullScreen && this.selectedQuest != null) {
            this.renderQuestDetailsFullScreen(graphics);
        } else {
            this.renderQuestList(graphics, mouseX, mouseY);
            if (this.selectedQuest != null) {
                this.renderQuestDetails(graphics);
            }
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
    }

    private void renderQuestList(GuiGraphics graphics, int mouseX, int mouseY) {
        int x = 10;
        int y = 30;
        int maxVisible = (this.f_96544_ - y - 40) / 25;
        graphics.m_280509_(x - 2, y - 2, x + 200 + 2, this.f_96544_ - 35, Integer.MIN_VALUE);
        for (int i = this.scrollOffset; i < Math.min(this.scrollOffset + maxVisible, this.visibleQuests.size()); ++i) {
            Quest quest = this.visibleQuests.get(i);
            int itemY = y + (i - this.scrollOffset) * 25;
            this.renderQuestListItem(graphics, quest, x, itemY, mouseX, mouseY);
        }
    }

    private void renderQuestListItem(GuiGraphics graphics, Quest quest, int x, int y, int mouseX, int mouseY) {
        boolean isCompleted = ClientQuestManager.getInstance().isQuestCompleted(quest.getId());
        boolean canComplete = ClientQuestManager.getInstance().canCompleteQuest(quest.getId());
        boolean isHovered = mouseX >= x && mouseX <= x + 200 && mouseY >= y && mouseY <= y + 25;
        boolean isSelected = quest.equals(this.selectedQuest);
        int bgColor = isSelected ? -12303105 : (isHovered ? -13421773 : (isCompleted ? -16733696 : (canComplete ? -22016 : -14540254)));
        graphics.m_280509_(x, y, x + 200, y + 25 - 1, bgColor);
        QuestIconRenderer.render(graphics, quest.getIcon(), x + 4, y + 4, 16);
        Component formattedTitle = TextFormatter.parse(quest.getTitle());
        if (this.f_96547_.m_92852_((FormattedText)formattedTitle) > 170) {
            String plainTitle = formattedTitle.getString();
            String truncated = this.f_96547_.m_92834_(plainTitle, 160) + "...";
            formattedTitle = Component.m_237113_((String)truncated);
        }
        graphics.m_280430_(this.f_96547_, formattedTitle, x + 25, y + 8, 0xFFFFFF);
    }

    private void renderQuestDetails(GuiGraphics graphics) {
        int statusColor;
        String status;
        int x = 230;
        int y = 30;
        int width = this.f_96543_ - x - 20;
        int height = this.f_96544_ - y - 40;
        if (this.tryRenderWithPanel(graphics, x, y, width, height)) {
            return;
        }
        IconProperty qvbg = ThemeProperties.QUEST_VIEW_BACKGROUND;
        if (qvbg.getResourceLocation() != null || qvbg.getColorModifier() != null || "builtin".equals(qvbg.getTexturePath())) {
            ThemeIconRenderer.draw(graphics, qvbg, x - 2, y - 2, width + 4, height + 4);
        } else {
            graphics.m_280509_(x - 2, y - 2, x + width + 2, y + height + 2, Integer.MIN_VALUE);
        }
        int contentY = y + 5;
        Component formattedTitle = TextFormatter.parse(this.selectedQuest.getTitle());
        graphics.m_280430_(this.f_96547_, formattedTitle, x + 5, contentY, 0xFFFFFF);
        contentY += 15;
        String desc = this.selectedQuest.getDescription();
        if (!desc.isEmpty()) {
            FormattedTextWithImages formatted = TextFormatter.parseWithImages(desc);
            Iterator<Reward> descLines = this.f_96547_.m_92923_((FormattedText)formatted.getTextComponent(), width - 10);
            int textStartY = contentY;
            Iterator iterator = descLines.iterator();
            while (iterator.hasNext()) {
                FormattedCharSequence line = (FormattedCharSequence)iterator.next();
                graphics.m_280648_(this.f_96547_, line, x + 5, contentY, -1);
                contentY += 10;
            }
            if (formatted.hasImages()) {
                int imageHeight = ImageRenderer.renderAllImages(graphics, formatted, x + 5, textStartY, width - 10, 10);
                contentY += imageHeight;
            }
        }
        graphics.m_280488_(this.f_96547_, "Requirements:", x + 5, contentY += 5, 0xFFFF55);
        contentY += 12;
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        for (Requirement req : this.selectedQuest.getRequirements()) {
            IconProperty iconProp;
            String reqText = req.getProgressDisplay(progress, this.selectedQuest.getId());
            boolean met = req.isMet(progress, this.selectedQuest.getId());
            int iconSize = 9;
            int ix = x + 5;
            int iy = contentY + 1;
            IconProperty iconProperty = iconProp = met ? ThemeProperties.CHECKMARK_TASK_ACTIVE : ThemeProperties.CHECKMARK_TASK_INACTIVE;
            if (iconProp.getResourceLocation() != null || iconProp.getColorModifier() != null || "builtin".equals(iconProp.getTexturePath())) {
                ThemeIconRenderer.draw(graphics, iconProp, ix, iy, iconSize, iconSize);
                graphics.m_280488_(this.f_96547_, "  " + reqText, ix + iconSize + 2, contentY, 0xFFFFFF);
            } else {
                graphics.m_280488_(this.f_96547_, (met ? "\u2713 " : "  \u2022 ") + reqText, ix, contentY, 0xFFFFFF);
            }
            contentY += 10;
        }
        contentY += 5;
        if (!this.selectedQuest.getRewards().isEmpty()) {
            graphics.m_280488_(this.f_96547_, "Rewards:", x + 5, contentY, 0xFFFF55);
            contentY += 12;
            for (Reward reward : this.selectedQuest.getRewards()) {
                String rewardText = reward.getDisplayString();
                graphics.m_280488_(this.f_96547_, "  \u2022 " + rewardText, x + 5, contentY, 0x55FF55);
                contentY += 10;
            }
        }
        contentY += 10;
        boolean isCompleted = ClientQuestManager.getInstance().isQuestCompleted(this.selectedQuest.getId());
        boolean canComplete = ClientQuestManager.getInstance().canCompleteQuest(this.selectedQuest.getId());
        if (isCompleted) {
            status = "\u2713 Completed";
            statusColor = 65280;
        } else if (canComplete) {
            status = "Ready to complete!";
            statusColor = 0xFFAA00;
        } else {
            status = "In progress";
            statusColor = 0xFFFFFF;
        }
        graphics.m_280488_(this.f_96547_, "Status: " + status, x + 5, contentY, statusColor);
    }

    private void renderQuestDetailsFullScreen(GuiGraphics graphics) {
        int x = 10;
        int y = 10;
        int width = this.f_96543_ - 20;
        int height = this.f_96544_ - 50;
        if (this.tryRenderWithPanel(graphics, x, y, width, height)) {
            return;
        }
        IconProperty qvbg = ThemeProperties.QUEST_VIEW_BACKGROUND;
        if (qvbg.getResourceLocation() != null || qvbg.getColorModifier() != null || "builtin".equals(qvbg.getTexturePath())) {
            ThemeIconRenderer.draw(graphics, qvbg, x, y, width, height);
        } else {
            graphics.m_280509_(x, y, x + width, y + height, -1610612736);
        }
        int contentY = y + 8;
        Component formattedTitle = TextFormatter.parse(this.selectedQuest.getTitle());
        graphics.m_280430_(this.f_96547_, formattedTitle, x + 8, contentY, 0xFFFFFF);
        QuestIconRenderer.render(graphics, this.selectedQuest.getIcon(), x + 8, contentY += 14, 24);
        contentY += 28;
        String desc = this.selectedQuest.getDescription();
        if (!desc.isEmpty()) {
            FormattedTextWithImages formatted = TextFormatter.parseWithImages(desc);
            List descLines = this.f_96547_.m_92923_((FormattedText)formatted.getTextComponent(), width - 16);
            int textStartY = contentY;
            for (FormattedCharSequence line : descLines) {
                graphics.m_280648_(this.f_96547_, line, x + 8, contentY, -1);
                contentY += 10;
            }
            if (formatted.hasImages()) {
                int imageHeight = ImageRenderer.renderAllImages(graphics, formatted, x + 8, textStartY, width - 16, 10);
                contentY += imageHeight;
            }
        }
        graphics.m_280488_(this.f_96547_, "Requirements:", x + 8, contentY += 8, ((Integer)ThemeProperties.TASKS_TEXT_COLOR.get()).intValue());
        contentY += 12;
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        for (Requirement req : this.selectedQuest.getRequirements()) {
            IconProperty iconProp;
            String reqText = req.getProgressDisplay(progress, this.selectedQuest.getId());
            boolean met = req.isMet(progress, this.selectedQuest.getId());
            int iconSize = 10;
            int ix = x + 8;
            int iy = contentY + 1;
            IconProperty iconProperty = iconProp = met ? ThemeProperties.CHECKMARK_TASK_ACTIVE : ThemeProperties.CHECKMARK_TASK_INACTIVE;
            if (iconProp.getResourceLocation() != null || iconProp.getColorModifier() != null || "builtin".equals(iconProp.getTexturePath())) {
                ThemeIconRenderer.draw(graphics, iconProp, ix, iy, iconSize, iconSize);
                graphics.m_280488_(this.f_96547_, "  " + reqText, ix + iconSize + 2, contentY, ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
            } else {
                graphics.m_280488_(this.f_96547_, (met ? "\u2713 " : "  \u2022 ") + reqText, ix, contentY, ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
            }
            contentY += 10;
        }
        if (!this.selectedQuest.getRewards().isEmpty()) {
            graphics.m_280488_(this.f_96547_, "Rewards:", x + 8, contentY, ((Integer)ThemeProperties.REWARDS_TEXT_COLOR.get()).intValue());
            contentY += 12;
            for (Reward reward : this.selectedQuest.getRewards()) {
                graphics.m_280488_(this.f_96547_, "  \u2022 " + reward.getDisplayString(), x + 8, contentY, ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
                contentY += 10;
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int clickedIndex;
        if (mouseX >= 10.0 && mouseX <= 210.0 && mouseY >= 30.0 && (clickedIndex = ((int)mouseY - 30) / 25 + this.scrollOffset) >= 0 && clickedIndex < this.visibleQuests.size()) {
            this.selectedQuest = this.visibleQuests.get(clickedIndex);
            this.updatePanelContext();
            this.updateCheckmarkButtons();
            this.updateCheckmarkEventHandlers();
            return true;
        }
        if (this.selectedQuest != null && this.panelRenderer != null && this.panelRenderer.handleClick((int)mouseX, (int)mouseY)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (mouseX >= 10.0 && mouseX <= 210.0) {
            this.scrollOffset = Math.max(0, this.scrollOffset - (int)delta);
            int maxScroll = Math.max(0, this.visibleQuests.size() - (this.f_96544_ - 30 - 40) / 25);
            this.scrollOffset = Math.min(this.scrollOffset, maxScroll);
            return true;
        }
        if (this.selectedQuest != null && this.panelRenderer != null) {
            this.panelRenderer.handleScroll(delta);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void updateCheckmarkButtons() {
        int contentY;
        for (Button btn2 : this.checkmarkButtons) {
            this.m_169411_((GuiEventListener)btn2);
        }
        this.checkmarkButtons.clear();
        if (this.selectedQuest == null) {
            return;
        }
        int x = 230;
        int y = 30;
        int width = this.f_96543_ - x - 20;
        if (this.fullScreen) {
            x = 10;
            y = 10;
            width = this.f_96543_ - 20;
            contentY = y + 8;
            contentY += 14;
            contentY += 28;
        } else {
            contentY = y + 5;
            contentY += 15;
        }
        String desc = this.selectedQuest.getDescription();
        if (!desc.isEmpty()) {
            FormattedTextWithImages formatted = TextFormatter.parseWithImages(desc);
            List descLines = this.f_96547_.m_92923_((FormattedText)formatted.getTextComponent(), this.fullScreen ? width - 16 : width - 10);
            contentY += descLines.size() * 10;
            if (formatted.hasImages()) {
                int imageHeight = 0;
                for (FormattedTextWithImages.ImageElement img : formatted.getImages()) {
                    imageHeight += img.getHeight() + 2;
                }
                contentY += imageHeight;
            }
        }
        contentY += this.fullScreen ? 8 : 5;
        contentY += 12;
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        List<Requirement> requirements = this.selectedQuest.getRequirements();
        int iconX = this.fullScreen ? x + 8 : x + 5;
        for (int i = 0; i < requirements.size(); ++i) {
            Requirement req = requirements.get(i);
            if (req instanceof CheckmarkRequirement && !req.isMet(progress, this.selectedQuest.getId())) {
                int reqIndex = i;
                Button checkBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2610"), btn -> this.completeCheckmarkRequirement(reqIndex)).m_252987_(iconX, contentY - 1, 12, 12).m_253136_();
                this.m_142416_((GuiEventListener)checkBtn);
                this.checkmarkButtons.add(checkBtn);
            }
            contentY += 10;
        }
    }

    private void completeCheckmarkRequirement(int requirementIndex) {
        if (this.selectedQuest != null) {
            NetworkManager.sendToServer(new RequirementCompletePacket(this.selectedQuest.getId(), requirementIndex));
            new Thread(() -> {
                try {
                    Thread.sleep(100L);
                    this.f_96541_.execute(this::updateCheckmarkButtons);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
    }

    private void completeSelectedQuest() {
        if (this.selectedQuest != null && ClientQuestManager.getInstance().canCompleteQuest(this.selectedQuest.getId())) {
            NetworkManager.sendToServer(new QuestCompleteRequestPacket(this.selectedQuest.getId()));
        }
    }

    private void filterByGroup(String group) {
        this.selectedGroup = group;
        this.scrollOffset = 0;
        this.visibleQuests = "all".equals(group) ? new ArrayList<Quest>(ClientQuestManager.getInstance().getVisibleQuests()) : ClientQuestManager.getInstance().getQuestsByGroup(group).stream().filter(q -> q.isVisible(ClientQuestManager.getInstance().getProgress())).collect(Collectors.toList());
        this.visibleQuests.sort((a, b) -> {
            boolean bComplete;
            boolean aComplete = ClientQuestManager.getInstance().isQuestCompleted(a.getId());
            if (aComplete != (bComplete = ClientQuestManager.getInstance().isQuestCompleted(b.getId()))) {
                return aComplete ? 1 : -1;
            }
            return a.getTitle().compareTo(b.getTitle());
        });
    }

    private void filterQuests() {
        this.visibleQuests = "all".equals(this.selectedGroup) ? new ArrayList<Quest>(ClientQuestManager.getInstance().getVisibleQuests()) : ClientQuestManager.getInstance().getQuestsByGroup(this.selectedGroup).stream().filter(q -> q.isVisible(ClientQuestManager.getInstance().getProgress())).collect(Collectors.toList());
        if (this.searchText != null && !this.searchText.isEmpty()) {
            String lowerSearch = this.searchText.toLowerCase();
            this.visibleQuests = this.visibleQuests.stream().filter(q -> q.getTitle().toLowerCase().contains(lowerSearch) || q.getDescription().toLowerCase().contains(lowerSearch)).collect(Collectors.toList());
        }
        this.visibleQuests.sort((a, b) -> {
            boolean bComplete;
            boolean aComplete = ClientQuestManager.getInstance().isQuestCompleted(a.getId());
            if (aComplete != (bComplete = ClientQuestManager.getInstance().isQuestCompleted(b.getId()))) {
                return aComplete ? 1 : -1;
            }
            return a.getTitle().compareTo(b.getTitle());
        });
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (ClientInputHelper.isSearch(keyCode, scanCode)) {
            if (this.searchBox != null) {
                this.searchBox.m_93692_(true);
            }
            return true;
        }
        if (keyCode == 257) {
            if (this.searchBox != null && this.searchBox.m_93696_()) {
                return true;
            }
            if (this.selectedQuest != null) {
                this.completeSelectedQuest();
                return true;
            }
        }
        if (this.searchBox != null && this.searchBox.m_93696_() && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_93696_() && this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private List<String> splitText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private boolean tryRenderWithPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        if (this.selectedQuest == null || QuestTheme.instance == null) {
            return false;
        }
        PanelTemplate template = QuestTheme.instance.getPanel("quest_details");
        if (template == null) {
            return false;
        }
        if (this.panelContext == null) {
            this.updatePanelContext();
        }
        if (this.panelRenderer != null) {
            this.panelRenderer.render(template, this.panelContext, graphics, x, y, width, height);
            return true;
        }
        return false;
    }

    private void updatePanelContext() {
        if (this.selectedQuest != null) {
            this.panelContext = new BindingContext(this.selectedQuest, ClientQuestManager.getInstance().getProgress());
        }
    }

    private void setupPanelEventHandlers() {
        if (this.panelRenderer == null) {
            return;
        }
        this.panelRenderer.registerEventHandler("completeQuest", this::completeSelectedQuest);
        this.updateCheckmarkEventHandlers();
        this.panelRenderer.registerEventHandler("toggleTrack", () -> {
            if (this.selectedQuest != null) {
                boolean isTracked = ClientConfig.isQuestTracked(this.selectedQuest.getId());
                if (isTracked) {
                    QuestHudOverlay.untrackQuest(this.selectedQuest.getId());
                } else {
                    QuestHudOverlay.trackQuest(this.selectedQuest.getId());
                }
            }
        });
        this.panelRenderer.registerEventHandler("close", this::m_7379_);
    }

    private void updateCheckmarkEventHandlers() {
        if (this.panelRenderer == null || this.selectedQuest == null) {
            return;
        }
        List<Requirement> requirements = this.selectedQuest.getRequirements();
        for (int i = 0; i < requirements.size(); ++i) {
            int index = i;
            this.panelRenderer.registerEventHandler("completeRequirement_" + i, () -> this.completeCheckmarkRequirement(index));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        ClientQuestManager.getInstance().removeProgressListener(this);
        super.m_7379_();
    }

    @Override
    public void onProgressUpdated() {
        Quest updated;
        this.filterQuests();
        if (this.selectedQuest != null && (updated = ClientQuestManager.getInstance().getQuest(this.selectedQuest.getId())) != null) {
            this.selectedQuest = updated;
            this.updatePanelContext();
            this.updateCheckmarkButtons();
        }
    }
}

