/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.rendering.CustomShapeRenderer;
import org.texboobcat.questory.shape.ShapeDef;
import org.texboobcat.questory.shape.ShapeRegistry;

public class ShapeDesignerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> onApplyShapeId;
    private EditBox idBox;
    private EditBox nameBox;
    private EditBox pointsBox;
    private EditBox circleCx;
    private EditBox circleCy;
    private EditBox circleR;
    private EditBox gearTeeth;
    private EditBox gearInnerR;
    private EditBox gearOuterR;
    private EditBox gearHoleR;
    private Button addPolygonBtn;
    private Button addCircleBtn;
    private Button addGearBtn;
    private Button saveBtn;
    private Button applyBtn;
    private Button cancelBtn;
    private Button templateCircleBtn;
    private Button templateHexBtn;
    private Button templateStarBtn;
    private Button templateGearBtn;
    private Button clearBtn;
    private Button gridToggleBtn;
    private Button brushBtn;
    private Button eraserBtn;
    private Button sizeMinusBtn;
    private Button sizePlusBtn;
    private Button clearIconBtn;
    private Button exportIconBtn;
    private Button useAsIconBtn;
    private Button undoBtn;
    private Button redoBtn;
    private Button eyedropperBtn;
    private EditBox colorHexBox;
    private int brushSize = 4;
    private int brushColor = -1;
    private boolean erasing = false;
    private boolean drawing = false;
    private boolean eyedropper = false;
    private boolean strokeSnapshotTaken = false;
    private int lastDrawX = -1;
    private int lastDrawY = -1;
    private int[] previewRect = null;
    private static final int ICON_W = 128;
    private static final int ICON_H = 128;
    private static final long UPLOAD_INTERVAL_NS_DRAW = 150000000L;
    private int[] iconPixels = new int[16384];
    private boolean showGrid = true;
    private boolean livePreview = true;
    private boolean[] shapeMask128;
    private boolean[] shapeMaskLow;
    private DynamicTexture canvasTexture;
    private NativeImage canvasImage;
    private ResourceLocation canvasRL;
    private boolean canvasDirty = false;
    private long lastUploadNs = 0L;
    private boolean needCanvasSync = false;
    private static final int LIVE_W = 64;
    private static final int LIVE_H = 64;
    private NativeImage liveImage;
    private DynamicTexture liveTexture;
    private ResourceLocation liveRL;
    private boolean liveDirty = false;
    private long lastLiveUploadNs = 0L;
    private boolean hasLiveStroke = false;
    private static final long LIVE_UPLOAD_INTERVAL_NS = 16000000L;
    private static final Map<Integer, short[]> BRUSH_MASKS = new HashMap<Integer, short[]>();
    private final Deque<int[]> undoStack = new ArrayDeque<int[]>();
    private final Deque<int[]> redoStack = new ArrayDeque<int[]>();
    private final ShapeDef working = new ShapeDef();

    public ShapeDesignerScreen(Screen parent, String initialId, Consumer<String> onApplyShapeId) {
        super((Component)Component.m_237113_((String)"Shape Designer"));
        this.parent = parent;
        this.onApplyShapeId = onApplyShapeId;
        this.working.displayName = this.working.id = initialId == null || initialId.isBlank() ? "my_shape" : ShapeDesignerScreen.sanitize(initialId);
        this.working.viewBox = new double[]{0.0, 0.0, 1.0, 1.0};
        this.working.hitTest = "auto";
    }

    protected void m_7856_() {
        int ix;
        int iy;
        int panelW = 520;
        int x = Math.max(12, this.f_96543_ / 2 - panelW / 2);
        int y = Math.max(20, this.f_96544_ / 2 - 110);
        int pvSize = Math.min(240, this.f_96544_ - 120);
        int pvX = x;
        int pvY = y;
        this.previewRect = new int[]{pvX, pvY, pvSize, pvSize};
        this.rebuildMask128();
        if (this.canvasImage == null) {
            this.canvasImage = new NativeImage(128, 128, true);
            for (iy = 0; iy < 128; ++iy) {
                for (ix = 0; ix < 128; ++ix) {
                    int argb = this.iconPixels[iy * 128 + ix];
                    int a = argb >>> 24 & 0xFF;
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b2 = argb & 0xFF;
                    int rgba = r << 24 | g << 16 | b2 << 8 | a;
                    this.canvasImage.m_84988_(ix, iy, rgba);
                }
            }
            this.canvasTexture = new DynamicTexture(this.canvasImage);
            this.canvasRL = new ResourceLocation("questory", "textures/gui/custom_icons/_designer/" + String.valueOf(UUID.randomUUID()));
            Minecraft.m_91087_().m_91097_().m_118495_(this.canvasRL, (AbstractTexture)this.canvasTexture);
            this.canvasDirty = true;
        }
        if (this.liveImage == null) {
            this.liveImage = new NativeImage(64, 64, true);
            for (iy = 0; iy < 64; ++iy) {
                for (ix = 0; ix < 64; ++ix) {
                    this.liveImage.m_84988_(ix, iy, 0);
                }
            }
            this.liveTexture = new DynamicTexture(this.liveImage);
            this.liveRL = new ResourceLocation("questory", "textures/gui/custom_icons/_designer_live/" + String.valueOf(UUID.randomUUID()));
            Minecraft.m_91087_().m_91097_().m_118495_(this.liveRL, (AbstractTexture)this.liveTexture);
            this.liveDirty = true;
        }
        int controlsX = pvX + pvSize + 16;
        this.idBox = new EditBox(this.f_96547_, controlsX, y, 220, 18, (Component)Component.m_237113_((String)"id"));
        this.idBox.m_94144_(this.working.id);
        this.m_142416_((GuiEventListener)this.idBox);
        this.nameBox = new EditBox(this.f_96547_, controlsX, y += 20, 260, 18, (Component)Component.m_237113_((String)"display name"));
        this.nameBox.m_94144_(this.working.displayName == null ? this.working.id : this.working.displayName);
        this.m_142416_((GuiEventListener)this.nameBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Polygon"), b -> {}).m_252987_(controlsX, y += 24, 80, 18).m_253136_());
        this.pointsBox = new EditBox(this.f_96547_, controlsX + 84, y, 256, 18, (Component)Component.m_237113_((String)"x1,y1 x2,y2 ... (0..1)"));
        this.pointsBox.m_94144_("0.2,0.2 0.8,0.2 0.5,0.8");
        this.m_142416_((GuiEventListener)this.pointsBox);
        this.addPolygonBtn = Button.m_253074_((Component)Component.m_237113_((String)"Add"), b -> this.addPolygon()).m_252987_(controlsX + 344, y, 40, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.addPolygonBtn);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Circle"), b -> {}).m_252987_(controlsX, y += 22, 80, 18).m_253136_());
        this.circleCx = new EditBox(this.f_96547_, controlsX + 84, y, 60, 18, (Component)Component.m_237113_((String)"cx"));
        this.circleCx.m_94144_("0.5");
        this.m_142416_((GuiEventListener)this.circleCx);
        this.circleCy = new EditBox(this.f_96547_, controlsX + 148, y, 60, 18, (Component)Component.m_237113_((String)"cy"));
        this.circleCy.m_94144_("0.5");
        this.m_142416_((GuiEventListener)this.circleCy);
        this.circleR = new EditBox(this.f_96547_, controlsX + 212, y, 60, 18, (Component)Component.m_237113_((String)"r"));
        this.circleR.m_94144_("0.45");
        this.m_142416_((GuiEventListener)this.circleR);
        this.addCircleBtn = Button.m_253074_((Component)Component.m_237113_((String)"Add"), b -> this.addCircle()).m_252987_(controlsX + 276, y, 40, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.addCircleBtn);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Gear"), b -> {}).m_252987_(controlsX, y += 22, 80, 18).m_253136_());
        this.gearTeeth = new EditBox(this.f_96547_, controlsX + 84, y, 40, 18, (Component)Component.m_237113_((String)"teeth"));
        this.gearTeeth.m_94144_("8");
        this.m_142416_((GuiEventListener)this.gearTeeth);
        this.gearInnerR = new EditBox(this.f_96547_, controlsX + 128, y, 50, 18, (Component)Component.m_237113_((String)"innerR"));
        this.gearInnerR.m_94144_("0.28");
        this.m_142416_((GuiEventListener)this.gearInnerR);
        this.gearOuterR = new EditBox(this.f_96547_, controlsX + 182, y, 50, 18, (Component)Component.m_237113_((String)"outerR"));
        this.gearOuterR.m_94144_("0.48");
        this.m_142416_((GuiEventListener)this.gearOuterR);
        this.gearHoleR = new EditBox(this.f_96547_, controlsX + 236, y, 50, 18, (Component)Component.m_237113_((String)"holeR"));
        this.gearHoleR.m_94144_("0.10");
        this.m_142416_((GuiEventListener)this.gearHoleR);
        this.addGearBtn = Button.m_253074_((Component)Component.m_237113_((String)"Add"), b -> this.addGear()).m_252987_(controlsX + 290, y, 40, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.addGearBtn);
        this.saveBtn = Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.doSave()).m_252987_(controlsX, y += 28, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveBtn);
        this.applyBtn = Button.m_253074_((Component)Component.m_237113_((String)"Apply to Quest"), b -> this.doApply()).m_252987_(controlsX + 86, y, 120, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.applyBtn);
        this.cancelBtn = Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.m_7379_()).m_252987_(controlsX + 210, y, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelBtn);
        this.templateCircleBtn = Button.m_253074_((Component)Component.m_237113_((String)"Template: Circle"), b -> this.applyTemplateCircle()).m_252987_(controlsX, y += 24, 120, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.templateCircleBtn);
        this.templateHexBtn = Button.m_253074_((Component)Component.m_237113_((String)"Hexagon"), b -> this.applyTemplateHex()).m_252987_(controlsX + 124, y, 80, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.templateHexBtn);
        this.templateStarBtn = Button.m_253074_((Component)Component.m_237113_((String)"Star"), b -> this.applyTemplateStar()).m_252987_(controlsX + 208, y, 60, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.templateStarBtn);
        this.templateGearBtn = Button.m_253074_((Component)Component.m_237113_((String)"Gear"), b -> this.applyTemplateGear()).m_252987_(controlsX + 272, y, 60, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.templateGearBtn);
        this.clearBtn = Button.m_253074_((Component)Component.m_237113_((String)"Clear"), b -> {
            this.working.paths.clear();
            this.rebuildMask128();
        }).m_252987_(controlsX + 336, y, 60, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.clearBtn);
        this.gridToggleBtn = Button.m_253074_((Component)Component.m_237113_((String)"Grid: On"), b -> {
            this.showGrid = !this.showGrid;
            this.gridToggleBtn.m_93666_((Component)Component.m_237113_((String)(this.showGrid ? "Grid: On" : "Grid: Off")));
        }).m_252987_(controlsX, y += 20, 80, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.gridToggleBtn);
        Button livePreviewBtn = Button.m_253074_((Component)Component.m_237113_((String)"Live: On"), b -> {
            this.livePreview = !this.livePreview;
            b.m_93666_((Component)Component.m_237113_((String)(this.livePreview ? "Live: On" : "Live: Off")));
        }).m_252987_(controlsX + 84, y, 80, 18).m_253136_();
        this.m_142416_((GuiEventListener)livePreviewBtn);
        int toolsY = pvY + pvSize + 10;
        this.brushBtn = Button.m_253074_((Component)Component.m_237113_((String)"Brush"), b -> {
            this.erasing = false;
        }).m_252987_(pvX, toolsY, 50, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.brushBtn);
        this.eraserBtn = Button.m_253074_((Component)Component.m_237113_((String)"Eraser"), b -> {
            this.erasing = true;
        }).m_252987_(pvX + 54, toolsY, 60, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.eraserBtn);
        this.sizeMinusBtn = Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
            this.brushSize = Math.max(1, this.brushSize - 1);
        }).m_252987_(pvX + 118, toolsY, 18, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.sizeMinusBtn);
        this.sizePlusBtn = Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> {
            this.brushSize = Math.min(32, this.brushSize + 1);
        }).m_252987_(pvX + 138, toolsY, 18, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.sizePlusBtn);
        this.colorHexBox = new EditBox(this.f_96547_, pvX + 160, toolsY, 70, 18, (Component)Component.m_237113_((String)"#ARGB"));
        this.colorHexBox.m_94144_("FFFFFFFF");
        this.m_142416_((GuiEventListener)this.colorHexBox);
        this.clearIconBtn = Button.m_253074_((Component)Component.m_237113_((String)"Clear Icon"), b -> this.clearIcon()).m_252987_(pvX + 234, toolsY, 80, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.clearIconBtn);
        this.exportIconBtn = Button.m_253074_((Component)Component.m_237113_((String)"Export PNG"), b -> this.exportIcon()).m_252987_(pvX + 320, toolsY, 90, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.exportIconBtn);
        this.useAsIconBtn = Button.m_253074_((Component)Component.m_237113_((String)"Use as Icon"), b -> this.useAsQuestIcon()).m_252987_(pvX + 416, toolsY, 100, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.useAsIconBtn);
        int toolsY2 = toolsY + 22;
        this.eyedropperBtn = Button.m_253074_((Component)Component.m_237113_((String)"Eyedropper"), b -> {
            this.eyedropper = true;
            this.erasing = false;
        }).m_252987_(pvX, toolsY2, 76, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.eyedropperBtn);
        this.undoBtn = Button.m_253074_((Component)Component.m_237113_((String)"Undo"), b -> this.undo()).m_252987_(pvX + 82, toolsY2, 50, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.undoBtn);
        this.redoBtn = Button.m_253074_((Component)Component.m_237113_((String)"Redo"), b -> this.redo()).m_252987_(pvX + 136, toolsY2, 50, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.redoBtn);
    }

    private void addPolygon() {
        try {
            String txt = this.pointsBox.m_94155_();
            String[] tokens = txt.split("\\s+");
            ArrayList<Double> pts = new ArrayList<Double>();
            for (String t : tokens) {
                String[] xy = t.split(",");
                if (xy.length != 2) continue;
                pts.add(Double.parseDouble(xy[0]));
                pts.add(Double.parseDouble(xy[1]));
            }
            if (pts.size() >= 6) {
                ShapeDef.Path p = new ShapeDef.Path();
                p.type = "polygon";
                p.points.addAll(pts);
                p.fill = true;
                this.working.paths.add(p);
                this.rebuildMask128();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCircle() {
        try {
            double cx = Double.parseDouble(this.circleCx.m_94155_());
            double cy = Double.parseDouble(this.circleCy.m_94155_());
            double r = Double.parseDouble(this.circleR.m_94155_());
            ShapeDef.Path p = new ShapeDef.Path();
            p.type = "circle";
            p.num.put("cx", cx);
            p.num.put("cy", cy);
            p.num.put("r", r);
            p.fill = true;
            this.working.paths.add(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addGear() {
        try {
            int teeth = (int)Double.parseDouble(this.gearTeeth.m_94155_());
            double innerR = Double.parseDouble(this.gearInnerR.m_94155_());
            double outerR = Double.parseDouble(this.gearOuterR.m_94155_());
            double holeR = Double.parseDouble(this.gearHoleR.m_94155_());
            ShapeDef.Path p = new ShapeDef.Path();
            p.type = "gear";
            p.num.put("teeth", Double.valueOf(teeth));
            p.num.put("innerR", innerR);
            p.num.put("outerR", outerR);
            p.num.put("holeR", holeR);
            p.fill = true;
            this.working.paths.add(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doSave() {
        this.working.id = ShapeDesignerScreen.sanitize(this.idBox.m_94155_());
        this.working.displayName = this.nameBox.m_94155_().isBlank() ? this.working.id : this.nameBox.m_94155_();
        try {
            ShapeRegistry.save(this.working);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doApply() {
        this.doSave();
        if (this.onApplyShapeId != null) {
            this.onApplyShapeId.accept(this.working.id);
        }
    }

    private static String sanitize(String s) {
        String out = s == null ? "" : s.trim().toLowerCase(Locale.ROOT);
        out = out.replaceAll("[^a-z0-9_]+", "_");
        if ((out = out.replaceAll("_+", "_")).isEmpty()) {
            out = "my_shape";
        }
        return out;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        long now;
        this.m_280273_(g);
        int panelW = 520;
        int x = Math.max(12, this.f_96543_ / 2 - panelW / 2);
        int y = Math.max(20, this.f_96544_ / 2 - 110);
        int pvSize = Math.min(240, this.f_96544_ - 120);
        int pvX = x;
        int pvY = y;
        g.m_280488_(this.f_96547_, "Shape Designer (MVP)", x, y - 12, -1);
        g.m_280488_(this.f_96547_, "ID:", x + pvSize + 16 - 40, y + 4, -5592406);
        g.m_280488_(this.f_96547_, "Name:", x + pvSize + 16 - 40, y + 24, -5592406);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280509_(pvX - 6, pvY - 6, pvX + pvSize + 6, pvY + pvSize + 6, -2013265920);
        g.m_280509_(pvX - 4, pvY - 4, pvX + pvSize + 4, pvY + pvSize + 4, -14803426);
        if (this.showGrid && !this.drawing) {
            int step = Math.max(8, pvSize / 10);
            int gridColorMajor = 0x22444444;
            int gridColorMinor = 0x11222222;
            for (int i = 0; i <= pvSize; i += step) {
                int c = i == pvSize / 2 ? gridColorMajor : gridColorMinor;
                g.m_280509_(pvX + i, pvY, pvX + i + 1, pvY + pvSize, c);
                g.m_280509_(pvX, pvY + i, pvX + pvSize, pvY + i + 1, c);
            }
        }
        if (!this.drawing) {
            CustomShapeRenderer.draw(this.working, g, pvX, pvY, pvSize, -14013910);
            CustomShapeRenderer.drawShadeOverlay(this.working, g, pvX, pvY, pvSize, "linear", "down_right", 0.6, -16777216);
            CustomShapeRenderer.drawOutline(this.working, g, pvX, pvY, pvSize, -1, Math.max(1, pvSize / 24));
        } else {
            g.m_280509_(pvX, pvY, pvX + pvSize, pvY + pvSize, -14671840);
        }
        if (this.canvasDirty && this.canvasTexture != null) {
            long interval;
            long now2 = System.nanoTime();
            long l = interval = this.drawing ? 150000000L : 16000000L;
            if (now2 - this.lastUploadNs > interval) {
                if (this.needCanvasSync && this.canvasImage != null) {
                    for (int iy = 0; iy < 128; ++iy) {
                        for (int ix = 0; ix < 128; ++ix) {
                            int argb = this.iconPixels[iy * 128 + ix];
                            int a = argb >>> 24 & 0xFF;
                            int r = argb >>> 16 & 0xFF;
                            int gch = argb >>> 8 & 0xFF;
                            int b = argb & 0xFF;
                            int rgba = r << 24 | gch << 16 | b << 8 | a;
                            this.canvasImage.m_84988_(ix, iy, rgba);
                        }
                    }
                    this.needCanvasSync = false;
                }
                this.canvasTexture.m_117985_();
                this.canvasDirty = false;
                this.lastUploadNs = now2;
            }
        }
        if (this.liveDirty && this.liveTexture != null && (now = System.nanoTime()) - this.lastLiveUploadNs > 16000000L) {
            this.liveTexture.m_117985_();
            this.liveDirty = false;
            this.lastLiveUploadNs = now;
        }
        if (this.canvasRL != null) {
            g.m_280411_(this.canvasRL, pvX, pvY, pvSize, pvSize, 0.0f, 0.0f, 128, 128, 128, 128);
        }
        if (this.liveRL != null && (this.drawing || this.hasLiveStroke)) {
            g.m_280411_(this.liveRL, pvX, pvY, pvSize, pvSize, 0.0f, 0.0f, 64, 64, 64, 64);
        }
        g.m_280488_(this.f_96547_, "Preview", pvX, pvY + pvSize + 6, -3355444);
    }

    private void applyTemplateCircle() {
        this.working.paths.clear();
        ShapeDef.Path p = new ShapeDef.Path();
        p.type = "circle";
        p.num.put("cx", 0.5);
        p.num.put("cy", 0.5);
        p.num.put("r", 0.48);
        p.fill = true;
        this.working.paths.add(p);
        this.rebuildMask128();
        this.rebuildMask128();
    }

    private void applyTemplateHex() {
        this.working.paths.clear();
        double cx = 0.5;
        double cy = 0.5;
        double r = 0.48;
        double[][] pts = new double[6][2];
        for (int i = 0; i < 6; ++i) {
            double a = Math.toRadians(60 * i - 30);
            pts[i][0] = cx + r * Math.cos(a);
            pts[i][1] = cy + r * Math.sin(a);
        }
        ShapeDef.Path p = new ShapeDef.Path();
        p.type = "polygon";
        for (int i = 0; i < 6; ++i) {
            p.points.add(pts[i][0]);
            p.points.add(pts[i][1]);
        }
        p.fill = true;
        this.working.paths.add(p);
        this.rebuildMask128();
    }

    private void applyTemplateStar() {
        this.working.paths.clear();
        ShapeDef.Path p = new ShapeDef.Path();
        p.type = "star";
        p.num.put("cx", 0.5);
        p.num.put("cy", 0.5);
        p.num.put("points", 5.0);
        p.num.put("innerR", 0.22);
        p.num.put("outerR", 0.48);
        p.num.put("rotation", -90.0);
        p.fill = true;
        this.working.paths.add(p);
        this.rebuildMask128();
    }

    private void applyTemplateGear() {
        this.working.paths.clear();
        ShapeDef.Path p = new ShapeDef.Path();
        p.type = "gear";
        p.num.put("cx", 0.5);
        p.num.put("cy", 0.5);
        p.num.put("teeth", 10.0);
        p.num.put("innerR", 0.3);
        p.num.put("outerR", 0.48);
        p.fill = true;
        this.working.paths.add(p);
        ShapeDef.Path inner = new ShapeDef.Path();
        inner.type = "circle";
        inner.num.put("cx", 0.5);
        inner.num.put("cy", 0.5);
        inner.num.put("r", 0.12);
        inner.fill = false;
        this.working.paths.add(inner);
        this.rebuildMask128();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private void clearIcon() {
        Arrays.fill(this.iconPixels, 0);
        if (this.canvasImage != null) {
            for (int iy = 0; iy < 128; ++iy) {
                for (int ix = 0; ix < 128; ++ix) {
                    this.canvasImage.m_84988_(ix, iy, 0);
                }
            }
            this.canvasDirty = true;
        }
        this.clearLiveCanvas();
    }

    private void clearLiveCanvas() {
        if (this.liveImage == null) {
            return;
        }
        for (int iy = 0; iy < 64; ++iy) {
            for (int ix = 0; ix < 64; ++ix) {
                this.liveImage.m_84988_(ix, iy, 0);
            }
        }
        this.liveDirty = true;
        this.hasLiveStroke = false;
    }

    private void exportIcon() {
        try {
            String id = ShapeDesignerScreen.sanitize(this.idBox.m_94155_());
            File dir = new File(Minecraft.m_91087_().f_91069_, "config/questory/shapes/icons");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File out = new File(dir, id + ".png");
            BufferedImage img = new BufferedImage(128, 128, 2);
            img.setRGB(0, 0, 128, 128, this.iconPixels, 0, 128);
            ImageIO.write((RenderedImage)img, "PNG", out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int parseColorBox() {
        try {
            String s = this.colorHexBox.m_94155_().trim();
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (s.length() == 8) {
                return (int)Long.parseLong(s, 16);
            }
            if (s.length() == 6) {
                int rgb = Integer.parseInt(s, 16);
                return 0xFF000000 | rgb;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private void drawAtScreen(int mouseX, int mouseY) {
        if (this.previewRect == null) {
            return;
        }
        int px = this.previewRect[0];
        int py = this.previewRect[1];
        int ps = this.previewRect[2];
        if (mouseX < px || mouseX >= px + ps || mouseY < py || mouseY >= py + ps) {
            return;
        }
        if (this.eyedropper) {
            int sx = (int)Math.round((double)(mouseX - px) * (128.0 / (double)ps));
            int sy = (int)Math.round((double)(mouseY - py) * (128.0 / (double)ps));
            sx = Math.max(0, Math.min(127, sx));
            sy = Math.max(0, Math.min(127, sy));
            int argb = this.iconPixels[sy * 128 + sx];
            this.colorHexBox.m_94144_(String.format(Locale.ROOT, "%08X", argb));
            this.eyedropper = false;
            return;
        }
        this.brushColor = this.parseColorBox();
        int cx = (int)Math.round((double)(mouseX - px) * (128.0 / (double)ps));
        int cy = (int)Math.round((double)(mouseY - py) * (128.0 / (double)ps));
        cx = Math.max(0, Math.min(127, cx));
        cy = Math.max(0, Math.min(127, cy));
        int liveX = (int)Math.round((double)(mouseX - px) * (64.0 / (double)ps));
        int liveY = (int)Math.round((double)(mouseY - py) * (64.0 / (double)ps));
        liveX = Math.max(0, Math.min(63, liveX));
        liveY = Math.max(0, Math.min(63, liveY));
        if (!this.strokeSnapshotTaken) {
            this.pushUndoSnapshot();
            this.strokeSnapshotTaken = true;
        }
        this.paintCircleLive(liveX, liveY, this.brushSize, this.erasing ? 0 : this.brushColor);
        this.hasLiveStroke = true;
    }

    private int toRgba(int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        return r << 24 | g << 16 | b << 8 | a;
    }

    private int liveRadiusFor(int baseRadius) {
        double scaled = (double)baseRadius * 0.5;
        return Math.max(1, (int)Math.round(scaled));
    }

    private void paintCircleLive(int cx, int cy, int baseRadius, int color) {
        if (this.liveImage == null) {
            return;
        }
        int rLive = this.liveRadiusFor(baseRadius);
        short[] mask = BRUSH_MASKS.computeIfAbsent(rLive, this::buildBrushMask);
        int rgba = this.toRgba(color);
        boolean changed = false;
        for (int i = 0; i < mask.length; i += 2) {
            short dx = mask[i];
            short dy = mask[i + 1];
            int x = cx + dx;
            int y = cy + dy;
            if (x < 0 || x >= 64 || y < 0 || y >= 64) continue;
            this.liveImage.m_84988_(x, y, rgba);
            changed = true;
        }
        if (changed) {
            this.liveDirty = true;
            this.hasLiveStroke = true;
        }
    }

    private short[] buildBrushMask(int r) {
        ArrayList<Short> list = new ArrayList<Short>();
        int r2 = r * r;
        for (int dy = -r; dy <= r; ++dy) {
            for (int dx = -r; dx <= r; ++dx) {
                if (dx * dx + dy * dy > r2) continue;
                list.add((short)dx);
                list.add((short)dy);
            }
        }
        short[] arr = new short[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (Short)list.get(i);
        }
        return arr;
    }

    private void rebuildMask128() {
        this.shapeMask128 = new boolean[16384];
        boolean any = false;
        for (int py = 0; py < 128; ++py) {
            for (int px = 0; px < 128; ++px) {
                boolean inside;
                this.shapeMask128[py * 128 + px] = inside = CustomShapeRenderer.contains(this.working, 0, 0, 128, px, py);
                if (!inside) continue;
                any = true;
            }
        }
        this.shapeMaskLow = new boolean[4096];
        boolean anyLow = false;
        for (int py = 0; py < 64; ++py) {
            for (int px = 0; px < 64; ++px) {
                boolean inside;
                this.shapeMaskLow[py * 64 + px] = inside = CustomShapeRenderer.contains(this.working, 0, 0, 64, px, py);
                if (!inside) continue;
                anyLow = true;
            }
        }
        if (!any) {
            this.shapeMask128 = null;
        }
        if (!anyLow) {
            this.shapeMaskLow = null;
        }
    }

    private void commitLiveToHiRes() {
        if (this.liveImage == null || !this.hasLiveStroke) {
            return;
        }
        for (int y = 0; y < 128; ++y) {
            int sy = (int)Math.floor((double)y * 0.5);
            if (sy < 0) {
                sy = 0;
            }
            if (sy >= 64) {
                sy = 63;
            }
            for (int x = 0; x < 128; ++x) {
                int argb;
                int sx = (int)Math.floor((double)x * 0.5);
                if (sx < 0) {
                    sx = 0;
                }
                if (sx >= 64) {
                    sx = 63;
                }
                int rgba = this.liveImage.m_84985_(sx, sy);
                int a = rgba >>> 24 & 0xFF;
                int r = rgba >>> 16 & 0xFF;
                int g = rgba >>> 8 & 0xFF;
                int b = rgba & 0xFF;
                if (a == 0) continue;
                this.iconPixels[y * 128 + x] = argb = a << 24 | r << 16 | g << 8 | b;
            }
        }
        for (int iy = 0; iy < 64; ++iy) {
            for (int ix = 0; ix < 64; ++ix) {
                this.liveImage.m_84988_(ix, iy, 0);
            }
        }
        this.liveDirty = true;
        this.canvasDirty = true;
        this.needCanvasSync = true;
        this.hasLiveStroke = false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.drawing = true;
            this.drawAtScreen((int)mouseX, (int)mouseY);
            if (this.previewRect != null) {
                int px = this.previewRect[0];
                int py = this.previewRect[1];
                int ps = this.previewRect[2];
                this.lastDrawX = (int)Math.round((mouseX - (double)px) * (64.0 / (double)ps));
                this.lastDrawY = (int)Math.round((mouseY - (double)py) * (64.0 / (double)ps));
                this.lastDrawX = Math.max(0, Math.min(63, this.lastDrawX));
                this.lastDrawY = Math.max(0, Math.min(63, this.lastDrawY));
                this.canvasDirty = true;
                this.lastUploadNs = 0L;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.commitLiveToHiRes();
            this.drawing = false;
            this.strokeSnapshotTaken = false;
            this.lastDrawY = -1;
            this.lastDrawX = -1;
            this.canvasDirty = true;
            this.lastUploadNs = 0L;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.drawing && button == 0 && this.previewRect != null) {
            int px = this.previewRect[0];
            int py = this.previewRect[1];
            int ps = this.previewRect[2];
            int cx = (int)Math.round((mouseX - (double)px) * (64.0 / (double)ps));
            int cy = (int)Math.round((mouseY - (double)py) * (64.0 / (double)ps));
            cx = Math.max(0, Math.min(63, cx));
            cy = Math.max(0, Math.min(63, cy));
            this.brushColor = this.parseColorBox();
            if (this.lastDrawX >= 0) {
                int dx = cx - this.lastDrawX;
                int dy = cy - this.lastDrawY;
                int maxDelta = Math.max(Math.abs(dx), Math.abs(dy));
                int stepPx = Math.max(1, this.liveRadiusFor(this.brushSize));
                int steps = Math.max(1, maxDelta / stepPx);
                for (int i = 1; i <= steps; ++i) {
                    int ix = this.lastDrawX + dx * i / steps;
                    int iy = this.lastDrawY + dy * i / steps;
                    this.paintCircleLive(ix, iy, this.brushSize, this.erasing ? 0 : this.brushColor);
                }
            } else {
                this.paintCircleLive(cx, cy, this.brushSize, this.erasing ? 0 : this.brushColor);
            }
            this.lastDrawX = cx;
            this.lastDrawY = cy;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void pushUndoSnapshot() {
        int[] snap = Arrays.copyOf(this.iconPixels, this.iconPixels.length);
        this.undoStack.push(snap);
        this.redoStack.clear();
    }

    private void applySnapshot(int[] snap) {
        System.arraycopy(snap, 0, this.iconPixels, 0, this.iconPixels.length);
        if (this.canvasImage != null) {
            for (int iy = 0; iy < 128; ++iy) {
                for (int ix = 0; ix < 128; ++ix) {
                    int argb = this.iconPixels[iy * 128 + ix];
                    int a = argb >>> 24 & 0xFF;
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int rgba = r << 24 | g << 16 | b << 8 | a;
                    this.canvasImage.m_84988_(ix, iy, rgba);
                }
            }
            this.canvasDirty = true;
        }
    }

    private void undo() {
        if (!this.undoStack.isEmpty()) {
            int[] current = Arrays.copyOf(this.iconPixels, this.iconPixels.length);
            int[] snap = this.undoStack.pop();
            this.redoStack.push(current);
            this.applySnapshot(snap);
        }
    }

    private void redo() {
        if (!this.redoStack.isEmpty()) {
            int[] current = Arrays.copyOf(this.iconPixels, this.iconPixels.length);
            int[] snap = this.redoStack.pop();
            this.undoStack.push(current);
            this.applySnapshot(snap);
        }
    }

    private void useAsQuestIcon() {
        try {
            NativeImage img = new NativeImage(128, 128, true);
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    int argb = this.iconPixels[y * 128 + x];
                    int a = argb >>> 24 & 0xFF;
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int rgba = r << 24 | g << 16 | b << 8 | a;
                    img.m_84988_(x, y, rgba);
                }
            }
            String sid = ShapeDesignerScreen.sanitize(this.idBox.m_94155_());
            ResourceLocation rl = new ResourceLocation("questory", "textures/gui/custom_icons/" + sid + ".png");
            DynamicTexture dyn = new DynamicTexture(img);
            Minecraft.m_91087_().m_91097_().m_118495_(rl, (AbstractTexture)dyn);
            Screen r = this.parent;
            if (r instanceof QuestEditorScreen) {
                QuestEditorScreen editor = (QuestEditorScreen)r;
                String iconSpec = "texture:questory:gui/custom_icons/" + sid;
                editor.getWorkingQuest().setIcon(iconSpec);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

