/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.quest.GroupNode;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class SidebarPanel {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean expanded = true;
    private int scroll = 0;
    private final int handleWidth = 12;
    private final int rowHeight = 18;
    private final List<Entry> entries = new ArrayList<Entry>();
    private String selectedGroup = "";
    private OnSelect onSelect = null;
    private GroupNode groupTree;
    private final Map<String, Boolean> expandedMap = new HashMap<String, Boolean>();
    private Function<String, Integer> countProvider = g -> 0;
    private Function<String, Component> labelProvider = null;
    private Function<String, Integer> colorProvider = null;
    private Function<String, String> groupIconProvider = null;
    private Function<String, Integer> rightBadgeProvider = null;
    private final Set<String> pinned = new HashSet<String>();
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private boolean panelPinned = false;
    private final Set<String> collapsedDefault = new HashSet<String>();
    private int slide = 0;
    private boolean showCounts = true;

    public SidebarPanel(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = Math.max(width, 120);
        this.height = height;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = Math.max(width, 120);
        this.height = height;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int getOccupiedWidth() {
        return this.expanded ? 12 + this.width : 12;
    }

    public int getHandleWidth() {
        return 12;
    }

    public int getReservedWidth() {
        return this.panelPinned ? (this.expanded ? 12 + this.width : 12) : 12;
    }

    public void setSelectedGroup(String group) {
        this.selectedGroup = group;
    }

    public void setOnSelect(OnSelect onSelect) {
        this.onSelect = onSelect;
    }

    public void setCountProvider(Function<String, Integer> f) {
        this.countProvider = f == null ? g -> 0 : f;
    }

    public void setPinned(Collection<String> groups) {
        this.pinned.clear();
        if (groups != null) {
            this.pinned.addAll(groups);
        }
    }

    public void setPanelPinned(boolean pinned) {
        this.panelPinned = pinned;
    }

    public boolean isPanelPinned() {
        return this.panelPinned;
    }

    public void setCollapsedSections(Collection<String> secs) {
        this.collapsedDefault.clear();
        if (secs != null) {
            this.collapsedDefault.addAll(secs);
        }
    }

    public void setGroupLabelProvider(Function<String, Component> resolver) {
        this.labelProvider = resolver;
    }

    public void setGroupColorProvider(Function<String, Integer> resolver) {
        this.colorProvider = resolver;
    }

    public void setGroupIconProvider(Function<String, String> resolver) {
        this.groupIconProvider = resolver;
    }

    public void setRightBadgeProvider(Function<String, Integer> resolver) {
        this.rightBadgeProvider = resolver;
    }

    public void setShowCounts(boolean show) {
        this.showCounts = show;
    }

    private void drawIconBackground(GuiGraphics g, IconProperty prop, int x, int y, int w, int h) {
        Integer tile;
        if (prop == null) {
            return;
        }
        ResourceLocation rl = prop.getResourceLocation();
        Integer color = prop.getColorModifier();
        if (rl == null) {
            int argb;
            int n = argb = color != null ? color : 0;
            if (argb != 0) {
                g.m_280509_(x, y, x + w, y + h, argb);
            }
            return;
        }
        if (color != null) {
            float a = (float)(color >>> 24 & 0xFF) / 255.0f;
            float r = (float)(color >>> 16 & 0xFF) / 255.0f;
            float gg = (float)(color >>> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)gg, (float)b, (float)a);
        }
        int ts = (tile = prop.getTileSize()) != null && tile > 0 ? tile : Math.min(w, Math.min(h, 32));
        for (int yy = 0; yy < h; yy += ts) {
            for (int xx = 0; xx < w; xx += ts) {
                int bw = Math.min(ts, w - xx);
                int bh = Math.min(ts, h - yy);
                g.m_280163_(rl, x + xx, y + yy, 0.0f, 0.0f, bw, bh, ts, ts);
            }
        }
        if (color != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void drawSmallIcon(GuiGraphics g, IconProperty prop, int x, int y, int w, int h) {
        if (prop == null) {
            return;
        }
        ResourceLocation rl = prop.getResourceLocation();
        Integer color = prop.getColorModifier();
        if (rl != null) {
            if (color != null) {
                float a = (float)(color >>> 24 & 0xFF) / 255.0f;
                float r = (float)(color >>> 16 & 0xFF) / 255.0f;
                float gg = (float)(color >>> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)gg, (float)b, (float)a);
            }
            g.m_280163_(rl, x, y, 0.0f, 0.0f, w, h, w, h);
            if (color != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else if (color != null) {
            g.m_280509_(x, y, x + w, y + h, color.intValue());
        }
    }

    public void setEntries(List<Entry> list) {
        this.entries.clear();
        this.entries.addAll(list);
        this.entries.sort(Comparator.comparing(e -> e.label.getString().toLowerCase()));
        this.clampScroll();
    }

    public void setGroupTree(GroupNode root) {
        this.groupTree = root;
        this.rebuildFromTree();
    }

    private void rebuildFromTree() {
        this.entries.clear();
        if (this.groupTree != null) {
            ArrayList<GroupNode> top = new ArrayList<GroupNode>(this.groupTree.getChildren());
            top.sort(Comparator.comparingInt(GroupNode::getOrder).thenComparing(GroupNode::getTitle));
            for (GroupNode n : top) {
                this.addNode(n, 0);
            }
        }
        this.clampScroll();
    }

    private void addNode(GroupNode node, int indent) {
        String id = node.getId() == null || node.getId().isEmpty() ? node.getTitle() : node.getId();
        boolean exp = this.expandedMap.getOrDefault(id, !this.collapsedDefault.contains(id));
        String rawTitle = node.getTitle() == null ? "" : node.getTitle();
        String converted = TextFormatter.convertMinecraftCodesToTags(rawTitle);
        String plainTitle = TextFormatter.stripTags(converted);
        Integer secColor = this.parseColor(node.getColor());
        if (secColor == null) {
            secColor = TextFormatter.firstArgbFromMinecraftCodes(rawTitle);
        }
        this.entries.add(new Entry("section:" + id, (Component)Component.m_237113_((String)plainTitle), 0, true, indent, secColor, node.getIcon()));
        if (exp) {
            for (String g : node.getGroups()) {
                MutableComponent label;
                String gKey = this.normalizeKey(g);
                int cnt = this.countProvider.apply(gKey);
                Object object = label = this.labelProvider != null ? this.labelProvider.apply(gKey) : Component.m_237113_((String)gKey);
                if (label == null) {
                    label = Component.m_237113_((String)gKey);
                }
                Integer col = this.colorProvider != null ? this.colorProvider.apply(gKey) : null;
                String icon = this.groupIconProvider != null ? this.groupIconProvider.apply(gKey) : null;
                this.entries.add(new Entry(gKey, (Component)label, cnt, false, indent + 1, col, icon));
            }
            if (node.getGroups().isEmpty()) {
                MutableComponent label;
                String synthKey = plainTitle;
                int cnt = this.countProvider.apply(synthKey);
                Object object = label = this.labelProvider != null ? this.labelProvider.apply(synthKey) : Component.m_237113_((String)synthKey);
                if (label == null) {
                    label = Component.m_237113_((String)synthKey);
                }
                Integer col = this.colorProvider != null ? this.colorProvider.apply(synthKey) : null;
                String icon = this.groupIconProvider != null ? this.groupIconProvider.apply(synthKey) : null;
                this.entries.add(new Entry(synthKey, (Component)label, cnt, false, indent + 1, col, icon));
            }
            ArrayList<GroupNode> kids = new ArrayList<GroupNode>(node.getChildren());
            kids.sort(Comparator.comparingInt(GroupNode::getOrder).thenComparing(GroupNode::getTitle));
            for (GroupNode c : kids) {
                this.addNode(c, indent + 1);
            }
        }
    }

    private Integer parseColor(String c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        try {
            if (c.startsWith("#")) {
                int rgb = (int)Long.parseLong(c.substring(1), 16);
                if (c.length() <= 7) {
                    return 0xFF000000 | rgb;
                }
                return rgb;
            }
            if (c.startsWith("0x") || c.startsWith("0X")) {
                return (int)Long.parseLong(c.substring(2), 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void clampScroll() {
        int maxScroll = Math.max(0, this.entries.size() * 18 - (this.height - 24));
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > maxScroll) {
            this.scroll = maxScroll;
        }
    }

    private boolean isInside(int mx, int my) {
        return mx >= this.x && mx <= this.x + this.getOccupiedWidth() && my >= this.y && my <= this.y + this.height;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isInside((int)mouseX, (int)mouseY)) {
            return false;
        }
        if (mouseX >= (double)this.x && mouseX <= (double)(this.x + 12)) {
            if (button == 1) {
                this.panelPinned = !this.panelPinned;
                ClientConfig.toggleChapterPanelPinned();
            } else {
                this.expanded = !this.expanded;
            }
            return true;
        }
        if (!this.expanded) {
            return true;
        }
        int listX = this.x + 12 + 6;
        int listY = this.y + 8;
        int localY = (int)mouseY - listY + this.scroll;
        int index = localY / 18;
        if (index >= 0 && index < this.entries.size()) {
            Entry e = this.entries.get(index);
            if (e.isSection) {
                String id;
                boolean newState = this.expandedMap.getOrDefault(id, !this.collapsedDefault.contains(id = e.key.substring("section:".length()))) == false;
                this.expandedMap.put(id, newState);
                ClientConfig.toggleSectionCollapsed(id);
                this.rebuildFromTree();
            } else if (button == 1) {
                if (this.pinned.contains(e.key)) {
                    this.pinned.remove(e.key);
                } else {
                    this.pinned.add(e.key);
                }
                ClientConfig.togglePinned(e.key);
            } else if (this.onSelect != null) {
                this.onSelect.onSelect(e.key);
            }
            return true;
        }
        return false;
    }

    private String normalizeKey(String k) {
        if (k == null) {
            return null;
        }
        String conv = TextFormatter.convertMinecraftCodesToTags(k);
        String plain = TextFormatter.stripTags(conv);
        return plain == null || plain.isEmpty() ? k : plain;
    }

    private GroupNode findNodeById(String id) {
        if (this.groupTree == null) {
            return null;
        }
        return this.findNodeByIdRec(id, this.groupTree);
    }

    private GroupNode findNodeByIdRec(String id, GroupNode node) {
        String nid;
        if (node == null) {
            return null;
        }
        String string = nid = node.getId() == null || node.getId().isEmpty() ? node.getTitle() : node.getId();
        if (id.equals(nid)) {
            return node;
        }
        for (GroupNode c : node.getChildren()) {
            GroupNode r = this.findNodeByIdRec(id, c);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (!this.isInside((int)mouseX, (int)mouseY) || !this.expanded) {
            return false;
        }
        this.scroll -= (int)(delta * 12.0);
        this.clampScroll();
        return true;
    }

    public void render(GuiGraphics g, Font font, int screenHeight, int mouseX, int mouseY) {
        int visible;
        int targetSlide;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.height = screenHeight - (this.y + 30);
        if (this.expanded || this.panelPinned) {
            int target;
            this.width = target = Math.max(120, Math.min(260, this.measurePreferredWidth(font)));
        }
        if (!this.panelPinned) {
            boolean over;
            this.expanded = over = mouseX >= this.x && mouseX <= this.x + this.getOccupiedWidth() && mouseY >= this.y && mouseY <= this.y + this.height;
        }
        int n = targetSlide = this.expanded ? 0 : -this.width;
        if (this.slide < targetSlide) {
            this.slide = Math.min(this.slide + 40, targetSlide);
        } else if (this.slide > targetSlide) {
            this.slide = Math.max(this.slide - 40, targetSlide);
        }
        int handleRight = this.x + 12;
        int handleColor = (Integer)ThemeProperties.WIDGET_BORDER.get();
        g.m_280509_(this.x, this.y, handleRight, this.y + this.height, handleColor);
        int contentLeft = handleRight + this.slide;
        int contentWidth = this.width;
        if (contentLeft < handleRight) {
            IconProperty bgProp = ThemeProperties.CHAPTER_PANEL_BACKGROUND;
            if (bgProp.getResourceLocation() != null || bgProp.getColorModifier() != null) {
                this.drawIconBackground(g, bgProp, contentLeft, this.y, contentWidth, this.height);
            } else {
                int bgColor = (Integer)ThemeProperties.WIDGET_BACKGROUND.get();
                if (bgColor == 0 || bgColor >>> 24 == 0) {
                    bgColor = -586143680;
                }
                g.m_280509_(contentLeft, this.y, contentLeft + contentWidth, this.y + this.height, bgColor);
            }
        }
        int cx = this.x + 6;
        int cy = this.y + 12;
        g.m_280509_(cx - 3, cy - 3, cx - 1, cy + 3, -1);
        g.m_280509_(cx + 1, cy - 3, cx + 3, cy + 3, -1);
        try {
            IconProperty pinProp = this.panelPinned ? ThemeProperties.PIN_ICON_ON : ThemeProperties.PIN_ICON_OFF;
            this.drawSmallIcon(g, pinProp, this.x + 2, this.y + 18, 8, 8);
        }
        catch (Throwable pinProp) {
            // empty catch block
        }
        if (this.slide <= -this.width + 2) {
            return;
        }
        int listLeft = handleRight + 2 + this.slide;
        int listRight = handleRight + this.width - 4 + this.slide;
        int listTop = this.y + 4;
        int listBottom = this.y + this.height - 4;
        int yOff = listTop - this.scroll;
        for (int i = 0; i < this.entries.size(); ++i) {
            Object txt;
            ResourceLocation rl;
            String[] parts;
            Object path;
            String ns;
            int iy;
            int ix;
            int isz;
            ItemStack stack;
            ResourceLocation itemId;
            Item item;
            boolean isItemIcon;
            String iconStr2;
            boolean over;
            Entry e = this.entries.get(i);
            int rowTop = yOff + i * 18;
            int rowBottom = rowTop + 18 - 2;
            if (rowBottom < listTop || rowTop > listBottom) continue;
            boolean bl = over = mouseX >= listLeft && mouseX <= listRight && mouseY >= rowTop && mouseY <= rowBottom;
            if (!e.isSection && e.key.equals(this.selectedGroup)) {
                this.drawIconBackground(g, ThemeProperties.CHAPTER_ROW_SELECTED, listLeft, rowTop, listRight - listLeft, rowBottom - rowTop);
            } else if (over) {
                if (ThemeProperties.CHAPTER_ROW_HOVER.getResourceLocation() != null || ThemeProperties.CHAPTER_ROW_HOVER.getColorModifier() != null) {
                    this.drawIconBackground(g, ThemeProperties.CHAPTER_ROW_HOVER, listLeft, rowTop, listRight - listLeft, rowBottom - rowTop);
                } else {
                    g.m_280509_(listLeft, rowTop, listRight, rowBottom, 0x28FFFFFF);
                }
            }
            int textX = listLeft + 6 + e.indent * 10;
            if (e.isSection) {
                IconProperty arr = this.expandedMap.getOrDefault(e.key.substring("section:".length()), !this.collapsedDefault.contains(e.key.substring("section:".length()))) != false ? ThemeProperties.SIDEBAR_ARROW_EXPANDED : ThemeProperties.SIDEBAR_ARROW_COLLAPSED;
                this.drawSmallIcon(g, arr, textX, rowTop + 4, 10, 10);
                textX += 12;
            }
            if (e.isSection && e.icon != null && !e.icon.isEmpty()) {
                boolean sectionIconDrawn = false;
                try {
                    iconStr2 = e.icon;
                    boolean bl2 = isItemIcon = !iconStr2.contains("textures/") && !iconStr2.endsWith(".png");
                    if (isItemIcon && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId = new ResourceLocation(iconStr2))) != Items.f_41852_) {
                        stack = new ItemStack((ItemLike)item);
                        isz = 16;
                        ix = textX;
                        iy = rowTop + 1;
                        g.m_280480_(stack, ix, iy);
                        textX += isz + 4;
                        sectionIconDrawn = true;
                    }
                    if (!sectionIconDrawn) {
                        ns = "minecraft";
                        path = iconStr2;
                        if (((String)path).contains(":")) {
                            parts = ((String)path).split(":", 2);
                            ns = parts[0];
                            path = parts[1];
                        }
                        if (!((String)path).startsWith("textures/")) {
                            path = "textures/" + (String)path;
                        }
                        if (!((String)path).endsWith(".png")) {
                            path = (String)path + ".png";
                        }
                        rl = new ResourceLocation(ns, (String)path);
                        ResourceManager rm = Minecraft.m_91087_().m_91098_();
                        if (rm.m_213713_(rl).isPresent()) {
                            ix = textX;
                            iy = rowTop + 1;
                            int isz2 = 16;
                            g.m_280163_(rl, ix, iy, 0.0f, 0.0f, isz2, isz2, isz2, isz2);
                            textX += isz2 + 4;
                            sectionIconDrawn = true;
                        }
                    }
                }
                catch (Throwable iconStr2) {
                    // empty catch block
                }
            }
            if (!e.isSection && e.icon != null && !e.icon.isEmpty()) {
                boolean iconDrawn = false;
                try {
                    iconStr2 = e.icon;
                    boolean bl3 = isItemIcon = !iconStr2.contains("textures/") && !iconStr2.endsWith(".png");
                    if (isItemIcon && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId = new ResourceLocation(iconStr2))) != Items.f_41852_) {
                        stack = new ItemStack((ItemLike)item);
                        isz = 12;
                        ix = textX;
                        iy = rowTop + 2;
                        g.m_280168_().m_85836_();
                        g.m_280168_().m_252880_((float)ix, (float)iy, 0.0f);
                        g.m_280168_().m_85841_((float)isz / 16.0f, (float)isz / 16.0f, 1.0f);
                        g.m_280480_(stack, 0, 0);
                        g.m_280168_().m_85849_();
                        textX += isz + 4;
                        iconDrawn = true;
                    }
                    if (!iconDrawn) {
                        ns = "minecraft";
                        path = iconStr2;
                        if (((String)path).contains(":")) {
                            parts = ((String)path).split(":", 2);
                            ns = parts[0];
                            path = parts[1];
                        }
                        if (!((String)path).startsWith("textures/")) {
                            path = "textures/" + (String)path;
                        }
                        if (!((String)path).endsWith(".png")) {
                            path = (String)path + ".png";
                        }
                        rl = new ResourceLocation(ns, (String)path);
                        ResourceManager rm = Minecraft.m_91087_().m_91098_();
                        if (rm.m_213713_(rl).isPresent()) {
                            int isz3 = 12;
                            int ix2 = textX;
                            int iy2 = rowTop + 3;
                            g.m_280163_(rl, ix2, iy2, 0.0f, 0.0f, isz3, isz3, isz3, isz3);
                            textX += isz3 + 4;
                            iconDrawn = true;
                        }
                    }
                }
                catch (Throwable iconStr3) {
                    // empty catch block
                }
            }
            int color = e.color != null ? e.color : (over ? ((Integer)ThemeProperties.HOVER_TEXT_COLOR.get()).intValue() : ((Integer)ThemeProperties.TEXT_COLOR.get()).intValue());
            if (!e.isSection && this.pinned.contains(e.key)) {
                try {
                    this.drawSmallIcon(g, ThemeProperties.PIN_ICON_ON, textX, rowTop + 3, 10, 10);
                    textX += 12;
                }
                catch (Throwable iconStr3) {
                    // empty catch block
                }
            }
            if (e.isSection) {
                txt = e.label.getString();
            } else {
                Object base = e.label.getString();
                if (e.key.equals(this.selectedGroup)) {
                    base = (String)base + " \u25c0";
                }
                txt = this.showCounts ? (String)base + " (" + e.count + ")" : base;
            }
            g.m_280056_(font, (String)txt, textX, rowTop + 4, color, false);
            if (e.isSection || this.rightBadgeProvider == null) continue;
            int badge = 0;
            try {
                badge = Math.max(0, this.rightBadgeProvider.apply(e.key));
            }
            catch (Throwable ns2) {
                // empty catch block
            }
            int iconSize = 10;
            int ix3 = listRight - iconSize - 2;
            if (badge == 1) {
                this.drawSmallIcon(g, ThemeProperties.ALERT_ICON, ix3, rowTop + 3, iconSize, iconSize);
                continue;
            }
            if (badge != 2) continue;
            this.drawSmallIcon(g, ThemeProperties.CLOSE_ICON, ix3, rowTop + 3, iconSize, iconSize);
        }
        int contentHeight = this.entries.size() * 18;
        if (contentHeight > (visible = listBottom - listTop)) {
            int sbW = 6;
            int sbLeft = listRight - sbW;
            this.drawIconBackground(g, ThemeProperties.SCROLL_BAR_BACKGROUND, sbLeft, listTop, sbW, visible);
            int thumbH = Math.max(8, visible * visible / contentHeight);
            int maxScroll = contentHeight - visible;
            int thumbY = listTop + (maxScroll > 0 ? this.scroll * (visible - thumbH) / maxScroll : 0);
            this.drawIconBackground(g, ThemeProperties.SCROLL_BAR, sbLeft, thumbY, sbW, thumbH);
            if (mouseX >= sbLeft && mouseX <= sbLeft + sbW && mouseY >= listTop && mouseY <= listBottom && Minecraft.m_91087_().f_91067_.m_91560_()) {
                int relY = mouseY - listTop;
                int newScroll = (int)((long)relY * (long)maxScroll / (long)Math.max(1, visible));
                this.scroll = Math.max(0, Math.min(maxScroll, newScroll));
            }
        }
    }

    private int measurePreferredWidth(Font font) {
        int max = 0;
        for (Entry e : this.entries) {
            Object text = e.label.getString();
            if (!e.isSection && this.showCounts) {
                text = (String)text + " (" + e.count + ")";
            }
            int base = font.m_92895_((String)text);
            int extra = 6 + e.indent * 10;
            if (e.isSection) {
                extra += 12;
            }
            if (!e.isSection) {
                if (this.pinned.contains(e.key)) {
                    extra += 12;
                }
                if (e.icon != null && !e.icon.isEmpty()) {
                    extra += 16;
                }
                if (this.rightBadgeProvider != null) {
                    extra += 12;
                }
            }
            max = Math.max(max, base + extra);
        }
        return max + 18;
    }

    public static interface OnSelect {
        public void onSelect(String var1);
    }

    public static class Entry {
        public final String key;
        public final Component label;
        public final int count;
        public final boolean isSection;
        public final int indent;
        public final Integer color;
        public final String icon;

        public Entry(String key, Component label, int count, boolean isSection, int indent, Integer color, String icon) {
            this.key = key;
            this.label = label;
            this.count = count;
            this.isSection = isSection;
            this.indent = indent;
            this.color = color;
            this.icon = icon;
        }
    }
}

