/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.texboobcat.questory.client.gui.FormattedTextWithImages;

public class TextFormatter {
    private static final Pattern TAG_PATTERN = Pattern.compile("<(/?)([a-zA-Z_#][a-zA-Z0-9_]*)(\\s+[^>]*)?>");
    private static final Pattern LINK_PATTERN = Pattern.compile("<link\\s+href=\"([^\"]+)\">([^<]+)</link>");
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("<a\\s+href=\"([^\"]+)\">([^<]+)</a>");
    private static final Pattern MARKDOWN_HEADER = Pattern.compile("^##\\s+(.+)$", 8);
    private static final Pattern MARKDOWN_BOLD = Pattern.compile("\\*\\*([^*]+)\\*\\*");
    private static final Pattern SLASH_E_PATTERN = Pattern.compile("/e/([^/]+)/e/");
    private static final Pattern SLASH_9_PATTERN = Pattern.compile("/9/([^/]+)/9/");
    private static final Pattern FTB_IMAGE_PATTERN = Pattern.compile("\\{image:([^\\s}]+)(?:\\s+width:([0-9]+))?(?:\\s+height:([0-9]+))?(?:\\s+align:(\\w+))?[^}]*}");
    private static final Pattern IMG_TAG_PATTERN = Pattern.compile("<img\\s+src=\"([^\"]+)\"(?:\\s+width=\"([0-9]+)\")?(?:\\s+height=\"([0-9]+)\")?(?:\\s+align=\"(\\w+)\")?\\s*/>");
    private static final Pattern FTB_TRANSLATION_KEY_PATTERN = Pattern.compile("\\{(ftbquests\\.[^}]+)\\}");

    public static Component parse(String text) {
        if (text == null || text.isEmpty()) {
            return Component.m_237119_();
        }
        text = TextFormatter.resolveFTBTranslationKeys(text);
        text = TextFormatter.preprocessMarkdown(text);
        text = TextFormatter.processLinks(text, new ArrayList<String>());
        MutableComponent root = Component.m_237119_();
        StyleStack styleStack = new StyleStack();
        Matcher matcher = TAG_PATTERN.matcher(text);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String content = text.substring(lastEnd, matcher.start());
                root.m_7220_((Component)Component.m_237113_((String)content).m_6270_(styleStack.current()));
            }
            boolean isClosing = matcher.group(1).equals("/");
            String tagName = matcher.group(2).toLowerCase();
            String attributes = matcher.group(3);
            if (isClosing) {
                styleStack.pop(tagName);
            } else if (tagName.equals("reset")) {
                styleStack.reset();
            } else if (tagName.equals("__link__")) {
                if (attributes != null) {
                    String url = attributes.trim();
                    styleStack.pushLink(tagName, url);
                }
            } else if (tagName.startsWith("#")) {
                styleStack.pushColor(tagName, TextFormatter.parseHexColor(tagName));
            } else {
                TextFormatter.applyTag(styleStack, tagName);
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < text.length()) {
            String content = text.substring(lastEnd);
            root.m_7220_((Component)Component.m_237113_((String)content).m_6270_(styleStack.current()));
        }
        return root;
    }

    public static Component parseToComponent(String text) {
        return TextFormatter.parse(text);
    }

    private static String resolveFTBTranslationKeys(String text) {
        if (text == null || !text.contains("{ftbquests.")) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        Matcher matcher = FTB_TRANSLATION_KEY_PATTERN.matcher(text);
        while (matcher.find()) {
            String translated;
            String key = matcher.group(1);
            try {
                translated = I18n.m_118938_((String)key, (Object[])new Object[0]);
                if (translated.equals(key)) {
                    translated = TextFormatter.extractFallbackFromKey(key);
                }
            }
            catch (Exception e) {
                translated = TextFormatter.extractFallbackFromKey(key);
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(translated));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String extractFallbackFromKey(String key) {
        if (key == null) {
            return "";
        }
        if (key.endsWith(".title") || key.endsWith(".subtitle") || key.matches(".*\\.description\\d*$") || key.matches(".*\\.image\\d*$") || key.matches(".*\\.task\\..*\\.title$")) {
            return "";
        }
        return "{" + key + "}";
    }

    private static String preprocessMarkdown(String text) {
        StringBuffer sb = new StringBuffer();
        Matcher imageMatcher = FTB_IMAGE_PATTERN.matcher(text);
        while (imageMatcher.find()) {
            String path = imageMatcher.group(1);
            String width = imageMatcher.group(2);
            String height = imageMatcher.group(3);
            String align = imageMatcher.group(4);
            StringBuilder imgTag = new StringBuilder("<img src=\"");
            imgTag.append(path).append("\"");
            if (width != null) {
                imgTag.append(" width=\"").append(width).append("\"");
            }
            if (height != null) {
                imgTag.append(" height=\"").append(height).append("\"");
            }
            if (align != null) {
                imgTag.append(" align=\"").append(align).append("\"");
            }
            imgTag.append("/>");
            imageMatcher.appendReplacement(sb, Matcher.quoteReplacement(imgTag.toString()));
        }
        imageMatcher.appendTail(sb);
        text = sb.toString();
        text = MARKDOWN_HEADER.matcher(text).replaceAll("<gold><bold>$1</bold></gold>");
        text = MARKDOWN_BOLD.matcher(text).replaceAll("<bold>$1</bold>");
        text = SLASH_E_PATTERN.matcher(text).replaceAll("<italic>$1</italic>");
        text = SLASH_9_PATTERN.matcher(text).replaceAll("<aqua>$1</aqua>");
        return text;
    }

    private static String processLinks(String text, List<String> urls) {
        StringBuffer result = new StringBuffer();
        Matcher linkMatcher = LINK_PATTERN.matcher(text);
        while (linkMatcher.find()) {
            String url = linkMatcher.group(1);
            String linkText = linkMatcher.group(2);
            String replacement = "<__link__ " + url + ">" + linkText + "</__link__>";
            linkMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        linkMatcher.appendTail(result);
        text = result.toString();
        result = new StringBuffer();
        Matcher anchorMatcher = ANCHOR_PATTERN.matcher(text);
        while (anchorMatcher.find()) {
            String url = anchorMatcher.group(1);
            String linkText = anchorMatcher.group(2);
            String replacement = "<__link__ " + url + ">" + linkText + "</__link__>";
            anchorMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        anchorMatcher.appendTail(result);
        return result.toString();
    }

    public static String stripTags(String text) {
        if (text == null) {
            return "";
        }
        return TAG_PATTERN.matcher(text).replaceAll("");
    }

    public static String getPreview(String text, int maxLength) {
        String plain = TextFormatter.stripTags(text);
        if (plain.length() <= maxLength) {
            return plain;
        }
        return plain.substring(0, maxLength - 3) + "...";
    }

    private static void applyTag(StyleStack stack, String tag) {
        switch (tag) {
            case "black": {
                stack.pushColor(tag, ChatFormatting.BLACK);
                break;
            }
            case "dark_blue": {
                stack.pushColor(tag, ChatFormatting.DARK_BLUE);
                break;
            }
            case "dark_green": {
                stack.pushColor(tag, ChatFormatting.DARK_GREEN);
                break;
            }
            case "dark_aqua": 
            case "dark_cyan": {
                stack.pushColor(tag, ChatFormatting.DARK_AQUA);
                break;
            }
            case "dark_red": {
                stack.pushColor(tag, ChatFormatting.DARK_RED);
                break;
            }
            case "dark_purple": 
            case "purple": {
                stack.pushColor(tag, ChatFormatting.DARK_PURPLE);
                break;
            }
            case "gold": 
            case "orange": {
                stack.pushColor(tag, ChatFormatting.GOLD);
                break;
            }
            case "gray": 
            case "grey": {
                stack.pushColor(tag, ChatFormatting.GRAY);
                break;
            }
            case "dark_gray": 
            case "dark_grey": {
                stack.pushColor(tag, ChatFormatting.DARK_GRAY);
                break;
            }
            case "blue": {
                stack.pushColor(tag, ChatFormatting.BLUE);
                break;
            }
            case "green": 
            case "lime": {
                stack.pushColor(tag, ChatFormatting.GREEN);
                break;
            }
            case "aqua": 
            case "cyan": {
                stack.pushColor(tag, ChatFormatting.AQUA);
                break;
            }
            case "red": {
                stack.pushColor(tag, ChatFormatting.RED);
                break;
            }
            case "light_purple": 
            case "pink": 
            case "magenta": {
                stack.pushColor(tag, ChatFormatting.LIGHT_PURPLE);
                break;
            }
            case "yellow": {
                stack.pushColor(tag, ChatFormatting.YELLOW);
                break;
            }
            case "white": {
                stack.pushColor(tag, ChatFormatting.WHITE);
                break;
            }
            case "bold": 
            case "b": {
                stack.pushFormat(tag, "bold");
                break;
            }
            case "italic": 
            case "i": 
            case "em": {
                stack.pushFormat(tag, "italic");
                break;
            }
            case "underline": 
            case "u": {
                stack.pushFormat(tag, "underline");
                break;
            }
            case "strikethrough": 
            case "strike": 
            case "s": {
                stack.pushFormat(tag, "strikethrough");
                break;
            }
            case "obfuscated": 
            case "obf": {
                stack.pushFormat(tag, "obfuscated");
            }
        }
    }

    private static TextColor parseHexColor(String hex) {
        try {
            String color = hex.startsWith("#") ? hex.substring(1) : hex;
            int rgb = Integer.parseInt(color, 16);
            return TextColor.m_131266_((int)rgb);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FormattedTextWithImages parseWithImages(String text) {
        if (text == null || text.isEmpty()) {
            return new FormattedTextWithImages((Component)Component.m_237119_(), new ArrayList<FormattedTextWithImages.ImageElement>());
        }
        text = TextFormatter.resolveFTBTranslationKeys(text);
        text = TextFormatter.preprocessMarkdown(text);
        ArrayList<FormattedTextWithImages.ImageElement> images = new ArrayList<FormattedTextWithImages.ImageElement>();
        StringBuffer textWithoutImages = new StringBuffer();
        Matcher imgMatcher = IMG_TAG_PATTERN.matcher(text);
        int currentLineIndex = 0;
        while (imgMatcher.find()) {
            String path = imgMatcher.group(1);
            String widthStr = imgMatcher.group(2);
            String heightStr = imgMatcher.group(3);
            String align = imgMatcher.group(4);
            int width = widthStr != null ? Integer.parseInt(widthStr) : 100;
            int height = heightStr != null ? Integer.parseInt(heightStr) : 100;
            String textBefore = text.substring(0, imgMatcher.start());
            currentLineIndex = textBefore.split("\n", -1).length - 1;
            images.add(new FormattedTextWithImages.ImageElement(path, width, height, align, currentLineIndex));
            imgMatcher.appendReplacement(textWithoutImages, Matcher.quoteReplacement("\n"));
        }
        imgMatcher.appendTail(textWithoutImages);
        Component textComponent = TextFormatter.parse(textWithoutImages.toString());
        return new FormattedTextWithImages(textComponent, images);
    }

    public static String convertMinecraftCodesToTags(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replace('\u00a7', '&');
        StringBuilder out = new StringBuilder();
        Stack<String> open = new Stack<String>();
        for (int i = 0; i < text.length(); ++i) {
            char code;
            String tag;
            char c = text.charAt(i);
            if (c == '&' && i + 1 < text.length() && (tag = TextFormatter.getTagForCode(code = Character.toLowerCase(text.charAt(i + 1)))) != null) {
                if ("reset".equals(tag)) {
                    while (!open.isEmpty()) {
                        out.append("</").append((String)open.pop()).append(">");
                    }
                } else if (TextFormatter.isColorCode(code)) {
                    Stack<String> fmt = new Stack<String>();
                    while (!open.isEmpty()) {
                        String top = (String)open.peek();
                        if (TextFormatter.isFormattingTag(top)) {
                            fmt.push((String)open.pop());
                            continue;
                        }
                        out.append("</").append((String)open.pop()).append(">");
                    }
                    out.append('<').append(tag).append('>');
                    open.push(tag);
                    while (!fmt.isEmpty()) {
                        String t = (String)fmt.pop();
                        open.push(t);
                    }
                } else {
                    out.append('<').append(tag).append('>');
                    open.push(tag);
                }
                ++i;
                continue;
            }
            out.append(c);
        }
        while (!open.isEmpty()) {
            out.append("</").append((String)open.pop()).append(">");
        }
        return out.toString();
    }

    public static Integer firstArgbFromMinecraftCodes(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace('\u00a7', '&');
        for (int i = 0; i < text.length() - 1; ++i) {
            ChatFormatting fmt;
            char code;
            if (text.charAt(i) != '&' || !TextFormatter.isColorCode(code = Character.toLowerCase(text.charAt(i + 1))) || (fmt = TextFormatter.colorForCode(code)) == null || fmt.m_126665_() == null) continue;
            return 0xFF000000 | fmt.m_126665_();
        }
        return null;
    }

    private static String getTagForCode(char code) {
        return switch (code) {
            case '0' -> "black";
            case '1' -> "dark_blue";
            case '2' -> "dark_green";
            case '3' -> "dark_aqua";
            case '4' -> "dark_red";
            case '5' -> "dark_purple";
            case '6' -> "gold";
            case '7' -> "gray";
            case '8' -> "dark_gray";
            case '9' -> "blue";
            case 'a' -> "green";
            case 'b' -> "aqua";
            case 'c' -> "red";
            case 'd' -> "light_purple";
            case 'e' -> "yellow";
            case 'f' -> "white";
            case 'k' -> "obfuscated";
            case 'l' -> "bold";
            case 'm' -> "strikethrough";
            case 'n' -> "underline";
            case 'o' -> "italic";
            case 'r' -> "reset";
            default -> null;
        };
    }

    private static boolean isColorCode(char code) {
        return "0123456789abcdef".indexOf(code) >= 0;
    }

    private static boolean isFormattingTag(String tag) {
        return tag.equals("bold") || tag.equals("italic") || tag.equals("underline") || tag.equals("strikethrough") || tag.equals("obfuscated");
    }

    private static ChatFormatting colorForCode(char code) {
        return switch (code) {
            case '0' -> ChatFormatting.BLACK;
            case '1' -> ChatFormatting.DARK_BLUE;
            case '2' -> ChatFormatting.DARK_GREEN;
            case '3' -> ChatFormatting.DARK_AQUA;
            case '4' -> ChatFormatting.DARK_RED;
            case '5' -> ChatFormatting.DARK_PURPLE;
            case '6' -> ChatFormatting.GOLD;
            case '7' -> ChatFormatting.GRAY;
            case '8' -> ChatFormatting.DARK_GRAY;
            case '9' -> ChatFormatting.BLUE;
            case 'a' -> ChatFormatting.GREEN;
            case 'b' -> ChatFormatting.AQUA;
            case 'c' -> ChatFormatting.RED;
            case 'd' -> ChatFormatting.LIGHT_PURPLE;
            case 'e' -> ChatFormatting.YELLOW;
            case 'f' -> ChatFormatting.WHITE;
            default -> null;
        };
    }

    private static class StyleStack {
        private final List<StyleLayer> stack = new ArrayList<StyleLayer>();

        private StyleStack() {
        }

        public Style current() {
            Style style = Style.f_131099_;
            for (StyleLayer layer : this.stack) {
                style = layer.apply(style);
            }
            return style;
        }

        public void pushColor(String tag, ChatFormatting formatting) {
            Integer color = formatting.m_126665_();
            if (color != null) {
                this.stack.add(new StyleLayer(tag, "color", TextColor.m_131266_((int)color), null));
            }
        }

        public void pushColor(String tag, TextColor color) {
            if (color != null) {
                this.stack.add(new StyleLayer(tag, "color", color, null));
            }
        }

        public void pushFormat(String tag, String formatType) {
            this.stack.add(new StyleLayer(tag, formatType, null, null));
        }

        public void pushLink(String tag, String url) {
            this.stack.add(new StyleLayer(tag, "link", null, url));
        }

        public void pop(String tag) {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                if (!this.stack.get((int)i).tag.equals(tag)) continue;
                this.stack.remove(i);
                break;
            }
        }

        public void reset() {
            this.stack.clear();
        }
    }

    private static class StyleLayer {
        final String tag;
        final String type;
        final TextColor color;
        final String url;

        StyleLayer(String tag, String type, TextColor color, String url) {
            this.tag = tag;
            this.type = type;
            this.color = color;
            this.url = url;
        }

        Style apply(Style base) {
            Style result;
            switch (this.type) {
                case "color": {
                    Style style = base.m_131148_(this.color);
                    break;
                }
                case "bold": {
                    Style style = base.m_131136_(Boolean.valueOf(true));
                    break;
                }
                case "italic": {
                    Style style = base.m_131155_(Boolean.valueOf(true));
                    break;
                }
                case "underline": {
                    Style style = base.m_131162_(Boolean.valueOf(true));
                    break;
                }
                case "strikethrough": {
                    Style style = base.m_178522_(Boolean.valueOf(true));
                    break;
                }
                case "obfuscated": {
                    Style style = base.m_178524_(Boolean.valueOf(true));
                    break;
                }
                case "link": {
                    Style style = base.m_131148_(TextColor.m_131266_((int)0x55FFFF)).m_131162_(Boolean.valueOf(true));
                    break;
                }
                default: {
                    Style style = result = base;
                }
            }
            if (this.type.equals("link") && this.url != null && !this.url.isEmpty()) {
                try {
                    result = result.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, this.url)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to open: " + this.url))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

