/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.questory.manager.TriggerListenerManager;

public class TriggerPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> onSelect;
    private final List<String> allTriggers;
    private List<String> filteredTriggers;
    private EditBox searchBox;
    private int scroll = 0;
    private boolean draggingScrollbar = false;

    public TriggerPickerScreen(Screen parent, Consumer<String> onSelect) {
        super((Component)Component.m_237113_((String)"Select Trigger"));
        this.parent = parent;
        this.onSelect = onSelect;
        this.allTriggers = TriggerListenerManager.getInstance().getKnownTriggerIds().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList());
        this.filteredTriggers = new ArrayList<String>(this.allTriggers);
    }

    protected void m_7856_() {
        super.m_7856_();
        int panelW = 300;
        int panelH = 400;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        this.searchBox = new EditBox(this.f_96547_, panelX + 10, panelY + 30, panelW - 20, 20, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94151_(this::updateFilter);
        this.m_142416_((GuiEventListener)this.searchBox);
        int btnW = 80;
        int btnX = this.f_96543_ / 2 - btnW / 2;
        int btnY = panelY + panelH - 28;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(btnX, btnY, btnW, 20).m_253136_());
    }

    private void updateFilter(String query) {
        if (query.isBlank()) {
            this.filteredTriggers = new ArrayList<String>(this.allTriggers);
        } else {
            String lower = query.toLowerCase();
            this.filteredTriggers = this.allTriggers.stream().filter(t -> t.toLowerCase().contains(lower)).collect(Collectors.toList());
        }
        this.scroll = 0;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int panelW = 300;
        int panelH = 400;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        g.m_280509_(panelX, panelY, panelX + panelW, panelY + panelH, -535818224);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, panelY + 10, -1);
        int listY = panelY + 60;
        int listH = panelH - 100;
        int lineH = 15;
        g.m_280588_(panelX, listY, panelX + panelW, listY + listH);
        int maxVisible = listH / lineH;
        this.scroll = Math.max(0, Math.min(this.scroll, Math.max(0, this.filteredTriggers.size() - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, this.filteredTriggers.size() - this.scroll); ++i) {
            boolean hover;
            int index = this.scroll + i;
            String trigger = this.filteredTriggers.get(index);
            int itemY = listY + i * lineH;
            boolean bl = hover = mouseX >= panelX + 8 && mouseX <= panelX + panelW - 8 && mouseY >= itemY && mouseY < itemY + lineH;
            if (hover) {
                g.m_280509_(panelX + 8, itemY, panelX + panelW - 8, itemY + lineH, -12952966);
            }
            g.m_280488_(this.f_96547_, trigger, panelX + 12, itemY + 4, -1);
        }
        g.m_280618_();
        int total = this.filteredTriggers.size();
        if (total > maxVisible) {
            int barW = 6;
            int trackX = panelX + panelW - 8 - barW;
            int trackY = listY;
            int trackH = listH;
            g.m_280509_(trackX, trackY, trackX + barW, trackY + trackH, 0x40222222);
            int thumbH = Math.max(12, (int)((float)trackH * (float)maxVisible / (float)total));
            int maxScroll = total - maxVisible;
            int thumbMax = trackH - thumbH;
            int thumbY = trackY + (maxScroll == 0 ? 0 : (int)((float)this.scroll / (float)maxScroll * (float)thumbMax));
            g.m_280509_(trackX + 1, thumbY, trackX + barW - 1, thumbY + thumbH, this.draggingScrollbar ? -9787695 : -7829368);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int total;
        int index;
        int panelW = 300;
        int panelH = 400;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        int listY = panelY + 60;
        int listH = panelH - 100;
        int lineH = 15;
        int maxVisible = listH / lineH;
        if (mouseX >= (double)(panelX + 8) && mouseX <= (double)(panelX + panelW - 8) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (index = this.scroll + ((int)mouseY - listY) / lineH) >= 0 && index < this.filteredTriggers.size()) {
            this.onSelect.accept(this.filteredTriggers.get(index));
            this.f_96541_.m_91152_(this.parent);
            return true;
        }
        int barW = 6;
        int trackX = panelX + panelW - 8 - barW;
        if (mouseX >= (double)trackX && mouseX <= (double)(trackX + barW) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (total = this.filteredTriggers.size()) > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            this.draggingScrollbar = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int panelW = 300;
        int panelH = 400;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelW) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelH)) {
            this.scroll = (int)Math.max(0.0, (double)this.scroll - Math.signum(delta));
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScrollbar) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        int panelW = 300;
        int panelH = 400;
        int panelX = this.f_96543_ / 2 - panelW / 2;
        int panelY = this.f_96544_ / 2 - panelH / 2;
        int listY = panelY + 60;
        int listH = panelH - 100;
        int lineH = 15;
        int maxVisible = Math.max(1, listH / lineH);
        int total = this.filteredTriggers.size();
        if (total > maxVisible) {
            int thumbH = Math.max(12, (int)((float)listH * (float)maxVisible / (float)total));
            int thumbMax = listH - thumbH;
            double rel = (mouseY - (double)listY - (double)thumbH / 2.0) / (double)Math.max(1, thumbMax);
            rel = Math.max(0.0, Math.min(1.0, rel));
            int maxScroll = total - maxVisible;
            this.scroll = (int)Math.round(rel * (double)maxScroll);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }
}

