/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.TextFormatter;

public class EditorNotification {
    private static final List<Toast> toasts = new ArrayList<Toast>();
    private static final int TOAST_WIDTH = 400;
    private static final int TOAST_HEIGHT = 32;
    private static final int PADDING = 8;
    private static final int DEFAULT_DURATION = 4000;

    public static void success(String message) {
        EditorNotification.show(message, Type.SUCCESS, 4000);
    }

    public static void error(String message) {
        EditorNotification.show(message, Type.ERROR, 6000);
    }

    public static void warning(String message) {
        EditorNotification.show(message, Type.WARNING, 4000);
    }

    public static void info(String message) {
        EditorNotification.show(message, Type.INFO, 4000);
    }

    public static void show(String message, Type type, int durationMs) {
        toasts.removeIf(t -> t.message.equals(message) && t.type == type);
        while (toasts.size() >= 3) {
            toasts.remove(0);
        }
        toasts.add(new Toast(message, type, durationMs));
    }

    public static void render(GuiGraphics graphics, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        toasts.removeIf(Toast::isExpired);
        if (toasts.isEmpty()) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        int yOffset = 8;
        for (Toast toast : toasts) {
            float alpha;
            if (toast.slideIn < 1.0f) {
                toast.slideIn = Math.min(1.0f, toast.slideIn + 0.1f);
            }
            if ((alpha = toast.getAlpha()) <= 0.0f) continue;
            int alphaInt = (int)(alpha * 255.0f);
            int x = (screenWidth - 400) / 2;
            int y = yOffset;
            graphics.m_280509_(x + 2, (y -= (int)((1.0f - toast.slideIn) * 32.0f)) + 2, x + 400 + 2, y + 32 + 2, alphaInt / 2 << 24);
            int bgColor = alphaInt << 24 | toast.type.bgColor;
            int borderColor = alphaInt << 24 | toast.type.textColor;
            graphics.m_280509_(x - 1, y - 1, x + 400 + 1, y + 32 + 1, borderColor);
            graphics.m_280509_(x, y, x + 400, y + 32, bgColor);
            int iconX = x + 8;
            Objects.requireNonNull(font);
            int iconY = y + (32 - 9) / 2;
            int textColor = alphaInt << 24 | toast.type.textColor;
            graphics.m_280056_(font, toast.type.icon, iconX, iconY, textColor, false);
            int textX = iconX + font.m_92895_(toast.type.icon) + 6;
            int maxTextWidth = 400 - (textX - x) - 8;
            Component formattedMessage = TextFormatter.parseToComponent(toast.message);
            Object plainText = formattedMessage.getString();
            if (font.m_92895_((String)plainText) > maxTextWidth) {
                plainText = font.m_92837_((String)plainText, maxTextWidth - 10, false) + "...";
                formattedMessage = Component.m_237113_((String)plainText);
            }
            graphics.m_280614_(font, formattedMessage, textX, iconY, 0xFFFFFF | alphaInt << 24, true);
            yOffset += 36;
        }
        graphics.m_280168_().m_85849_();
    }

    public static void clear() {
        toasts.clear();
    }

    public static enum Type {
        SUCCESS(0x55FF55, 2785066, "\u2713"),
        ERROR(0xFF5555, 8333866, "\u2715"),
        WARNING(0xFFAA00, 8344832, "\u26a0"),
        INFO(0x5555FF, 2763391, "\u2139");

        final int textColor;
        final int bgColor;
        final String icon;

        private Type(int textColor, int bgColor, String icon) {
            this.textColor = textColor;
            this.bgColor = bgColor;
            this.icon = icon;
        }
    }

    private static class Toast {
        final String message;
        final Type type;
        final long createdAt;
        final int duration;
        float slideIn = 0.0f;

        Toast(String message, Type type, int duration) {
            this.message = message;
            this.type = type;
            this.createdAt = System.currentTimeMillis();
            this.duration = duration;
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.createdAt > (long)this.duration;
        }

        float getAlpha() {
            long elapsed = System.currentTimeMillis() - this.createdAt;
            if (elapsed < 200L) {
                return (float)elapsed / 200.0f;
            }
            if (elapsed > (long)(this.duration - 300)) {
                return (float)((long)this.duration - elapsed) / 300.0f;
            }
            return 1.0f;
        }
    }
}

