/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class BackgroundRenderer {
    private BackgroundType type = BackgroundType.SOLID;
    private int color1 = Integer.MIN_VALUE;
    private int color2 = Integer.MIN_VALUE;
    private ResourceLocation texture;
    private float scrollSpeedX = 0.0f;
    private float scrollSpeedY = 0.0f;
    private float animationTime = 0.0f;
    private int tileSize = 16;
    private Integer tintColor = null;

    public BackgroundRenderer withSolidColor(int color) {
        this.type = BackgroundType.SOLID;
        this.color1 = color;
        return this;
    }

    public BackgroundRenderer withGradient(int topColor, int bottomColor) {
        this.type = BackgroundType.GRADIENT;
        this.color1 = topColor;
        this.color2 = bottomColor;
        return this;
    }

    public BackgroundRenderer withTexture(ResourceLocation texture) {
        this.type = BackgroundType.TEXTURE;
        this.texture = texture;
        return this;
    }

    public BackgroundRenderer withTiledTexture(ResourceLocation texture, int tileSize) {
        this.type = BackgroundType.TILED;
        this.texture = texture;
        this.tileSize = tileSize;
        return this;
    }

    public BackgroundRenderer withScrolling(ResourceLocation texture, float speedX, float speedY) {
        this.type = BackgroundType.ANIMATED;
        this.texture = texture;
        this.scrollSpeedX = speedX;
        this.scrollSpeedY = speedY;
        return this;
    }

    public BackgroundRenderer withTint(Integer argb) {
        this.tintColor = argb;
        return this;
    }

    public void tick() {
        if (this.type == BackgroundType.ANIMATED) {
            this.animationTime += 0.05f;
            if (this.animationTime > 1000.0f) {
                this.animationTime = 0.0f;
            }
        }
    }

    public void render(GuiGraphics graphics, int x, int y, int width, int height) {
        switch (this.type.ordinal()) {
            case 0: {
                this.renderSolid(graphics, x, y, width, height);
                break;
            }
            case 1: {
                this.renderGradient(graphics, x, y, width, height);
                break;
            }
            case 2: {
                this.renderTexture(graphics, x, y, width, height);
                break;
            }
            case 3: {
                this.renderTiled(graphics, x, y, width, height);
                break;
            }
            case 4: {
                this.renderAnimated(graphics, x, y, width, height);
            }
        }
    }

    private void renderSolid(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + height, this.color1);
    }

    private void renderGradient(GuiGraphics graphics, int x, int y, int width, int height) {
        int steps = Math.max(2, height / 4);
        for (int i = 0; i < steps; ++i) {
            int y1 = y + i * height / steps;
            int y2 = y + (i + 1) * height / steps;
            float t = (float)i / (float)(steps - 1);
            int r = (int)((float)(this.color1 >> 16 & 0xFF) * (1.0f - t) + (float)(this.color2 >> 16 & 0xFF) * t);
            int g = (int)((float)(this.color1 >> 8 & 0xFF) * (1.0f - t) + (float)(this.color2 >> 8 & 0xFF) * t);
            int b = (int)((float)(this.color1 & 0xFF) * (1.0f - t) + (float)(this.color2 & 0xFF) * t);
            int a = (int)((float)(this.color1 >> 24 & 0xFF) * (1.0f - t) + (float)(this.color2 >> 24 & 0xFF) * t);
            int color = a << 24 | r << 16 | g << 8 | b;
            graphics.m_280509_(x, y1, x + width, y2, color);
        }
    }

    private void renderTexture(GuiGraphics graphics, int x, int y, int width, int height) {
        if (this.texture == null) {
            this.renderSolid(graphics, x, y, width, height);
            return;
        }
        try {
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            if (this.tintColor != null) {
                float a = (float)(this.tintColor >>> 24 & 0xFF) / 255.0f;
                float r = (float)(this.tintColor >>> 16 & 0xFF) / 255.0f;
                float g = (float)(this.tintColor >>> 8 & 0xFF) / 255.0f;
                float b = (float)(this.tintColor & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            }
            graphics.m_280163_(this.texture, x, y, 0.0f, 0.0f, width, height, width, height);
            if (this.tintColor != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.disableBlend();
        }
        catch (Exception e) {
            this.renderSolid(graphics, x, y, width, height);
        }
    }

    private void renderTiled(GuiGraphics graphics, int x, int y, int width, int height) {
        if (this.texture == null) {
            this.renderSolid(graphics, x, y, width, height);
            return;
        }
        try {
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            if (this.tintColor != null) {
                float a = (float)(this.tintColor >>> 24 & 0xFF) / 255.0f;
                float r = (float)(this.tintColor >>> 16 & 0xFF) / 255.0f;
                float g = (float)(this.tintColor >>> 8 & 0xFF) / 255.0f;
                float b = (float)(this.tintColor & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            }
            int tilesX = (width + this.tileSize - 1) / this.tileSize;
            int tilesY = (height + this.tileSize - 1) / this.tileSize;
            for (int ty = 0; ty < tilesY; ++ty) {
                for (int tx = 0; tx < tilesX; ++tx) {
                    int tileX = x + tx * this.tileSize;
                    int tileY = y + ty * this.tileSize;
                    int tileW = Math.min(this.tileSize, width - tx * this.tileSize);
                    int tileH = Math.min(this.tileSize, height - ty * this.tileSize);
                    graphics.m_280163_(this.texture, tileX, tileY, 0.0f, 0.0f, tileW, tileH, this.tileSize, this.tileSize);
                }
            }
            if (this.tintColor != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.disableBlend();
        }
        catch (Exception e) {
            this.renderSolid(graphics, x, y, width, height);
        }
    }

    private void renderAnimated(GuiGraphics graphics, int x, int y, int width, int height) {
        if (this.texture == null) {
            this.renderSolid(graphics, x, y, width, height);
            return;
        }
        try {
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            if (this.tintColor != null) {
                float a = (float)(this.tintColor >>> 24 & 0xFF) / 255.0f;
                float r = (float)(this.tintColor >>> 16 & 0xFF) / 255.0f;
                float g = (float)(this.tintColor >>> 8 & 0xFF) / 255.0f;
                float b = (float)(this.tintColor & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            }
            float offsetX = this.animationTime * this.scrollSpeedX % (float)this.tileSize;
            float offsetY = this.animationTime * this.scrollSpeedY % (float)this.tileSize;
            int tilesX = (width + this.tileSize) / this.tileSize + 1;
            int tilesY = (height + this.tileSize) / this.tileSize + 1;
            for (int ty = 0; ty < tilesY; ++ty) {
                for (int tx = 0; tx < tilesX; ++tx) {
                    int tileX = (int)((float)(x + tx * this.tileSize) - offsetX);
                    int tileY = (int)((float)(y + ty * this.tileSize) - offsetY);
                    if (tileX + this.tileSize < x || tileX > x + width || tileY + this.tileSize < y || tileY > y + height) continue;
                    graphics.m_280163_(this.texture, tileX, tileY, 0.0f, 0.0f, this.tileSize, this.tileSize, this.tileSize, this.tileSize);
                }
            }
            if (this.tintColor != null) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.disableBlend();
        }
        catch (Exception e) {
            this.renderSolid(graphics, x, y, width, height);
        }
    }

    public static BackgroundRenderer darkGradient() {
        return new BackgroundRenderer().withGradient(-1073741824, -536870912);
    }

    public static BackgroundRenderer lightGradient() {
        return new BackgroundRenderer().withGradient(0x40FFFFFF, 0x60FFFFFF);
    }

    public static BackgroundRenderer transparent() {
        return new BackgroundRenderer().withSolidColor(0);
    }

    public static BackgroundRenderer solid(int color) {
        return new BackgroundRenderer().withSolidColor(color);
    }

    public static BackgroundRenderer fromTheme(String themeBackground) {
        if (themeBackground == null || themeBackground.isEmpty()) {
            return BackgroundRenderer.darkGradient();
        }
        String[] parts = themeBackground.split(":");
        if (parts.length == 0) {
            return BackgroundRenderer.darkGradient();
        }
        try {
            switch (parts[0].toLowerCase()) {
                case "solid": {
                    if (parts.length < 2) break;
                    return BackgroundRenderer.solid(BackgroundRenderer.parseColor(parts[1]));
                }
                case "gradient": {
                    if (parts.length < 3) break;
                    return new BackgroundRenderer().withGradient(BackgroundRenderer.parseColor(parts[1]), BackgroundRenderer.parseColor(parts[2]));
                }
                case "texture": {
                    if (parts.length < 2) break;
                    ResourceLocation loc = new ResourceLocation(parts[1]);
                    return new BackgroundRenderer().withTexture(loc);
                }
                case "tiled": {
                    if (parts.length < 3) break;
                    ResourceLocation loc = new ResourceLocation(parts[1]);
                    int size = parts.length >= 4 ? Integer.parseInt(parts[2]) : 16;
                    return new BackgroundRenderer().withTiledTexture(loc, size);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BackgroundRenderer.darkGradient();
    }

    private static int parseColor(String colorStr) {
        if (colorStr.startsWith("0x") || colorStr.startsWith("0X")) {
            return (int)Long.parseLong(colorStr.substring(2), 16);
        }
        if (colorStr.startsWith("#")) {
            return (int)Long.parseLong(colorStr.substring(1), 16);
        }
        return (int)Long.parseLong(colorStr, 16);
    }

    public static enum BackgroundType {
        SOLID,
        GRADIENT,
        TEXTURE,
        TILED,
        ANIMATED;

    }
}

