/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class ThemeIconRenderer {
    public static void draw(GuiGraphics g, IconProperty iconProperty, int x, int y, int w, int h) {
        if (iconProperty == null) {
            return;
        }
        String path = iconProperty.getTexturePath();
        if ("builtin".equals(path)) {
            ThemeIconRenderer.drawBuiltin(g, iconProperty, x, y, w, h);
            return;
        }
        ResourceLocation loc = iconProperty.getResourceLocation();
        if (loc == null) {
            Integer tint = iconProperty.getColorModifier();
            if (tint != null) {
                int pad = iconProperty.getPadding() != null ? iconProperty.getPadding() : 0;
                g.m_280509_(x + pad, y + pad, x + w - pad, y + h - pad, tint.intValue());
            }
            return;
        }
        int pad = iconProperty.getPadding() != null ? iconProperty.getPadding() : 0;
        int drawX = x + pad;
        int drawY = y + pad;
        int drawW = Math.max(0, w - 2 * pad);
        int drawH = Math.max(0, h - 2 * pad);
        Integer tile = iconProperty.getTileSize();
        Integer tint = iconProperty.getColorModifier();
        if (tile != null && tile > 0) {
            if (tint != null) {
                float a = (float)(tint >> 24 & 0xFF) / 255.0f;
                float r = (float)(tint >> 16 & 0xFF) / 255.0f;
                float gch = (float)(tint >> 8 & 0xFF) / 255.0f;
                float b = (float)(tint & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)gch, (float)b, (float)a);
            }
            for (int yy = 0; yy < drawH; yy += tile.intValue()) {
                int th = Math.min(tile, drawH - yy);
                for (int xx = 0; xx < drawW; xx += tile.intValue()) {
                    int tw = Math.min(tile, drawW - xx);
                    g.m_280163_(loc, drawX + xx, drawY + yy, 0.0f, 0.0f, tw, th, tile.intValue(), tile.intValue());
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        if (tint != null) {
            float a = (float)(tint >> 24 & 0xFF) / 255.0f;
            float r = (float)(tint >> 16 & 0xFF) / 255.0f;
            float gch = (float)(tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(tint & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)gch, (float)b, (float)a);
            g.m_280163_(loc, drawX, drawY, 0.0f, 0.0f, drawW, drawH, drawW, drawH);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            g.m_280163_(loc, drawX, drawY, 0.0f, 0.0f, drawW, drawH, drawW, drawH);
        }
    }

    public static void draw(GuiGraphics g, IconProperty.IconData data, int x, int y, int w, int h) {
        if (data == null) {
            return;
        }
        String path = data.path == null ? "" : data.path;
        String colorStr = data.modifiers != null ? data.modifiers.get("color") : null;
        Integer tint = ThemeIconRenderer.parseColor(colorStr);
        int pad = 0;
        try {
            if (data.modifiers != null && data.modifiers.get("padding") != null) {
                pad = Integer.parseInt(data.modifiers.get("padding"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int drawX = x + pad;
        int drawY = y + pad;
        int drawW = Math.max(0, w - 2 * pad);
        int drawH = Math.max(0, h - 2 * pad);
        if (data.isShape()) {
            Integer parsed;
            String shapeColor = data.getShapeColor();
            int shapeColorInt = -8355712;
            if (shapeColor != null && (parsed = ThemeIconRenderer.parseColor(shapeColor)) != null) {
                shapeColorInt = parsed;
            }
            ThemeIconRenderer.drawShape(g, data.getShapeType(), drawX, drawY, drawW, drawH, shapeColorInt);
            return;
        }
        if (data.isPart()) {
            int[] pos;
            ResourceLocation loc = ThemeIconRenderer.parseResource(path);
            if (loc != null && (pos = data.getPartPosition()) != null && pos.length >= 4) {
                g.m_280163_(loc, drawX, drawY, (float)pos[0], (float)pos[1], drawW, drawH, pos[2], pos[3]);
                return;
            }
            if (tint != null) {
                g.m_280509_(drawX, drawY, drawX + drawW, drawY + drawH, tint.intValue());
            }
            return;
        }
        if (path.equals("builtin")) {
            int c = tint != null ? tint : -8355712;
            g.m_280509_(drawX, drawY, drawX + drawW, drawY + drawH, c);
            return;
        }
        if (path.isEmpty()) {
            if (tint != null) {
                g.m_280509_(drawX, drawY, drawX + drawW, drawY + drawH, tint.intValue());
            }
            return;
        }
        ResourceLocation loc = ThemeIconRenderer.parseResource(path);
        if (loc == null) {
            if (tint != null) {
                g.m_280509_(drawX, drawY, drawX + drawW, drawY + drawH, tint.intValue());
            }
            return;
        }
        Integer tile = null;
        try {
            if (data.modifiers != null && data.modifiers.get("tile_size") != null) {
                tile = Integer.parseInt(data.modifiers.get("tile_size"));
            }
        }
        catch (Exception parsed) {
            // empty catch block
        }
        if (tile != null && tile > 0) {
            if (tint != null) {
                float a = (float)(tint >> 24 & 0xFF) / 255.0f;
                float r = (float)(tint >> 16 & 0xFF) / 255.0f;
                float gch = (float)(tint >> 8 & 0xFF) / 255.0f;
                float b = (float)(tint & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)gch, (float)b, (float)a);
            }
            for (int yy = 0; yy < drawH; yy += tile.intValue()) {
                int th = Math.min(tile, drawH - yy);
                for (int xx = 0; xx < drawW; xx += tile.intValue()) {
                    int tw = Math.min(tile, drawW - xx);
                    g.m_280163_(loc, drawX + xx, drawY + yy, 0.0f, 0.0f, tw, th, tile.intValue(), tile.intValue());
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        if (tint != null) {
            float a = (float)(tint >> 24 & 0xFF) / 255.0f;
            float r = (float)(tint >> 16 & 0xFF) / 255.0f;
            float gch = (float)(tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(tint & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)gch, (float)b, (float)a);
            g.m_280163_(loc, drawX, drawY, 0.0f, 0.0f, drawW, drawH, drawW, drawH);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            g.m_280163_(loc, drawX, drawY, 0.0f, 0.0f, drawW, drawH, drawW, drawH);
        }
    }

    private static ResourceLocation parseResource(String value) {
        try {
            if (value == null || value.isEmpty()) {
                return null;
            }
            if (value.startsWith("item:") || value.startsWith("tag:")) {
                return null;
            }
            String lowerValue = value.toLowerCase();
            if (lowerValue.startsWith("hollow_rectangle") || lowerValue.startsWith("rectangle") || lowerValue.startsWith("square") || lowerValue.startsWith("filled_rectangle") || lowerValue.startsWith("circle") || lowerValue.startsWith("filled_circle")) {
                return null;
            }
            String namespace = "minecraft";
            Object path = value;
            if (value.contains(":")) {
                String[] parts = value.split(":", 2);
                namespace = parts[0];
                path = parts[1];
            } else {
                namespace = "ftbquests";
            }
            if (!((String)path).startsWith("textures/")) {
                path = "textures/" + (String)path;
            }
            if (!((String)path).endsWith(".png")) {
                path = (String)path + ".png";
            }
            return new ResourceLocation(namespace, (String)path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Integer parseColor(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            s = s.trim();
            if (s.startsWith("#")) {
                String hex = s.substring(1);
                if (hex.length() == 6) {
                    int rgb = (int)Long.parseLong(hex, 16) & 0xFFFFFF;
                    return 0xFF000000 | rgb;
                }
                if (hex.length() == 8) {
                    return (int)Long.parseLong(hex, 16);
                }
            } else if (s.startsWith("0x") || s.startsWith("0X")) {
                return (int)Long.parseLong(s.substring(2), 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void drawShape(GuiGraphics g, String shapeType, int x, int y, int w, int h, int color) {
        if (shapeType == null) {
            return;
        }
        int thick = Math.max(1, Math.min(w, h) / 8);
        switch (shapeType.toLowerCase()) {
            case "hollow_rectangle": 
            case "rectangle": {
                g.m_280509_(x, y, x + w, y + thick, color);
                g.m_280509_(x, y + h - thick, x + w, y + h, color);
                g.m_280509_(x, y, x + thick, y + h, color);
                g.m_280509_(x + w - thick, y, x + w, y + h, color);
                break;
            }
            case "filled_rectangle": 
            case "square": {
                g.m_280509_(x, y, x + w, y + h, color);
                break;
            }
            case "circle": 
            case "filled_circle": {
                int cx = x + w / 2;
                int cy = y + h / 2;
                int r = Math.min(w, h) / 2;
                g.m_280509_(cx - r, cy - r, cx + r, cy + r, color);
                break;
            }
            default: {
                g.m_280509_(x, y, x + w, y + h, color);
            }
        }
    }

    private static void drawBuiltin(GuiGraphics g, IconProperty prop, int x, int y, int w, int h) {
        int out = (Integer)ThemeProperties.SYMBOL_OUT.get();
        int in = (Integer)ThemeProperties.SYMBOL_IN.get();
        if (prop == ThemeProperties.CHECK_ICON) {
            int i;
            int thick = Math.max(2, Math.min(w, h) / 8);
            for (i = 0; i < thick; ++i) {
                g.m_280168_().m_85836_();
                g.m_280509_(x + w / 8, y + h / 2 + i, x + w / 2, y + h - h / 8 + i, out);
                g.m_280168_().m_85849_();
            }
            for (i = 0; i < Math.max(1, thick - 1); ++i) {
                g.m_280509_(x + w / 8, y + h / 2 + i, x + w / 2 - thick / 2, y + h - h / 8 + i, in);
            }
            for (i = 0; i < thick; ++i) {
                g.m_280509_(x + w / 2 - i, y + h - h / 8 - i, x + w - w / 8, y + h / 4 - i, out);
            }
            for (i = 0; i < Math.max(1, thick - 1); ++i) {
                g.m_280509_(x + w / 2, y + h - h / 8 - i, x + w - w / 8 - thick / 2, y + h / 4 - i, in);
            }
            return;
        }
        if (prop == ThemeProperties.CHECKMARK_TASK_ACTIVE) {
            int thick = Math.max(1, Math.min(w, h) / 7);
            int lx = x + w / 8;
            int ly = y + h / 2;
            int mx = x + w / 2;
            int my = y + h - h / 6;
            int rx = x + w - w / 8;
            int ry = y + h / 4;
            g.m_280509_(lx, ly, mx, my, out);
            g.m_280509_(lx + thick, ly + thick, mx, my, in);
            g.m_280509_(mx - thick, my - thick, rx, ry, out);
            g.m_280509_(mx, my - thick / 2, rx - thick, ry + thick / 2, in);
            return;
        }
        if (prop == ThemeProperties.CHECKMARK_TASK_INACTIVE) {
            int thick = Math.max(1, Math.min(w, h) / 10);
            int cx = x + w / 2;
            int cy = y + h / 2;
            int r = Math.max(3, Math.min(w, h) / 3);
            g.m_280509_(cx - r, cy - r, cx + r, cy - r + thick, out);
            g.m_280509_(cx - r, cy + r - thick, cx + r, cy + r, out);
            g.m_280509_(cx - r, cy - r, cx - r + thick, cy + r, out);
            g.m_280509_(cx + r - thick, cy - r, cx + r, cy + r, out);
            return;
        }
        if (prop == ThemeProperties.LOCK_ICON) {
            int thick = Math.max(2, Math.min(w, h) / 10);
            int bodyH = (int)((double)h * 0.55);
            int shackleH = h - bodyH;
            g.m_280509_(x + thick, y + shackleH, x + w - thick, y + h - thick, out);
            g.m_280509_(x + thick * 2, y + shackleH + thick, x + w - thick * 2, y + h - thick * 2, in);
            int sx = x + w / 4;
            int ex = x + w - w / 4;
            int sy = y + thick;
            int ey = y + shackleH;
            g.m_280509_(sx, sy, sx + thick, ey, out);
            g.m_280509_(ex - thick, sy, ex, ey, out);
            g.m_280509_(sx + thick, sy, ex - thick, sy + thick, out);
            return;
        }
        if (prop == ThemeProperties.HIDDEN_ICON) {
            int cx = x + w / 2;
            int cy = y + h / 2;
            int rx = Math.max(4, w / 3);
            int ry = Math.max(3, h / 3);
            g.m_280509_(cx - rx, cy - ry / 2, cx + rx, cy + ry / 2, out);
            g.m_280509_(cx - rx + 2, cy - ry / 3, cx + rx - 2, cy + ry / 3, in);
            int pr = Math.max(2, Math.min(w, h) / 8);
            g.m_280509_(cx - pr, cy - pr, cx + pr, cy + pr, out);
            int thick = Math.max(2, Math.min(w, h) / 10);
            g.m_280509_(x, y + h - thick, x + thick, y + h, out);
            g.m_280509_(x + thick, y + h - 2 * thick, x + 2 * thick, y + h - thick, out);
            g.m_280509_(x + 2 * thick, y + h - 3 * thick, x + 3 * thick, y + h - 2 * thick, out);
            return;
        }
        int thick = Math.max(1, Math.min(w, h) / 12);
        int c = out;
        g.m_280509_(x, y, x + w, y + thick, c);
        g.m_280509_(x, y + h - thick, x + w, y + h, c);
        g.m_280509_(x, y, x + thick, y + h, c);
        g.m_280509_(x + w - thick, y, x + w, y + h, c);
    }
}

