/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.telemetry.HardwareIdGenerator;
import org.texboobcat.questory.telemetry.SupabaseClient;
import org.texboobcat.questory.telemetry.TelemetryManager;

public class TelemetryCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"questify").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"telemetry").then(Commands.m_82127_((String)"status").executes(TelemetryCommand::status))).then(Commands.m_82127_((String)"optin").executes(TelemetryCommand::optIn))).then(Commands.m_82127_((String)"optout").executes(TelemetryCommand::optOut))).then(Commands.m_82127_((String)"export").executes(TelemetryCommand::export))).then(Commands.m_82127_((String)"delete").executes(TelemetryCommand::delete))));
    }

    private static int status(CommandContext<CommandSourceStack> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        boolean enabled = tm.isEnabled();
        String hwid = HardwareIdGenerator.getHardwareId();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== Questify Telemetry Status ==="), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a77Status: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a77Hardware ID: \u00a7e" + hwid)), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)""), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77Note: This ID is machine-specific, not linked to your account."), false);
        if (enabled) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a77Session ID: \u00a7f" + String.valueOf(tm.getSessionId()))), false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a77Session Duration: \u00a7f" + TelemetryCommand.formatDuration(tm.getSessionDuration()))), false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)""), false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77You can opt-out at any time with: \u00a7f/questory telemetry optout"), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)""), false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77Telemetry helps improve quest design for everyone."), false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77All data is anonymous and stored in a central database."), false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77Opt-in with: \u00a7f/questory telemetry optin"), false);
        }
        return 1;
    }

    private static int optIn(CommandContext<CommandSourceStack> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        if (tm.isEnabled()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cTelemetry is already enabled!"));
            return 0;
        }
        tm.enableTelemetry();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7a\u2713 Telemetry enabled!"), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77Thank you for helping improve quest designs!"), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77Your data is anonymous and helps everyone."), false);
        return 1;
    }

    private static int optOut(CommandContext<CommandSourceStack> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        if (!tm.isEnabled()) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cTelemetry is already disabled!"));
            return 0;
        }
        tm.disableTelemetry();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77Telemetry disabled."), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77No further data will be collected."), false);
        return 1;
    }

    private static int export(CommandContext<CommandSourceStack> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        String hwid = HardwareIdGenerator.getHardwareId();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== GDPR Data Export ==="), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a77Your hardware ID: \u00a7f" + hwid)), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)""), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77To request a full data export, contact the mod author"), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77with this hardware ID. They can query the central database."), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)""), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77Note: This ID is machine-specific, not linked to your account."), false);
        return 1;
    }

    private static int delete(CommandContext<CommandSourceStack> ctx) {
        TelemetryManager tm = TelemetryManager.getInstance();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7c\u00a7l=== GDPR Data Deletion ==="), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77This will permanently delete all data associated with your Hardware ID."), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77To confirm, please run this command again."), false);
        try {
            SupabaseClient.getInstance().deletePlayerData(HardwareIdGenerator.getHardwareId());
            tm.disableTelemetry();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7a\u2713 Data deleted successfully."), false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77You have been opted out of telemetry."), false);
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7cFailed to delete data: " + e.getMessage())), false);
        }
        return 1;
    }

    private static String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes % 60L);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds % 60L);
        }
        return String.format("%ds", seconds);
    }
}

