/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.config;

import java.nio.file.Path;
import java.util.List;
import org.texboobcat.questory.config.ConfigBackupManager;
import org.texboobcat.questory.config.ConfigMigrator;
import org.texboobcat.questory.config.ConfigVersion;
import org.texboobcat.questory.config.QuestoryConfig;

public class ConfigManager {
    private final Path configPath;
    private final ConfigBackupManager backupManager;
    private static final String CONFIG_FILE_NAME = "questory-common.json";

    public ConfigManager(Path configPath) {
        this.configPath = configPath;
        this.backupManager = new ConfigBackupManager(configPath);
    }

    public void loadConfig() {
        QuestoryConfig.load(this.configPath);
    }

    public void saveConfig() {
        QuestoryConfig.save(this.configPath);
    }

    public void reloadConfig() {
        QuestoryConfig.reload(this.configPath);
    }

    public Path createBackup(String reason) {
        Path configFile = this.configPath.resolve(CONFIG_FILE_NAME);
        return this.backupManager.createBackup(configFile, reason);
    }

    public List<ConfigBackupManager.BackupInfo> listBackups() {
        return this.backupManager.listBackups();
    }

    public boolean restoreBackup(Path backupPath) {
        Path configFile = this.configPath.resolve(CONFIG_FILE_NAME);
        boolean success = this.backupManager.restoreBackup(backupPath, configFile);
        if (success) {
            this.reloadConfig();
        }
        return success;
    }

    public boolean forceMigration(ConfigVersion targetVersion) {
        return ConfigMigrator.migrate(this.configPath, CONFIG_FILE_NAME, targetVersion);
    }

    public QuestoryConfig getConfig() {
        return QuestoryConfig.getInstance();
    }

    public ConfigVersion getCurrentVersion() {
        QuestoryConfig config = QuestoryConfig.getInstance();
        return ConfigVersion.fromString(config.configVersion);
    }

    public boolean isConfigUpToDate() {
        ConfigVersion current = this.getCurrentVersion();
        return current.equals(ConfigVersion.CURRENT);
    }

    public ConfigStatus getStatus() {
        ConfigVersion current = this.getCurrentVersion();
        boolean upToDate = current.equals(ConfigVersion.CURRENT);
        int backupCount = this.listBackups().size();
        return new ConfigStatus(current, ConfigVersion.CURRENT, upToDate, backupCount);
    }

    public static class ConfigStatus {
        private final ConfigVersion currentVersion;
        private final ConfigVersion targetVersion;
        private final boolean upToDate;
        private final int backupCount;

        public ConfigStatus(ConfigVersion currentVersion, ConfigVersion targetVersion, boolean upToDate, int backupCount) {
            this.currentVersion = currentVersion;
            this.targetVersion = targetVersion;
            this.upToDate = upToDate;
            this.backupCount = backupCount;
        }

        public ConfigVersion getCurrentVersion() {
            return this.currentVersion;
        }

        public ConfigVersion getTargetVersion() {
            return this.targetVersion;
        }

        public boolean isUpToDate() {
            return this.upToDate;
        }

        public int getBackupCount() {
            return this.backupCount;
        }

        public String toString() {
            return "Config Status:\n  Current Version: " + String.valueOf(this.currentVersion) + "\n  Target Version: " + String.valueOf(this.targetVersion) + "\n  Up to Date: " + (this.upToDate ? "Yes" : "No") + "\n  Backups Available: " + this.backupCount;
        }
    }
}

