/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.events;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.api.events.QuestEventBus;
import org.texboobcat.questory.api.events.QuestPreStartEvent;
import org.texboobcat.questory.api.events.QuestProgressEvent;
import org.texboobcat.questory.api.events.QuestRequirementPreProgressEvent;
import org.texboobcat.questory.api.events.QuestStartedEvent;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.integration.OPACIntegration;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.manager.TriggerListenerManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.ClaimCountRequirement;
import org.texboobcat.questory.quest.ClaimRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EquipItemRequirement;
import org.texboobcat.questory.quest.GenericTriggerRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;

public class QuestEvents {
    private static final Map<UUID, LookCache> LOOK_CACHE = new HashMap<UUID, LookCache>();

    public static void onItemObtained(ServerPlayer player, ItemStack stack) {
        if (stack.m_41619_()) {
            Questory.LOGGER.debug("[Questory Debug] onItemObtained called with empty stack");
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        Questory.LOGGER.debug("[Questory Debug] onItemObtained: Player={}, Item={}, Count={}", (Object)player.m_7755_().getString(), (Object)itemId, (Object)stack.m_41613_());
        QuestManager.getInstance().trackItemProgress(player.m_20148_(), itemId.toString(), stack.m_41613_(), player);
        QuestManager.getInstance().trackItemTagProgress(player.m_20148_(), itemId.toString(), stack.m_41613_(), player);
    }

    public static void onItemCrafted(ServerPlayer player, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        QuestEvents.onItemsCrafted(player, stack, stack.m_41613_());
    }

    public static void onItemsCrafted(ServerPlayer player, ItemStack stack, int totalCount) {
        if (stack.m_41619_()) {
            return;
        }
        int amount = Math.max(1, totalCount);
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        if (QuestoryConfig.getInstance().debugMode) {
            Questory.LOGGER.debug("[Questory Debug] onItemsCrafted: Player={}, Item={}, Count={}", (Object)player.m_7755_().getString(), (Object)itemId, (Object)amount);
        }
        QuestManager.getInstance().trackCraftingProgress(player.m_20148_(), itemId.toString(), amount, player);
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(amount);
        QuestEvents.onItemObtained(player, copy);
    }

    public static void onEntityKilled(ServerPlayer player, LivingEntity entity) {
        ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        QuestManager.getInstance().trackEntityKillProgress(player.m_20148_(), entityId.toString(), 1, player);
    }

    public static void onAdvancementEarned(ServerPlayer player, ResourceLocation advancementId) {
        QuestManager.getInstance().trackAdvancementProgress(player.m_20148_(), advancementId.toString(), player);
    }

    public static void onPlayerDisconnect(ServerPlayer player) {
        QuestManager.getInstance().onPlayerDisconnect(player.m_20148_());
        TriggerListenerManager.getInstance().onPlayerDisconnect(player.m_20148_());
        try {
            LOOK_CACHE.remove(player.m_20148_());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            OPACIntegration.onPlayerLogout(player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void onPlayerJoin(ServerPlayer player) {
        QuestManager.getInstance().onPlayerJoin(player);
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId()) || !quest.isVisible(progress)) continue;
            for (Requirement req : quest.getRequirements()) {
                if (!(req instanceof GenericTriggerRequirement)) continue;
                GenericTriggerRequirement trigReq = (GenericTriggerRequirement)req;
                trigReq.startListening(player, quest.getId());
            }
        }
        try {
            OPACIntegration.onPlayerLogin(player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void onInventoryChanged(ServerPlayer player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        boolean changed = false;
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                int existing;
                int before;
                int cap;
                int invCount;
                if (req instanceof ItemRequirement) {
                    ItemRequirement itemReq = (ItemRequirement)req;
                    invCount = QuestEvents.countItemInInventory(player, itemReq.getItem());
                    cap = Math.min(invCount, itemReq.getCount());
                    if (!itemReq.shouldConsume()) {
                        before = progress.getRequirementProgress(quest.getId(), req);
                        if (before == cap) continue;
                        progress.setRequirementProgress(quest.getId(), req, cap);
                        changed = true;
                        continue;
                    }
                    existing = progress.getRequirementProgress(quest.getId(), req);
                    if (cap <= existing) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                if (!(req instanceof ItemTagRequirement)) continue;
                ItemTagRequirement tagReq = (ItemTagRequirement)req;
                invCount = QuestEvents.countItemTagInInventory(player, tagReq.getTag());
                cap = Math.min(invCount, tagReq.getCount());
                if (!tagReq.shouldConsume()) {
                    before = progress.getRequirementProgress(quest.getId(), req);
                    if (before == cap) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                existing = progress.getRequirementProgress(quest.getId(), req);
                if (cap <= existing) continue;
                progress.setRequirementProgress(quest.getId(), req, cap);
                changed = true;
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static int countItemInInventory(ServerPlayer player, String itemIdString) {
        ResourceLocation itemId = new ResourceLocation(itemIdString);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
        if (item == null) {
            return 0;
        }
        int total = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    private static int countItemTagInInventory(ServerPlayer player, String tagId) {
        TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagId));
        int total = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !stack.m_204117_(key)) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    public static void onStatisticChanged(ServerPlayer player, String statistic, int value) {
        QuestManager.getInstance().trackStatisticProgress(player.m_20148_(), statistic, value, player);
    }

    public static void onEnvironmentTick(ServerPlayer player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        boolean changed = false;
        ServerLevel level = player.m_284548_();
        BlockPos pos = player.m_20183_();
        Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
        ResourceLocation biomeId = biomeRegistry.m_7981_((Object)((Biome)level.m_204166_(pos).m_203334_()));
        String dimId = level.m_46472_().m_135782_().toString();
        long dayTime = level.m_46468_() % 24000L;
        boolean isRaining = level.m_46471_();
        boolean isThundering = level.m_46470_();
        boolean needObsEntity = false;
        boolean needObsBlock = false;
        boolean needObsItemHand = false;
        boolean needObsItemEntity = false;
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (cfg.observationEnabled && QuestManager.getInstance().hasObservationRequirements()) {
            Collection<Quest> questsForFlags = cfg.environmentOnlyVisibleQuests ? manager.getVisibleQuests(player.m_20148_()) : manager.getAllQuests();
            for (Quest q : questsForFlags) {
                if (progress.isQuestCompleted(q.getId())) continue;
                for (Requirement r : q.getRequirements()) {
                    if (!(r instanceof ObservationRequirement)) continue;
                    ObservationRequirement or = (ObservationRequirement)r;
                    if (progress.getRequirementProgress(q.getId(), r) >= or.getTimer()) continue;
                    switch (String.valueOf(or.getObserveType())) {
                        case "entity": {
                            needObsEntity = true;
                            break;
                        }
                        case "block": {
                            needObsBlock = true;
                            break;
                        }
                        case "item_hand": {
                            needObsItemHand = true;
                            break;
                        }
                        case "item_entity": {
                            needObsItemEntity = true;
                        }
                    }
                }
            }
        }
        if (!cfg.observationEnabled) {
            needObsItemEntity = false;
            needObsItemHand = false;
            needObsBlock = false;
            needObsEntity = false;
        }
        double MAX_LOOK_DIST = Math.max(1.0, cfg.observationMaxLookDistance);
        Entity lookedEntity = null;
        ResourceLocation lookedEntityTypeId = null;
        ResourceLocation lookedBlockId = null;
        String handItemId = null;
        String lookedItemEntityItemId = null;
        if (needObsEntity || needObsBlock || needObsItemHand || needObsItemEntity) {
            LookCache cache = LOOK_CACHE.computeIfAbsent(player.m_20148_(), k -> new LookCache());
            Vec3 nowPos = player.m_20299_(1.0f);
            Vec3 nowDir = player.m_20252_(1.0f);
            String nowHand = player.m_21205_().m_41619_() ? null : BuiltInRegistries.f_257033_.m_7981_((Object)player.m_21205_().m_41720_()).toString();
            boolean posSame = cache.pos != null && cache.pos.m_82557_(nowPos) < 1.0E-4;
            boolean dirSame = cache.dir != null && cache.dir.m_82557_(nowDir) < 1.0E-4;
            boolean handSame = Objects.equals(cache.handItemId, nowHand);
            if (posSame && dirSame && handSame) {
                lookedEntityTypeId = cache.entityTypeId;
                lookedBlockId = cache.blockId;
                lookedItemEntityItemId = cache.itemEntityItemId;
                handItemId = cache.handItemId;
            } else {
                if (needObsEntity || needObsItemEntity) {
                    ItemEntity ie;
                    ItemStack is;
                    lookedEntity = QuestEvents.getLookedEntity(player, MAX_LOOK_DIST);
                    ResourceLocation resourceLocation = lookedEntityTypeId = lookedEntity != null ? BuiltInRegistries.f_256780_.m_7981_((Object)lookedEntity.m_6095_()) : null;
                    if (lookedEntity instanceof ItemEntity && !(is = (ie = (ItemEntity)lookedEntity).m_32055_()).m_41619_()) {
                        lookedItemEntityItemId = BuiltInRegistries.f_257033_.m_7981_((Object)is.m_41720_()).toString();
                    }
                }
                if (needObsBlock) {
                    lookedBlockId = QuestEvents.getLookedBlock(level, player, MAX_LOOK_DIST);
                }
                handItemId = needObsItemHand ? nowHand : nowHand;
                cache.pos = nowPos;
                cache.dir = nowDir;
                cache.handItemId = handItemId;
                cache.entityTypeId = lookedEntityTypeId;
                cache.blockId = lookedBlockId;
                cache.itemEntityItemId = lookedItemEntityItemId;
            }
            if (needObsEntity || needObsItemEntity) {
                ItemEntity ie2;
                ItemStack is2;
                lookedEntity = QuestEvents.getLookedEntity(player, MAX_LOOK_DIST);
                lookedEntityTypeId = lookedEntity != null ? BuiltInRegistries.f_256780_.m_7981_((Object)lookedEntity.m_6095_()) : null;
                lookedItemEntityItemId = null;
                if (lookedEntity instanceof ItemEntity && !(is2 = (ie2 = (ItemEntity)lookedEntity).m_32055_()).m_41619_()) {
                    lookedItemEntityItemId = BuiltInRegistries.f_257033_.m_7981_((Object)is2.m_41720_()).toString();
                }
                cache.entityTypeId = lookedEntityTypeId;
                cache.itemEntityItemId = lookedItemEntityItemId;
            }
        }
        if (needObsEntity || needObsBlock || needObsItemHand || needObsItemEntity) {
            for (QuestManager.QuestRequirementRef ref : manager.getObservationRequirements()) {
                Requirement posSame;
                Quest quest = ref.quest;
                if (progress.isQuestCompleted(quest.getId()) || cfg.environmentOnlyVisibleQuests && !quest.isVisible(progress) || !((posSame = ref.requirement) instanceof ObservationRequirement)) continue;
                ObservationRequirement obsReq = (ObservationRequirement)posSame;
                int before = progress.getRequirementProgress(quest.getId(), ref.requirement);
                if (before >= obsReq.getTimer()) continue;
                boolean match = false;
                String target = obsReq.getTargetId();
                String type = obsReq.getObserveType();
                String normalized = QuestEvents.normalizeId(target);
                if ("entity".equalsIgnoreCase(type)) {
                    match = lookedEntityTypeId != null && QuestEvents.normalizeId(lookedEntityTypeId.toString()).equals(normalized);
                } else if ("block".equalsIgnoreCase(type)) {
                    match = lookedBlockId != null && QuestEvents.normalizeId(lookedBlockId.toString()).equals(normalized);
                } else if ("item_hand".equalsIgnoreCase(type)) {
                    match = handItemId != null && QuestEvents.normalizeId(handItemId).equals(normalized);
                } else if ("item_entity".equalsIgnoreCase(type)) {
                    boolean bl = match = lookedItemEntityItemId != null && QuestEvents.normalizeId(lookedItemEntityItemId).equals(normalized);
                }
                if (match) {
                    boolean anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int increment = Math.max(1, cfg.observationScanIntervalTicks);
                    int now = Math.min(obsReq.getTimer(), before + increment);
                    if (now == before) continue;
                    progress.setRequirementProgress(quest.getId(), ref.requirement, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, ref.requirement, before, now));
                        if (!anyBefore && now > 0) {
                            QuestEventBus.post(new QuestStartedEvent(player, quest));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!QuestoryConfig.getInstance().debugMode) continue;
                    Questory.LOGGER.debug("[Questory Debug] Observation matched: type={}, target={}, lookedEntity={}, lookedBlock={}, hand={}, itemEntity={}, now={}/{}", (Object)type, (Object)target, lookedEntityTypeId != null ? lookedEntityTypeId : "null", lookedBlockId != null ? lookedBlockId : "null", (Object)handItemId, (Object)lookedItemEntityItemId, (Object)now, (Object)obsReq.getTimer());
                    continue;
                }
                if (!QuestoryConfig.getInstance().debugMode) continue;
                Questory.LOGGER.debug("[Questory Debug] Observation no match: type={}, target={}, lookedEntity={}, lookedBlock={}, hand={}, itemEntity={}", (Object)type, (Object)target, lookedEntityTypeId != null ? lookedEntityTypeId : "null", lookedBlockId != null ? lookedBlockId : "null", (Object)handItemId, (Object)lookedItemEntityItemId);
            }
        }
        Collection<Quest> mainQuestList = cfg.environmentOnlyVisibleQuests ? manager.getVisibleQuests(player.m_20148_()) : manager.getAllQuests();
        for (Quest quest : mainQuestList) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                boolean dimOk;
                boolean anyBefore;
                boolean ok;
                if (req instanceof BiomeRequirement) {
                    BiomeRequirement biomeReq = (BiomeRequirement)req;
                    if (biomeReq.isTag()) {
                        TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(biomeReq.getBiomeId().substring(1)));
                        ok = level.m_204166_(pos).m_203656_(key);
                    } else {
                        ok = biomeId != null && biomeId.toString().equals(biomeReq.getBiomeId());
                    }
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof DimensionRequirement) {
                    DimensionRequirement dimReq = (DimensionRequirement)req;
                    ok = dimId.equals(dimReq.getDimensionId());
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof LocationRequirement) {
                    int r;
                    int dz;
                    int dy;
                    LocationRequirement locReq = (LocationRequirement)req;
                    dimOk = locReq.getDimension().equals(dimId);
                    if (!dimOk) continue;
                    int dx = pos.m_123341_() - locReq.getX();
                    boolean ok2 = dx * dx + (dy = pos.m_123342_() - locReq.getY()) * dy + (dz = pos.m_123343_() - locReq.getZ()) * dz <= (r = locReq.getRange()) * r;
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore2 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok2 ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore2 && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore2 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof RegionRequirement) {
                    RegionRequirement regReq = (RegionRequirement)req;
                    dimOk = regReq.getDimension().equals(dimId);
                    boolean in = dimOk && pos.m_123341_() >= regReq.getMinX() && pos.m_123341_() <= regReq.getMaxX() && pos.m_123342_() >= regReq.getMinY() && pos.m_123342_() <= regReq.getMaxY() && pos.m_123343_() >= regReq.getMinZ() && pos.m_123343_() <= regReq.getMaxZ();
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore3 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = in ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore3 && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore3 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof TimeRequirement) {
                    long end;
                    TimeRequirement timeReq = (TimeRequirement)req;
                    long start = timeReq.getStart();
                    boolean inWindow = start <= (end = timeReq.getEnd()) ? dayTime >= start && dayTime <= end : dayTime >= start || dayTime <= end;
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore4 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = inWindow ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore4 && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore4 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof WeatherRequirement) {
                    WeatherRequirement weatherReq = (WeatherRequirement)req;
                    ok = switch (weatherReq.getMode()) {
                        default -> throw new IncompatibleClassChangeError();
                        case WeatherRequirement.Mode.CLEAR -> {
                            if (!isRaining && !isThundering) {
                                yield true;
                            }
                            yield false;
                        }
                        case WeatherRequirement.Mode.RAIN -> {
                            if (isRaining && !isThundering) {
                                yield true;
                            }
                            yield false;
                        }
                        case WeatherRequirement.Mode.THUNDER -> isThundering;
                    };
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof StructureRequirement) {
                    StructureRequirement structReq = (StructureRequirement)req;
                    ok = false;
                    try {
                        StructureManager mgr = level.m_215010_();
                        if (structReq.getStructureId().startsWith("#")) {
                            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structReq.getStructureId().substring(1)));
                            ok = mgr.m_220491_(pos, tag).m_73603_();
                        } else {
                            ResourceKey key;
                            Registry structReg = level.m_9598_().m_175515_(Registries.f_256944_);
                            Structure structure = (Structure)structReg.m_6246_(key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structReq.getStructureId())));
                            ok = structure != null && mgr.m_220524_(pos, structure).m_73603_();
                        }
                    }
                    catch (Throwable mgr) {
                        // empty catch block
                    }
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof ObservationRequirement) continue;
                if (req instanceof ClaimRequirement) {
                    ClaimRequirement claimReq = (ClaimRequirement)req;
                    if (!cfg.opacIntegrationEnabled || !cfg.opacEnableClaimRequirements || player.f_19797_ % cfg.opacClaimCheckIntervalTicks != 0) continue;
                    ok = claimReq.checkForPlayer(player);
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof ClaimCountRequirement) {
                    ClaimCountRequirement claimCountReq = (ClaimCountRequirement)req;
                    if (!cfg.opacIntegrationEnabled || !cfg.opacEnableClaimRequirements || player.f_19797_ % cfg.opacClaimCheckIntervalTicks != 0) continue;
                    int currentCount = claimCountReq.getCurrentCount(player);
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    if (currentCount <= before) continue;
                    try {
                        QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, currentCount - before);
                        QuestEventBus.post(pre);
                        if (pre.isCanceled()) continue;
                        if (!anyBefore && pre.getDelta() > 0) {
                            QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                            QuestEventBus.post(preStart);
                            if (preStart.isCanceled()) {
                                continue;
                            }
                        }
                    }
                    catch (Throwable pre) {
                        // empty catch block
                    }
                    progress.setRequirementProgress(quest.getId(), req, currentCount);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, currentCount));
                        if (anyBefore || currentCount <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (!(req instanceof EquipItemRequirement)) continue;
                EquipItemRequirement equipReq = (EquipItemRequirement)req;
                if (player.f_19797_ % cfg.equipmentCheckIntervalTicks != 0) continue;
                boolean allEquipped = equipReq.isEquipped((Player)player);
                int before = progress.getRequirementProgress(quest.getId(), req);
                anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                int now = allEquipped ? equipReq.getEntries().size() : 0;
                if (before == now) continue;
                if (now > before) {
                    try {
                        QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                        QuestEventBus.post(pre);
                        if (pre.isCanceled()) continue;
                        if (!anyBefore && pre.getDelta() > 0) {
                            QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                            QuestEventBus.post(preStart);
                            if (preStart.isCanceled()) {
                                continue;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                progress.setRequirementProgress(quest.getId(), req, now);
                changed = true;
                try {
                    QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                    if (anyBefore || now <= 0) continue;
                    QuestEventBus.post(new QuestStartedEvent(player, quest));
                }
                catch (Throwable throwable) {}
            }
            if (progress.isQuestCompleted(quest.getId()) || !quest.canComplete(progress)) continue;
            try {
                manager.notifyQuestReadyOnce(player, progress, quest);
            }
            catch (Throwable obsReq) {
                // empty catch block
            }
            if (!cfg.autoCompleteWhenRequirementsMet) continue;
            try {
                manager.completeQuest(player, quest.getId());
            }
            catch (Throwable t) {
                Questory.LOGGER.error("Auto-complete failed for quest {}: {}", (Object)quest.getId(), (Object)t.getMessage());
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static boolean hasAnyProgress(QuestProgress progress, Quest quest) {
        for (Requirement r : quest.getRequirements()) {
            if (progress.getRequirementProgress(quest.getId(), r) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void onStageChanged(ServerPlayer player, String stage, boolean added) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        boolean changed = false;
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                int newProgress;
                StageRequirement stageReq;
                if (!(req instanceof StageRequirement) || !(stageReq = (StageRequirement)req).getStage().equals(stage)) continue;
                int n = newProgress = added ? 1 : 0;
                int oldProgress = progress.getRequirementProgress(quest.getId(), req);
                if (oldProgress == newProgress) continue;
                boolean anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                progress.setRequirementProgress(quest.getId(), req, newProgress);
                changed = true;
                try {
                    QuestEventBus.post(new QuestProgressEvent(player, quest, req, oldProgress, newProgress));
                    if (anyBefore || newProgress <= 0) continue;
                    QuestEventBus.post(new QuestStartedEvent(player, quest));
                }
                catch (Throwable throwable) {}
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static Entity getLookedEntity(ServerPlayer player, double maxDistance) {
        AABB aabb;
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 end = eyePos.m_82520_(look.f_82479_ * maxDistance, look.f_82480_ * maxDistance, look.f_82481_ * maxDistance);
        EntityHitResult ehr = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePos, (Vec3)end, (AABB)(aabb = player.m_20191_().m_82369_(look.m_82490_(maxDistance)).m_82400_(1.0)), e -> e != null && !e.m_5833_() && e.m_6087_() && e != player, (double)(maxDistance * maxDistance));
        if (ehr != null) {
            return ehr.m_82443_();
        }
        double cosThreshold = 0.94;
        Entity best = null;
        double bestDist2 = Double.MAX_VALUE;
        for (Entity e2 : player.m_9236_().m_6249_((Entity)player, aabb, ent -> ent != null && !ent.m_5833_() && ent.m_6087_() && ent != player)) {
            double cos;
            Vec3 to = e2.m_20191_().m_82399_().m_82546_(eyePos);
            double dist2 = to.m_82556_();
            if (dist2 > maxDistance * maxDistance || !((cos = to.m_82541_().m_82526_(look)) >= 0.94) || !player.m_142582_(e2) || !(dist2 < bestDist2)) continue;
            best = e2;
            bestDist2 = dist2;
        }
        return best;
    }

    private static ResourceLocation getLookedBlock(ServerLevel level, ServerPlayer player, double maxDistance) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 end = eyePos.m_82520_(look.f_82479_ * maxDistance, look.f_82480_ * maxDistance, look.f_82481_ * maxDistance);
        BlockHitResult bhr = level.m_45547_(new ClipContext(eyePos, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (bhr != null && bhr.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos bpos = bhr.m_82425_();
            Block block = level.m_8055_(bpos).m_60734_();
            return BuiltInRegistries.f_256975_.m_7981_((Object)block);
        }
        return null;
    }

    private static String normalizeId(String id) {
        if (id == null) {
            return "";
        }
        Object s = id.trim().toLowerCase(Locale.ROOT);
        if (((String)s).isEmpty()) {
            return s;
        }
        if (!((String)s).contains(":")) {
            if (((String)s).startsWith("minecraft")) {
                String path = ((String)s).substring("minecraft".length());
                if (path.startsWith("_") || path.startsWith("/")) {
                    path = path.substring(1);
                }
                s = "minecraft:" + path;
            } else {
                s = "minecraft:" + (String)s;
            }
        }
        return s;
    }

    private static class LookCache {
        Vec3 pos;
        Vec3 dir;
        String handItemId;
        ResourceLocation entityTypeId;
        ResourceLocation blockId;
        String itemEntityItemId;

        private LookCache() {
        }
    }
}

